/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.plugins;

import com.google.common.base.Optional;
import java.io.File;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.ide.xcode.XcodeExtension;
import org.gradle.ide.xcode.XcodeProject;
import org.gradle.ide.xcode.internal.DefaultXcodeExtension;
import org.gradle.ide.xcode.internal.DefaultXcodeProject;
import org.gradle.ide.xcode.internal.XcodePropertyAdapter;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.ide.xcode.internal.xcodeproj.GidGenerator;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;
import org.gradle.ide.xcode.tasks.GenerateSchemeFileTask;
import org.gradle.ide.xcode.tasks.GenerateWorkspaceSettingsFileTask;
import org.gradle.ide.xcode.tasks.GenerateXcodeProjectFileTask;
import org.gradle.ide.xcode.tasks.GenerateXcodeWorkspaceFileTask;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppExecutable;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.CppStaticLibrary;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.plugins.CppApplicationPlugin;
import org.gradle.language.cpp.plugins.CppLibraryPlugin;
import org.gradle.language.swift.ProductionSwiftComponent;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftExecutable;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.SwiftStaticLibrary;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.language.swift.plugins.SwiftApplicationPlugin;
import org.gradle.language.swift.plugins.SwiftLibraryPlugin;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.plugins.XCTestConventionPlugin;
import org.gradle.plugins.ide.internal.IdePlugin;
import org.gradle.util.CollectionUtils;

@Incubating
public class XcodePlugin
extends IdePlugin {
    private final GidGenerator gidGenerator;
    private final ObjectFactory objectFactory;
    private DefaultXcodeExtension xcode;

    @Inject
    public XcodePlugin(GidGenerator gidGenerator, ObjectFactory objectFactory) {
        this.gidGenerator = gidGenerator;
        this.objectFactory = objectFactory;
    }

    protected String getLifecycleTaskName() {
        return "xcode";
    }

    protected void onApply(Project project) {
        Task lifecycleTask = this.getLifecycleTask();
        lifecycleTask.setDescription("Generates XCode project files (pbxproj, xcworkspace, xcscheme)");
        this.xcode = (DefaultXcodeExtension)project.getExtensions().create(XcodeExtension.class, "xcode", DefaultXcodeExtension.class, new Object[]{this.objectFactory});
        this.xcode.getProject().setLocationDir(project.file((Object)(project.getName() + ".xcodeproj")));
        if (this.isRoot()) {
            GenerateXcodeWorkspaceFileTask workspaceTask = this.createWorkspaceTask(project);
            lifecycleTask.dependsOn(new Object[]{workspaceTask});
        }
        GenerateXcodeProjectFileTask projectTask = this.createProjectTask(project);
        lifecycleTask.dependsOn(new Object[]{projectTask});
        project.getTasks().addRule("Xcode bridge tasks begin with _xcode. Do not call these directly.", (Action)new XcodeBridge(this.xcode.getProject(), project));
        this.configureForSwiftPlugin(project);
        this.configureForCppPlugin(project);
        this.includeBuildFilesInProject(project);
        this.configureXcodeCleanTask(project);
        this.registerIdeArtifact(XcodePlugin.createXcodeProjectArtifact(project));
    }

    private void includeBuildFilesInProject(Project project) {
        if (project.getBuildFile().exists()) {
            this.xcode.getProject().getGroups().getRoot().from(new Object[]{project.getBuildFile()});
        }
    }

    private void configureXcodeCleanTask(Project project) {
        this.getCleanTask().setDescription("Cleans XCode project files (xcodeproj)");
        Delete cleanTask = (Delete)project.getTasks().create("cleanXcodeProject", Delete.class);
        cleanTask.delete(new Object[]{this.xcode.getProject().getLocationDir()});
        if (this.isRoot()) {
            cleanTask.delete(new Object[]{XcodePlugin.toXcodeWorkspacePackageDir(project)});
        }
        this.getCleanTask().dependsOn(new Object[]{cleanTask});
    }

    private GenerateXcodeProjectFileTask createProjectTask(Project project) {
        File xcodeProjectPackageDir = this.xcode.getProject().getLocationDir();
        GenerateWorkspaceSettingsFileTask workspaceSettingsFileTask = (GenerateWorkspaceSettingsFileTask)project.getTasks().create("xcodeProjectWorkspaceSettings", GenerateWorkspaceSettingsFileTask.class);
        workspaceSettingsFileTask.setOutputFile(new File(xcodeProjectPackageDir, "project.xcworkspace/xcshareddata/WorkspaceSettings.xcsettings"));
        GenerateXcodeProjectFileTask projectFileTask = (GenerateXcodeProjectFileTask)project.getTasks().create("xcodeProject", GenerateXcodeProjectFileTask.class);
        projectFileTask.dependsOn(new Object[]{workspaceSettingsFileTask});
        projectFileTask.dependsOn(new Object[]{this.xcode.getProject().getTaskDependencies()});
        projectFileTask.dependsOn(new Object[]{project.getTasks().withType(GenerateSchemeFileTask.class)});
        projectFileTask.setXcodeProject(this.xcode.getProject());
        projectFileTask.setOutputFile(new File(xcodeProjectPackageDir, "project.pbxproj"));
        return projectFileTask;
    }

    private GenerateXcodeWorkspaceFileTask createWorkspaceTask(Project project) {
        File xcodeWorkspacePackageDir = XcodePlugin.toXcodeWorkspacePackageDir(project);
        GenerateWorkspaceSettingsFileTask workspaceSettingsFileTask = (GenerateWorkspaceSettingsFileTask)project.getTasks().create("xcodeWorkspaceWorkspaceSettings", GenerateWorkspaceSettingsFileTask.class);
        workspaceSettingsFileTask.setOutputFile(new File(xcodeWorkspacePackageDir, "xcshareddata/WorkspaceSettings.xcsettings"));
        GenerateXcodeWorkspaceFileTask workspaceFileTask = (GenerateXcodeWorkspaceFileTask)project.getTasks().create("xcodeWorkspace", GenerateXcodeWorkspaceFileTask.class);
        workspaceFileTask.dependsOn(new Object[]{workspaceSettingsFileTask});
        workspaceFileTask.setOutputFile(new File(xcodeWorkspacePackageDir, "contents.xcworkspacedata"));
        workspaceFileTask.setXcodeProjectLocations(this.getIdeArtifacts("xcodeproj"));
        return workspaceFileTask;
    }

    private String getBridgeTaskPath(Project project) {
        String projectPath = "";
        if (!this.isRoot()) {
            projectPath = project.getPath();
        }
        return projectPath + ":_xcode__${ACTION}_${PRODUCT_NAME}_${CONFIGURATION}";
    }

    private void configureForSwiftPlugin(final Project project) {
        project.getPlugins().withType(SwiftApplicationPlugin.class, (Action)new Action<SwiftApplicationPlugin>(){

            public void execute(SwiftApplicationPlugin plugin) {
                XcodePlugin.this.configureXcodeForSwift(project);
            }
        });
        project.getPlugins().withType(SwiftLibraryPlugin.class, (Action)new Action<SwiftLibraryPlugin>(){

            public void execute(SwiftLibraryPlugin plugin) {
                XcodePlugin.this.configureXcodeForSwift(project);
            }
        });
        project.getPlugins().withType(XCTestConventionPlugin.class, (Action)new Action<XCTestConventionPlugin>(){

            public void execute(XCTestConventionPlugin plugin) {
                XcodePlugin.this.configureXcodeForXCTest(project);
            }
        });
    }

    private void configureXcodeForXCTest(Project project) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                SwiftXCTestSuite component = (SwiftXCTestSuite)project.getExtensions().getByType(SwiftXCTestSuite.class);
                FileCollection sources = component.getSwiftSource();
                XcodePlugin.this.xcode.getProject().getGroups().getTests().from(new Object[]{sources});
                String targetName = (String)component.getModule().get();
                XcodeTarget target = XcodePlugin.this.newTarget(targetName, (String)component.getModule().get(), XcodePlugin.toGradleCommand(project.getRootProject()), XcodePlugin.this.getBridgeTaskPath(project), sources);
                target.setDebug((Provider<? extends FileSystemLocation>)((SwiftXCTestBinary)component.getTestBinary().get()).getInstallDirectory(), PBXTarget.ProductType.UNIT_TEST);
                target.setRelease((Provider<? extends FileSystemLocation>)((SwiftXCTestBinary)component.getTestBinary().get()).getInstallDirectory(), PBXTarget.ProductType.UNIT_TEST);
                target.getCompileModules().from(new Object[]{((SwiftXCTestBinary)component.getTestBinary().get()).getCompileModules()});
                target.addTaskDependency(XcodePlugin.this.filterArtifactsFromImplicitBuilds(((DefaultSwiftBinary)component.getTestBinary().get()).getImportPathConfiguration()).getBuildDependencies());
                XcodePlugin.this.xcode.getProject().addTarget(target);
            }
        });
    }

    private FileCollection filterArtifactsFromImplicitBuilds(Configuration configuration) {
        return configuration.getIncoming().artifactView(XcodePlugin.fromSourceDependency(this.project)).getArtifacts().getArtifactFiles();
    }

    private void configureXcodeForSwift(Project project) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                ProductionSwiftComponent component = (ProductionSwiftComponent)project.getComponents().withType(ProductionSwiftComponent.class).getByName("main");
                FileCollection sources = component.getSwiftSource();
                XcodePlugin.this.xcode.getProject().getGroups().getSources().from(new Object[]{sources});
                String targetName = (String)component.getModule().get();
                final XcodeTarget target = XcodePlugin.this.newTarget(targetName, (String)component.getModule().get(), XcodePlugin.toGradleCommand(project.getRootProject()), XcodePlugin.this.getBridgeTaskPath(project), sources);
                component.getBinaries().whenElementFinalized((Action)new Action<SwiftBinary>(){

                    public void execute(SwiftBinary swiftBinary) {
                        if (swiftBinary instanceof SwiftExecutable && swiftBinary.isDebuggable() && !swiftBinary.isOptimized()) {
                            target.setDebug((Provider<? extends FileSystemLocation>)((SwiftExecutable)swiftBinary).getDebuggerExecutableFile(), PBXTarget.ProductType.TOOL);
                        } else if (swiftBinary instanceof SwiftExecutable && swiftBinary.isDebuggable() && swiftBinary.isOptimized()) {
                            target.setRelease((Provider<? extends FileSystemLocation>)((SwiftExecutable)swiftBinary).getDebuggerExecutableFile(), PBXTarget.ProductType.TOOL);
                        } else if (swiftBinary instanceof SwiftSharedLibrary && swiftBinary.isDebuggable() && !swiftBinary.isOptimized()) {
                            target.setDebug((Provider<? extends FileSystemLocation>)((SwiftSharedLibrary)swiftBinary).getRuntimeFile(), PBXTarget.ProductType.DYNAMIC_LIBRARY);
                        } else if (swiftBinary instanceof SwiftSharedLibrary && swiftBinary.isDebuggable() && swiftBinary.isOptimized()) {
                            target.setRelease((Provider<? extends FileSystemLocation>)((SwiftSharedLibrary)swiftBinary).getRuntimeFile(), PBXTarget.ProductType.DYNAMIC_LIBRARY);
                        } else if (swiftBinary instanceof SwiftStaticLibrary && swiftBinary.isDebuggable() && !swiftBinary.isOptimized()) {
                            target.setDebug((Provider<? extends FileSystemLocation>)((SwiftStaticLibrary)swiftBinary).getLinkFile(), PBXTarget.ProductType.STATIC_LIBRARY);
                        } else if (swiftBinary instanceof SwiftStaticLibrary && swiftBinary.isDebuggable() && swiftBinary.isOptimized()) {
                            target.setRelease((Provider<? extends FileSystemLocation>)((SwiftStaticLibrary)swiftBinary).getLinkFile(), PBXTarget.ProductType.STATIC_LIBRARY);
                        }
                    }
                });
                target.getCompileModules().from(new Object[]{((SwiftBinary)component.getDevelopmentBinary().get()).getCompileModules()});
                target.addTaskDependency(XcodePlugin.this.filterArtifactsFromImplicitBuilds(((DefaultSwiftBinary)component.getDevelopmentBinary().get()).getImportPathConfiguration()).getBuildDependencies());
                XcodePlugin.this.xcode.getProject().addTarget(target);
                XcodePlugin.createSchemeTask(project.getTasks(), targetName, XcodePlugin.this.xcode.getProject());
            }
        });
    }

    private void configureForCppPlugin(final Project project) {
        project.getPlugins().withType(CppApplicationPlugin.class, (Action)new Action<CppApplicationPlugin>(){

            public void execute(CppApplicationPlugin plugin) {
                XcodePlugin.this.configureXcodeForCpp(project);
            }
        });
        project.getPlugins().withType(CppLibraryPlugin.class, (Action)new Action<CppLibraryPlugin>(){

            public void execute(CppLibraryPlugin plugin) {
                XcodePlugin.this.configureXcodeForCpp(project);
            }
        });
    }

    private void configureXcodeForCpp(Project project) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                ProductionCppComponent component = (ProductionCppComponent)project.getComponents().withType(ProductionCppComponent.class).getByName("main");
                FileCollection sources = component.getCppSource();
                XcodePlugin.this.xcode.getProject().getGroups().getSources().from(new Object[]{sources});
                FileTree headers = component.getHeaderFiles();
                XcodePlugin.this.xcode.getProject().getGroups().getHeaders().from(new Object[]{headers});
                String targetName = StringUtils.capitalize((String)((String)component.getBaseName().get()));
                final XcodeTarget target = XcodePlugin.this.newTarget(targetName, targetName, XcodePlugin.toGradleCommand(project.getRootProject()), XcodePlugin.this.getBridgeTaskPath(project), sources);
                component.getBinaries().whenElementFinalized((Action)new Action<CppBinary>(){

                    public void execute(CppBinary cppBinary) {
                        if (cppBinary instanceof CppExecutable && cppBinary.isDebuggable() && !cppBinary.isOptimized()) {
                            target.setDebug((Provider<? extends FileSystemLocation>)((CppExecutable)cppBinary).getDebuggerExecutableFile(), PBXTarget.ProductType.TOOL);
                        } else if (cppBinary instanceof CppExecutable && cppBinary.isDebuggable() && cppBinary.isOptimized()) {
                            target.setRelease((Provider<? extends FileSystemLocation>)((CppExecutable)cppBinary).getDebuggerExecutableFile(), PBXTarget.ProductType.TOOL);
                        } else if (cppBinary instanceof CppSharedLibrary && cppBinary.isDebuggable() && !cppBinary.isOptimized()) {
                            target.setDebug((Provider<? extends FileSystemLocation>)((CppSharedLibrary)cppBinary).getRuntimeFile(), PBXTarget.ProductType.DYNAMIC_LIBRARY);
                        } else if (cppBinary instanceof CppSharedLibrary && cppBinary.isDebuggable() && cppBinary.isOptimized()) {
                            target.setRelease((Provider<? extends FileSystemLocation>)((CppSharedLibrary)cppBinary).getRuntimeFile(), PBXTarget.ProductType.DYNAMIC_LIBRARY);
                        } else if (cppBinary instanceof CppStaticLibrary && cppBinary.isDebuggable() && !cppBinary.isOptimized()) {
                            target.setDebug((Provider<? extends FileSystemLocation>)((CppStaticLibrary)cppBinary).getLinkFile(), PBXTarget.ProductType.STATIC_LIBRARY);
                        } else if (cppBinary instanceof CppStaticLibrary && cppBinary.isDebuggable() && cppBinary.isOptimized()) {
                            target.setRelease((Provider<? extends FileSystemLocation>)((CppStaticLibrary)cppBinary).getLinkFile(), PBXTarget.ProductType.STATIC_LIBRARY);
                        }
                    }
                });
                target.getHeaderSearchPaths().from(new Object[]{((CppBinary)component.getDevelopmentBinary().get()).getCompileIncludePath()});
                target.getTaskDependencies().add(XcodePlugin.this.filterArtifactsFromImplicitBuilds(((DefaultCppBinary)component.getDevelopmentBinary().get()).getIncludePathConfiguration()).getBuildDependencies());
                XcodePlugin.this.xcode.getProject().addTarget(target);
                XcodePlugin.createSchemeTask(project.getTasks(), targetName, XcodePlugin.this.xcode.getProject());
            }
        });
    }

    private static GenerateSchemeFileTask createSchemeTask(TaskContainer tasks, String schemeName, DefaultXcodeProject xcodeProject) {
        String name = "xcodeScheme";
        GenerateSchemeFileTask schemeFileTask = (GenerateSchemeFileTask)((Object)tasks.maybeCreate(name, GenerateSchemeFileTask.class));
        schemeFileTask.setXcodeProject(xcodeProject);
        schemeFileTask.setOutputFile(new File(xcodeProject.getLocationDir(), "xcshareddata/xcschemes/" + schemeName + ".xcscheme"));
        return schemeFileTask;
    }

    private static String toGradleCommand(Project project) {
        Gradle gradle = project.getGradle();
        Optional gradleWrapperPath = Optional.absent();
        if (project.file((Object)"gradlew").exists()) {
            gradleWrapperPath = Optional.of((Object)project.file((Object)"gradlew").getAbsolutePath());
        }
        if (gradle.getGradleHomeDir() != null) {
            if (gradleWrapperPath.isPresent() && gradle.getGradleHomeDir().getAbsolutePath().startsWith(gradle.getGradleUserHomeDir().getAbsolutePath())) {
                return (String)gradleWrapperPath.get();
            }
            return gradle.getGradleHomeDir().getAbsolutePath() + "/bin/gradle";
        }
        return (String)gradleWrapperPath.or((Object)"gradle");
    }

    private XcodeTarget newTarget(String name, String productName, String gradleCommand, String taskName, FileCollection sources) {
        String id = this.gidGenerator.generateGid("PBXLegacyTarget", name.hashCode());
        XcodeTarget target = (XcodeTarget)this.objectFactory.newInstance(XcodeTarget.class, new Object[]{name, id});
        target.setTaskName(taskName);
        target.setGradleCommand(gradleCommand);
        target.setProductName(productName);
        target.getSources().setFrom((Iterable)sources);
        return target;
    }

    private static File toXcodeWorkspacePackageDir(Project project) {
        return project.file((Object)(project.getName() + ".xcworkspace"));
    }

    private static String toString(PBXTarget.ProductType productType) {
        if (PBXTarget.ProductType.TOOL.equals((Object)productType)) {
            return "Executable";
        }
        if (PBXTarget.ProductType.DYNAMIC_LIBRARY.equals((Object)productType)) {
            return "SharedLibrary";
        }
        if (PBXTarget.ProductType.UNIT_TEST.equals((Object)productType)) {
            return "XCTestBundle";
        }
        return "";
    }

    private static PublishArtifact createXcodeProjectArtifact(Project project) {
        DefaultXcodeProject xcodeProject = ((DefaultXcodeExtension)project.getExtensions().getByType(XcodeExtension.class)).getProject();
        Task byName = project.getTasks().getByName("xcodeProject");
        return new XcodeProjectArtifact(xcodeProject, byName);
    }

    private static final Action<ArtifactView.ViewConfiguration> fromSourceDependency(final Project project) {
        return new Action<ArtifactView.ViewConfiguration>(){

            public void execute(ArtifactView.ViewConfiguration viewConfiguration) {
                viewConfiguration.componentFilter(XcodePlugin.isSourceDependency((ProjectInternal)project));
            }
        };
    }

    private static final Spec<ComponentIdentifier> isSourceDependency(ProjectInternal project) {
        return new Spec<ComponentIdentifier>(){

            public boolean isSatisfiedBy(ComponentIdentifier id) {
                if (id instanceof ProjectComponentIdentifier) {
                    ProjectComponentIdentifier identifier = (ProjectComponentIdentifier)id;
                    return !identifier.getBuild().isCurrentBuild();
                }
                return false;
            }
        };
    }

    private static class XcodeBridge
    implements Action<String> {
        private final DefaultXcodeProject xcodeProject;
        private final Project project;
        private final XcodePropertyAdapter xcodePropertyAdapter;

        public XcodeBridge(DefaultXcodeProject xcodeProject, Project project) {
            this.xcodeProject = xcodeProject;
            this.project = project;
            this.xcodePropertyAdapter = new XcodePropertyAdapter(project);
        }

        public void execute(String taskName) {
            if (taskName.startsWith("_xcode")) {
                Task bridgeTask = this.project.getTasks().create(taskName);
                String action = this.xcodePropertyAdapter.getAction();
                if (action.equals("clean")) {
                    bridgeTask.dependsOn(new Object[]{"clean"});
                } else if ("".equals(action) || "build".equals(action)) {
                    XcodeTarget target = this.findXcodeTarget();
                    if (target.isUnitTest()) {
                        this.bridgeTestExecution(bridgeTask, target);
                    } else {
                        this.bridgeProductBuild(bridgeTask, target);
                    }
                } else {
                    throw new GradleException("Unrecognized bridge action from Xcode '" + action + "'");
                }
            }
        }

        private XcodeTarget findXcodeTarget() {
            final String productName = this.xcodePropertyAdapter.getProductName();
            XcodeTarget target = (XcodeTarget)CollectionUtils.findFirst(this.xcodeProject.getTargets(), (Spec)new Spec<XcodeTarget>(){

                public boolean isSatisfiedBy(XcodeTarget target) {
                    return target.getProductName().equals(productName);
                }
            });
            if (target == null) {
                throw new GradleException("Unknown Xcode target '" + productName + "', do you need to re-generate Xcode configuration?");
            }
            return target;
        }

        private void bridgeProductBuild(Task bridgeTask, XcodeTarget target) {
            String configuration = this.xcodePropertyAdapter.getConfiguration();
            if (configuration.equals("Debug")) {
                bridgeTask.dependsOn(new Object[]{target.getDebugOutputFile()});
            } else {
                bridgeTask.dependsOn(new Object[]{target.getReleaseOutputFile()});
            }
        }

        private void bridgeTestExecution(Task bridgeTask, final XcodeTarget target) {
            final String builtProductsPath = this.xcodePropertyAdapter.getBuiltProductsDir();
            Sync syncTask = (Sync)this.project.getTasks().create("syncBundleToXcodeBuiltProductDir", Sync.class, (Action)new Action<Sync>(){

                public void execute(Sync task) {
                    task.from(new Object[]{target.getDebugOutputFile()});
                    task.into((Object)builtProductsPath);
                }
            });
            bridgeTask.dependsOn(new Object[]{syncTask});
        }
    }

    private static class XcodeProjectArtifact
    extends DefaultPublishArtifact {
        private final DefaultXcodeProject xcodeProject;

        public XcodeProjectArtifact(XcodeProject xcodeProject, Object ... tasks) {
            super(null, "xcodeproj", "xcodeproj", null, null, null, tasks);
            this.xcodeProject = (DefaultXcodeProject)xcodeProject;
        }

        public String getName() {
            String fileName = this.xcodeProject.getLocationDir().getName();
            return fileName.substring(0, fileName.length() - ".xcodeproj".length());
        }

        public File getFile() {
            return this.xcodeProject.getLocationDir();
        }
    }
}

