/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.ParameterizedCachedValueProvider;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class CachedValuesManager {
    private static final NotNullLazyKey<CachedValuesManager, Project> INSTANCE_KEY = ServiceManager.createLazyKey(CachedValuesManager.class);
    private final ConcurrentMap<String, Key<CachedValue>> keyForProvider = ContainerUtil.newConcurrentMap();
    private static final ConcurrentMap<String, Key<CachedValue>> globalKeyForProvider = ContainerUtil.newConcurrentMap();

    public static CachedValuesManager getManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getManager"));
        }
        return INSTANCE_KEY.getValue(project);
    }

    @NotNull
    public abstract <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> var1, boolean var2);

    @NotNull
    public abstract <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> var1, boolean var2);

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "createCachedValue"));
        }
        CachedValue<T> cachedValue2 = this.createCachedValue(provider, true);
        if (cachedValue2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "createCachedValue"));
        }
        return cachedValue2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, D extends UserDataHolder, P> T getParameterizedCachedValue(@NotNull D dataHolder, @NotNull Key<ParameterizedCachedValue<T, P>> key, @NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue, P parameter) {
        ParameterizedCachedValue<T, P> value;
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getParameterizedCachedValue"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getParameterizedCachedValue"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getParameterizedCachedValue"));
        }
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = dh.getUserData(key);
            if (value == null) {
                value = this.createParameterizedCachedValue(provider, trackValue);
                value = dh.putUserDataIfAbsent(key, value);
            }
        } else {
            D d = dataHolder;
            synchronized (d) {
                value = dataHolder.getUserData(key);
                if (value == null) {
                    value = this.createParameterizedCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, value);
                }
            }
        }
        return value.getValue(parameter);
    }

    public abstract <T, D extends UserDataHolder> T getCachedValue(@NotNull D var1, @NotNull Key<CachedValue<T>> var2, @NotNull CachedValueProvider<T> var3, boolean var4);

    public <T, D extends UserDataHolder> T getCachedValue(@NotNull D dataHolder, @NotNull CachedValueProvider<T> provider) {
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getCachedValue"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getCachedValue"));
        }
        return this.getCachedValue(dataHolder, this.getKeyForClass(provider.getClass()), provider, false);
    }

    public static <T> T getCachedValue(@NotNull PsiElement psi, @NotNull CachedValueProvider<T> provider) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getCachedValue"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getCachedValue"));
        }
        return CachedValuesManager.getCachedValue(psi, CachedValuesManager.getKeyForClass(provider.getClass(), globalKeyForProvider), provider);
    }

    public static <T> T getCachedValue(@NotNull PsiElement psi, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getCachedValue"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getCachedValue"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getCachedValue"));
        }
        CachedValue<T> value = psi.getUserData(key);
        if (value != null) {
            return value.getValue();
        }
        return CachedValuesManager.getManager(psi.getProject()).getCachedValue(psi, key, () -> {
            PsiFile file;
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "lambda$getCachedValue$0"));
            }
            if (psi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "lambda$getCachedValue$0"));
            }
            CachedValueProvider.Result result2 = provider.compute();
            if (result2 != null && !psi.isPhysical() && (file = psi.getContainingFile()) != null) {
                return CachedValueProvider.Result.create(result2.getValue(), ArrayUtil.append(result2.getDependencyItems(), file, ArrayUtil.OBJECT_ARRAY_FACTORY));
            }
            return result2;
        }, false);
    }

    @NotNull
    public <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass) {
        if (providerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerClass", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getKeyForClass"));
        }
        Key<CachedValue<T>> key = CachedValuesManager.getKeyForClass(providerClass, this.keyForProvider);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getKeyForClass"));
        }
        return key;
    }

    @NotNull
    private static <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass, ConcurrentMap<String, Key<CachedValue>> keyForProvider) {
        if (providerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerClass", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getKeyForClass"));
        }
        String name = providerClass.getName();
        assert (name != null) : providerClass + " doesn't have a name; can't be used for cache value provider";
        Key key = (Key)keyForProvider.get(name);
        if (key == null) {
            key = ConcurrencyUtil.cacheOrGet(keyForProvider, name, Key.create(name));
        }
        Key key2 = key;
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/CachedValuesManager", "getKeyForClass"));
        }
        return key2;
    }
}

