/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import groovy.lang.GroovyObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.tasks.options.OptionValues;
import org.gradle.api.internal.tasks.properties.PropertyMetadata;
import org.gradle.api.internal.tasks.properties.PropertyMetadataStore;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.annotations.DestroysPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.InputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.InputFilePropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.InputFilesPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.InputPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.LocalStatePropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.NoOpPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.OutputDirectoriesPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.OutputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.OutputFilePropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.OutputFilesPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.OverridingPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.internal.reflect.GroovyMethods;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.Types;
import org.gradle.internal.scripts.ScriptOrigin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertyMetadataStore
implements PropertyMetadataStore {
    private static final Collection<Class<?>> IGNORED_SUPER_CLASSES = ImmutableSet.of(ConventionTask.class, DefaultTask.class, AbstractTask.class, Task.class, Object.class, GroovyObject.class, (Object[])new Class[]{IConventionAware.class, ExtensionAware.class, HasConvention.class, ScriptOrigin.class, DynamicObjectAware.class});
    private static final List<? extends PropertyAnnotationHandler> HANDLERS = Arrays.asList(new InputFilePropertyAnnotationHandler(), new InputDirectoryPropertyAnnotationHandler(), new InputFilesPropertyAnnotationHandler(), new OutputFilePropertyAnnotationHandler(), new OutputFilesPropertyAnnotationHandler(), new OutputDirectoryPropertyAnnotationHandler(), new OutputDirectoriesPropertyAnnotationHandler(), new InputPropertyAnnotationHandler(), new DestroysPropertyAnnotationHandler(), new LocalStatePropertyAnnotationHandler(), new NoOpPropertyAnnotationHandler(Nested.class), new NoOpPropertyAnnotationHandler(Inject.class), new NoOpPropertyAnnotationHandler(Console.class), new NoOpPropertyAnnotationHandler(Internal.class), new NoOpPropertyAnnotationHandler(OptionValues.class));
    private final Map<Class<? extends Annotation>, PropertyAnnotationHandler> annotationHandlers;
    private final Multimap<Class<? extends Annotation>, Class<? extends Annotation>> annotationOverrides;
    private final Set<Class<? extends Annotation>> relevantAnnotationTypes;
    private final LoadingCache<Class<?>, TypeMetadata> cache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, TypeMetadata>(){

        public TypeMetadata load(@Nonnull Class<?> type) throws Exception {
            return DefaultPropertyMetadataStore.this.createTypeMetadata(type);
        }
    });

    public DefaultPropertyMetadataStore(Iterable<? extends PropertyAnnotationHandler> customAnnotationHandlers) {
        ImmutableMap annotationsHandlers;
        Iterable allAnnotationHandlers = Iterables.concat(HANDLERS, customAnnotationHandlers);
        this.annotationHandlers = annotationsHandlers = Maps.uniqueIndex((Iterable)allAnnotationHandlers, (Function)new Function<PropertyAnnotationHandler, Class<? extends Annotation>>(){

            public Class<? extends Annotation> apply(PropertyAnnotationHandler handler) {
                return handler.getAnnotationType();
            }
        });
        this.annotationOverrides = DefaultPropertyMetadataStore.collectAnnotationOverrides(allAnnotationHandlers);
        this.relevantAnnotationTypes = DefaultPropertyMetadataStore.collectRelevantAnnotationTypes(annotationsHandlers.keySet());
    }

    private static Multimap<Class<? extends Annotation>, Class<? extends Annotation>> collectAnnotationOverrides(Iterable<PropertyAnnotationHandler> allAnnotationHandlers) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (PropertyAnnotationHandler handler : allAnnotationHandlers) {
            if (!(handler instanceof OverridingPropertyAnnotationHandler)) continue;
            builder.put(((OverridingPropertyAnnotationHandler)handler).getOverriddenAnnotationType(), handler.getAnnotationType());
        }
        return builder.build();
    }

    private static Set<Class<? extends Annotation>> collectRelevantAnnotationTypes(Set<Class<? extends Annotation>> propertyTypeAnnotations) {
        return ImmutableSet.builder().addAll(propertyTypeAnnotations).add(Optional.class).add(SkipWhenEmpty.class).add(PathSensitive.class).build();
    }

    @Override
    public <T> TypeMetadata getTypeMetadata(Class<T> type) {
        return (TypeMetadata)this.cache.getUnchecked(type);
    }

    private <T> TypeMetadata createTypeMetadata(Class<T> type) {
        final Set<Class<? extends Annotation>> propertyTypeAnnotations = this.annotationHandlers.keySet();
        final LinkedHashMap propertyContexts = Maps.newLinkedHashMap();
        Types.walkTypeHierarchy(type, IGNORED_SUPER_CLASSES, (Types.TypeVisitor)new Types.TypeVisitor<T>(){

            public void visitType(Class<? super T> type) {
                if (type.isSynthetic()) {
                    return;
                }
                Map fields = DefaultPropertyMetadataStore.getFields(type);
                List getters = DefaultPropertyMetadataStore.getGetters(type);
                for (Getter getter : getters) {
                    String fieldName;
                    Field field;
                    Method method = getter.getMethod();
                    if (method.isSynthetic() || method.getName().equals("getContentHash") || method.getName().equals("getOriginalClassName") || (field = (Field)fields.get(fieldName = getter.getName())) != null && field.isSynthetic()) continue;
                    DefaultPropertyMetadata propertyMetadata = (DefaultPropertyMetadata)propertyContexts.get(fieldName);
                    if (propertyMetadata == null) {
                        propertyMetadata = new DefaultPropertyMetadata(propertyTypeAnnotations, fieldName, method);
                        propertyContexts.put(fieldName, propertyMetadata);
                    }
                    Iterable declaredAnnotations = DefaultPropertyMetadataStore.this.mergeDeclaredAnnotations(method, field, propertyMetadata);
                    Iterable overriddenAnnotations = DefaultPropertyMetadataStore.this.filterOverridingAnnotations(declaredAnnotations, propertyTypeAnnotations);
                    DefaultPropertyMetadataStore.this.recordAnnotations(propertyMetadata, overriddenAnnotations, propertyTypeAnnotations);
                }
            }
        });
        return new DefaultTypeMetadata((ImmutableSet<PropertyMetadata>)ImmutableSet.builder().addAll(propertyContexts.values()).build());
    }

    private Iterable<Annotation> mergeDeclaredAnnotations(Method method, @Nullable Field field, DefaultPropertyMetadata propertyContext) {
        Collection<Annotation> methodAnnotations = this.collectRelevantAnnotations(method.getDeclaredAnnotations());
        if (Modifier.isPrivate(method.getModifiers()) && !methodAnnotations.isEmpty()) {
            propertyContext.validationMessage("is private and annotated with an input or output annotation");
        }
        if (field == null) {
            return methodAnnotations;
        }
        Collection<Annotation> fieldAnnotations = this.collectRelevantAnnotations(field.getDeclaredAnnotations());
        if (fieldAnnotations.isEmpty()) {
            return methodAnnotations;
        }
        if (methodAnnotations.isEmpty()) {
            return fieldAnnotations;
        }
        for (Annotation methodAnnotation : methodAnnotations) {
            Iterator<Annotation> iFieldAnnotation = fieldAnnotations.iterator();
            while (iFieldAnnotation.hasNext()) {
                Annotation fieldAnnotation = iFieldAnnotation.next();
                if (!methodAnnotation.annotationType().equals(fieldAnnotation.annotationType())) continue;
                propertyContext.validationMessage("has both a getter and field declared with annotation @" + methodAnnotation.annotationType().getSimpleName());
                iFieldAnnotation.remove();
            }
        }
        return Iterables.concat(methodAnnotations, fieldAnnotations);
    }

    private Iterable<Annotation> filterOverridingAnnotations(final Iterable<Annotation> declaredAnnotations, final Set<Class<? extends Annotation>> propertyTypeAnnotations) {
        return Iterables.filter(declaredAnnotations, (Predicate)new Predicate<Annotation>(){

            public boolean apply(Annotation input) {
                Class<? extends Annotation> annotationType = input.annotationType();
                if (!propertyTypeAnnotations.contains(annotationType)) {
                    return true;
                }
                for (Class overridingAnnotation : DefaultPropertyMetadataStore.this.annotationOverrides.get(annotationType)) {
                    for (Annotation declaredAnnotation : declaredAnnotations) {
                        if (!declaredAnnotation.annotationType().equals(overridingAnnotation)) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }

    private void recordAnnotations(DefaultPropertyMetadata propertyContext, Iterable<Annotation> annotations, Set<Class<? extends Annotation>> propertyTypeAnnotations) {
        LinkedHashSet declaredPropertyTypes = Sets.newLinkedHashSet();
        for (Annotation annotation : annotations) {
            if (propertyTypeAnnotations.contains(annotation.annotationType())) {
                declaredPropertyTypes.add(annotation.annotationType());
            }
            propertyContext.addAnnotation(annotation);
        }
        if (declaredPropertyTypes.size() > 1) {
            propertyContext.validationMessage("has conflicting property types declared: " + Joiner.on((String)", ").join(Iterables.transform((Iterable)declaredPropertyTypes, (Function)new Function<Class<? extends Annotation>, String>(){

                public String apply(Class<? extends Annotation> annotationType) {
                    return "@" + annotationType.getSimpleName();
                }
            })));
        }
    }

    private Collection<Annotation> collectRelevantAnnotations(Annotation[] annotations) {
        ArrayList relevantAnnotations = Lists.newArrayListWithCapacity((int)annotations.length);
        for (Annotation annotation : annotations) {
            if (!this.relevantAnnotationTypes.contains(annotation.annotationType())) continue;
            relevantAnnotations.add(annotation);
        }
        return relevantAnnotations;
    }

    private static Map<String, Field> getFields(Class<?> type) {
        HashMap fields = Maps.newHashMap();
        for (Field field : type.getDeclaredFields()) {
            fields.put(field.getName(), field);
        }
        return fields;
    }

    private static List<Getter> getGetters(Class<?> type) {
        Method[] methods = type.getDeclaredMethods();
        ArrayList getters = Lists.newArrayListWithCapacity((int)methods.length);
        for (Method method : methods) {
            PropertyAccessorType accessorType = PropertyAccessorType.of((Method)method);
            if (accessorType == null || accessorType == PropertyAccessorType.SETTER || method.isBridge() || GroovyMethods.isObjectMethod((Method)method)) continue;
            getters.add(new Getter(method, accessorType.propertyNameFor(method)));
        }
        Collections.sort(getters);
        return getters;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultPropertyMetadata
    implements PropertyMetadata {
        private final Set<Class<? extends Annotation>> propertyTypeAnnotations;
        private final String fieldName;
        private final Method method;
        private Class<? extends Annotation> propertyType;
        private final List<Annotation> annotations = Lists.newArrayList();
        private final List<String> validationMessages = Lists.newArrayList();

        public DefaultPropertyMetadata(Set<Class<? extends Annotation>> propertyTypeAnnotations, String fieldName, Method method) {
            this.propertyTypeAnnotations = propertyTypeAnnotations;
            this.fieldName = fieldName;
            this.method = method;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        public void addAnnotation(Annotation annotation) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (this.propertyType == null && this.isPropertyTypeAnnotation(annotationType)) {
                this.propertyType = annotationType;
            }
            if (!this.isAnnotationPresent(annotation.annotationType())) {
                this.annotations.add(annotation);
            }
        }

        private boolean isPropertyTypeAnnotation(Class<? extends Annotation> annotationType) {
            return this.propertyTypeAnnotations.contains(annotationType);
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        @Override
        @Nullable
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            for (Annotation annotation : this.annotations) {
                if (!annotationType.equals(annotation.annotationType())) continue;
                return (A)((Annotation)annotationType.cast(annotation));
            }
            return null;
        }

        public void validationMessage(String message) {
            this.validationMessages.add(message);
        }

        @Override
        public List<String> getValidationMessages() {
            return this.validationMessages;
        }

        @Override
        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        @Nullable
        public PropertyAnnotationHandler getPropertyValueVisitor() {
            return (PropertyAnnotationHandler)DefaultPropertyMetadataStore.this.annotationHandlers.get(this.propertyType);
        }

        @Override
        @Nullable
        public Class<? extends Annotation> getPropertyType() {
            return this.propertyType;
        }

        @Override
        public Class<?> getDeclaredType() {
            return this.method.getReturnType();
        }

        @Override
        public Method getMethod() {
            return this.method;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultTypeMetadata
    implements TypeMetadata {
        private final Set<PropertyMetadata> propertiesMetadata;

        public DefaultTypeMetadata(ImmutableSet<PropertyMetadata> propertiesMetadata) {
            this.propertiesMetadata = propertiesMetadata;
        }

        @Override
        public Set<PropertyMetadata> getPropertiesMetadata() {
            return this.propertiesMetadata;
        }

        @Override
        public boolean isAnnotated() {
            for (PropertyMetadata metadata : this.propertiesMetadata) {
                if (metadata.getPropertyType() == null) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Getter
    implements Comparable<Getter> {
        private final Method method;
        private final String name;

        public Getter(Method method, String name) {
            this.method = method;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public int compareTo(@Nonnull Getter o) {
            return this.method.getName().compareTo(o.method.getName());
        }
    }
}

