/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsBibParser;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsEntryComparator;
import com.dickimawbooks.bib2gls.Bib2GlsEntryLetterComparator;
import com.dickimawbooks.bib2gls.Bib2GlsEntryNumericComparator;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.FlattenedHomograph;
import com.dickimawbooks.bib2gls.FlattenedPreSort;
import com.dickimawbooks.bib2gls.GlsRecord;
import com.dickimawbooks.bib2gls.GroupTitle;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.aux.AuxData;
import com.dickimawbooks.texparserlib.aux.AuxParser;
import com.dickimawbooks.texparserlib.bib.BibData;
import com.dickimawbooks.texparserlib.bib.BibEntry;
import com.dickimawbooks.texparserlib.bib.BibParser;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.generic.DefaultTeXParserListener;
import com.dickimawbooks.texparserlib.html.L2HStringConverter;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class GlsResource {
    private File texFile;
    private Vector<TeXPath> sources = new Vector();
    private String[] skipFields = null;
    private String[] externalPrefixes = null;
    private String type = null;
    private String category = null;
    private String sort = "locale";
    private String sortField = "sort";
    private String sortRules = null;
    private String secondarySortRules = null;
    private String dualSortRules = null;
    private String dualType = null;
    private String dualCategory = null;
    private String dualSort = null;
    private String dualSortField = "sort";
    private String pluralSuffix = "\\glspluralsuffix ";
    private String dualPluralSuffix = "\\glspluralsuffix ";
    private String shortPluralSuffix = null;
    private String dualShortPluralSuffix = null;
    private Charset bibCharset = null;
    private boolean flatten = false;
    private boolean interpretPreamble = true;
    private boolean setWidest = false;
    private String secondaryType = null;
    private String secondarySort = null;
    private String secondaryField = null;
    private int minLocationRange = 3;
    private int locGap = 1;
    private String suffixF = null;
    private String suffixFF = null;
    private String preamble = null;
    private BibValueList preambleList = null;
    private HashMap<String, Pattern> fieldPatterns = null;
    private boolean fieldPatternsAnd = true;
    private static final String PATTERN_FIELD_ID = "id";
    private static final String PATTERN_FIELD_ENTRY_TYPE = "entrytype";
    private Vector<Bib2GlsEntry> bibData;
    private Vector<Bib2GlsEntry> dualData;
    private Bib2Gls bib2gls;
    private int collatorStrength = 0;
    private int collatorDecomposition = 1;
    private int breakPoint = 1;
    private String breakPointMarker = "|";
    private int seeLocation = 2;
    private int seeAlsoLocation = 2;
    private String[] locationPrefix = null;
    private String[] locationSuffix = null;
    private boolean saveLocations = true;
    public static final int FLATTEN_LONELY_FALSE = 0;
    public static final int FLATTEN_LONELY_PRE_SORT = 1;
    public static final int FLATTEN_LONELY_POST_SORT = 2;
    private int flattenLonely = 0;
    public static final int FLATTEN_LONELY_RULE_ONLY_UNRECORDED_PARENTS = 0;
    public static final int FLATTEN_LONELY_RULE_NO_DISCARD = 1;
    public static final int FLATTEN_LONELY_RULE_DISCARD_UNRECORDED = 2;
    private int flattenLonelyRule = 0;
    private boolean saveChildCount = false;
    private boolean defpagesname = false;
    public static final int ALIAS_LOC_OMIT = 0;
    public static final int ALIAS_LOC_TRANS = 1;
    public static final int ALIAS_LOC_KEEP = 2;
    private int aliasLocations = 1;
    private boolean aliases = false;
    private String labelPrefix = null;
    private String dualPrefix = "dual.";
    private String dualField = null;
    private HashMap<String, String> dualEntryMap;
    private HashMap<String, String> dualAbbrevMap;
    private HashMap<String, String> dualSymbolMap;
    private HashMap<String, String> dualEntryAbbrevMap;
    private String dualEntryFirstMap;
    private String dualAbbrevFirstMap;
    private String dualSymbolFirstMap;
    private String dualEntryAbbrevFirstMap;
    private boolean backLinkDualEntry = false;
    private boolean backLinkDualAbbrev = false;
    private boolean backLinkDualSymbol = false;
    private boolean backLinkDualEntryAbbrev = false;
    private String shortCaseChange = null;
    private String dualShortCaseChange = null;
    private String masterLinkPrefix = null;
    private Vector<TeXPath> masterGlsTeXPath = null;
    private TeXPath masterPdfPath = null;
    private String[] masterSelection = null;
    private String[] counters = null;
    private Random random = null;
    private HashMap<String, GroupTitle> groupTitleMap = null;
    private Vector<GlsRecord> supplementalRecords = null;
    private TeXPath supplementalPdfPath = null;
    private String[] supplementalSelection = null;
    private String supplementalCategory = null;
    private String groupField = null;
    public static final int SELECTION_RECORDED_AND_DEPS = 0;
    public static final int SELECTION_RECORDED_AND_DEPS_AND_SEE = 1;
    public static final int SELECTION_RECORDED_NO_DEPS = 2;
    public static final int SELECTION_RECORDED_AND_PARENTS = 3;
    public static final int SELECTION_ALL = 4;
    private int selectionMode = 0;
    private static final String[] SELECTION_OPTIONS = new String[]{"recorded and deps", "recorded and deps and see", "recorded no deps", "recorded and ancestors", "all"};

    public GlsResource(TeXParser teXParser, AuxData auxData, String string, String string2) throws IOException, InterruptedException, Bib2GlsException {
        this.pluralSuffix = string;
        this.dualPluralSuffix = string;
        this.init(teXParser, auxData.getArg(0), auxData.getArg(1));
    }

    private void init(TeXParser teXParser, TeXObject teXObject, TeXObject teXObject2) throws IOException, InterruptedException, Bib2GlsException, IllegalArgumentException {
        this.bib2gls = (Bib2Gls)teXParser.getListener().getTeXApp();
        TeXPath teXPath = new TeXPath(teXParser, teXObject2.toString(teXParser), "glstex");
        this.texFile = this.bib2gls.resolveFile(teXPath.getFile());
        this.bib2gls.registerTeXFile(this.texFile);
        String string = teXPath.getTeXPath(true);
        KeyValList keyValList = KeyValList.getList(teXParser, teXObject);
        String[] stringArray = null;
        String string2 = null;
        String string3 = null;
        if (this.bib2gls.useGroupField()) {
            this.groupTitleMap = new HashMap();
        }
        block4: for (String string4 : keyValList.keySet()) {
            if (string4.equals("src")) {
                stringArray = this.getStringArray(teXParser, keyValList, string4);
                if (stringArray == null) {
                    this.sources.add(this.bib2gls.getBibFilePath(teXParser, string));
                    continue;
                }
                for (String string5 : stringArray) {
                    this.sources.add(this.bib2gls.getBibFilePath(teXParser, string5));
                }
                continue;
            }
            if (string4.equals("master")) {
                string2 = this.getRequired(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("master-resources")) {
                this.masterSelection = this.getStringArray(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("supplemental-locations")) {
                string3 = this.getRequired(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("supplemental-category")) {
                this.supplementalCategory = this.getRequired(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("supplemental-selection")) {
                this.supplementalSelection = this.getStringArray(teXParser, keyValList, string4);
                if (this.supplementalSelection == null || this.supplementalSelection.length == 0) {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string4));
                }
                if (this.supplementalSelection.length != 1 || !this.supplementalSelection[0].equals("selected")) continue;
                this.supplementalSelection = null;
                continue;
            }
            if (string4.equals("short-case-change")) {
                this.shortCaseChange = this.getChoice(teXParser, keyValList, string4, "none", "lc", "uc", "lc-cs", "uc-cs");
                continue;
            }
            if (string4.equals("dual-short-case-change")) {
                this.dualShortCaseChange = this.getChoice(teXParser, keyValList, string4, "none", "lc", "uc", "lc-cs", "uc-cs");
                continue;
            }
            if (string4.equals("short-plural-suffix")) {
                this.shortPluralSuffix = this.getOptional(teXParser, "", keyValList, string4);
                if (!this.shortPluralSuffix.equals("use-default")) continue;
                this.shortPluralSuffix = null;
                continue;
            }
            if (string4.equals("dual-short-plural-suffix")) {
                this.dualShortPluralSuffix = this.getOptional(teXParser, "", keyValList, string4);
                if (!this.dualShortPluralSuffix.equals("use-default")) continue;
                this.dualShortPluralSuffix = null;
                continue;
            }
            if (string4.equals("match-op")) {
                String string6 = this.getChoice(teXParser, keyValList, string4, "and", "or");
                this.fieldPatternsAnd = string6.equals("and");
                continue;
            }
            if (string4.equals("match")) {
                TeXObject[] teXObjectArray = this.getTeXObjectArray(teXParser, keyValList, string4);
                if (teXObjectArray == null) {
                    this.fieldPatterns = null;
                    continue;
                }
                this.fieldPatterns = new HashMap();
                for (int i = 0; i < teXObjectArray.length; ++i) {
                    String string5;
                    if (!(teXObjectArray[i] instanceof TeXObjectList)) {
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", string4, ((TeXObject)keyValList.get(string4)).toString(teXParser)));
                    }
                    Vector<TeXObject> vector = this.splitList(teXParser, '=', (TeXObjectList)teXObjectArray[i]);
                    if (vector == null || vector.size() == 0) continue;
                    string5 = vector.get(0).toString(teXParser);
                    if (vector.size() > 2) {
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.keylist.value", string5, teXObjectArray[i].toString(teXParser), string4));
                    }
                    String string7 = vector.size() == 1 ? "" : vector.get(1).toString(teXParser);
                    Pattern pattern = this.fieldPatterns.get(string5);
                    pattern = pattern == null ? Pattern.compile(string7) : Pattern.compile(String.format("(?:%s)|(?:%s)", pattern.pattern(), string7));
                    try {
                        this.fieldPatterns.put(string5, pattern);
                        continue;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.keylist.pattern", string5, string7, string4), patternSyntaxException);
                    }
                }
                continue;
            }
            if (string4.equals("secondary")) {
                TeXObject teXObject3 = this.getRequiredObject(teXParser, keyValList, string4);
                if (!(teXObject3 instanceof TeXObjectList)) {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", string4, teXObject3.toString(teXParser)));
                }
                Vector<TeXObject> vector = this.splitList(teXParser, ':', (TeXObjectList)teXObject3);
                int n = vector.size();
                if (n == 2) {
                    this.secondaryType = vector.get(1).toString(teXParser);
                } else if (n == 3) {
                    this.secondaryField = vector.get(1).toString(teXParser);
                    this.secondaryType = vector.get(2).toString(teXParser);
                } else {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", string4, teXObject3.toString(teXParser)));
                }
                this.secondarySort = vector.get(0).toString(teXParser);
                continue;
            }
            if (string4.equals("ext-prefixes")) {
                this.externalPrefixes = this.getStringArray(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("interpret-preamble")) {
                this.interpretPreamble = this.getBoolean(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("flatten")) {
                this.flatten = this.getBoolean(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("flatten-lonely")) {
                String string8 = this.getChoice(teXParser, keyValList, string4, "false", "presort", "postsort");
                if (string8.equals("false")) {
                    this.flattenLonely = 0;
                    continue;
                }
                if (string8.equals("presort")) {
                    this.flattenLonely = 1;
                    continue;
                }
                if (!string8.equals("postsort")) continue;
                this.flattenLonely = 2;
                continue;
            }
            if (string4.equals("flatten-lonely-rule")) {
                String string9 = this.getChoice(teXParser, keyValList, string4, "only unrecorded parents", "no discard", "discard unrecorded");
                if (string9.equals("only unrecorded parents")) {
                    this.flattenLonelyRule = 0;
                    continue;
                }
                if (string9.equals("no discard")) {
                    this.flattenLonelyRule = 1;
                    continue;
                }
                if (!string9.equals("discard unrecorded")) continue;
                this.flattenLonelyRule = 2;
                continue;
            }
            if (string4.equals("save-locations")) {
                this.saveLocations = this.getBoolean(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("save-child-count")) {
                this.saveChildCount = this.getBoolean(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("alias-loc")) {
                String string10 = this.getChoice(teXParser, keyValList, string4, "omit", "transfer", "keep");
                if (string10.equals("omit")) {
                    this.aliasLocations = 0;
                    continue;
                }
                if (string10.equals("transfer")) {
                    this.aliasLocations = 1;
                    continue;
                }
                this.aliasLocations = 2;
                continue;
            }
            if (string4.equals("set-widest")) {
                this.setWidest = this.getBoolean(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("dual-entry-map")) {
                String[] stringArray2 = new String[1];
                this.dualEntryMap = this.getDualMap(teXParser, keyValList, string4, stringArray2);
                this.dualEntryFirstMap = stringArray2[0];
                continue;
            }
            if (string4.equals("dual-abbrv-map")) {
                String[] stringArray3 = new String[1];
                this.dualAbbrevMap = this.getDualMap(teXParser, keyValList, string4, stringArray3);
                this.dualAbbrevFirstMap = stringArray3[0];
                continue;
            }
            if (string4.equals("dual-entryabbrv-map")) {
                String[] stringArray4 = new String[1];
                this.dualEntryAbbrevMap = this.getDualMap(teXParser, keyValList, string4, stringArray4);
                this.dualEntryAbbrevFirstMap = stringArray4[0];
                continue;
            }
            if (string4.equals("dual-symbol-map")) {
                String[] stringArray5 = new String[1];
                this.dualSymbolMap = this.getDualMap(teXParser, keyValList, string4, stringArray5);
                this.dualSymbolFirstMap = stringArray5[0];
                continue;
            }
            if (string4.equals("dual-backlink")) {
                if (this.getBoolean(teXParser, keyValList, string4)) {
                    this.backLinkDualEntry = true;
                    this.backLinkDualAbbrev = true;
                    this.backLinkDualSymbol = true;
                    this.backLinkDualEntryAbbrev = true;
                    continue;
                }
                this.backLinkDualEntry = false;
                this.backLinkDualAbbrev = false;
                this.backLinkDualSymbol = false;
                this.backLinkDualEntryAbbrev = false;
                continue;
            }
            if (string4.equals("dual-entry-backlink")) {
                this.backLinkDualEntry = this.getBoolean(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("dual-abbrv-backlink")) {
                this.backLinkDualAbbrev = this.getBoolean(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("dual-entryabbrv-backlink")) {
                this.backLinkDualEntryAbbrev = this.getBoolean(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("dual-symbol-backlink")) {
                this.backLinkDualSymbol = this.getBoolean(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("type")) {
                this.type = this.getRequired(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("dual-type")) {
                this.dualType = this.getRequired(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("dual-field")) {
                this.dualField = this.getOptional(teXParser, "dual", keyValList, string4);
                continue;
            }
            if (string4.equals("category")) {
                this.category = this.getRequired(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("dual-category")) {
                this.dualCategory = this.getRequired(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("label-prefix")) {
                this.labelPrefix = this.getOptional(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("dual-prefix")) {
                this.dualPrefix = this.getOptional(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("sort")) {
                this.sort = this.getOptional(teXParser, "doc", keyValList, string4);
                if (!this.sort.equals("none") && !this.sort.equals("unsrt")) continue;
                this.sort = null;
                continue;
            }
            if (string4.equals("sort-rule")) {
                this.sortRules = this.replaceHex(this.getRequired(teXParser, keyValList, string4));
                continue;
            }
            if (string4.equals("dual-sort-rule")) {
                this.dualSortRules = this.replaceHex(this.getRequired(teXParser, keyValList, string4));
                continue;
            }
            if (string4.equals("secondary-sort-rule")) {
                this.secondarySortRules = this.replaceHex(this.getRequired(teXParser, keyValList, string4));
                continue;
            }
            if (string4.equals("group")) {
                if (this.bib2gls.useGroupField()) {
                    this.groupField = this.getOptional(teXParser, "auto", keyValList, string4);
                    if (!this.groupField.equals("auto")) continue;
                    this.groupField = null;
                    continue;
                }
                this.bib2gls.warning(this.bib2gls.getMessage("warning.group.option.required", string4, "--group"));
                this.groupField = null;
                continue;
            }
            if (string4.equals("shuffle")) {
                long l = this.getOptionalLong(teXParser, 0L, keyValList, string4);
                this.random = l == 0L ? new Random() : new Random(l);
                this.sort = "random";
                this.flatten = true;
                continue;
            }
            if (string4.equals("dual-sort")) {
                this.dualSort = this.getOptional(teXParser, "doc", keyValList, string4);
                if (!this.dualSort.equals("unsrt")) continue;
                this.dualSort = "none";
                continue;
            }
            if (string4.equals("sort-field")) {
                this.sortField = this.getRequired(teXParser, keyValList, string4);
                if (this.sortField.equals(PATTERN_FIELD_ID) || this.bib2gls.isKnownField(this.sortField)) continue;
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", string4, this.sortField));
            }
            if (string4.equals("dual-sort-field")) {
                this.dualSortField = this.getRequired(teXParser, keyValList, string4);
                if (this.dualSortField.equals(PATTERN_FIELD_ID) || this.bib2gls.isKnownField(this.dualSortField)) continue;
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.value", string4, this.dualSortField));
            }
            if (string4.equals("charset")) {
                this.bibCharset = Charset.forName(this.getRequired(teXParser, keyValList, string4));
                continue;
            }
            if (string4.equals("min-loc-range")) {
                this.minLocationRange = this.getRequiredIntGe(teXParser, 2, "none", Integer.MAX_VALUE, keyValList, string4);
                continue;
            }
            if (string4.equals("loc-gap")) {
                this.bib2gls.warning(this.bib2gls.getMessage("warning.deprecated", string4, "max-loc-diff"));
                this.locGap = this.getRequiredIntGe(teXParser, 1, keyValList, string4);
                continue;
            }
            if (string4.equals("max-loc-diff")) {
                this.locGap = this.getRequiredIntGe(teXParser, 1, keyValList, string4);
                continue;
            }
            if (string4.equals("suffixF")) {
                this.suffixF = this.getOptional(teXParser, "", keyValList, string4);
                if (!this.suffixF.equals("none")) continue;
                this.suffixF = null;
                continue;
            }
            if (string4.equals("suffixFF")) {
                this.suffixFF = this.getOptional(teXParser, "", keyValList, string4);
                if (!this.suffixFF.equals("none")) continue;
                this.suffixFF = null;
                continue;
            }
            if (string4.equals("see")) {
                String string11 = this.getChoice(teXParser, keyValList, string4, "omit", "before", "after");
                if (string11.equals("omit")) {
                    this.seeLocation = 0;
                    continue;
                }
                if (string11.equals("before")) {
                    this.seeLocation = 1;
                    continue;
                }
                if (!string11.equals("after")) continue;
                this.seeLocation = 2;
                continue;
            }
            if (string4.equals("seealso")) {
                String string12 = this.getChoice(teXParser, keyValList, string4, "omit", "before", "after");
                if (string12.equals("omit")) {
                    this.seeAlsoLocation = 0;
                    continue;
                }
                if (string12.equals("before")) {
                    this.seeAlsoLocation = 1;
                    continue;
                }
                if (!string12.equals("after")) continue;
                this.seeAlsoLocation = 2;
                continue;
            }
            if (string4.equals("loc-counters")) {
                String[] stringArray6 = this.getStringArray(teXParser, keyValList, string4);
                if (stringArray6 == null || stringArray6.length == 0) {
                    throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string4));
                }
                if (stringArray6.length == 1) {
                    if (stringArray6[0].equals("as-use")) {
                        this.counters = null;
                        continue;
                    }
                    this.counters = stringArray6;
                    continue;
                }
                this.counters = stringArray6;
                continue;
            }
            if (string4.equals("loc-prefix")) {
                String[] stringArray7 = this.getStringArray(teXParser, "true", keyValList, string4);
                this.defpagesname = false;
                if (stringArray7.length == 1) {
                    if (stringArray7[0].equals("false")) {
                        this.locationPrefix = null;
                        continue;
                    }
                    if (stringArray7[0].equals("list")) {
                        this.locationPrefix = new String[]{"\\pagelistname "};
                        continue;
                    }
                    if (stringArray7[0].equals("true")) {
                        this.locationPrefix = new String[]{"\\bibglspagename ", this.bib2gls.getMessage("\\bibglspagesname ")};
                        this.defpagesname = true;
                        continue;
                    }
                    this.locationPrefix = stringArray7;
                    continue;
                }
                this.locationPrefix = stringArray7;
                continue;
            }
            if (string4.equals("loc-suffix")) {
                String[] stringArray8 = this.getStringArray(teXParser, "\\@.", keyValList, string4);
                if (stringArray8.length == 1) {
                    if (stringArray8[0].equals("false")) {
                        this.locationSuffix = null;
                        continue;
                    }
                    this.locationSuffix = stringArray8;
                    continue;
                }
                this.locationSuffix = stringArray8;
                continue;
            }
            if (string4.equals("ignore-fields")) {
                this.skipFields = this.getStringArray(teXParser, keyValList, string4);
                continue;
            }
            if (string4.equals("selection")) {
                String string13 = this.getChoice(teXParser, keyValList, string4, SELECTION_OPTIONS);
                this.selectionMode = -1;
                for (int i = 0; i < SELECTION_OPTIONS.length; ++i) {
                    if (!string13.equals(SELECTION_OPTIONS[i])) continue;
                    this.selectionMode = i;
                    continue block4;
                }
                continue;
            }
            if (string4.equals("break-at")) {
                String string14 = this.getChoice(teXParser, keyValList, string4, "none", "word", "character", "sentence");
                if (string14.equals("none")) {
                    this.breakPoint = 0;
                    continue;
                }
                if (string14.equals("word")) {
                    this.breakPoint = 1;
                    continue;
                }
                if (string14.equals("character")) {
                    this.breakPoint = 2;
                    continue;
                }
                if (!string14.equals("sentence")) continue;
                this.breakPoint = 3;
                continue;
            }
            if (string4.equals("break-marker")) {
                this.breakPointMarker = this.getOptional(teXParser, "", keyValList, string4);
                continue;
            }
            if (string4.equals("strength")) {
                String string15 = this.getChoice(teXParser, keyValList, string4, "primary", "secondary", "tertiary", "identical");
                if (string15.equals("primary")) {
                    this.collatorStrength = 0;
                    continue;
                }
                if (string15.equals("secondary")) {
                    this.collatorStrength = 1;
                    continue;
                }
                if (string15.equals("tertiary")) {
                    this.collatorStrength = 2;
                    continue;
                }
                if (!string15.equals("identical")) continue;
                this.collatorStrength = 3;
                continue;
            }
            if (string4.equals("decomposition")) {
                String string16 = this.getChoice(teXParser, keyValList, string4, "none", "canonical", "full");
                if (string16.equals("none")) {
                    this.collatorDecomposition = 0;
                    continue;
                }
                if (string16.equals("canonical")) {
                    this.collatorDecomposition = 1;
                    continue;
                }
                if (!string16.equals("full")) continue;
                this.collatorDecomposition = 2;
                continue;
            }
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.syntax.unknown_option", string4));
        }
        if (string3 != null) {
            this.parseSupplemental(teXParser, string3);
        }
        if (string2 != null) {
            this.parseMaster(teXParser, string2);
        }
        if ("doc".equals(this.sort)) {
            this.sort = this.bib2gls.getDocDefaultLocale();
        }
        if ("doc".equals(this.dualSort)) {
            this.dualSort = this.bib2gls.getDocDefaultLocale();
        }
        if ("custom".equals(this.sort) && this.sortRules == null) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("warning.option.pair.required", "sort=custom", "sort-rules"));
        }
        if ("custom".equals(this.dualSort) && this.dualSortRules == null) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("warning.option.pair.required", "dual-sort=custom", "dual-sort-rules"));
        }
        if ("custom".equals(this.secondarySort) && this.secondarySortRules == null) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("warning.option.pair.required", this.secondaryField == null ? String.format("secondary={%s:%s}", this.secondarySort, this.secondaryType) : String.format("secondary={%s:%s:%s}", this.secondarySort, this.secondaryField, this.secondaryType), "secondary-sort-rules"));
        }
        if (this.selectionMode == 4 && "use".equals(this.sort)) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "selection=all", "sort=use"));
            this.sort = null;
        }
        if (this.labelPrefix == null && this.dualPrefix == null || this.labelPrefix != null && this.dualPrefix != null && this.labelPrefix.equals(this.dualPrefix)) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.option.clash", String.format("label-prefix={%s}", this.labelPrefix == null ? "" : this.labelPrefix), String.format("dual-prefix={%s}", this.dualPrefix == null ? "" : this.dualPrefix)));
        }
        if (this.dualEntryMap == null) {
            this.dualEntryMap = new HashMap();
            this.dualEntryMap.put("name", "description");
            this.dualEntryMap.put("plural", "descriptionplural");
            this.dualEntryMap.put("description", "name");
            this.dualEntryMap.put("descriptionplural", "plural");
            this.dualEntryFirstMap = "name";
        }
        if (this.dualAbbrevMap == null) {
            this.dualAbbrevMap = new HashMap();
            this.dualAbbrevMap.put("short", "dualshort");
            this.dualAbbrevMap.put("shortplural", "dualshortplural");
            this.dualAbbrevMap.put("long", "duallong");
            this.dualAbbrevMap.put("longplural", "duallongplural");
            this.dualAbbrevMap.put("dualshort", "short");
            this.dualAbbrevMap.put("dualshortplural", "shortplural");
            this.dualAbbrevMap.put("duallong", "long");
            this.dualAbbrevMap.put("duallongplural", "longplural");
            this.dualAbbrevFirstMap = "short";
        }
        if (this.dualEntryAbbrevMap == null) {
            this.dualEntryAbbrevMap = new HashMap();
            this.dualEntryAbbrevMap.put("long", "name");
            this.dualEntryAbbrevMap.put("short", "text");
            this.dualEntryAbbrevFirstMap = "long";
        }
        if (this.dualSymbolMap == null) {
            this.dualSymbolMap = new HashMap();
            this.dualSymbolMap.put("name", "symbol");
            this.dualSymbolMap.put("plural", "symbolplural");
            this.dualSymbolMap.put("symbol", "name");
            this.dualSymbolMap.put("symbolplural", "plural");
            this.dualSymbolFirstMap = "name";
        }
        if (this.dualSort == null) {
            this.dualSort = "combine";
        } else if (this.dualSort.equals("none")) {
            this.dualSort = null;
        }
        if (this.dualSortField == null) {
            this.dualSortField = this.sortField;
        }
        if (this.bib2gls.getVerboseLevel() > 0) {
            this.bib2gls.logMessage();
            this.bib2gls.verbose(this.bib2gls.getMessage("message.selection.mode", SELECTION_OPTIONS[this.selectionMode]));
            if (this.skipFields != null) {
                this.bib2gls.verbose(this.bib2gls.getMessage("message.ignore.fields"));
                for (int i = 0; i < this.skipFields.length; ++i) {
                    this.bib2gls.verbose(this.skipFields[i]);
                }
                this.bib2gls.logMessage();
            }
            this.bib2gls.verbose(this.bib2gls.getMessage("message.sort.mode", this.sort == null ? "none" : this.sort));
            this.bib2gls.verbose(this.bib2gls.getMessage("message.sort.field", this.sortField));
            this.bib2gls.verbose(this.bib2gls.getMessage("message.label.prefix", this.labelPrefix == null ? "" : this.labelPrefix));
            this.bib2gls.verbose(this.bib2gls.getMessage("message.dual.label.prefix", this.dualPrefix == null ? "" : this.dualPrefix));
            this.bib2gls.verbose(this.bib2gls.getMessage("message.dual.sort.mode", this.dualSort == null ? "none" : this.dualSort));
            this.bib2gls.verbose(this.bib2gls.getMessage("message.dual.sort.field", this.dualSortField));
            this.bib2gls.logMessage();
            this.bib2gls.verbose(this.bib2gls.getMessage("message.dual.entry.mappings"));
            for (String string4 : this.dualEntryMap.keySet()) {
                this.bib2gls.verbose(String.format("%s -> %s", string4, this.dualEntryMap.get(string4)));
            }
            this.bib2gls.logMessage();
            this.bib2gls.verbose(this.bib2gls.getMessage("message.dual.symbol.mappings"));
            for (String string4 : this.dualSymbolMap.keySet()) {
                this.bib2gls.verbose(String.format("%s -> %s", string4, this.dualSymbolMap.get(string4)));
            }
            this.bib2gls.logMessage();
            this.bib2gls.verbose(this.bib2gls.getMessage("message.dual.abbreviation.mappings"));
            for (String string4 : this.dualAbbrevMap.keySet()) {
                this.bib2gls.verbose(String.format("%s -> %s", string4, this.dualAbbrevMap.get(string4)));
            }
            this.bib2gls.logMessage();
            this.bib2gls.verbose(this.bib2gls.getMessage("message.dual.entryabbreviation.mappings"));
            for (String string4 : this.dualEntryAbbrevMap.keySet()) {
                this.bib2gls.verbose(String.format("%s -> %s", string4, this.dualEntryAbbrevMap.get(string4)));
            }
            this.bib2gls.logMessage();
        }
        if (stringArray == null && string2 == null) {
            try {
                this.sources.add(this.bib2gls.getBibFilePath(teXParser, string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Bib2GlsException(this.bib2gls.getMessage("error.missing.src", string + ".bib"), fileNotFoundException);
            }
        }
    }

    private void parseMaster(TeXParser teXParser, String string) throws IOException, Bib2GlsException {
        if (this.sources.size() > 0) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "src"));
            this.sources.clear();
        }
        if (this.supplementalRecords != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "supplemental-locations"));
        }
        if (this.shortCaseChange != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "short-case-change"));
        }
        if (this.dualShortCaseChange != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-short-case-change"));
        }
        if (this.shortPluralSuffix != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "short-plural-suffix"));
        }
        if (this.dualShortPluralSuffix != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-short-plural-suffix"));
        }
        if (this.fieldPatterns != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "match"));
        }
        if (this.secondaryType != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "secondary"));
        }
        if (this.externalPrefixes != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "ext-prefixes"));
        }
        if (this.flatten) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "flatten"));
        }
        if (this.setWidest) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "set-widest"));
        }
        if (this.dualType != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-type"));
        }
        if (this.dualField != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-field"));
        }
        if (this.dualCategory != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-category"));
        }
        if (!"dual.".equals(this.dualPrefix)) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-prefix"));
        }
        if (this.dualSort != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-sort"));
        }
        if (!this.dualSortField.equals("sort")) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "dual-sort"));
        }
        if (!"locale".equals(this.sort)) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "sort"));
        }
        if (!this.sortField.equals("sort")) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "sort"));
        }
        if (this.bibCharset != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "charset"));
        }
        if (this.minLocationRange != 3) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "min-loc-range"));
        }
        if (this.locGap != 1) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "loc-gap"));
        }
        if (this.suffixF != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "suffixF"));
        }
        if (this.suffixFF != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "suffixFF"));
        }
        if (this.seeLocation != 2) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "see"));
        }
        if (this.seeAlsoLocation != 2) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "seealso"));
        }
        if (this.locationPrefix != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "loc-prefix"));
        }
        if (this.locationSuffix != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "loc-suffix"));
        }
        if (this.skipFields != null) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "ignore-fields"));
        }
        if (this.selectionMode != 0) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "selection"));
        }
        if (this.collatorStrength != 0) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "strength"));
        }
        if (this.collatorDecomposition != 1) {
            this.bib2gls.warning(this.bib2gls.getMessage("warning.option.clash", "master", "decomposition"));
        }
        TeXPath teXPath = new TeXPath(teXParser, string + ".aux", false);
        this.bib2gls.checkReadAccess(teXPath);
        File file = teXPath.getFile();
        if (this.category == null) {
            this.category = "master";
        }
        if (this.type == null) {
            this.type = "master";
        }
        AuxParser auxParser = new AuxParser(this.bib2gls){

            @Override
            protected void addPredefined() {
                super.addPredefined();
                this.addAuxCommand("glsxtr@resource", 2);
                this.addAuxCommand("glsxtr@linkprefix", 1);
            }
        };
        this.masterPdfPath = new TeXPath(teXParser, string + ".pdf", false);
        TeXParser teXParser2 = auxParser.parseAuxFile(file);
        Vector<AuxData> vector = auxParser.getAuxData();
        this.masterGlsTeXPath = new Vector();
        for (AuxData auxData : vector) {
            String string2 = auxData.getName();
            if (string2.equals("glsxtr@resource")) {
                String string3 = auxData.getArg(1).toString(teXParser2);
                if (this.masterSelection != null) {
                    boolean bl = false;
                    for (String string4 : this.masterSelection) {
                        if (!string4.equals(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                }
                TeXPath teXPath2 = new TeXPath(teXParser, string3 + ".glstex", false);
                this.bib2gls.checkReadAccess(teXPath2);
                this.masterGlsTeXPath.add(teXPath2);
                continue;
            }
            if (!string2.equals("glsxtr@linkprefix")) continue;
            this.masterLinkPrefix = auxData.getArg(0).toString(teXParser2);
        }
    }

    private void parseSupplemental(TeXParser teXParser, String string) throws IOException {
        TeXPath teXPath = new TeXPath(teXParser, string + ".aux", false);
        this.bib2gls.checkReadAccess(teXPath);
        File file = teXPath.getFile();
        AuxParser auxParser = new AuxParser(this.bib2gls){

            @Override
            protected void addPredefined() {
                super.addPredefined();
                this.addAuxCommand("glsxtr@record", 5);
            }
        };
        this.supplementalPdfPath = new TeXPath(teXParser, string + ".pdf", false);
        TeXParser teXParser2 = auxParser.parseAuxFile(file);
        Vector<AuxData> vector = auxParser.getAuxData();
        this.supplementalRecords = new Vector();
        for (AuxData auxData : vector) {
            if (!auxData.getName().equals("glsxtr@record")) continue;
            this.supplementalRecords.add(new GlsRecord(auxData.getArg(0).toString(teXParser2), auxData.getArg(1).toString(teXParser2), auxData.getArg(2).toString(teXParser2), auxData.getArg(3).toString(teXParser2), auxData.getArg(4).toString(teXParser2)));
        }
        if (this.supplementalCategory == null) {
            this.supplementalCategory = this.category;
        }
    }

    private String replaceHex(String string) {
        Pattern pattern = Pattern.compile("\\\\u ?([0-9A-Fa-f]+)");
        Matcher matcher = pattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (matcher.find()) {
            String string2 = matcher.group(1);
            stringBuilder.append(string.substring(n, matcher.start()));
            stringBuilder.appendCodePoint(Integer.parseInt(string2, 16));
            n = matcher.end();
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private boolean getBoolean(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String string2 = keyValList.getValue(string).toString(teXParser).trim();
        if (string2.isEmpty() || string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.choice.value", string, string2, "true, false"));
    }

    private TeXObject getRequiredObject(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        TeXObject teXObject = keyValList.getValue(string);
        if (teXObject == null) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string));
        }
        if (teXObject instanceof TeXObjectList && ((TeXObjectList)(teXObject = GlsResource.trimList((TeXObjectList)teXObject))).size() == 0) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string));
        }
        return teXObject;
    }

    private String getRequired(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String string2;
        TeXObject teXObject = keyValList.getValue(string);
        if (teXObject == null) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string));
        }
        if (teXObject instanceof TeXObjectList) {
            teXObject = GlsResource.trimList((TeXObjectList)teXObject);
        }
        if ((string2 = teXObject.toString(teXParser).trim()).isEmpty()) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string));
        }
        return string2;
    }

    private String getOptional(TeXParser teXParser, String string, KeyValList keyValList, String string2) throws IOException {
        String string3;
        TeXObject teXObject = keyValList.getValue(string2);
        if (teXObject == null) {
            return string;
        }
        if (teXObject instanceof TeXObjectList) {
            teXObject = GlsResource.trimList((TeXObjectList)teXObject);
        }
        if ((string3 = teXObject.toString(teXParser).trim()).isEmpty()) {
            return string;
        }
        return string3;
    }

    private String getOptional(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        return this.getOptional(teXParser, null, keyValList, string);
    }

    private int getRequiredInt(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String string2 = this.getRequired(teXParser, keyValList, string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.int.value", string, string2), numberFormatException);
        }
    }

    private int getOptionalInt(TeXParser teXParser, int n, KeyValList keyValList, String string) throws IOException {
        String string2 = this.getOptional(teXParser, keyValList, string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.int.value", string, string2), numberFormatException);
        }
    }

    private int getRequiredInt(TeXParser teXParser, String string, int n, KeyValList keyValList, String string2) throws IOException {
        String string3 = this.getRequired(teXParser, keyValList, string2);
        if (string3.equals(string)) {
            return n;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.int.value", string2, string3), numberFormatException);
        }
    }

    private int getRequiredIntGe(TeXParser teXParser, int n, KeyValList keyValList, String string) throws IOException {
        int n2 = this.getRequiredInt(teXParser, keyValList, string);
        if (n2 < n) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.minint.value", string, n2, n));
        }
        return n2;
    }

    private int getRequiredIntGe(TeXParser teXParser, int n, String string, int n2, KeyValList keyValList, String string2) throws IOException {
        int n3 = this.getRequiredInt(teXParser, string, n2, keyValList, string2);
        if (n3 < n) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.minint.value", string2, n3, n));
        }
        return n3;
    }

    private int getOptionalIntGe(TeXParser teXParser, int n, int n2, KeyValList keyValList, String string) throws IOException {
        int n3 = this.getOptionalInt(teXParser, n2, keyValList, string);
        if (n3 < n) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.minint.value", string, n3, n));
        }
        return n3;
    }

    private long getRequiredLong(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        String string2 = this.getRequired(teXParser, keyValList, string);
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.int.value", string, string2), numberFormatException);
        }
    }

    private long getOptionalLong(TeXParser teXParser, long l, KeyValList keyValList, String string) throws IOException {
        String string2 = this.getOptional(teXParser, keyValList, string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.int.value", string, string2), numberFormatException);
        }
    }

    private String getChoice(TeXParser teXParser, KeyValList keyValList, String string, String ... stringArray) throws IOException {
        return this.getChoice(teXParser, null, keyValList, string, stringArray);
    }

    private String getChoice(TeXParser teXParser, String string, KeyValList keyValList, String string2, String ... stringArray) throws IOException {
        String string3 = this.getOptional(teXParser, keyValList, string2);
        if (string3 == null) {
            if (string == null) {
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string2));
            }
            return string;
        }
        StringBuilder stringBuilder = null;
        for (String string4 : stringArray) {
            if (string3.equals(string4)) {
                return string3;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append('\'');
            stringBuilder.append(string4);
            stringBuilder.append('\'');
        }
        throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.choice.value", string2, string3, stringBuilder));
    }

    private String[] getStringArray(TeXParser teXParser, String string, KeyValList keyValList, String string2) throws IOException {
        String[] stringArray = this.getStringArray(teXParser, keyValList, string2);
        if (stringArray == null) {
            return new String[]{string};
        }
        return stringArray;
    }

    private String[] getStringArray(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        CsvList csvList = CsvList.getList(teXParser, keyValList.getValue(string));
        int n = csvList.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = csvList.getValue(i);
            if (teXObject instanceof TeXObjectList) {
                teXObject = GlsResource.trimList((TeXObjectList)teXObject);
            }
            stringArray[i] = teXObject.toString(teXParser).trim();
        }
        return stringArray;
    }

    private TeXObject[] getTeXObjectArray(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        CsvList csvList = CsvList.getList(teXParser, keyValList.getValue(string));
        int n = csvList.size();
        if (n == 0) {
            return null;
        }
        TeXObject[] teXObjectArray = new TeXObject[n];
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = csvList.getValue(i);
            if (teXObject instanceof TeXObjectList) {
                teXObject = GlsResource.trimList((TeXObjectList)teXObject);
            }
            teXObjectArray[i] = teXObject;
        }
        return teXObjectArray;
    }

    private CsvList[] getListArray(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        CsvList csvList;
        int n;
        TeXObject teXObject = keyValList.getValue(string);
        if (teXObject instanceof TeXObjectList) {
            teXObject = GlsResource.trimList((TeXObjectList)teXObject);
        }
        if ((n = (csvList = CsvList.getList(teXParser, teXObject)).size()) == 0) {
            return null;
        }
        CsvList[] csvListArray = new CsvList[n];
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject2 = csvList.getValue(i);
            if (teXObject2 instanceof TeXObjectList) {
                teXObject2 = GlsResource.trimList((TeXObjectList)teXObject2);
            }
            csvListArray[i] = CsvList.getList(teXParser, teXObject2);
        }
        return csvListArray;
    }

    private HashMap<String, String> getDualMap(TeXParser teXParser, KeyValList keyValList, String string, String[] stringArray) throws IOException {
        CsvList[] csvListArray = this.getListArray(teXParser, keyValList, string);
        if (csvListArray == null) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.missing.value", string));
        }
        if (csvListArray.length != 2) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.opt.list.size", string, 2));
        }
        int n = csvListArray[0].size();
        if (n != csvListArray[1].size()) {
            throw new IllegalArgumentException(this.bib2gls.getMessage("error.invalid.dual.map", string, ((TeXObject)keyValList.get(string)).toString(teXParser), n, csvListArray[1].size()));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = csvListArray[0].getValue(i);
            TeXObject teXObject2 = csvListArray[1].getValue(i);
            if (teXObject instanceof TeXObjectList) {
                teXObject = GlsResource.trimList((TeXObjectList)teXObject);
            }
            if (teXObject2 instanceof TeXObjectList) {
                teXObject2 = GlsResource.trimList((TeXObjectList)teXObject2);
            }
            String string2 = teXObject.toString(teXParser);
            String string3 = teXObject2.toString(teXParser);
            if (string2.equals("alias") || string3.equals("alias")) {
                throw new IllegalArgumentException(this.bib2gls.getMessage("error.alias.map.forbidden"));
            }
            hashMap.put(string2, string3);
            if (i >= stringArray.length) continue;
            stringArray[i] = string2;
        }
        return hashMap;
    }

    private KeyValList getKeyValList(TeXParser teXParser, KeyValList keyValList, String string) throws IOException {
        KeyValList keyValList2;
        TeXObject teXObject = keyValList.getValue(string);
        if (teXObject instanceof TeXObjectList) {
            teXObject = GlsResource.trimList((TeXObjectList)teXObject);
        }
        if ((keyValList2 = KeyValList.getList(teXParser, teXObject)) == null || keyValList2.size() == 0) {
            return null;
        }
        return keyValList2;
    }

    public static TeXObjectList trimList(TeXObjectList teXObjectList) {
        while (teXObjectList.size() > 0 && teXObjectList.get(0) instanceof WhiteSpace) {
            teXObjectList.remove(0);
        }
        while (teXObjectList.size() > 0 && teXObjectList.lastElement() instanceof WhiteSpace) {
            teXObjectList.remove(teXObjectList.size() - 1);
        }
        if (teXObjectList.size() == 1 && teXObjectList.get(0) instanceof Group) {
            teXObjectList = ((Group)teXObjectList.get(0)).toList();
        }
        return teXObjectList;
    }

    private Vector<TeXObject> splitList(TeXParser teXParser, char c, TeXObjectList teXObjectList) throws IOException {
        while (teXObjectList.size() == 1 && teXObjectList.firstElement() instanceof TeXObjectList) {
            teXObjectList = (TeXObjectList)teXObjectList.firstElement();
        }
        if (teXObjectList.size() == 0) {
            return null;
        }
        Vector<TeXObject> vector = new Vector<TeXObject>();
        TeXObjectList teXObjectList2 = new TeXObjectList();
        for (TeXObject teXObject : teXObjectList) {
            if (teXObject instanceof CharObject && ((CharObject)teXObject).getCharCode() == c) {
                if ((teXObjectList2 = GlsResource.trimList(teXObjectList2)).size() != 0) {
                    vector.add(teXObjectList2);
                }
                teXObjectList2 = new TeXObjectList();
                continue;
            }
            teXObjectList2.add(teXObject);
        }
        if ((teXObjectList2 = GlsResource.trimList(teXObjectList2)).size() != 0) {
            vector.add(teXObjectList2);
        }
        return vector;
    }

    private void stripUnknownFieldPatterns() {
        if (this.fieldPatterns == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        for (String string : this.fieldPatterns.keySet()) {
            if (this.bib2gls.isKnownField(string) || string.equals(PATTERN_FIELD_ID) || string.equals(PATTERN_FIELD_ENTRY_TYPE)) continue;
            this.bib2gls.warning(this.bib2gls.getMessage("warning.unknown.field.pattern", string));
            vector.add(string);
        }
        for (String string : vector) {
            this.fieldPatterns.remove(string);
        }
        if (this.fieldPatterns.size() == 0) {
            this.fieldPatterns = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(TeXParser teXParser) throws IOException {
        Object object;
        Object object2;
        this.stripUnknownFieldPatterns();
        this.bibData = new Vector();
        this.dualData = new Vector();
        Vector<GlsRecord> vector = this.bib2gls.getRecords();
        Vector<Bib2GlsEntry> vector2 = null;
        if (this.selectionMode == 1) {
            vector2 = new Vector<Bib2GlsEntry>();
        }
        for (TeXPath object3 : this.sources) {
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            int n;
            Serializable serializable;
            Object object8;
            object2 = object3.getFile();
            object = this.bibCharset;
            if (object == null) {
                object8 = null;
                serializable = Pattern.compile("% Encoding: ([^\\s]+)");
                try {
                    object8 = new BufferedReader(new FileReader((File)object2));
                    n = 0;
                    while ((object7 = ((BufferedReader)object8).readLine()) != null) {
                        ++n;
                        object6 = ((Pattern)serializable).matcher((CharSequence)object7);
                        if (!((Matcher)object6).matches()) continue;
                        object5 = ((Matcher)object6).group(1);
                        try {
                            object = Charset.forName((String)object5);
                        }
                        catch (Exception exception) {
                            this.bib2gls.warning((File)object2, n, this.bib2gls.getMessage("warning.ignoring.unknown.encoding", (String)object5), exception);
                            object = this.bibCharset;
                        }
                        ((BufferedReader)object8).close();
                        object8 = null;
                        break;
                    }
                }
                finally {
                    if (object8 != null) {
                        ((BufferedReader)object8).close();
                    }
                }
            }
            object8 = new Bib2GlsBibParser(this.bib2gls, this, (Charset)object);
            serializable = ((BibParser)object8).parseBibFile((File)object2);
            object7 = ((BibParser)object8).getBibData();
            if (this.hasAliases() && this.aliasLocations == 1) {
                for (n = 0; n < vector.size(); ++n) {
                    object6 = vector.get(n);
                    object5 = GlsResource.getBib2GlsEntry(((GlsRecord)object6).getLabel(), (Vector<BibData>)object7);
                    if (object5 == null) continue;
                    object4 = ((Bib2GlsEntry)object5).getFieldValue("alias");
                    if (object4 == null) {
                        ((Bib2GlsEntry)object5).addRecord((GlsRecord)object6);
                        continue;
                    }
                    Bib2GlsEntry bib2GlsEntry = GlsResource.getBib2GlsEntry((String)object4, (Vector<BibData>)object7);
                    if (bib2GlsEntry == null) {
                        this.bib2gls.warning(this.bib2gls.getMessage("warning.alias.not.found", object4, ((Bib2GlsEntry)object5).getOriginalId(), "alias-loc", "transfer"));
                        continue;
                    }
                    ((Bib2GlsEntry)object5).addRecord((GlsRecord)object6);
                    GlsRecord glsRecord = (GlsRecord)((GlsRecord)object6).clone();
                    glsRecord.setLabel((String)object4);
                    if (vector.contains(glsRecord)) continue;
                    this.bib2gls.debug(this.bib2gls.getMessage("message.adding.target.record", glsRecord, ((Bib2GlsEntry)object5).getOriginalId()));
                    bib2GlsEntry.addRecord(glsRecord);
                    vector.add(++n, glsRecord);
                }
            }
            for (n = 0; n < ((Vector)object7).size(); ++n) {
                boolean bl;
                object6 = (BibData)((Vector)object7).get(n);
                if (!(object6 instanceof Bib2GlsEntry)) continue;
                object5 = (Bib2GlsEntry)object6;
                object4 = null;
                if (object5 instanceof Bib2GlsDualEntry) {
                    object4 = ((Bib2GlsDualEntry)object5).createDual();
                    ((Bib2GlsEntry)object5).setDual((Bib2GlsEntry)object4);
                    ((Bib2GlsEntry)object4).setDual((Bib2GlsEntry)object5);
                }
                this.setType((Bib2GlsEntry)object5);
                this.setCategory((Bib2GlsEntry)object5);
                boolean bl2 = ((Bib2GlsEntry)object5).hasRecords();
                boolean bl3 = bl = object4 != null && ((Bib2GlsEntry)object4).hasRecords();
                if (this.aliasLocations != 1 || ((BibEntry)object5).getField("alias") == null) {
                    for (GlsRecord glsRecord : vector) {
                        if (glsRecord.getLabel().equals(((Bib2GlsEntry)object5).getId())) {
                            ((Bib2GlsEntry)object5).addRecord(glsRecord);
                            bl2 = true;
                        }
                        if (object4 == null || !glsRecord.getLabel().equals(((Bib2GlsEntry)object4).getId())) continue;
                        ((Bib2GlsEntry)object4).addRecord(glsRecord);
                        bl = true;
                    }
                }
                if (this.discard((Bib2GlsEntry)object5)) {
                    this.bib2gls.verbose(this.bib2gls.getMessage("message.discarding.entry", ((Bib2GlsEntry)object5).getId()));
                    continue;
                }
                this.bibData.add((Bib2GlsEntry)object5);
                if (object4 != null) {
                    if (this.discard((Bib2GlsEntry)object4)) {
                        this.bib2gls.verbose(this.bib2gls.getMessage("message.discarding.entry", ((Bib2GlsEntry)object4).getId()));
                        continue;
                    }
                    if (this.dualSort.equals("combine")) {
                        this.setDualType((Bib2GlsEntry)object4);
                        this.setDualCategory((Bib2GlsEntry)object4);
                        this.bibData.add((Bib2GlsEntry)object4);
                    } else {
                        this.dualData.add((Bib2GlsEntry)object4);
                    }
                }
                if (this.selectionMode == 0 || this.selectionMode == 1) {
                    if (bl2) {
                        this.addDependencies(teXParser, (Bib2GlsEntry)object5, (Vector<BibData>)object7);
                        if (object4 != null) {
                            this.bib2gls.addDependent(((Bib2GlsEntry)object4).getId());
                        }
                    }
                    if (bl) {
                        if (((Bib2GlsEntry)object4).getFieldValue("see") == null && ((Bib2GlsEntry)object4).getFieldValue("seealso") == null) {
                            ((Bib2GlsEntry)object4).initCrossRefs(teXParser);
                        }
                        Iterator<Object> iterator = ((Bib2GlsEntry)object4).getDependencyIterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            this.bib2gls.addDependent(string);
                        }
                        this.bib2gls.addDependent(((Bib2GlsEntry)object5).getId());
                    }
                }
                if (bl2 || vector2 == null) continue;
                ((Bib2GlsEntry)object5).initCrossRefs(teXParser);
                this.addCrossRefs((Vector<BibData>)object7, (Bib2GlsEntry)object5, ((Bib2GlsEntry)object5).getCrossRefs(), vector2);
                this.addCrossRefs((Vector<BibData>)object7, (Bib2GlsEntry)object5, ((Bib2GlsEntry)object5).getAlsoCrossRefs(), vector2);
            }
        }
        if (vector2 != null) {
            for (Bib2GlsEntry bib2GlsEntry : vector2) {
                if (!bib2GlsEntry.hasRecords()) continue;
                object2 = bib2GlsEntry.getCrossRefdByIterator();
                while (object2.hasNext()) {
                    object = (Bib2GlsEntry)object2.next();
                    this.bib2gls.addDependent(((Bib2GlsEntry)object).getId());
                }
            }
        }
        this.addSupplementalRecords();
    }

    private void addCrossRefs(Vector<BibData> vector, Bib2GlsEntry bib2GlsEntry, String[] stringArray, Vector<Bib2GlsEntry> vector2) {
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray) {
            Bib2GlsEntry bib2GlsEntry2 = GlsResource.getBib2GlsEntry(string, vector);
            if (bib2GlsEntry2 == null) continue;
            bib2GlsEntry2.addCrossRefdBy(bib2GlsEntry);
            if (vector2.contains(bib2GlsEntry2)) continue;
            vector2.add(bib2GlsEntry2);
        }
    }

    private void addSupplementalRecords() {
        if (this.supplementalRecords != null) {
            for (GlsRecord glsRecord : this.supplementalRecords) {
                String string = glsRecord.getLabel();
                Bib2GlsEntry bib2GlsEntry = GlsResource.getEntry(string, this.bibData);
                if (bib2GlsEntry == null && this.labelPrefix != null && !string.startsWith(this.labelPrefix)) {
                    bib2GlsEntry = GlsResource.getEntry(this.labelPrefix + string, this.bibData);
                }
                if (bib2GlsEntry == null) {
                    if (this.dualData == null) {
                        bib2GlsEntry = GlsResource.getEntry(this.dualPrefix + string, this.bibData);
                    } else {
                        bib2GlsEntry = GlsResource.getEntry(string, this.dualData);
                        if (bib2GlsEntry == null && !string.startsWith(this.dualPrefix)) {
                            bib2GlsEntry = GlsResource.getEntry(this.dualPrefix + string, this.dualData);
                        }
                    }
                }
                if (bib2GlsEntry == null) continue;
                if (this.supplementalCategory != null) {
                    this.setCategory(bib2GlsEntry, this.supplementalCategory);
                }
                bib2GlsEntry.addSupplementalRecord(glsRecord);
            }
        }
    }

    private void addDependencies(TeXParser teXParser, Bib2GlsEntry bib2GlsEntry, Vector<BibData> vector) throws IOException {
        bib2GlsEntry.initCrossRefs(teXParser);
        Iterator<String> iterator = bib2GlsEntry.getDependencyIterator();
        while (iterator.hasNext()) {
            Bib2GlsEntry bib2GlsEntry2;
            String string = iterator.next();
            if (this.bib2gls.isDependent(string)) continue;
            this.bib2gls.addDependent(string);
            if (this.bib2gls.hasRecord(string) || (bib2GlsEntry2 = GlsResource.getBib2GlsEntry(string, vector)) == null || !bib2GlsEntry2.hasDependencies()) continue;
            this.addDependencies(teXParser, bib2GlsEntry2, vector);
        }
    }

    public int processData() throws IOException, Bib2GlsException {
        if (this.masterGlsTeXPath == null) {
            return this.processBibData();
        }
        this.processMaster();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMaster() throws IOException, Bib2GlsException {
        this.bib2gls.message(this.bib2gls.getMessage("message.writing", this.texFile.toString()));
        try (PrintWriter printWriter = null;){
            printWriter = new PrintWriter(this.texFile, this.bib2gls.getTeXCharset().name());
            printWriter.println("\\let\\bibglsorgdefglossaryentry\\@glsxtr@s@longnewglossaryentry");
            printWriter.println("\\let\\bibglsorgdefabbreviation\\glsxtr@newabbreviation");
            printWriter.println();
            printWriter.println("\\renewcommand{\\@glsxtr@s@longnewglossaryentry}[3]{%");
            printWriter.format(" \\bibglsorgdefglossaryentry{%s#1}{#2,type={%s},category={%s}}{#3}%%%n", this.labelPrefix == null ? "" : this.labelPrefix, this.type, this.category);
            printWriter.println("}");
            printWriter.println();
            printWriter.println("\\renewcommand{\\glsxtr@newabbreviation}[4]{%");
            printWriter.format(" \\bibglsorgdefabbreviation{#1,type={%s},category={%s}}{%s#2}{#3}{#4}%%%n", this.type, this.category, this.labelPrefix == null ? "" : this.labelPrefix);
            printWriter.println("}");
            printWriter.println();
            printWriter.format("\\provideignoredglossary*{%s}%n", this.type);
            printWriter.format("\\glssetcategoryattribute{%s}{targeturl}{%s}%n", this.category, this.masterPdfPath);
            printWriter.format("\\glssetcategoryattribute{%s}{targetname}", this.category);
            if (this.labelPrefix == null) {
                printWriter.format("{%s\\glslabel}%n", this.masterLinkPrefix);
            } else {
                printWriter.format("{%s\\csname bibglsstrip%sprefix\\expandafter\\endcsname\\glslabel}%n", this.masterLinkPrefix, this.category);
                printWriter.format("\\csdef{bibglsstrip%sprefix}%s#1{#1}%n", this.category, this.labelPrefix);
            }
            for (TeXPath teXPath : this.masterGlsTeXPath) {
                printWriter.println();
                printWriter.format("\\InputIfFileExists{%s}{}{}%n", teXPath);
                printWriter.println();
            }
            printWriter.println("\\let\\@glsxtr@s@longnewglossaryentry\\bibglsorgdefglossaryentry");
            printWriter.println("\\let\\glsxtr@newabbreviation\\bibglsorgdefabbreviation");
        }
    }

    public void setPreamble(String string, BibValueList bibValueList) throws IOException {
        this.preamble = this.preamble == null ? string : this.preamble + string;
        if (bibValueList != null && this.interpretPreamble) {
            this.bib2gls.processPreamble(bibValueList);
        }
    }

    private void addHierarchy(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector, Vector<Bib2GlsEntry> vector2) {
        String string = bib2GlsEntry.getParent();
        if (string == null) {
            return;
        }
        for (Bib2GlsEntry bib2GlsEntry2 : vector) {
            if (!bib2GlsEntry2.getId().equals(string)) continue;
            return;
        }
        Bib2GlsEntry bib2GlsEntry3 = GlsResource.getEntry(string, vector2);
        if (bib2GlsEntry3 != null) {
            this.bib2gls.verbose(this.bib2gls.getMessage("message.added.parent", string));
            this.addHierarchy(bib2GlsEntry3, vector, vector2);
            vector.add(bib2GlsEntry3);
        }
    }

    public Bib2GlsEntry getEntry(String string) {
        Bib2GlsEntry bib2GlsEntry = GlsResource.getEntry(string, this.bibData);
        if (bib2GlsEntry != null) {
            return bib2GlsEntry;
        }
        return GlsResource.getEntry(string, this.dualData);
    }

    public static Bib2GlsEntry getEntry(String string, Vector<Bib2GlsEntry> vector) {
        for (Bib2GlsEntry bib2GlsEntry : vector) {
            if (!bib2GlsEntry.getId().equals(string)) continue;
            return bib2GlsEntry;
        }
        return null;
    }

    public static Bib2GlsEntry getBib2GlsEntry(String string, Vector<BibData> vector) {
        for (BibData bibData : vector) {
            if (!(bibData instanceof Bib2GlsEntry) || !((Bib2GlsEntry)bibData).getId().equals(string)) continue;
            return (Bib2GlsEntry)bibData;
        }
        return null;
    }

    private void processData(Vector<Bib2GlsEntry> vector, Vector<Bib2GlsEntry> vector2, String string, String string2, String string3) throws Bib2GlsException {
        Vector<String> vector3 = this.bib2gls.getFields();
        Vector<GlsRecord> vector4 = this.bib2gls.getRecords();
        if (this.selectionMode == 4) {
            for (Bib2GlsEntry bib2GlsEntry : vector) {
                vector2.add(bib2GlsEntry);
            }
        } else if (string == null) {
            for (Bib2GlsEntry bib2GlsEntry : vector) {
                if (!bib2GlsEntry.hasRecords()) continue;
                if (this.selectionMode == 0 || this.selectionMode == 1 || this.selectionMode == 3) {
                    this.addHierarchy(bib2GlsEntry, vector2, vector);
                }
                vector2.add(bib2GlsEntry);
            }
        } else {
            Object object;
            for (int i = 0; i < vector4.size(); ++i) {
                GlsRecord glsRecord = vector4.get(i);
                object = GlsResource.getEntry(glsRecord.getLabel(), vector);
                if (object == null || vector2.contains(object)) continue;
                if (this.selectionMode == 0 || this.selectionMode == 1 || this.selectionMode == 3) {
                    this.addHierarchy((Bib2GlsEntry)object, vector2, vector);
                }
                vector2.add((Bib2GlsEntry)object);
            }
            if (this.supplementalRecords != null && this.supplementalSelection != null) {
                block3: for (GlsRecord glsRecord : this.supplementalRecords) {
                    object = glsRecord.getLabel();
                    Bib2GlsEntry bib2GlsEntry = GlsResource.getEntry((String)object, vector);
                    if (bib2GlsEntry == null || vector2.contains(bib2GlsEntry)) continue;
                    if (this.supplementalSelection.length == 1 && this.supplementalSelection[0].equals("all")) {
                        if (this.selectionMode == 0 || this.selectionMode == 1 || this.selectionMode == 3) {
                            this.addHierarchy(bib2GlsEntry, vector2, vector);
                        }
                        vector2.add(bib2GlsEntry);
                        continue;
                    }
                    for (String string4 : this.supplementalSelection) {
                        if (!string4.equals(object)) continue;
                        if (this.selectionMode == 0 || this.selectionMode == 1 || this.selectionMode == 3) {
                            this.addHierarchy(bib2GlsEntry, vector2, vector);
                        }
                        vector2.add(bib2GlsEntry);
                        continue block3;
                    }
                }
            }
        }
        this.processDepsAndSort(vector, vector2, string, string2, string3);
    }

    private void processDepsAndSort(Vector<Bib2GlsEntry> vector, Vector<Bib2GlsEntry> vector2, String string, String string2, String string3) throws Bib2GlsException {
        Object object;
        Object object2;
        Object object3;
        if (this.selectionMode == 0 || this.selectionMode == 1) {
            object3 = this.bib2gls.getDependencies();
            object2 = ((Vector)object3).iterator();
            while (object2.hasNext()) {
                object = object2.next();
                Bib2GlsEntry bib2GlsEntry = GlsResource.getEntry((String)object, vector);
                if (bib2GlsEntry == null || vector2.contains(bib2GlsEntry)) continue;
                this.addHierarchy(bib2GlsEntry, vector2, vector);
                vector2.add(bib2GlsEntry);
            }
        }
        if (this.flattenLonely == 1) {
            object3 = this.bib2gls.getInterpreterListener();
            if (object3 != null) {
                object2 = ((TeXParserListener)object3).getParser();
                if (((TeXParser)object2).getControlSequence("bibglsflattenedchildpresort") == null) {
                    ((DefaultTeXParserListener)object3).putControlSequence(new FlattenedPreSort());
                }
                if (((TeXParser)object2).getControlSequence("bibglsflattenedhomograph") == null) {
                    ((DefaultTeXParserListener)object3).putControlSequence(new FlattenedHomograph());
                }
            }
            this.flattenLonelyChildren(vector2);
        }
        int n = vector2.size();
        if (string != null && !string.equals("use") && n > 0) {
            if (string.equals("random")) {
                if (this.random == null) {
                    this.random = new Random();
                }
                Collections.shuffle(vector2, this.random);
            } else if (string.equals("letter-case")) {
                object2 = new Bib2GlsEntryLetterComparator(this.bib2gls, vector2, string, string3, false, false);
                ((Bib2GlsEntryLetterComparator)object2).sortEntries();
            } else if (string.equals("letter-case-reverse")) {
                object2 = new Bib2GlsEntryLetterComparator(this.bib2gls, vector2, string, string3, false, true);
                ((Bib2GlsEntryLetterComparator)object2).sortEntries();
            } else if (string.equals("letter-nocase")) {
                object2 = new Bib2GlsEntryLetterComparator(this.bib2gls, vector2, string, string3, true, false);
                ((Bib2GlsEntryLetterComparator)object2).sortEntries();
            } else if (string.equals("letter-nocase-reverse")) {
                object2 = new Bib2GlsEntryLetterComparator(this.bib2gls, vector2, string, string3, true, true);
                ((Bib2GlsEntryLetterComparator)object2).sortEntries();
            } else if (string.startsWith("integer") || string.startsWith("float") || string.startsWith("double") || string.startsWith("hex") || string.startsWith("octal") || string.startsWith("binary")) {
                object2 = new Bib2GlsEntryNumericComparator(this.bib2gls, vector2, string, string3);
                ((Bib2GlsEntryNumericComparator)object2).sortEntries();
            } else if (string.equals("custom")) {
                try {
                    object2 = new Bib2GlsEntryComparator(this.bib2gls, vector2, string3, this.collatorStrength, this.collatorDecomposition, string2, this.breakPoint, this.breakPointMarker);
                    ((Bib2GlsEntryComparator)object2).sortEntries();
                }
                catch (ParseException parseException) {
                    throw new Bib2GlsException(this.bib2gls.getMessage("error.invalid.sort.rule", parseException.getMessage()), parseException);
                }
            } else {
                object2 = null;
                object2 = string.equals("locale") ? Locale.getDefault() : Locale.forLanguageTag(string);
                object = new Bib2GlsEntryComparator(this.bib2gls, vector2, (Locale)object2, string3, this.collatorStrength, this.collatorDecomposition, this.breakPoint, this.breakPointMarker);
                ((Bib2GlsEntryComparator)object).sortEntries();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int processBibData() throws IOException, Bib2GlsException {
        Iterator<String> iterator;
        if (this.bibData == null) {
            throw new NullPointerException("No data (parse must come before processData)");
        }
        if (this.dualField != null) {
            this.bib2gls.addField(this.dualField);
        }
        this.checkFieldMaps(this.dualEntryMap, "dual-entry-map");
        this.checkFieldMaps(this.dualAbbrevMap, "dual-abbrv-map");
        this.checkFieldMaps(this.dualSymbolMap, "dual-symbol-map");
        this.checkFieldMaps(this.dualEntryAbbrevMap, "dual-entryabbrv-map");
        Vector<Bib2GlsEntry> vector = new Vector<Bib2GlsEntry>();
        this.processData(this.bibData, vector, this.sort, this.sortRules, this.sortField);
        Vector<Bib2GlsEntry> vector2 = null;
        int n = vector.size();
        if (this.dualData.size() > 0) {
            vector2 = new Vector<Bib2GlsEntry>();
            if (this.dualSort == null || this.dualSort.equals("use")) {
                for (Bib2GlsEntry bib2GlsEntry : vector) {
                    if (!(bib2GlsEntry instanceof Bib2GlsDualEntry)) continue;
                    iterator = bib2GlsEntry.getDual();
                    this.setDualType((Bib2GlsEntry)((Object)iterator));
                    this.setDualCategory((Bib2GlsEntry)((Object)iterator));
                    vector2.add((Bib2GlsEntry)((Object)iterator));
                }
            } else {
                for (Bib2GlsEntry bib2GlsEntry : this.dualData) {
                    this.setDualType(bib2GlsEntry);
                    this.setDualCategory(bib2GlsEntry);
                    vector2.add(bib2GlsEntry);
                }
            }
            this.processDepsAndSort(this.dualData, vector2, this.dualSort, this.dualSortRules, this.dualSortField);
            n += vector2.size();
        }
        this.bib2gls.message(this.bib2gls.getMessage("message.writing", this.texFile.toString()));
        try (Object object = null;){
            void var7_16;
            Object object2;
            int stringBuilder;
            Object object3;
            object = new PrintWriter(this.texFile, this.bib2gls.getTeXCharset().name());
            ((PrintWriter)object).println("\\providecommand{\\bibglsrange}[1]{#1}");
            ((PrintWriter)object).println("\\providecommand{\\bibglsinterloper}[1]{#1\\delimN }");
            ((PrintWriter)object).format("\\providecommand{\\bibglspassimname}{%s}%n", this.bib2gls.getMessage("tag.passim"));
            ((PrintWriter)object).println("\\providecommand{\\bibglspassim}{ \\bibglspassimname}");
            ((PrintWriter)object).println();
            if (this.counters != null) {
                ((PrintWriter)object).println("\\providecommand{\\bibglslocationgroup}[3]{#3}");
                ((PrintWriter)object).println("\\providecommand{\\bibglslocationgroupsep}{\\delimN}");
                ((PrintWriter)object).println();
            }
            if (this.supplementalRecords != null) {
                ((PrintWriter)object).println("\\providecommand{\\bibglssupplementalsep}{\\delimN}");
                ((PrintWriter)object).println("\\providecommand{\\bibglssupplemental}[2]{#2}");
                ((PrintWriter)object).println();
            }
            if (this.dualField != null) {
                ((PrintWriter)object).format("\\glsxtrprovidestoragekey{%s}{}{}%n%n", this.dualField);
            }
            if (this.seeLocation != 0) {
                ((PrintWriter)object).println("\\providecommand{\\bibglsseesep}{, }");
                ((PrintWriter)object).println();
            }
            if (this.seeAlsoLocation != 0) {
                ((PrintWriter)object).println("\\providecommand{\\bibglsseealsosep}{, }");
                ((PrintWriter)object).println();
            }
            if (this.bib2gls.useGroupField()) {
                ((PrintWriter)object).println("\\ifdef\\glsxtrsetgrouptitle");
                ((PrintWriter)object).println("{");
                ((PrintWriter)object).println("  \\providecommand{\\bibglslettergroup}[4]{#4#3}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglslettergrouptitle}[4]{\\unexpanded{#1}}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetlettergrouptitle}[1]{%");
                ((PrintWriter)object).println("    \\glsxtrsetgrouptitle{\\bibglslettergroup#1}{\\bibglslettergrouptitle#1}}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsothergroup}[3]{glssymbols}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsothergrouptitle}[3]{\\glssymbolsgroupname}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetothergrouptitle}[1]{%");
                ((PrintWriter)object).println("    \\glsxtrsetgrouptitle{\\bibglsothergroup#1}{\\bibglsothergrouptitle#1}}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsnumbergroup}[3]{glsnumbers}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsnumbergrouptitle}[3]{\\glsnumbersgroupname}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetnumbergrouptitle}[1]{%");
                ((PrintWriter)object).println("    \\glsxtrsetgrouptitle{\\bibglsnumbergroup#1}{\\bibglsnumbergrouptitle#1}}");
                ((PrintWriter)object).println("}");
                ((PrintWriter)object).println("{");
                ((PrintWriter)object).println("  \\providecommand{\\bibglslettergroup}[4]{#1}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsothergroup}[3]{glssymbols}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglsnumbergroup}[3]{glsnumbers}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetlettergrouptitle}[1]{}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetothergrouptitle}[1]{}");
                ((PrintWriter)object).println("  \\providecommand{\\bibglssetnumbergrouptitle}[1]{}");
                ((PrintWriter)object).println("}");
                ((PrintWriter)object).println();
                boolean bl = this.bib2gls.hyperrefLoaded() && this.bib2gls.createHyperGroupsOn();
                for (String object52 : this.groupTitleMap.keySet()) {
                    object3 = this.groupTitleMap.get(object52);
                    if (((GroupTitle)object3).getType() == null) {
                        bl = false;
                    }
                    ((PrintWriter)object).format("\\%s{%s}%n", ((GroupTitle)object3).getCsSetName(), object3);
                }
                ((PrintWriter)object).println();
                if (!bl) {
                    this.bib2gls.setCreateHyperGroups(false);
                }
                if (bl) {
                    ((PrintWriter)object).println("\\ifdef\\@glsnavhypertarget");
                    ((PrintWriter)object).println("{");
                    ((PrintWriter)object).println("  \\ifdef\\bibglsorgnavhypertarget");
                    ((PrintWriter)object).println("  {}");
                    ((PrintWriter)object).println("  {");
                    ((PrintWriter)object).println("    \\let\\bibglsorgnavhypertarget\\@glsnavhypertarget");
                    ((PrintWriter)object).println("  }");
                    ((PrintWriter)object).println("  \\renewcommand*{\\@glsnavhypertarget}[3]{%");
                    ((PrintWriter)object).println("    \\@glstarget{\\glsnavhyperlinkname{#1}{#2}}{#3}%");
                    ((PrintWriter)object).println("  }");
                    ((PrintWriter)object).println("  \\providecommand{\\bibglshypergroup}{\\@gls@hypergroup}");
                    ((PrintWriter)object).println("}");
                    ((PrintWriter)object).println("{");
                    ((PrintWriter)object).println("  \\providecommand{\\bibglshypergroup}[2]{}");
                    ((PrintWriter)object).println("}");
                    for (String string : this.groupTitleMap.keySet()) {
                        object3 = this.groupTitleMap.get(string);
                        ((PrintWriter)object).format("\\bibglshypergroup{%s}{\\%s%s}%n", ((GroupTitle)object3).getType(), ((GroupTitle)object3).getCsLabelName(), object3);
                    }
                    ((PrintWriter)object).println();
                } else if (this.bib2gls.hyperrefLoaded()) {
                    ((PrintWriter)object).println("\\ifdef\\bibglsorgnavhypertarget");
                    ((PrintWriter)object).println("{");
                    ((PrintWriter)object).println("  \\let\\@glsnavhypertarget\\bibglsorgnavhypertarget");
                    ((PrintWriter)object).println("}");
                    ((PrintWriter)object).println("{}");
                }
            }
            if (this.locationPrefix != null) {
                ((PrintWriter)object).println("\\providecommand{\\bibglspostlocprefix}{\\ }");
                if (this.defpagesname) {
                    ((PrintWriter)object).format("\\providecommand{\\bibglspagename}{%s}%n", this.bib2gls.getMessage("tag.page"));
                    ((PrintWriter)object).format("\\providecommand{\\bibglspagesname}{%s}%n", this.bib2gls.getMessage("tag.pages"));
                }
                if (this.type == null) {
                    ((PrintWriter)object).println("\\appto\\glossarypreamble{%");
                } else {
                    ((PrintWriter)object).format("\\apptoglossarypreamble[%s]{%%%n", this.type);
                }
                ((PrintWriter)object).println(" \\providecommand{\\bibglslocprefix}[1]{%");
                ((PrintWriter)object).println("  \\ifcase#1");
                for (int i = 0; i < this.locationPrefix.length; ++i) {
                    ((PrintWriter)object).format("  \\%s %s\\bibglspostlocprefix%n", i == this.locationPrefix.length - 1 ? "else" : "or", this.locationPrefix[i]);
                }
                ((PrintWriter)object).println("  \\fi");
                ((PrintWriter)object).println(" }%");
                ((PrintWriter)object).println("}");
            }
            if (this.locationSuffix != null) {
                if (this.type == null) {
                    ((PrintWriter)object).println("\\appto\\glossarypreamble{%");
                } else {
                    ((PrintWriter)object).format("\\apptoglossarypreamble[%s]{%%%n", this.type);
                }
                ((PrintWriter)object).print(" \\providecommand{\\bibglslocsuffix}[1]{");
                if (this.locationSuffix.length == 1) {
                    ((PrintWriter)object).print(this.locationSuffix[0]);
                } else {
                    ((PrintWriter)object).format("\\ifcase#1 %s", this.locationSuffix[0]);
                    for (int i = 1; i < this.locationSuffix.length; ++i) {
                        ((PrintWriter)object).format("\\%s %s", i == this.locationSuffix.length - 1 ? "else" : "or", this.locationSuffix[i]);
                    }
                    ((PrintWriter)object).print("\\fi");
                }
                ((PrintWriter)object).println("}%");
                ((PrintWriter)object).println("}");
            }
            Vector<String> vector3 = new Vector<String>();
            if (this.preamble != null) {
                ((PrintWriter)object).println(this.preamble);
                ((PrintWriter)object).println();
            }
            iterator = null;
            if (this.secondaryType != null) {
                iterator = new Vector(n);
            }
            Object var7_14 = null;
            object3 = null;
            Vector<String> vector4 = null;
            Vector<Double> vector5 = null;
            Font font = null;
            FontRenderContext fontRenderContext = null;
            if (this.setWidest) {
                Vector vector6 = new Vector();
                object3 = new Vector<Double>();
                font = new Font("Serif", 0, 12);
                fontRenderContext = new FontRenderContext(null, false, false);
            }
            if (this.supplementalPdfPath != null && this.supplementalCategory != null) {
                ((PrintWriter)object).format("\\glssetcategoryattribute{%s}{externallocation}{%s}%n%n", this.supplementalCategory, this.supplementalPdfPath);
            }
            if (this.flattenLonely == 2 || this.saveChildCount && this.flattenLonely != 1) {
                this.flattenLonelyChildren(vector);
            }
            ((PrintWriter)object).println("\\providecommand*{\\bibglsflattenedhomograph}[2]{#1}");
            if (this.flattenLonely == 2) {
                ((PrintWriter)object).format("\\providecommand*{\\%s}[2]{#1, #2}%n", this.flattenLonelyCsName());
                ((PrintWriter)object).println();
            } else if (this.flattenLonely == 1) {
                ((PrintWriter)object).format("\\providecommand*{\\%s}[2]{#1}%n", this.flattenLonelyCsName());
                ((PrintWriter)object).println();
            }
            int n4 = vector.size();
            for (stringBuilder = 0; stringBuilder < n4; ++stringBuilder) {
                Bib2GlsEntry bib2GlsEntry = vector.get(stringBuilder);
                this.bib2gls.verbose(bib2GlsEntry.getId());
                if (this.saveLocations) {
                    bib2GlsEntry.updateLocationList(this.minLocationRange, this.suffixF, this.suffixFF, this.seeLocation, this.seeAlsoLocation, this.locationPrefix != null, this.locationSuffix != null, this.locGap);
                }
                if (this.flattenLonely == 0 && !this.saveChildCount) {
                    this.checkParent(bib2GlsEntry, stringBuilder, vector);
                }
                if (!vector3.contains(object2 = bib2GlsEntry.getCsName())) {
                    bib2GlsEntry.writeCsDefinition((PrintWriter)object);
                    ((PrintWriter)object).println();
                    vector3.add((String)object2);
                }
                bib2GlsEntry.writeBibEntry((PrintWriter)object);
                bib2GlsEntry.writeLocList((PrintWriter)object);
                if (this.saveChildCount) {
                    ((PrintWriter)object).format("\\GlsXtrSetField{%s}{childcount}{%d}%n", bib2GlsEntry.getId(), bib2GlsEntry.getChildCount());
                }
                if (this.supplementalPdfPath != null && this.supplementalCategory == null && bib2GlsEntry.supplementalRecordCount() > 0) {
                    ((PrintWriter)object).format("\\glssetattribute{%s}{externallocation}{%s}%n", bib2GlsEntry.getId(), this.supplementalPdfPath);
                }
                ((PrintWriter)object).println();
                if (iterator != null) {
                    ((Vector)((Object)iterator)).add((String)((Object)bib2GlsEntry));
                }
                if (var7_16 == null) continue;
                this.updateWidestName(bib2GlsEntry, (Vector<String>)var7_16, (Vector<Double>)object3, font, fontRenderContext);
            }
            if (vector2 != null) {
                if (var7_16 != null) {
                    if (this.dualType != null && !this.dualType.equals(this.type)) {
                        vector4 = new Vector<String>();
                        vector5 = new Vector();
                    } else {
                        vector4 = var7_16;
                        vector5 = object3;
                    }
                }
                if (this.flattenLonely == 2 || this.saveChildCount && this.flattenLonely != 1) {
                    this.flattenLonelyChildren(vector2);
                }
                n4 = vector2.size();
                for (stringBuilder = 0; stringBuilder < n4; ++stringBuilder) {
                    Bib2GlsEntry bib2GlsEntry = vector2.get(stringBuilder);
                    this.bib2gls.verbose(bib2GlsEntry.getId());
                    if (this.saveLocations) {
                        bib2GlsEntry.updateLocationList(this.minLocationRange, this.suffixF, this.suffixFF, this.seeLocation, this.seeAlsoLocation, this.locationPrefix != null, this.locationSuffix != null, this.locGap);
                    }
                    if (this.flattenLonely == 0 && !this.saveChildCount) {
                        this.checkParent(bib2GlsEntry, stringBuilder, vector2);
                    }
                    if (!vector3.contains(object2 = bib2GlsEntry.getCsName())) {
                        bib2GlsEntry.writeCsDefinition((PrintWriter)object);
                        ((PrintWriter)object).println();
                        vector3.add((String)object2);
                    }
                    bib2GlsEntry.writeBibEntry((PrintWriter)object);
                    bib2GlsEntry.writeLocList((PrintWriter)object);
                    ((PrintWriter)object).println();
                    if (iterator != null) {
                        ((Vector)((Object)iterator)).add((String)((Object)bib2GlsEntry));
                    }
                    if (vector4 == null) continue;
                    this.updateWidestName(bib2GlsEntry, vector4, vector5, font, fontRenderContext);
                }
            }
            if (iterator != null) {
                ((PrintWriter)object).format("\\provideignoredglossary*{%s}%n", this.secondaryType);
                if (this.secondarySort.equals("none") || this.secondarySort.equals("unsrt")) {
                    Iterator iterator2 = ((Vector)((Object)iterator)).iterator();
                    while (iterator2.hasNext()) {
                        Bib2GlsEntry bib2GlsEntry = (Bib2GlsEntry)iterator2.next();
                        ((PrintWriter)object).format("\\glsxtrcopytoglossary{%s}{%s}", bib2GlsEntry.getId(), this.secondaryType);
                        ((PrintWriter)object).println();
                    }
                } else if (this.secondarySort.equals("use")) {
                    Vector<GlsRecord> vector7 = this.bib2gls.getRecords();
                    for (GlsRecord glsRecord : vector7) {
                        object2 = GlsResource.getEntry(glsRecord.getLabel(), iterator);
                        if (object2 == null) continue;
                        ((PrintWriter)object).format("\\glsxtrcopytoglossary{%s}{%s}", ((Bib2GlsEntry)object2).getId(), this.secondaryType);
                        ((PrintWriter)object).println();
                    }
                } else {
                    Object object4;
                    if (this.secondarySort.equals("letter-case")) {
                        object4 = new Bib2GlsEntryLetterComparator(this.bib2gls, (Vector<Bib2GlsEntry>)((Object)iterator), this.secondarySort, this.secondaryField == null ? this.sortField : this.secondaryField, false, false);
                        ((Bib2GlsEntryLetterComparator)object4).sortEntries();
                    } else if (this.secondarySort.equals("letter-case-reverse")) {
                        object4 = new Bib2GlsEntryLetterComparator(this.bib2gls, (Vector<Bib2GlsEntry>)((Object)iterator), this.secondarySort, this.secondaryField == null ? this.sortField : this.secondaryField, false, true);
                        ((Bib2GlsEntryLetterComparator)object4).sortEntries();
                    } else if (this.secondarySort.equals("letter-nocase")) {
                        object4 = new Bib2GlsEntryLetterComparator(this.bib2gls, (Vector<Bib2GlsEntry>)((Object)iterator), this.secondarySort, this.secondaryField == null ? this.sortField : this.secondaryField, true, false);
                        ((Bib2GlsEntryLetterComparator)object4).sortEntries();
                    } else if (this.secondarySort.equals("letter-nocase-reverse")) {
                        object4 = new Bib2GlsEntryLetterComparator(this.bib2gls, (Vector<Bib2GlsEntry>)((Object)iterator), this.secondarySort, this.secondaryField == null ? this.sortField : this.secondaryField, true, true);
                        ((Bib2GlsEntryLetterComparator)object4).sortEntries();
                    } else if (this.secondarySort.startsWith("integer") || this.secondarySort.startsWith("float") || this.secondarySort.startsWith("double") || this.secondarySort.startsWith("hex") || this.secondarySort.startsWith("octal") || this.secondarySort.startsWith("binary")) {
                        object4 = new Bib2GlsEntryNumericComparator(this.bib2gls, (Vector<Bib2GlsEntry>)((Object)iterator), this.secondarySort, this.secondaryField == null ? this.sortField : this.secondaryField);
                        ((Bib2GlsEntryNumericComparator)object4).sortEntries();
                    } else if (this.secondarySort.equals("custom")) {
                        try {
                            object4 = new Bib2GlsEntryComparator(this.bib2gls, (Vector<Bib2GlsEntry>)((Object)iterator), this.secondaryField == null ? this.sortField : this.secondaryField, this.collatorStrength, this.collatorDecomposition, this.secondarySortRules, this.breakPoint, this.breakPointMarker);
                            ((Bib2GlsEntryComparator)object4).sortEntries();
                        }
                        catch (ParseException parseException) {
                            throw new Bib2GlsException(this.bib2gls.getMessage("error.invalid.sort.rule", parseException.getErrorOffset(), this.secondarySortRules), parseException);
                        }
                    } else {
                        object4 = null;
                        object4 = this.secondarySort.equals("locale") ? Locale.getDefault() : Locale.forLanguageTag(this.secondarySort);
                        Bib2GlsEntryComparator bib2GlsEntryComparator = new Bib2GlsEntryComparator(this.bib2gls, (Vector<Bib2GlsEntry>)((Object)iterator), (Locale)object4, this.secondaryField == null ? this.sortField : this.secondaryField, this.collatorStrength, this.collatorDecomposition, this.breakPoint, this.breakPointMarker);
                        bib2GlsEntryComparator.sortEntries();
                    }
                    object4 = ((Vector)((Object)iterator)).iterator();
                    while (object4.hasNext()) {
                        Bib2GlsEntry bib2GlsEntry = (Bib2GlsEntry)object4.next();
                        ((PrintWriter)object).format("\\glsxtrcopytoglossary{%s}{%s}", bib2GlsEntry.getId(), this.secondaryType);
                        ((PrintWriter)object).println();
                    }
                }
            }
            if (var7_16 != null) {
                int n2;
                if (this.type != null) {
                    ((PrintWriter)object).format("\\apptoglossarypreamble[%s]{", this.type);
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                int n3 = var7_16.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    object2 = (String)var7_16.get(n2);
                    if (((String)object2).isEmpty()) continue;
                    stringBuilder2.append(String.format("\\glssetwidest[%d]{%s}", n2, object2));
                }
                ((PrintWriter)object).print(stringBuilder2);
                if (this.type != null) {
                    ((PrintWriter)object).println("}");
                }
                if (this.secondaryType != null) {
                    ((PrintWriter)object).format("\\apptoglossarypreamble[%s]{%s}%n", this.secondaryType, stringBuilder2);
                }
                ((PrintWriter)object).println();
                if (vector4 != null && vector4 != var7_16) {
                    ((PrintWriter)object).format("\\apptoglossarypreamble[%s]{", this.dualType);
                    int n5 = vector4.size();
                    for (n2 = 0; n2 < n5; ++n2) {
                        object2 = (String)vector4.get(n2);
                        if (((String)object2).isEmpty()) continue;
                        stringBuilder2.append(String.format("\\glssetwidest[%d]{%s}", n2, object2));
                    }
                    ((PrintWriter)object).println("}");
                }
            }
            this.bib2gls.message(this.bib2gls.getChoiceMessage("message.written", 0, "entry", 3, n, this.texFile.toString()));
        }
        return n;
    }

    private void updateWidestName(Bib2GlsEntry bib2GlsEntry, Vector<String> vector, Vector<Double> vector2, Font font, FontRenderContext fontRenderContext) {
        String string = bib2GlsEntry.getFieldValue("name");
        if (string == null || string.isEmpty()) {
            return;
        }
        this.bib2gls.logMessage(this.bib2gls.getMessage("message.calc.text.width", bib2GlsEntry.getId()));
        if (string.matches(".*[\\\\\\$\\{\\}].*")) {
            string = this.bib2gls.interpret(string, bib2GlsEntry.getField("name")).trim();
        }
        int n = bib2GlsEntry.getHierarchyCount();
        String string2 = "";
        double d = 0.0;
        if (n > 0) {
            --n;
        }
        if (n < vector.size()) {
            string2 = vector.get(n);
            d = vector2.get(n);
        }
        double d2 = 0.0;
        if (!string.isEmpty()) {
            TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
            d2 = textLayout.getBounds().getWidth();
        }
        this.bib2gls.logMessage(this.bib2gls.getMessage("message.calc.text.width.result", string, d2));
        if (d2 > d) {
            if (n < vector.size()) {
                vector.set(n, String.format("\\glsentryname{%s}", bib2GlsEntry.getId()));
                vector2.set(n, new Double(d2));
            } else {
                for (int i = vector.size(); i < n; ++i) {
                    vector.add("");
                    vector2.add(new Double(0.0));
                }
                vector.add(String.format("\\glsentryname{%s}", bib2GlsEntry.getId()));
                vector2.add(new Double(d2));
            }
        }
    }

    private void checkParent(Bib2GlsEntry bib2GlsEntry, int n, Vector<Bib2GlsEntry> vector) {
        Bib2GlsEntry bib2GlsEntry2;
        int n2;
        if (this.flatten) {
            bib2GlsEntry.removeFieldValue("parent");
            return;
        }
        String string = bib2GlsEntry.getParent();
        if (string == null || string.isEmpty()) {
            return;
        }
        for (n2 = n - 1; n2 >= 0; --n2) {
            bib2GlsEntry2 = vector.get(n2);
            if (!bib2GlsEntry2.getId().equals(string)) continue;
            if (this.flattenLonely != 0 || this.saveChildCount) {
                bib2GlsEntry2.addChild(bib2GlsEntry);
            }
            return;
        }
        for (n2 = vector.size() - 1; n2 > n - 1; --n2) {
            bib2GlsEntry2 = vector.get(n2);
            if (!bib2GlsEntry2.getId().equals(string)) continue;
            if (this.flattenLonely != 0 || this.saveChildCount) {
                bib2GlsEntry2.addChild(bib2GlsEntry);
            }
            return;
        }
        this.bib2gls.warning(this.bib2gls.getMessage("warning.parent.missing", string, bib2GlsEntry.getId()));
        bib2GlsEntry.removeFieldValue("parent");
    }

    private String flattenLonelyCsName() {
        return this.flattenLonely == 1 ? "bibglsflattenedchildpresort" : "bibglsflattenedchildpostsort";
    }

    private void flattenChild(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2, Vector<Bib2GlsEntry> vector) {
        String string;
        String string2;
        L2HStringConverter l2HStringConverter = null;
        BibValueList bibValueList = null;
        BibValueList bibValueList2 = null;
        if (this.flattenLonely == 1) {
            l2HStringConverter = this.bib2gls.getInterpreterListener();
        }
        String string3 = bib2GlsEntry2.getFieldValue("name");
        if (l2HStringConverter != null) {
            bibValueList = bib2GlsEntry2.getField("name");
        }
        if (string3 == null) {
            string3 = bib2GlsEntry2.getFallbackValue("name");
            if (l2HStringConverter != null && bibValueList == null) {
                bibValueList = bib2GlsEntry2.getFallbackContents("name");
            }
        }
        if ((string2 = bib2GlsEntry2.getFieldValue("text")) == null && string3 != null) {
            bib2GlsEntry2.putField("text", string3);
        }
        String string4 = bib2GlsEntry.getFieldValue("name");
        if (l2HStringConverter != null) {
            bibValueList2 = bib2GlsEntry.getField("name");
        }
        if (string4 == null) {
            string4 = bib2GlsEntry.getFallbackValue("name");
            if (l2HStringConverter != null) {
                bibValueList2 = bib2GlsEntry.getFallbackContents("name");
            }
        }
        if (string3 != null) {
            boolean bl = string3.equals(string4);
            String string5 = bl ? "bibglsflattenedhomograph" : this.flattenLonelyCsName();
            TeXObjectList teXObjectList = null;
            Group group = null;
            Group group2 = null;
            if (l2HStringConverter != null) {
                teXObjectList = new TeXObjectList();
                teXObjectList.add(new TeXCsRef(string5));
                group = bibValueList == null ? l2HStringConverter.createGroup(string3) : this.getContents(bibValueList, l2HStringConverter);
                group2 = bibValueList2 == null ? (string4 == null ? l2HStringConverter.createGroup() : l2HStringConverter.createGroup(string4)) : this.getContents(bibValueList2, l2HStringConverter);
                if (this.flattenLonely == 2) {
                    teXObjectList.add(group2);
                    teXObjectList.add(group);
                } else {
                    teXObjectList.add(group);
                    teXObjectList.add(group2);
                }
            }
            if (this.flattenLonely == 2) {
                bib2GlsEntry2.putField("name", String.format("\\%s{%s}{%s}", string5, string4, string3));
            } else {
                bib2GlsEntry2.putField("name", String.format("\\%s{%s}{%s}", string5, string3, string4));
                if (teXObjectList != null) {
                    BibValueList bibValueList3 = new BibValueList();
                    bibValueList3.add(new BibUserString(teXObjectList));
                    bib2GlsEntry2.putField("name", bibValueList3);
                }
            }
        }
        bib2GlsEntry2.moveUpHierarchy(vector);
        if (this.flattenLonely == 2 && (string = bib2GlsEntry.getFieldValue("group")) != null) {
            bib2GlsEntry2.putField("group", string);
        }
    }

    private Group getContents(BibValueList bibValueList, L2HStringConverter l2HStringConverter) {
        TeXObject teXObject = bibValueList.getContents(true);
        if (teXObject instanceof TeXObjectList && !(teXObject instanceof MathGroup) && ((TeXObjectList)teXObject).size() == 1 && ((TeXObjectList)teXObject).firstElement() instanceof Group) {
            TeXObjectList teXObjectList = (TeXObjectList)teXObject;
            Group group = (Group)teXObjectList.firstElement();
            if (!(group instanceof MathGroup)) {
                return group;
            }
            group = l2HStringConverter.createGroup();
            group.add(teXObjectList);
            return group;
        }
        Group group = l2HStringConverter.createGroup();
        group.add(teXObject);
        return group;
    }

    private void flattenLonelyChildren(Vector<Bib2GlsEntry> vector) {
        Object object;
        Bib2GlsEntry bib2GlsEntry;
        Object object22;
        int n;
        Hashtable<Object, Vector<Bib2GlsEntry>> hashtable = new Hashtable<Object, Vector<Bib2GlsEntry>>();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        Vector<Object> vector2 = new Vector<Object>();
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            object22 = vector.get(n);
            this.checkParent((Bib2GlsEntry)object22, n, vector);
        }
        int n4 = vector.size();
        for (n = 0; n < n4; ++n) {
            boolean string;
            object22 = vector.get(n);
            int iterator = ((Bib2GlsEntry)object22).getChildCount();
            if (iterator != 1) continue;
            bib2GlsEntry = ((Bib2GlsEntry)object22).getChild(0);
            boolean bl = string = ((Bib2GlsEntry)object22).recordCount() > 0 || ((Bib2GlsEntry)object22).hasCrossRefs();
            if (this.flattenLonelyRule == 0 && string) continue;
            object = new Integer(bib2GlsEntry.getLevel(vector));
            Vector<Bib2GlsEntry> vector3 = (Vector<Bib2GlsEntry>)hashtable.get(object);
            if (vector3 == null) {
                vector3 = new Vector<Bib2GlsEntry>();
                hashtable.put(object, vector3);
                treeSet.add(object);
            }
            vector3.add(bib2GlsEntry);
            if (this.flattenLonelyRule == 1 || string) continue;
            vector2.add(object22);
        }
        for (Integer n3 : treeSet) {
            object22 = (Vector)hashtable.get(n3);
            Iterator iterator = ((Vector)object22).iterator();
            while (iterator.hasNext()) {
                bib2GlsEntry = (Bib2GlsEntry)iterator.next();
                String string = bib2GlsEntry.getParent();
                object = Bib2GlsEntry.getEntry(string, vector);
                this.flattenChild((Bib2GlsEntry)object, bib2GlsEntry, vector);
            }
        }
        for (Object object22 : vector2) {
            vector.remove(object22);
        }
    }

    public boolean flattenSort() {
        return this.flatten;
    }

    private void setType(Bib2GlsEntry bib2GlsEntry) {
        if (this.type != null) {
            if (this.type.equals("same as entry")) {
                bib2GlsEntry.putField("type", bib2GlsEntry.getEntryType());
            } else {
                bib2GlsEntry.putField("type", this.type);
            }
        }
    }

    private void setCategory(Bib2GlsEntry bib2GlsEntry) {
        this.setCategory(bib2GlsEntry, this.category);
    }

    private void setCategory(Bib2GlsEntry bib2GlsEntry, String string) {
        if (string != null) {
            if (string.equals("same as entry")) {
                bib2GlsEntry.putField("category", bib2GlsEntry.getEntryType());
            } else if (string.equals("same as type")) {
                String string2 = bib2GlsEntry.getFieldValue("type");
                if (string2 != null) {
                    bib2GlsEntry.putField("category", string2);
                }
            } else {
                bib2GlsEntry.putField("category", string);
            }
        }
    }

    private void setDualType(Bib2GlsEntry bib2GlsEntry) {
        if (this.dualType != null) {
            if (this.dualType.equals("same as entry")) {
                bib2GlsEntry.putField("type", bib2GlsEntry.getEntryType());
            } else if (this.dualType.equals("same as primary")) {
                String string = bib2GlsEntry.getDual().getFieldValue("type");
                if (string != null) {
                    bib2GlsEntry.putField("type", string);
                }
            } else {
                bib2GlsEntry.putField("type", this.dualType);
            }
        }
    }

    private void setDualCategory(Bib2GlsEntry bib2GlsEntry) {
        if (this.dualCategory != null) {
            if (this.dualCategory.equals("same as entry")) {
                bib2GlsEntry.putField("category", bib2GlsEntry.getEntryType());
            } else if (this.dualCategory.equals("same as primary")) {
                String string = bib2GlsEntry.getDual().getFieldValue("category");
                if (string != null) {
                    bib2GlsEntry.putField("category", string);
                }
            } else if (this.dualCategory.equals("same as type")) {
                String string = bib2GlsEntry.getFieldValue("type");
                if (string != null) {
                    bib2GlsEntry.putField("category", string);
                }
            } else {
                bib2GlsEntry.putField("category", this.dualCategory);
            }
        }
    }

    public boolean hasSkippedFields() {
        return this.skipFields != null && this.skipFields.length != 0;
    }

    public String[] getSkipFields() {
        return this.skipFields;
    }

    public boolean skipField(String string) {
        if (this.skipFields == null) {
            return false;
        }
        for (int i = 0; i < this.skipFields.length; ++i) {
            if (!this.skipFields[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public String getDualPrefix() {
        return this.dualPrefix;
    }

    public String getExternalPrefix(int n) {
        if (this.externalPrefixes == null) {
            return null;
        }
        if (n >= 1 && n <= this.externalPrefixes.length) {
            return this.externalPrefixes[n - 1];
        }
        return null;
    }

    public String getDualSortField() {
        return this.dualSortField;
    }

    public String getPluralSuffix() {
        return this.pluralSuffix;
    }

    public String getShortPluralSuffix() {
        return this.shortPluralSuffix;
    }

    public String getDualPluralSuffix() {
        return this.dualPluralSuffix;
    }

    public String getDualShortPluralSuffix() {
        return this.dualShortPluralSuffix;
    }

    public HashMap<String, String> getDualEntryMap() {
        return this.dualEntryMap;
    }

    public String getFirstDualEntryMap() {
        return this.dualEntryFirstMap;
    }

    public boolean backLinkFirstDualEntryMap() {
        return this.backLinkDualEntry;
    }

    public HashMap<String, String> getDualSymbolMap() {
        return this.dualSymbolMap;
    }

    public String getFirstDualSymbolMap() {
        return this.dualSymbolFirstMap;
    }

    public boolean backLinkFirstDualSymbolMap() {
        return this.backLinkDualSymbol;
    }

    public HashMap<String, String> getDualAbbrevMap() {
        return this.dualAbbrevMap;
    }

    public HashMap<String, String> getDualEntryAbbrevMap() {
        return this.dualEntryAbbrevMap;
    }

    public String getFirstDualAbbrevMap() {
        return this.dualAbbrevFirstMap;
    }

    public String getFirstDualEntryAbbrevMap() {
        return this.dualEntryAbbrevFirstMap;
    }

    public boolean backLinkFirstDualAbbrevMap() {
        return this.backLinkDualAbbrev;
    }

    public boolean backLinkFirstDualEntryAbbrevMap() {
        return this.backLinkDualEntryAbbrev;
    }

    public String getDualField() {
        return this.dualField;
    }

    private void checkFieldMaps(HashMap<String, String> hashMap, String string) throws Bib2GlsException {
        for (String string2 : hashMap.keySet()) {
            if (!this.bib2gls.isKnownField(string2)) {
                throw new Bib2GlsException(this.bib2gls.getMessage("error.invalid.field", string2, string));
            }
            if (this.bib2gls.isKnownField(string2 = hashMap.get(string2))) continue;
            throw new Bib2GlsException(this.bib2gls.getMessage("error.invalid.field", string2, string));
        }
    }

    public boolean discard(Bib2GlsEntry bib2GlsEntry) {
        if (this.fieldPatterns == null) {
            return false;
        }
        boolean bl = this.fieldPatternsAnd;
        for (String string : this.fieldPatterns.keySet()) {
            String string2 = null;
            string2 = string.equals(PATTERN_FIELD_ID) ? bib2GlsEntry.getId() : (string.equals(PATTERN_FIELD_ENTRY_TYPE) ? bib2GlsEntry.getEntryType() : bib2GlsEntry.getFieldValue(string));
            if (string2 == null) {
                string2 = "";
            }
            Pattern pattern = this.fieldPatterns.get(string);
            Matcher matcher = pattern.matcher(string2);
            boolean bl2 = matcher.matches();
            this.bib2gls.debug(this.bib2gls.getMessage("message.pattern.info", pattern.pattern(), string, string2, bl2));
            if (this.fieldPatternsAnd) {
                if (bl2) continue;
                return true;
            }
            if (!bl2) continue;
            return false;
        }
        return !bl;
    }

    public boolean changeShortCase() {
        return this.shortCaseChange != null;
    }

    public boolean changeDualShortCase() {
        return this.dualShortCaseChange != null;
    }

    public BibValueList applyShortCaseChange(TeXParser teXParser, BibValueList bibValueList) {
        return this.applyCaseChange(teXParser, bibValueList, this.shortCaseChange);
    }

    public BibValueList applyDualShortCaseChange(TeXParser teXParser, BibValueList bibValueList) {
        return this.applyCaseChange(teXParser, bibValueList, this.dualShortCaseChange);
    }

    private void toLowerCase(TeXObjectList teXObjectList) {
        int n = teXObjectList.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)teXObjectList.get(i);
            if (teXObject instanceof CharObject) {
                int n2 = ((CharObject)teXObject).getCharCode();
                if (!Character.isAlphabetic(n2)) continue;
                n2 = Character.toLowerCase(n2);
                ((CharObject)teXObject).setCharCode(n2);
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                this.toLowerCase((TeXObjectList)teXObject);
                continue;
            }
            if (!(teXObject instanceof ControlSequence) || !((ControlSequence)teXObject).getName().equals("NoCaseChange")) continue;
            ++i;
            while (i < n && (teXObject = (TeXObject)teXObjectList.get(i)) instanceof Ignoreable) {
                ++i;
            }
        }
    }

    private void toUpperCase(TeXObjectList teXObjectList) {
        int n = teXObjectList.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)teXObjectList.get(i);
            if (teXObject instanceof CharObject) {
                int n2 = ((CharObject)teXObject).getCharCode();
                if (!Character.isAlphabetic(n2)) continue;
                n2 = Character.toUpperCase(n2);
                ((CharObject)teXObject).setCharCode(n2);
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                this.toUpperCase((TeXObjectList)teXObject);
                continue;
            }
            if (!(teXObject instanceof ControlSequence) || !((ControlSequence)teXObject).getName().equals("NoCaseChange")) continue;
            ++i;
            while (i < n && (teXObject = (TeXObject)teXObjectList.get(i)) instanceof Ignoreable) {
                ++i;
            }
        }
    }

    public BibValueList applyCaseChange(TeXParser teXParser, BibValueList bibValueList, String string) {
        if (string == null) {
            return bibValueList;
        }
        TeXObjectList teXObjectList = (TeXObjectList)bibValueList.getContents(true);
        BibValueList bibValueList2 = new BibValueList();
        if (string.equals("lc-cs")) {
            Group group = teXParser.getListener().createGroup();
            group.addAll(teXObjectList);
            teXObjectList = new TeXObjectList();
            teXObjectList.add(new TeXCsRef("MakeTextLowercase"));
            teXObjectList.add(group);
        } else if (string.equals("uc-cs")) {
            Group group = teXParser.getListener().createGroup();
            group.addAll(teXObjectList);
            teXObjectList = new TeXObjectList();
            teXObjectList.add(new TeXCsRef("MakeTextUppercase"));
            teXObjectList.add(group);
        } else if (string.equals("lc")) {
            this.toLowerCase(teXObjectList);
        } else if (string.equals("uc")) {
            this.toUpperCase(teXObjectList);
        } else {
            throw new IllegalArgumentException("Invalid case change option: " + string);
        }
        bibValueList2.add(new BibUserString(teXObjectList));
        return bibValueList2;
    }

    public int aliasLocations() {
        return this.aliasLocations;
    }

    public boolean hasAliases() {
        return this.aliases;
    }

    public void setAliases(boolean bl) {
        this.aliases = bl;
    }

    public String[] getLocationCounters() {
        return this.counters;
    }

    public String getGroupField() {
        return this.groupField;
    }

    public String getType(Bib2GlsEntry bib2GlsEntry) {
        String string = bib2GlsEntry.getFieldValue("type");
        if (string != null) {
            return string;
        }
        return this.type;
    }

    public void putGroupTitle(GroupTitle groupTitle) {
        if (this.groupTitleMap != null) {
            this.groupTitleMap.put(groupTitle.getKey(), groupTitle);
        }
    }

    public GroupTitle getGroupTitle(Bib2GlsEntry bib2GlsEntry, int n) {
        if (this.groupTitleMap != null) {
            return this.groupTitleMap.get(GroupTitle.getKey(this.getType(bib2GlsEntry), n));
        }
        return null;
    }
}

