/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.git.internal;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.gradle.vcs.VersionRef;

public class GitVersionRef
implements VersionRef {
    private final String version;
    private final String canonicalId;

    private GitVersionRef(String version, String canonicalId) {
        this.version = version;
        this.canonicalId = canonicalId;
    }

    public static GitVersionRef from(Ref ref) {
        ObjectId commitId = ref.getPeeledObjectId() == null ? ref.getObjectId() : ref.getPeeledObjectId();
        return new GitVersionRef(GitVersionRef.extractName(ref), commitId.getName());
    }

    public static GitVersionRef from(String version, String canonicalId) {
        return new GitVersionRef(version, canonicalId);
    }

    public String getVersion() {
        return this.version;
    }

    public String getCanonicalId() {
        return this.canonicalId;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitVersionRef other = (GitVersionRef)obj;
        return Objects.equal((Object)this.version, (Object)other.version) && Objects.equal((Object)this.canonicalId, (Object)other.canonicalId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.version, this.canonicalId});
    }

    public String toString() {
        return this.version + ": " + this.canonicalId;
    }

    private static String extractName(Ref ref) {
        List parts = Splitter.on((String)"/").splitToList((CharSequence)ref.getName());
        return (String)parts.get(parts.size() - 1);
    }
}

