/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jnlp.SingleInstanceListener;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.services.ExtendedSingleInstanceService;
import net.sourceforge.jnlp.services.InstanceExistsException;
import net.sourceforge.jnlp.services.SingleInstanceLock;
import net.sourceforge.jnlp.util.logging.OutputController;

public class XSingleInstanceService
implements ExtendedSingleInstanceService {
    boolean initialized = false;
    List<SingleInstanceListener> listeners = new LinkedList<SingleInstanceListener>();

    protected XSingleInstanceService() {
    }

    @Override
    public void initializeSingleInstance() {
        JNLPFile jnlpFile = JNLPRuntime.getApplication().getJNLPFile();
        if (!this.initialized || jnlpFile instanceof PluginBridge) {
            this.checkSingleInstanceRunning(jnlpFile);
            this.initialized = true;
            SingleInstanceLock lockFile = new SingleInstanceLock(jnlpFile);
            if (!lockFile.isValid()) {
                this.startListeningServer(lockFile);
            }
        }
    }

    @Override
    public void checkSingleInstanceRunning(JNLPFile jnlpFile) {
        SingleInstanceLock lockFile = new SingleInstanceLock(jnlpFile);
        if (lockFile.isValid()) {
            int port = lockFile.getPort();
            OutputController.getLogger().log("Lock file is valid (port=" + port + "). Exiting.");
            String[] args = null;
            if (jnlpFile.isApplet()) {
                Set<Map.Entry<String, String>> currentParams = jnlpFile.getApplet().getParameters().entrySet();
                args = new String[currentParams.size() * 2];
                int i = 0;
                for (Map.Entry<String, String> entry : currentParams) {
                    args[i] = entry.getKey();
                    args[i + 1] = entry.getValue();
                    i += 2;
                }
            } else if (!jnlpFile.isInstaller()) {
                args = jnlpFile.getApplication().getArguments();
            }
            try {
                this.sendProgramArgumentsToExistingApplication(port, args);
                throw new InstanceExistsException(String.valueOf(port));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void startListeningServer(SingleInstanceLock lockFile) {
        SingleInstanceServer server = new SingleInstanceServer(lockFile);
        Thread serverThread = new Thread(server);
        serverThread.setDaemon(true);
        serverThread.start();
    }

    private void sendProgramArgumentsToExistingApplication(int port, String[] arguments) throws IOException {
        try {
            Socket serverCommunicationSocket = new Socket((String)null, port);
            ObjectOutputStream argumentStream = new ObjectOutputStream(serverCommunicationSocket.getOutputStream());
            argumentStream.writeObject(arguments);
            argumentStream.close();
            serverCommunicationSocket.close();
        }
        catch (UnknownHostException unknownHost) {
            OutputController.getLogger().log("Unable to find localhost");
            throw new RuntimeException(unknownHost);
        }
    }

    private void notifySingleInstanceListeners(String[] arguments) {
        for (SingleInstanceListener listener : this.listeners) {
            listener.newActivation(arguments);
        }
    }

    @Override
    public void addSingleInstanceListener(SingleInstanceListener sil) {
        this.initializeSingleInstance();
        if (sil == null) {
            return;
        }
        this.listeners.add(sil);
    }

    @Override
    public void removeSingleInstanceListener(SingleInstanceListener sil) {
        this.initializeSingleInstance();
        if (sil == null) {
            return;
        }
        this.listeners.remove(sil);
    }

    class SingleInstanceServer
    implements Runnable {
        SingleInstanceLock lockFile = null;

        public SingleInstanceServer(SingleInstanceLock lockFile) {
            this.lockFile = lockFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerSocket listeningSocket = null;
            try {
                try {
                    listeningSocket = new ServerSocket(0);
                    this.lockFile.createWithPort(listeningSocket.getLocalPort());
                    OutputController.getLogger().log("Starting SingleInstanceServer on port" + listeningSocket);
                    while (true) {
                        try {
                            while (true) {
                                Socket communicationSocket = listeningSocket.accept();
                                ObjectInputStream ois = new ObjectInputStream(communicationSocket.getInputStream());
                                String[] arguments = (String[])ois.readObject();
                                XSingleInstanceService.this.notifySingleInstanceListeners(arguments);
                            }
                        }
                        catch (Exception exception) {
                            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
                    if (listeningSocket != null) {
                        try {
                            listeningSocket.close();
                        }
                        catch (IOException e2) {
                            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (listeningSocket != null) {
                    try {
                        listeningSocket.close();
                    }
                    catch (IOException e) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
                    }
                }
                throw throwable;
            }
        }
    }
}

