/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.RoaringDocIdSet;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeKey;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesComparator;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.bucket.composite.InternalComposite;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.internal.SearchContext;

final class CompositeAggregator
extends BucketsAggregator {
    private final int size;
    private final CompositeValuesSourceConfig[] sources;
    private final List<String> sourceNames;
    private final boolean canEarlyTerminate;
    private final TreeMap<Integer, Integer> keys;
    private final CompositeValuesComparator array;
    private final List<LeafContext> contexts = new ArrayList<LeafContext>();
    private LeafContext leaf;
    private RoaringDocIdSet.Builder builder;

    CompositeAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, int size, CompositeValuesSourceConfig[] sources, List<String> sourceNames, CompositeKey rawAfterKey) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.size = size;
        this.sources = sources;
        this.sourceNames = sourceNames;
        this.array = new CompositeValuesComparator(context.searcher().getIndexReader(), sources, size + 1);
        if (rawAfterKey != null) {
            this.array.setTop(rawAfterKey.values());
        }
        this.keys = new TreeMap(this.array::compare);
        this.canEarlyTerminate = Arrays.stream(sources).allMatch(CompositeValuesSourceConfig::canEarlyTerminate);
    }

    boolean canEarlyTerminate() {
        return this.canEarlyTerminate;
    }

    private int[] getReverseMuls() {
        return Arrays.stream(this.sources).mapToInt(CompositeValuesSourceConfig::reverseMul).toArray();
    }

    @Override
    public InternalAggregation buildAggregation(long zeroBucket) throws IOException {
        assert (zeroBucket == 0L);
        this.consumeBucketsAndMaybeBreak(this.keys.size());
        this.grow(this.keys.size() + 1);
        boolean needsScores = this.needsScores();
        Weight weight = null;
        if (needsScores) {
            Query query = this.context.query();
            weight = this.context.searcher().createNormalizedWeight(query, true);
        }
        for (LeafContext context : this.contexts) {
            int docID;
            DocIdSetIterator docIdSetIterator = context.docIdSet.iterator();
            if (docIdSetIterator == null) continue;
            CompositeValuesSource.Collector collector = this.array.getLeafCollector(context.ctx, this.getSecondPassCollector(context.subCollector));
            DocIdSetIterator scorerIt = null;
            if (needsScores) {
                Scorer scorer = weight.scorer(context.ctx);
                scorerIt = scorer.iterator();
                context.subCollector.setScorer(scorer);
            }
            while ((docID = docIdSetIterator.nextDoc()) != Integer.MAX_VALUE) {
                if (needsScores) {
                    assert (scorerIt.docID() < docID);
                    scorerIt.advance(docID);
                    assert (scorerIt.docID() == docID);
                }
                collector.collect(docID);
            }
        }
        int num = Math.min(this.size, this.keys.size());
        InternalComposite.InternalBucket[] buckets = new InternalComposite.InternalBucket[num];
        int[] reverseMuls = this.getReverseMuls();
        int pos = 0;
        for (int slot : this.keys.keySet()) {
            CompositeKey key = this.array.toCompositeKey(slot);
            InternalAggregations aggs = this.bucketAggregations(slot);
            int docCount = this.bucketDocCount(slot);
            buckets[pos++] = new InternalComposite.InternalBucket(this.sourceNames, key, reverseMuls, docCount, aggs);
        }
        return new InternalComposite(this.name, this.size, this.sourceNames, Arrays.asList(buckets), reverseMuls, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        int[] reverseMuls = this.getReverseMuls();
        return new InternalComposite(this.name, this.size, this.sourceNames, Collections.emptyList(), reverseMuls, this.pipelineAggregators(), this.metaData());
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.leaf != null) {
            this.leaf.docIdSet = this.builder.build();
            this.contexts.add(this.leaf);
        }
        this.leaf = new LeafContext(ctx, sub);
        this.builder = new RoaringDocIdSet.Builder(ctx.reader().maxDoc());
        final CompositeValuesSource.Collector inner = this.array.getLeafCollector(ctx, this.getFirstPassCollector());
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long zeroBucket) throws IOException {
                assert (zeroBucket == 0L);
                inner.collect(doc);
            }
        };
    }

    @Override
    protected void doPostCollection() throws IOException {
        if (this.leaf != null) {
            this.leaf.docIdSet = this.builder.build();
            this.contexts.add(this.leaf);
        }
    }

    private CompositeValuesSource.Collector getFirstPassCollector() {
        return new CompositeValuesSource.Collector(){
            int lastDoc = -1;

            @Override
            public void collect(int doc) throws IOException {
                int slot;
                if (CompositeAggregator.this.keys.containsKey(0)) {
                    if (doc != this.lastDoc) {
                        CompositeAggregator.this.builder.add(doc);
                        this.lastDoc = doc;
                    }
                    return;
                }
                if (CompositeAggregator.this.array.hasTop() && CompositeAggregator.this.array.compareTop(0) <= 0) {
                    if (CompositeAggregator.this.canEarlyTerminate) {
                        throw new CollectionTerminatedException();
                    }
                    return;
                }
                if (CompositeAggregator.this.keys.size() >= CompositeAggregator.this.size && CompositeAggregator.this.array.compare(0, (Integer)CompositeAggregator.this.keys.lastKey()) > 0) {
                    if (CompositeAggregator.this.canEarlyTerminate) {
                        throw new CollectionTerminatedException();
                    }
                    return;
                }
                int newSlot = CompositeAggregator.this.keys.size() >= CompositeAggregator.this.size ? (slot = ((Integer)CompositeAggregator.this.keys.pollLastEntry().getKey()).intValue()) : CompositeAggregator.this.keys.size() + 1;
                CompositeAggregator.this.array.move(0, newSlot);
                CompositeAggregator.this.keys.put(newSlot, newSlot);
                if (doc != this.lastDoc) {
                    CompositeAggregator.this.builder.add(doc);
                    this.lastDoc = doc;
                }
            }
        };
    }

    private CompositeValuesSource.Collector getSecondPassCollector(LeafBucketCollector subCollector) throws IOException {
        return doc -> {
            Integer bucket = this.keys.get(0);
            if (bucket != null) {
                this.collectExistingBucket(subCollector, doc, bucket.intValue());
            }
        };
    }

    static class LeafContext {
        final LeafReaderContext ctx;
        final LeafBucketCollector subCollector;
        DocIdSet docIdSet;

        LeafContext(LeafReaderContext ctx, LeafBucketCollector subCollector) {
            this.ctx = ctx;
            this.subCollector = subCollector;
        }
    }
}

