/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Locale;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformVisitor;

public enum Platform {
    UNIXOID{

        @Override
        public <T> T accept(PlatformVisitor<T> visitor) {
            return visitor.visitUnixoid();
        }
    }
    ,
    WINDOWS{

        @Override
        public <T> T accept(PlatformVisitor<T> visitor) {
            return visitor.visitWindows();
        }
    }
    ,
    OSX{

        @Override
        public <T> T accept(PlatformVisitor<T> visitor) {
            return visitor.visitOsx();
        }
    };

    private static volatile Platform platform;

    public abstract <T> T accept(PlatformVisitor<T> var1);

    public static Platform determinePlatform() {
        if (platform == null) {
            String os = System.getProperty("os.name");
            if (os == null) {
                Logging.warn("Your operating system has no name, so I'm guessing its some kind of *nix.");
                platform = UNIXOID;
            } else if (os.toLowerCase(Locale.ENGLISH).startsWith("windows")) {
                platform = WINDOWS;
            } else if ("Linux".equals(os) || "Solaris".equals(os) || "SunOS".equals(os) || "AIX".equals(os) || "FreeBSD".equals(os) || "NetBSD".equals(os) || "OpenBSD".equals(os)) {
                platform = UNIXOID;
            } else if (os.toLowerCase(Locale.ENGLISH).startsWith("mac os x")) {
                platform = OSX;
            } else {
                Logging.warn("I don't know your operating system '" + os + "', so I'm guessing its some kind of *nix.");
                platform = UNIXOID;
            }
        }
        return platform;
    }
}

