/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.server;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.scalasbt.ipcsocket.UnixDomainServerSocket;
import org.scalasbt.ipcsocket.UnixDomainSocket;
import org.scalasbt.ipcsocket.Win32NamedPipeServerSocket;
import sbt.ConnectionType;
import sbt.ConnectionType$Local$;
import sbt.ConnectionType$Tcp$;
import sbt.ServerAuthentication;
import sbt.ServerAuthentication$Token$;
import sbt.internal.protocol.PortFile;
import sbt.internal.protocol.PortFile$;
import sbt.internal.protocol.TokenFile;
import sbt.internal.protocol.TokenFile$;
import sbt.internal.server.AlreadyRunningException;
import sbt.internal.server.Server$;
import sbt.internal.server.Server$JsonProtocol$;
import sbt.internal.server.ServerConnection;
import sbt.internal.server.ServerInstance;
import sbt.internal.util.ErrorHandling$;
import sbt.internal.util.Util$;
import sbt.io.IO$;
import sbt.io.RichFile;
import sbt.io.syntax$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.CompactPrinter$;
import sjsonnew.support.scalajson.unsafe.Converter$;

public final class Server$ {
    public static Server$ MODULE$;

    static {
        new Server$();
    }

    public ServerInstance start(ServerConnection connection, Function2<Socket, ServerInstance, BoxedUnit> onIncomingSocket, Logger log) {
        return new ServerInstance(connection, onIncomingSocket, log){
            private final AtomicBoolean sbt$internal$server$Server$$anon$$running;
            private final Promise<BoxedUnit> sbt$internal$server$Server$$anon$$p;
            private final Future<BoxedUnit> ready;
            private final SecureRandom rand;
            private String token;
            public Option<ServerSocket> sbt$internal$server$Server$$anon$$serverSocketOpt;
            private final Thread serverThread;
            public final ServerConnection connection$1;
            public final Function2 onIncomingSocket$1;
            public final Logger log$1;

            public AtomicBoolean sbt$internal$server$Server$$anon$$running() {
                return this.sbt$internal$server$Server$$anon$$running;
            }

            public Promise<BoxedUnit> sbt$internal$server$Server$$anon$$p() {
                return this.sbt$internal$server$Server$$anon$$p;
            }

            public Future<BoxedUnit> ready() {
                return this.ready;
            }

            private Thread serverThread() {
                return this.serverThread;
            }

            public void sbt$internal$server$Server$$anon$$tryClient(Function0<Socket> f) {
                if (this.connection$1.portfile().exists()) {
                    Try try_ = Try$.MODULE$.apply(f);
                    if (try_ instanceof Failure) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            Socket socket = (Socket)success.value();
                            socket.close();
                            throw new AlreadyRunningException();
                        }
                        throw new MatchError((Object)try_);
                    }
                }
            }

            public ServerSocket sbt$internal$server$Server$$anon$$addServerError(Function0<ServerSocket> f) {
                return (ServerSocket)ErrorHandling$.MODULE$.translate((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"server failed to start on ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.connection$1.shortName()})), f);
            }

            public synchronized boolean authenticate(String challenge) {
                boolean bl;
                String string = this.token;
                String string2 = challenge;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.token = this.nextToken();
                    this.writeTokenfile();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            private String nextToken() {
                return new BigInteger(128, this.rand).toString();
            }

            public void shutdown() {
                this.log$1.info((Function0 & Serializable & scala.Serializable)() -> "shutting down server");
                if (this.connection$1.portfile().exists()) {
                    IO$.MODULE$.delete(this.connection$1.portfile());
                }
                if (this.connection$1.tokenfile().exists()) {
                    IO$.MODULE$.delete(this.connection$1.tokenfile());
                }
                this.sbt$internal$server$Server$$anon$$running().set(false);
            }

            private void writeTokenfile() {
                String uri = this.connection$1.shortName();
                TokenFile t = TokenFile$.MODULE$.apply(uri, this.token);
                JValue jsonToken = (JValue)Converter$.MODULE$.toJson((Object)t, Server$JsonProtocol$.MODULE$.TokenFileFormat()).get();
                if (this.connection$1.tokenfile().exists()) {
                    IO$.MODULE$.delete(this.connection$1.tokenfile());
                }
                IO$.MODULE$.touch(this.connection$1.tokenfile(), IO$.MODULE$.touch$default$2());
                this.ownerOnly(this.connection$1.tokenfile());
                IO$.MODULE$.write(this.connection$1.tokenfile(), CompactPrinter$.MODULE$.apply(jsonToken), IO$.MODULE$.utf8(), true);
            }

            private void ownerOnly(File file) {
                File file2 = file;
                if (IO$.MODULE$.isPosix()) {
                    IO$.MODULE$.chmod("rw-------", file);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (IO$.MODULE$.hasAclFileAttributeView()) {
                    AclFileAttributeView view = new RichFile(syntax$.MODULE$.fileToRichFile(file)).aclFileAttributeView();
                    view.setAcl(Collections.singletonList(anon.2.acl$1(view.getOwner())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public void sbt$internal$server$Server$$anon$$writePortfile() {
                PortFile portFile;
                String uri = this.connection$1.shortName();
                Set<ServerAuthentication> set = this.connection$1.auth();
                if (this.connection$1.auth().apply((Object)ServerAuthentication$Token$.MODULE$)) {
                    this.writeTokenfile();
                    portFile = PortFile$.MODULE$.apply(uri, Option$.MODULE$.apply((Object)this.connection$1.tokenfile().toString()), Option$.MODULE$.apply((Object)IO$.MODULE$.toURI(this.connection$1.tokenfile()).toString()));
                } else {
                    portFile = PortFile$.MODULE$.apply(uri, (Option)None$.MODULE$, (Option)None$.MODULE$);
                }
                PortFile p = portFile;
                JValue json = (JValue)Converter$.MODULE$.toJson((Object)p, Server$JsonProtocol$.MODULE$.PortFileFormat()).get();
                IO$.MODULE$.write(this.connection$1.portfile(), CompactPrinter$.MODULE$.apply(json), IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
            }

            public void prepareSocketfile() {
                if (this.connection$1.socketfile().exists()) {
                    IO$.MODULE$.delete(this.connection$1.socketfile());
                }
                IO$.MODULE$.createDirectory(this.connection$1.socketfile().getParentFile());
            }

            private static final AclEntry acl$1(UserPrincipal owner) {
                AclEntry.Builder builder = AclEntry.newBuilder();
                builder.setPrincipal(owner);
                builder.setPermissions(AclEntryPermission.values());
                builder.setType(AclEntryType.ALLOW);
                return builder.build();
            }
            {
                this.connection$1 = connection$1;
                this.onIncomingSocket$1 = onIncomingSocket$1;
                this.log$1 = log$1;
                this.sbt$internal$server$Server$$anon$$running = new AtomicBoolean(false);
                this.sbt$internal$server$Server$$anon$$p = Promise$.MODULE$.apply();
                this.ready = this.sbt$internal$server$Server$$anon$$p().future();
                this.rand = new SecureRandom();
                this.token = this.nextToken();
                this.sbt$internal$server$Server$$anon$$serverSocketOpt = None$.MODULE$;
                this.serverThread = new Thread(this){
                    private final /* synthetic */ anon.2 $outer;

                    public void run() {
                        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                            boolean bl = false;
                            ConnectionType connectionType = null;
                            ConnectionType connectionType2 = $this.$outer.connection$1.connectionType();
                            if (ConnectionType$Local$.MODULE$.equals(connectionType2)) {
                                bl = true;
                                connectionType = connectionType2;
                                if (Util$.MODULE$.isWindows()) {
                                    return $this.$outer.sbt$internal$server$Server$$anon$$addServerError((Function0<ServerSocket>)(Function0 & Serializable & scala.Serializable)() -> new Win32NamedPipeServerSocket($this.$outer.connection$1.pipeName()));
                                }
                            }
                            if (bl) {
                                $this.$outer.sbt$internal$server$Server$$anon$$tryClient((Function0<Socket>)(Function0 & Serializable & scala.Serializable)() -> new UnixDomainSocket($this.$outer.connection$1.socketfile().getAbsolutePath()));
                                $this.$outer.prepareSocketfile();
                                return $this.$outer.sbt$internal$server$Server$$anon$$addServerError((Function0<ServerSocket>)(Function0 & Serializable & scala.Serializable)() -> new UnixDomainServerSocket($this.$outer.connection$1.socketfile().getAbsolutePath()));
                            }
                            if (!ConnectionType$Tcp$.MODULE$.equals(connectionType2)) throw new MatchError((Object)connectionType2);
                            $this.$outer.sbt$internal$server$Server$$anon$$tryClient((Function0<Socket>)(Function0 & Serializable & scala.Serializable)() -> new Socket(InetAddress.getByName($this.$outer.connection$1.host()), $this.$outer.connection$1.port()));
                            return $this.$outer.sbt$internal$server$Server$$anon$$addServerError((Function0<ServerSocket>)(Function0 & Serializable & scala.Serializable)() -> new ServerSocket($this.$outer.connection$1.port(), 50, InetAddress.getByName($this.$outer.connection$1.host())));
                        });
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            this.$outer.sbt$internal$server$Server$$anon$$p().failure(e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            ServerSocket serverSocket = (ServerSocket)success.value();
                            serverSocket.setSoTimeout(5000);
                            this.$outer.sbt$internal$server$Server$$anon$$serverSocketOpt = Option$.MODULE$.apply((Object)serverSocket);
                            this.$outer.log$1.info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sbt server started at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.$outer.connection$1.shortName()})));
                            this.$outer.sbt$internal$server$Server$$anon$$writePortfile();
                            this.$outer.sbt$internal$server$Server$$anon$$running().set(true);
                            this.$outer.sbt$internal$server$Server$$anon$$p().success((Object)BoxedUnit.UNIT);
                            while (this.$outer.sbt$internal$server$Server$$anon$$running().get()) {
                                Object object;
                                try {
                                    Socket socket = serverSocket.accept();
                                    object = this.$outer.onIncomingSocket$1.apply((Object)socket, (Object)this.$outer);
                                }
                                catch (SocketTimeoutException socketTimeoutException) {
                                    object = BoxedUnit.UNIT;
                                }
                            }
                            serverSocket.close();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)try_);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super("sbt-socket-server");
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(sbt.internal.server.Server$$anon$2$$anon$1 ), $anonfun$run$7(sbt.internal.server.Server$$anon$2$$anon$1 ), $anonfun$run$2(sbt.internal.server.Server$$anon$2$$anon$1 ), $anonfun$run$3(sbt.internal.server.Server$$anon$2$$anon$1 ), $anonfun$run$4(sbt.internal.server.Server$$anon$2$$anon$1 ), $anonfun$run$5(sbt.internal.server.Server$$anon$2$$anon$1 ), $anonfun$run$6(sbt.internal.server.Server$$anon$2$$anon$1 )}, serializedLambda);
                    }
                };
                this.serverThread().start();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$addServerError$1(sbt.internal.server.Server$$anon$2 ), $anonfun$shutdown$1()}, serializedLambda);
            }
        };
    }

    private Server$() {
        MODULE$ = this;
    }
}

