/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.node.ResponseCollectorService;

public class AdaptiveSelectionStats
implements Writeable,
ToXContentFragment {
    private final Map<String, Long> clientOutgoingConnections;
    private final Map<String, ResponseCollectorService.ComputedNodeStats> nodeComputedStats;

    public AdaptiveSelectionStats(Map<String, Long> clientConnections, Map<String, ResponseCollectorService.ComputedNodeStats> nodeComputedStats) {
        this.clientOutgoingConnections = clientConnections;
        this.nodeComputedStats = nodeComputedStats;
    }

    public AdaptiveSelectionStats(StreamInput in) throws IOException {
        this.clientOutgoingConnections = in.readMap(StreamInput::readString, StreamInput::readLong);
        this.nodeComputedStats = in.readMap(StreamInput::readString, ResponseCollectorService.ComputedNodeStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.clientOutgoingConnections, StreamOutput::writeString, StreamOutput::writeLong);
        out.writeMap(this.nodeComputedStats, StreamOutput::writeString, (stream, stats) -> stats.writeTo(stream));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("adaptive_selection");
        Set<String> allNodeIds = Sets.union(this.clientOutgoingConnections.keySet(), this.nodeComputedStats.keySet());
        for (String nodeId : allNodeIds) {
            builder.startObject(nodeId);
            ResponseCollectorService.ComputedNodeStats stats = this.nodeComputedStats.get(nodeId);
            if (stats != null) {
                long outgoingSearches = this.clientOutgoingConnections.getOrDefault(nodeId, 0L);
                builder.field("outgoing_searches", outgoingSearches);
                builder.field("avg_queue_size", stats.queueSize);
                builder.timeValueField("avg_service_time_ns", "avg_service_time", (long)stats.serviceTime, TimeUnit.NANOSECONDS);
                builder.timeValueField("avg_response_time_ns", "avg_response_time", (long)stats.responseTime, TimeUnit.NANOSECONDS);
                builder.field("rank", String.format(Locale.ROOT, "%.1f", stats.rank(outgoingSearches)));
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public Map<String, Long> getOutgoingConnections() {
        return this.clientOutgoingConnections;
    }

    public Map<String, ResponseCollectorService.ComputedNodeStats> getComputedStats() {
        return this.nodeComputedStats;
    }

    public Map<String, Double> getRanks() {
        return this.nodeComputedStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ResponseCollectorService.ComputedNodeStats)e.getValue()).rank(this.clientOutgoingConnections.getOrDefault(e.getKey(), 0L))));
    }
}

