/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.docprovider;

import java.io.IOException;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.docprovider.TextsProvider;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.Formatter;

public class JavaWsTextsProvider
extends TextsProvider {
    public JavaWsTextsProvider(String encoding, Formatter formatter, boolean forceTitles, boolean expandFiles) {
        super(encoding, formatter, forceTitles, expandFiles);
    }

    @Override
    public String getId() {
        return "javaws";
    }

    @Override
    public String getIntroduction() {
        return super.getIntroduction() + this.getFormatter().wrapParagraph(this.getFormatter().process(this.getId() + " " + Translator.R("JWSintro")));
    }

    @Override
    public String getSynopsis() {
        return super.getSynopsis() + this.getFormatter().wrapParagraph(this.getFormatter().process(this.getFormatter().getBold(" " + this.getId() + " ") + Translator.R("BOUsage") + this.getFormatter().getBreakAndBold() + this.getId() + " " + this.getFormatter().getBoldClosing() + Translator.R("BOUsage2")));
    }

    @Override
    public String getDescription() {
        return super.getDescription() + this.getFormatter().wrapParagraph(this.getFormatter().process(this.getFormatter().getBold(this.getId() + " ") + Translator.R("JWSdescL1", this.getFormatter().getBold(this.getId() + " ")) + this.getFormatter().getNewLine() + this.getFormatter().getNewLine() + Translator.R("JWSdescL2")));
    }

    @Override
    public String getOptions() {
        String title = super.getOptions();
        String add1 = Translator.R("JWSoptionsL1");
        String add2 = Translator.R("JWSoptionsL2");
        String add3 = Translator.R("JWSoptionsL3");
        String adds = this.getFormatter().wrapParagraph(add1 + this.getFormatter().getNewLine() + add2 + this.getFormatter().getNewLine() + add3);
        String runtime = this.getFormatter().getBold(Translator.R("JWSoptionsTitle1")) + this.getFormatter().getNewLine() + this.optionsToString(OptionsDefinitions.getJavaWsRuntimeOptions());
        String control = this.getFormatter().getBold(Translator.R("JWSoptionsTitle2")) + this.getFormatter().getNewLine() + this.optionsToString(OptionsDefinitions.getJavaWsControlOptions());
        return title + adds + this.getFormatter().wrapParagraph(control) + this.getFormatter().wrapParagraph(runtime);
    }

    @Override
    public String getExamples() {
        return super.getExamples() + this.getFormatter().wrapParagraph(this.getFormatter().getOption(this.getId() + " " + OptionsDefinitions.OPTIONS.ABOUT.option, Translator.R("JWSexampleL1")) + this.getFormatter().getOption(this.getId() + " " + OptionsDefinitions.OPTIONS.ABOUT.option + " " + OptionsDefinitions.OPTIONS.HEADLESS.option, Translator.R("JWSexampleL2")) + this.getFormatter().getOption(this.getId() + "  " + OptionsDefinitions.OPTIONS.NOFORK.option + " " + OptionsDefinitions.OPTIONS.NOHEADERS.option + " " + OptionsDefinitions.OPTIONS.REDIRECT.option + " " + OptionsDefinitions.OPTIONS.OFFLINE.option + " http://mypage.web/dangerous.jnlp", Translator.R("JWSexampleL3", "dangerous.jnlp", "mypage.web")));
    }

    @Override
    public String getFiles() {
        String s = super.getFiles() + this.getFiles(PathsAndFiles.getAllJavaWsFiles());
        s = s + this.getFilesAppendix();
        return s;
    }

    public static void main(String[] args) throws IOException {
        TextsProvider.main(new String[]{"all", "true", "3.51.a"});
    }

    @Override
    public String getCommands() {
        return "";
    }
}

