/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;

final class XYZChemModel {
    float[] vert;
    Atom[] atoms;
    int[] tvert;
    int[] ZsortMap;
    int nvert;
    int maxvert;
    static final Map<String, Atom> atomTable = new HashMap<String, Atom>();
    static Atom defaultAtom;
    boolean transformed;
    Matrix3D mat = new Matrix3D();
    float xmin;
    float xmax;
    float ymin;
    float ymax;
    float zmin;
    float zmax;

    XYZChemModel() {
        this.mat.xrot(20.0);
        this.mat.yrot(30.0);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    XYZChemModel(InputStream is) throws Exception {
        this();
        st = new StreamTokenizer(new BufferedReader(new InputStreamReader(is, "UTF-8")));
        st.eolIsSignificant(true);
        st.commentChar(35);
        try {
            block6: while (true) {
                switch (st.nextToken()) {
                    case -1: {
                        break block6;
                    }
                    default: {
                        continue block6;
                    }
                    case -3: {
                        name = st.sval;
                        x = 0.0;
                        y = 0.0;
                        z = 0.0;
                        if (st.nextToken() == -2) {
                            x = st.nval;
                            if (st.nextToken() == -2) {
                                y = st.nval;
                                if (st.nextToken() == -2) {
                                    z = st.nval;
                                }
                            }
                        }
                        this.addVert(name, (float)x, (float)y, (float)z);
                        while (true) {
                            if (st.ttype != 10 && st.ttype != -1) ** break;
                            continue block6;
                            st.nextToken();
                        }
                    }
                }
                break;
            }
            is.close();
        }
        catch (IOException var3_4) {
            // empty catch block
        }
        if (st.ttype != -1) {
            throw new Exception(st.toString());
        }
    }

    int addVert(String name, float x, float y, float z) {
        Atom a;
        int i = this.nvert;
        if (i >= this.maxvert) {
            if (this.vert == null) {
                this.maxvert = 100;
                this.vert = new float[this.maxvert * 3];
                this.atoms = new Atom[this.maxvert];
            } else {
                this.maxvert *= 2;
                float[] nv = new float[this.maxvert * 3];
                System.arraycopy(this.vert, 0, nv, 0, this.vert.length);
                this.vert = nv;
                Atom[] na = new Atom[this.maxvert];
                System.arraycopy(this.atoms, 0, na, 0, this.atoms.length);
                this.atoms = na;
            }
        }
        if ((a = atomTable.get(name.toLowerCase())) == null) {
            a = defaultAtom;
        }
        this.atoms[i] = a;
        this.vert[i *= 3] = x;
        this.vert[i + 1] = y;
        this.vert[i + 2] = z;
        return this.nvert++;
    }

    void transform() {
        if (this.transformed || this.nvert <= 0) {
            return;
        }
        if (this.tvert == null || this.tvert.length < this.nvert * 3) {
            this.tvert = new int[this.nvert * 3];
        }
        this.mat.transform(this.vert, this.tvert, this.nvert);
        this.transformed = true;
    }

    void paint(Graphics g) {
        int lim;
        int j;
        int i;
        if (this.vert == null || this.nvert <= 0) {
            return;
        }
        this.transform();
        int[] v = this.tvert;
        int[] zs = this.ZsortMap;
        if (zs == null) {
            this.ZsortMap = zs = new int[this.nvert];
            i = this.nvert;
            while (--i >= 0) {
                zs[i] = i * 3;
            }
        }
        i = this.nvert - 1;
        while (--i >= 0) {
            boolean flipped = false;
            for (j = 0; j <= i; ++j) {
                int a = zs[j];
                int b = zs[j + 1];
                if (v[a + 2] <= v[b + 2]) continue;
                zs[j + 1] = a;
                zs[j] = b;
                flipped = true;
            }
            if (flipped) continue;
            break;
        }
        if ((lim = this.nvert) <= 0 || this.nvert <= 0) {
            return;
        }
        for (int i2 = 0; i2 < lim; ++i2) {
            j = zs[i2];
            int grey = v[j + 2];
            if (grey < 0) {
                grey = 0;
            }
            if (grey > 15) {
                grey = 15;
            }
            this.atoms[j / 3].paint(g, v[j], v[j + 1], grey);
        }
    }

    void findBB() {
        float _zmin;
        float _ymin;
        float _xmin;
        if (this.nvert <= 0) {
            return;
        }
        float[] v = this.vert;
        float _xmax = _xmin = v[0];
        float _ymax = _ymin = v[1];
        float _zmax = _zmin = v[2];
        int i = this.nvert * 3;
        while ((i -= 3) > 0) {
            float z;
            float y;
            float x = v[i];
            if (x < _xmin) {
                _xmin = x;
            }
            if (x > _xmax) {
                _xmax = x;
            }
            if ((y = v[i + 1]) < _ymin) {
                _ymin = y;
            }
            if (y > _ymax) {
                _ymax = y;
            }
            if ((z = v[i + 2]) < _zmin) {
                _zmin = z;
            }
            if (!(z > _zmax)) continue;
            _zmax = z;
        }
        this.xmax = _xmax;
        this.xmin = _xmin;
        this.ymax = _ymax;
        this.ymin = _ymin;
        this.zmax = _zmax;
        this.zmin = _zmin;
    }

    static {
        atomTable.put("c", new Atom(0, 0, 0));
        atomTable.put("h", new Atom(210, 210, 210));
        atomTable.put("n", new Atom(0, 0, 255));
        atomTable.put("o", new Atom(255, 0, 0));
        atomTable.put("p", new Atom(255, 0, 255));
        atomTable.put("s", new Atom(255, 255, 0));
        atomTable.put("hn", new Atom(150, 255, 150));
        defaultAtom = new Atom(255, 100, 200);
    }
}

