/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.ThreadId;

final class NativeThreadPool
implements IThreadPool {
    private final long pool = NativeThreadPool.create();
    private volatile Throwable dispose;

    public ThreadId getThreadId() {
        return new ThreadId(NativeThreadPool.threadId());
    }

    public void attach() {
        NativeThreadPool.attach(this.pool);
    }

    public Object attach(ThreadId id) {
        this.attach();
        return null;
    }

    public void detach() {
        NativeThreadPool.detach(this.pool);
    }

    public void detach(Object handle, ThreadId id) {
        this.detach();
    }

    public Object enter() throws Throwable {
        Job job = NativeThreadPool.enter(this.pool);
        if (job == null) {
            throw this.dispose;
        }
        return job.execute();
    }

    public Object enter(Object handle, ThreadId id) throws Throwable {
        return this.enter();
    }

    public void putJob(Job job) {
        NativeThreadPool.putJob(this.pool, job.getThreadId().getBytes(), job, job.isRequest(), job.isRequest() && !job.isSynchronous());
    }

    public void dispose(Throwable throwable) {
        this.dispose = throwable;
        NativeThreadPool.dispose(this.pool);
    }

    public void destroy() {
        NativeThreadPool.destroy(this.pool);
    }

    private static native byte[] threadId();

    private static native long create();

    private static native void attach(long var0);

    private static native Job enter(long var0);

    private static native void detach(long var0);

    private static native void putJob(long var0, byte[] var2, Job var3, boolean var4, boolean var5);

    private static native void dispose(long var0);

    private static native void destroy(long var0);

    static {
        System.loadLibrary("java_uno");
    }
}

