/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;

public class Bib2GlsDualEntryAbbrev
extends Bib2GlsDualEntry {
    public Bib2GlsDualEntryAbbrev(Bib2Gls bib2Gls) {
        this(bib2Gls, "dualentryabbreviation");
    }

    public Bib2GlsDualEntryAbbrev(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public HashMap<String, String> getMappings() {
        return this.getResource().getDualEntryAbbrevMap();
    }

    @Override
    public String getFirstMap() {
        return this.getResource().getFirstDualEntryAbbrevMap();
    }

    @Override
    public boolean backLink() {
        return this.getResource().backLinkFirstDualEntryAbbrevMap();
    }

    @Override
    protected Bib2GlsEntry createDualEntry() {
        return new Bib2GlsDualEntryAbbrev(this.bib2gls, this.getEntryType() + "secondary");
    }

    @Override
    public void checkRequiredFields(TeXParser teXParser) {
        if (this.getField("short") == null) {
            this.missingFieldWarning(teXParser, "short");
        }
        if (this.getField("long") == null) {
            this.missingFieldWarning(teXParser, "long");
        }
        if (this.getField("description") == null) {
            this.missingFieldWarning(teXParser, "description");
        }
    }

    @Override
    public String getFallbackValue(String string) {
        String string2;
        if (string.equals("name") && (string2 = this.getFieldValue("short")) != null) {
            return string2;
        }
        return super.getFallbackValue(string);
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        BibValueList bibValueList;
        if (string.equals("name") && (bibValueList = this.getField("short")) != null) {
            return bibValueList;
        }
        return super.getFallbackContents(string);
    }

    @Override
    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s{%s}%%%n{", this.getCsName(), this.getId());
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Set<String> set = this.getFieldSet();
        for (String string5 : set) {
            if (string5.equals("short")) {
                string2 = this.getFieldValue(string5);
                continue;
            }
            if (string5.equals("long")) {
                string3 = this.getFieldValue(string5);
                continue;
            }
            if (string5.equals("description")) {
                string4 = this.getFieldValue(string5);
                continue;
            }
            printWriter.format("%s", string);
            string = String.format(",%n", new Object[0]);
            printWriter.format("%s={%s}", string5, this.getFieldValue(string5));
        }
        printWriter.println(String.format("}%%%n{%s}{%s}%%%n{%s}", string2, string3, string4));
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        printWriter.format("\\providecommand{\\%s}[5]{%%%n", this.getCsName());
        if (this.getEntryType().endsWith("secondary")) {
            printWriter.println("  \\longnewglossaryentry*{#1}{#2}{#5}%");
        } else {
            printWriter.println("  \\newabbreviation[#2]{#1}{#3}{#4}%");
        }
        printWriter.println("}");
    }
}

