/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class Comment
extends Ignoreable {
    private StringBuilder builder = new StringBuilder();

    public void appendText(String string) {
        this.builder.append(string);
    }

    public void appendCodePoint(int n) {
        this.builder.appendCodePoint(n);
    }

    public String getText() {
        return this.builder.toString();
    }

    @Override
    public Object clone() {
        Comment comment = new Comment();
        comment.appendText(this.getText());
        return comment;
    }

    @Override
    public String toString(TeXParser teXParser) {
        return String.format("%c%s%n", Character.valueOf(teXParser.getCommentChar()), this.builder.toString());
    }

    @Override
    public String toString() {
        return String.format("%s[comment=%s]%n", this.getClass().getName(), this.builder.toString());
    }

    @Override
    public String format() {
        return String.format("%c%s%n", Character.valueOf('%'), this.builder.toString());
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(teXParser.getCommentChar()));
        teXParser.scan(this.builder.toString(), teXObjectList);
        return teXObjectList;
    }
}

