/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParserListener;

public abstract class Macro
implements TeXObject {
    protected boolean isShort = true;
    protected boolean allowsPrefix = false;
    public static final byte PREFIX_NONE = 0;
    public static final byte PREFIX_LONG = 1;
    public static final byte PREFIX_GLOBAL = 2;
    protected byte prefix = 0;
    protected TeXObjectList syntax = null;
    protected int numArgs = 0;
    protected boolean isDelimited = false;

    public boolean getAllowsPrefix() {
        return this.allowsPrefix;
    }

    protected void setAllowsPrefix(boolean bl) {
        this.allowsPrefix = bl;
    }

    public boolean isShort() {
        return this.isShort;
    }

    protected void setShort(boolean bl) {
        this.isShort = bl;
    }

    protected void setPrefix(byte by) {
        if (this.allowsPrefix) {
            this.prefix = by;
        }
    }

    public byte getPrefix() {
        return this.allowsPrefix ? this.prefix : (byte)0;
    }

    protected void clearPrefix() {
        this.prefix = 0;
    }

    public TeXObjectList getSyntax() {
        return this.syntax;
    }

    protected void setSyntax(TeXObjectList teXObjectList) {
        this.syntax = teXObjectList;
        this.isDelimited = false;
        if (teXObjectList != null) {
            this.numArgs = 0;
            for (TeXObject teXObject : teXObjectList) {
                if (!(teXObject instanceof Param)) continue;
                if (((Param)teXObject).getDigit() == -1) {
                    this.isDelimited = true;
                    continue;
                }
                ++this.numArgs;
            }
        }
    }

    protected void setSyntax(TeXParserListener teXParserListener, int n) {
        this.isDelimited = false;
        this.numArgs = n;
        if (this.numArgs == 0) {
            this.syntax = null;
        } else {
            this.syntax = new TeXObjectList(this.numArgs);
            for (int i = 1; i <= this.numArgs; ++i) {
                this.syntax.add(teXParserListener.getParam(i));
            }
        }
    }

    protected void setSyntax(TeXObject[] teXObjectArray) {
        this.isDelimited = false;
        this.numArgs = 0;
        if (teXObjectArray == null || teXObjectArray.length == 0) {
            this.syntax = null;
        } else {
            this.syntax = new TeXObjectList(teXObjectArray.length);
            for (int i = 0; i < teXObjectArray.length; ++i) {
                if (teXObjectArray[i] instanceof Param) {
                    if (((Param)teXObjectArray[i]).getDigit() == -1) {
                        this.isDelimited = true;
                    } else {
                        ++this.numArgs;
                    }
                }
                this.syntax.add(teXObjectArray[i]);
            }
        }
    }

    public boolean hasSyntax(Macro macro) {
        if (this.numArgs != macro.numArgs) {
            return false;
        }
        TeXObjectList teXObjectList = macro.syntax;
        if (this.syntax == null && teXObjectList == null) {
            return true;
        }
        if (this.syntax == null || teXObjectList == null) {
            return false;
        }
        return this.syntax.equals(teXObjectList);
    }

    @Override
    public boolean isPar() {
        return false;
    }

    @Override
    public abstract Object clone();

    public String toString() {
        return String.format("%s[prefix=%d,syntax=%s]", this.getClass().getSimpleName(), this.getPrefix(), this.syntax);
    }
}

