/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.image;

import com.dickimawbooks.texparserlib.TeXGraphicsException;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.image.TeXGraphicsClippingPath;
import com.dickimawbooks.texparserlib.image.TeXGraphicsFillAttributes;
import com.dickimawbooks.texparserlib.image.TeXGraphicsFilledPath;
import com.dickimawbooks.texparserlib.image.TeXGraphicsNoOpPath;
import com.dickimawbooks.texparserlib.image.TeXGraphicsObject;
import com.dickimawbooks.texparserlib.image.TeXGraphicsShape;
import com.dickimawbooks.texparserlib.image.TeXGraphicsStrokeAttributes;
import com.dickimawbooks.texparserlib.image.TeXGraphicsStrokedFilledPath;
import com.dickimawbooks.texparserlib.image.TeXGraphicsStrokedPath;
import com.dickimawbooks.texparserlib.image.TeXGraphicsTextAttributes;
import com.dickimawbooks.texparserlib.image.TeXGraphicsTransformAttributes;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class TeXGraphicsGroup
extends Vector<TeXGraphicsObject>
implements TeXGraphicsObject {
    private TeXGraphicsStrokeAttributes strokeAttributes;
    private TeXGraphicsFillAttributes fillAttributes;
    private TeXGraphicsTextAttributes textAttributes;
    private TeXGraphicsTransformAttributes transformAttributes;
    private TeXGraphicsShape currentPath = null;
    private TeXGraphicsGroup parent = null;
    private TeXParser parser;

    public TeXGraphicsGroup(TeXParser teXParser) {
        this.strokeAttributes = new TeXGraphicsStrokeAttributes();
        this.fillAttributes = new TeXGraphicsFillAttributes();
        this.transformAttributes = new TeXGraphicsTransformAttributes();
        this.textAttributes = new TeXGraphicsTextAttributes();
        this.parser = teXParser;
    }

    public TeXGraphicsGroup(TeXGraphicsGroup teXGraphicsGroup) {
        this.strokeAttributes = (TeXGraphicsStrokeAttributes)teXGraphicsGroup.strokeAttributes.clone();
        this.fillAttributes = (TeXGraphicsFillAttributes)teXGraphicsGroup.fillAttributes.clone();
        this.textAttributes = (TeXGraphicsTextAttributes)teXGraphicsGroup.textAttributes.clone();
        this.transformAttributes = (TeXGraphicsTransformAttributes)teXGraphicsGroup.transformAttributes.clone();
        this.parent = teXGraphicsGroup;
        this.parser = teXGraphicsGroup.parser;
    }

    public TeXGraphicsStrokeAttributes getStrokeAttributes() {
        return this.strokeAttributes;
    }

    public TeXGraphicsFillAttributes getFillAttributes() {
        return this.fillAttributes;
    }

    public TeXGraphicsTransformAttributes getTransformAttributes() {
        return this.transformAttributes;
    }

    public TeXGraphicsTextAttributes getTextAttributes() {
        return this.textAttributes;
    }

    public void newPath() {
        this.currentPath = new TeXGraphicsShape(this);
    }

    public void strokePath() throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        this.add(new TeXGraphicsStrokedPath(this.currentPath));
        this.currentPath = null;
    }

    public void fillPath() throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        this.add(new TeXGraphicsFilledPath(this.currentPath));
        this.currentPath = null;
    }

    public void strokeFillPath() throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        this.add(new TeXGraphicsStrokedFilledPath(this.currentPath));
        this.currentPath = null;
    }

    public void clip() throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        this.add(new TeXGraphicsClippingPath(this.currentPath));
        this.currentPath = null;
    }

    public void noOpPath() throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        this.add(new TeXGraphicsNoOpPath(this.currentPath));
        this.currentPath = null;
    }

    @Override
    public Rectangle2D computeBounds() {
        if (this.isEmpty()) {
            return null;
        }
        TeXGraphicsObject teXGraphicsObject = (TeXGraphicsObject)this.firstElement();
        Rectangle2D rectangle2D = teXGraphicsObject.computeBounds();
        for (int i = 1; i < this.size(); ++i) {
            rectangle2D.add(teXGraphicsObject.computeBounds());
        }
        return rectangle2D;
    }

    public void setCurrentColor(Color color) throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        this.currentPath.setColor(color);
    }

    public void setCurrentLineColor(Color color) throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        this.currentPath.getStrokeAttributes().setLineColor(color);
    }

    public void setCurrentFillColor(Color color) throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        this.currentPath.getFillAttributes().setFillColor(color);
    }

    public void setCurrentTextColor(Color color) throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        this.currentPath.getTextAttributes().setTextColor(color);
    }

    public TeXGraphicsStrokeAttributes getCurrentStrokeAttributes() throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        return this.currentPath.getStrokeAttributes();
    }

    public TeXGraphicsFillAttributes getCurrentFillAttributes() throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        return this.currentPath.getFillAttributes();
    }

    public TeXGraphicsTextAttributes getCurrentTextAttributes() throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        return this.currentPath.getTextAttributes();
    }

    public TeXGraphicsTransformAttributes getCurrentTransformAttributes() throws TeXGraphicsException {
        if (this.currentPath == null) {
            throw new TeXGraphicsException(this.parser, "teximage.error.no_path");
        }
        return this.currentPath.getTransformAttributes();
    }

    public void setColor(Color color) {
        this.fillAttributes.setFillColor(color);
        this.strokeAttributes.setLineColor(color);
        this.textAttributes.setTextColor(color);
    }

    public void setLineColor(Color color) {
        this.strokeAttributes.setLineColor(color);
    }

    public void setFillColor(Color color) {
        this.fillAttributes.setFillColor(color);
    }

    public void setTextColor(Color color) {
        this.textAttributes.setTextColor(color);
    }

    public TeXParser getParser() {
        return this.parser;
    }
}

