/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.booktabs;

import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.UserDimension;
import com.dickimawbooks.texparserlib.latex.Hline;
import java.io.IOException;

public class BKTrule
extends Hline
implements Expandable {
    private int position;
    private TeXObject width;
    public static int TOP = 0;
    public static int MIDDLE = 1;
    public static int BOTTOM = 2;

    public BKTrule(String string, int n) {
        super(string);
        this.setPosition(n);
    }

    @Override
    public Object clone() {
        BKTrule bKTrule = new BKTrule(this.getName(), this.getPosition());
        bKTrule.width = this.width == null ? null : (TeXObject)this.width.clone();
        return bKTrule;
    }

    public void setPosition(int n) {
        if (n != TOP && n != MIDDLE && n != BOTTOM) {
            throw new IllegalArgumentException("Invalid position " + n);
        }
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandfully(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandfully(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandfully(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2;
        TeXObject teXObject;
        TeXObject teXObject2 = teXObject = teXParser == teXObjectList ? teXParser.popNextArg('[', ']') : teXObjectList.popArg(teXParser, '[', ']');
        if (teXObject instanceof Expandable && (teXObjectList2 = teXParser == teXObjectList ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObject = teXObjectList2;
        }
        teXObjectList2 = new TeXObjectList();
        if (teXObject == null) {
            this.setWidth(null);
        } else {
            this.setWidth(teXObject);
        }
        teXObjectList2.add(this);
        return teXObjectList2;
    }

    public TeXDimension getWidth(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = this.width == null ? (this.position == MIDDLE ? teXParser.getListener().getControlSequence("lightrulewidth") : teXParser.getListener().getControlSequence("heavyrulewidth")) : this.width;
        if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser)) != null) {
            teXObject = teXObjectList;
        }
        if (teXObject instanceof TeXDimension) {
            return (TeXDimension)teXObject;
        }
        return new UserDimension(teXParser, teXObject.toString(teXParser));
    }

    public TeXObject getWidth() {
        return this.width;
    }

    public void setWidth(TeXObject teXObject) {
        this.width = teXObject;
    }
}

