/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.probsoln;

import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class ProbSolnData {
    private String name;
    private int numArgs = 0;
    private TeXObjectList contents;
    private TeXObjectList defArgs;

    public ProbSolnData(String string, TeXObjectList teXObjectList) {
        this(string, 0, null, teXObjectList);
    }

    public ProbSolnData(String string, int n, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) {
        this.setName(string);
        this.numArgs = n;
        this.defArgs = teXObjectList;
        this.contents = teXObjectList2;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int getNumArgs() {
        return this.numArgs;
    }

    public TeXObjectList getDefaultArgs() {
        return this.defArgs;
    }

    public void process(TeXParser teXParser) throws IOException {
        TeXObject[] teXObjectArray = null;
        if (this.numArgs > 0) {
            teXObjectArray = new TeXObject[this.numArgs];
            for (int i = 0; i < this.numArgs; ++i) {
                teXObjectArray[i] = teXParser.popNextArg();
            }
        }
        this.getData(teXParser, teXObjectArray).process(teXParser);
    }

    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject[] teXObjectArray = null;
        if (this.numArgs > 0) {
            teXObjectArray = new TeXObject[this.numArgs];
            for (int i = 0; i < this.numArgs; ++i) {
                teXObjectArray[i] = teXObjectList.popArg(teXParser);
            }
        }
        this.getData(teXParser, teXObjectArray).process(teXParser, teXObjectList);
    }

    private TeXObjectList getData(TeXParser teXParser, TeXObject[] teXObjectArray) throws IOException {
        return this.getData(teXParser, teXObjectArray, this.contents);
    }

    private TeXObjectList getData(TeXParser teXParser, TeXObject[] teXObjectArray, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = teXObjectList.createList();
        for (TeXObject teXObject : teXObjectList) {
            if (teXObject instanceof Param) {
                int n = ((Param)teXObject).getDigit() - 1;
                if (teXObjectArray == null || n >= teXObjectArray.length) {
                    throw new TeXSyntaxException(teXParser, "tex.error.syntax", teXObject.toString(teXParser));
                }
                teXObjectList2.add((TeXObject)teXObjectArray[n].clone());
                continue;
            }
            if (teXObject instanceof DoubleParam) {
                teXObjectList2.add((TeXObject)((DoubleParam)teXObject).getParam().clone());
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                teXObjectList2.add(this.getData(teXParser, teXObjectArray, (TeXObjectList)teXObject));
                continue;
            }
            teXObjectList2.add((TeXObject)teXObject.clone());
        }
        return teXObjectList2;
    }

    public String toString() {
        return String.format("ProbSolnData[name=%s,args=(n=%d,default=%s),contents=%s]", this.name, this.numArgs, this.defArgs, this.contents);
    }
}

