/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.PageRanges;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.print.PrintPreviewModel;
import org.gjt.sp.jedit.print.PrinterDialog;
import org.gjt.sp.jedit.print.Range;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DisplayTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SyntaxUtilities;

class BufferPrintable1_7
implements Printable {
    private static Color headerColor = Color.lightGray;
    private static Color headerTextColor = Color.black;
    private static Color footerColor = Color.lightGray;
    private static Color footerTextColor = Color.black;
    private static Color lineNumberColor = Color.gray;
    private static Color textColor = Color.black;
    private PrintRequestAttributeSet attributes;
    private boolean firstCall;
    private View view;
    private Buffer buffer;
    private boolean selection;
    private int[] selectedLines;
    private boolean reverse;
    private int printRangeType = PrinterDialog.ALL;
    private Font font;
    private SyntaxStyle[] styles;
    private boolean header;
    private boolean footer;
    private boolean lineNumbers;
    private HashMap<Integer, Range> pages = null;
    private int currentPhysicalLine;
    private LineMetrics lm;
    private final List<Chunk> lineList;
    private FontRenderContext frc;
    private DisplayTokenHandler tokenHandler;

    BufferPrintable1_7(PrintRequestAttributeSet printRequestAttributeSet, View view, Buffer buffer) {
        this.attributes = printRequestAttributeSet;
        this.view = view;
        this.buffer = buffer;
        this.firstCall = true;
        this.header = jEdit.getBooleanProperty("print.header");
        this.footer = jEdit.getBooleanProperty("print.footer");
        this.lineNumbers = jEdit.getBooleanProperty("print.lineNumbers");
        this.font = jEdit.getFontProperty("print.font");
        boolean bl = Chromaticity.COLOR.equals(printRequestAttributeSet.get(Chromaticity.class));
        this.styles = SyntaxUtilities.loadStyles(jEdit.getProperty("print.font"), jEdit.getIntegerProperty("print.fontsize", 10), bl);
        this.styles[0] = new SyntaxStyle(textColor, null, this.font);
        for (int i = 0; i < this.styles.length; ++i) {
            SyntaxStyle syntaxStyle = this.styles[i];
            if (!syntaxStyle.getForegroundColor().equals(Color.WHITE) || syntaxStyle.getBackgroundColor() != null) continue;
            this.styles[i] = new SyntaxStyle(Color.BLACK, syntaxStyle.getBackgroundColor(), syntaxStyle.getFont());
        }
        this.lineList = new ArrayList<Chunk>();
        this.tokenHandler = new DisplayTokenHandler();
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    public void setSelectedLines(int[] nArray) {
        this.selectedLines = Arrays.copyOf(nArray, nArray.length);
        Arrays.sort(this.selectedLines);
    }

    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    public void setPrintRangeType(int n) {
        this.printRangeType = n;
        this.selection = PrinterDialog.SELECTION == n;
    }

    public void setPages(HashMap<Integer, Range> hashMap) {
        this.pages = hashMap;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Range range;
        ++n;
        if (this.firstCall && this.pages == null) {
            this.pages = this.calculatePages(graphics, pageFormat);
            if (this.pages == null || this.pages.isEmpty()) {
                throw new PrinterException("Unable to determine page ranges.");
            }
            this.firstCall = false;
        }
        if (this.printRangeType == PrinterDialog.CURRENT_PAGE) {
            int n2 = this.view.getTextArea().getCaretLine();
            for (Integer n3 : this.pages.keySet()) {
                Range range2 = this.pages.get(n3);
                if (!range2.contains(n2)) continue;
                n = n3;
                break;
            }
        }
        if (this.reverse && this.printRangeType != PrinterDialog.CURRENT_PAGE) {
            n = this.pages.size() - 1 - n;
        }
        if (!((range = this.pages.get(n)) != null && this.inRange(n) || this.printRangeType == PrinterDialog.CURRENT_PAGE)) {
            return 1;
        }
        this.printPage(graphics, pageFormat, n, true);
        return 0;
    }

    protected HashMap<Integer, Range> calculatePages(Graphics graphics, PageFormat pageFormat) throws PrinterException {
        StringBuilder stringBuilder;
        double d;
        this.pages = new HashMap();
        String string = this.buffer.getStringProperty("largefilemode");
        if (!"full".equals(string)) {
            int n = jEdit.getIntegerProperty("largeBufferSize", 4000000);
            if (this.buffer.getLength() > n) {
                throw new PrinterException("Buffer is too large to print.");
            }
        }
        if (graphics == null) {
            return this.pages;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.view.getTextArea().getPainter().getAntiAlias().renderHint());
        boolean bl = jEdit.getBooleanProperty("view.fracFontMetrics");
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, bl ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        graphics2D.setFont(this.font);
        graphics2D.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        this.frc = graphics2D.getFontRenderContext();
        double d2 = pageFormat.getImageableX();
        double d3 = pageFormat.getImageableY();
        double d4 = pageFormat.getImageableWidth();
        double d5 = pageFormat.getImageableHeight();
        if (this.header) {
            d = this.paintHeader(graphics2D, d2, d3, d4, false);
            d3 += d;
            d5 -= d;
        }
        if (this.footer) {
            d = this.paintFooter(graphics2D, d2, d3, d4, d5, 0, false);
            d5 -= d;
        }
        d = 0.0;
        if (this.lineNumbers) {
            String string2 = String.valueOf(this.buffer.getLineCount());
            stringBuilder = new StringBuilder();
            for (int i = 0; i < string2.length(); ++i) {
                stringBuilder.append('0');
            }
            d = this.font.getStringBounds(stringBuilder.toString(), this.frc).getWidth();
        }
        int n = jEdit.getIntegerProperty("print.tabSize", 4);
        stringBuilder = new StringBuilder();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        double d6 = this.font.getStringBounds(stringBuilder.toString(), this.frc).getWidth();
        PrintTabExpander printTabExpander = new PrintTabExpander(d6);
        this.lm = this.font.getLineMetrics("gGyYX", this.frc);
        float f = this.lm.getHeight();
        boolean bl2 = jEdit.getBooleanProperty("print.folds", true);
        this.currentPhysicalLine = 0;
        int n2 = 1;
        int n3 = 0;
        double d7 = 0.0;
        int n4 = jEdit.getIntegerProperty("longLineLimit", 4000);
        int n5 = this.buffer.getLineCount();
        while (this.currentPhysicalLine <= n5) {
            if (this.currentPhysicalLine < n5 && this.buffer.getLineLength(this.currentPhysicalLine) > n4) {
                throw new PrinterException("Line " + (this.currentPhysicalLine + 1) + " is too long to print.");
            }
            if (this.currentPhysicalLine == n5) {
                Range range = new Range(n3, this.currentPhysicalLine);
                this.pages.put(new Integer(n2), range);
                Log.log(1, this, "calculatePages, page " + n2 + " has " + range);
                break;
            }
            if (!bl2 && !this.view.getTextArea().getDisplayManager().isLineVisible(this.currentPhysicalLine)) {
                ++this.currentPhysicalLine;
                continue;
            }
            this.lineList.clear();
            this.tokenHandler.init(this.styles, this.frc, printTabExpander, this.lineList, (float)(d4 - d), 0);
            this.buffer.markTokens(this.currentPhysicalLine, this.tokenHandler);
            int n6 = this.lineList.isEmpty() ? 1 : this.lineList.size();
            if (d7 + (double)(f * (float)n6) > d5) {
                Range range = new Range(n3, Math.max(0, this.currentPhysicalLine - 1));
                this.pages.put(new Integer(n2), range);
                Log.log(1, this, "calculatePages, page " + n2 + " has " + range);
                ++n2;
                n3 = this.currentPhysicalLine;
                d7 = 0.0;
                continue;
            }
            for (int i = 0; i < (this.lineList.isEmpty() ? 1 : this.lineList.size()); ++i) {
                d7 += (double)f;
            }
            ++this.currentPhysicalLine;
        }
        return this.pages;
    }

    private boolean inRange(int n) {
        PageRanges pageRanges = (PageRanges)this.attributes.get(PageRanges.class);
        boolean bl = false;
        bl = pageRanges == null ? true : pageRanges.contains(n);
        return bl;
    }

    private void printPage(Graphics graphics, PageFormat pageFormat, int n, boolean bl) {
        int n2;
        StringBuilder stringBuilder;
        double d;
        Graphics2D graphics2D = (Graphics2D)graphics;
        float f = 1.0f;
        if (pageFormat instanceof PrintPreviewModel) {
            PrintPreviewModel printPreviewModel = (PrintPreviewModel)pageFormat;
            f = printPreviewModel.getZoomLevel();
            this.font = this.font.deriveFont((float)this.font.getSize() * f);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.view.getTextArea().getPainter().getAntiAlias().renderHint());
            boolean bl2 = jEdit.getBooleanProperty("view.fracFontMetrics");
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, bl2 ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            graphics2D.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
            for (int i = 0; i < this.styles.length; ++i) {
                SyntaxStyle syntaxStyle = this.styles[i];
                this.styles[i] = new SyntaxStyle(syntaxStyle.getForegroundColor(), syntaxStyle.getBackgroundColor(), this.font);
            }
        }
        graphics2D.setFont(this.font);
        if (this.frc == null) {
            this.frc = graphics2D.getFontRenderContext();
        }
        double d2 = pageFormat.getImageableX();
        double d3 = pageFormat.getImageableY();
        double d4 = pageFormat.getImageableWidth();
        double d5 = pageFormat.getImageableHeight();
        if (this.header) {
            d = this.paintHeader(graphics2D, d2, d3, d4, bl);
            d3 += d;
            d5 -= d;
        }
        if (this.footer) {
            d = this.paintFooter(graphics2D, d2, d3, d4, d5, n, bl);
            d5 -= d;
        }
        d = 0.0;
        if (this.lineNumbers) {
            String string = String.valueOf(this.buffer.getLineCount());
            stringBuilder = new StringBuilder();
            for (n2 = 0; n2 < string.length(); ++n2) {
                stringBuilder.append('0');
            }
            d = this.font.getStringBounds(stringBuilder.toString(), this.frc).getWidth();
        }
        int n3 = jEdit.getIntegerProperty("print.tabSize", 4);
        stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuilder.append(' ');
        }
        double d6 = this.font.getStringBounds(stringBuilder.toString(), this.frc).getWidth();
        PrintTabExpander printTabExpander = new PrintTabExpander(d6);
        this.lm = this.font.getLineMetrics("gGyYX", this.frc);
        float f2 = this.lm.getHeight();
        double d7 = 0.0;
        Range range = this.pages.get(n);
        this.currentPhysicalLine = range.getStart();
        while (this.currentPhysicalLine <= range.getEnd() && this.currentPhysicalLine != this.buffer.getLineCount()) {
            if (!(!jEdit.getBooleanProperty("print.folds", true) && !this.view.getTextArea().getDisplayManager().isLineVisible(this.currentPhysicalLine) || this.selection && Arrays.binarySearch(this.selectedLines, this.currentPhysicalLine) < 0)) {
                this.lineList.clear();
                this.tokenHandler.init(this.styles, this.frc, printTabExpander, this.lineList, (float)(d4 - d), -1);
                this.buffer.markTokens(this.currentPhysicalLine, this.tokenHandler);
                if (this.lineNumbers && bl) {
                    graphics2D.setFont(this.font);
                    graphics2D.setColor(lineNumberColor);
                    graphics2D.drawString(String.valueOf(this.currentPhysicalLine + 1), (float)d2, (float)(d3 + d7 + (double)f2));
                }
                if (this.lineList.isEmpty()) {
                    d7 += (double)f2;
                } else {
                    for (Chunk chunk : this.lineList) {
                        d7 += (double)f2;
                        Chunk chunk2 = chunk;
                        if (chunk2 == null || !bl) continue;
                        Chunk.paintChunkBackgrounds(chunk2, graphics2D, (float)(d2 + d), (float)(d3 + d7), f2);
                        Chunk.paintChunkList(chunk2, graphics2D, (float)(d2 + d), (float)(d3 + d7), true);
                    }
                }
                if (this.currentPhysicalLine == range.getEnd()) break;
            }
            ++this.currentPhysicalLine;
        }
    }

    private double paintHeader(Graphics2D graphics2D, double d, double d2, double d3, boolean bl) {
        String string = jEdit.getProperty("print.headerText", new String[]{this.buffer.getName()});
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        this.lm = this.font.getLineMetrics(string, fontRenderContext);
        Rectangle2D rectangle2D = this.font.getStringBounds(string, fontRenderContext);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, rectangle2D.getHeight());
        if (bl) {
            graphics2D.setColor(headerColor);
            graphics2D.fill(double_);
            graphics2D.setColor(headerTextColor);
            graphics2D.drawString(string, (float)(d + (d3 - rectangle2D.getWidth()) / 2.0), (float)(d2 + (double)this.lm.getAscent()));
        }
        return ((RectangularShape)double_).getHeight();
    }

    private double paintFooter(Graphics2D graphics2D, double d, double d2, double d3, double d4, int n, boolean bl) {
        String string = jEdit.getProperty("print.footerText", new Object[]{new Date(), n});
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        this.lm = this.font.getLineMetrics(string, fontRenderContext);
        Rectangle2D rectangle2D = this.font.getStringBounds(string, fontRenderContext);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2 + d4 - rectangle2D.getHeight(), d3, rectangle2D.getHeight());
        if (bl) {
            graphics2D.setColor(footerColor);
            graphics2D.fill(double_);
            graphics2D.setColor(footerTextColor);
            graphics2D.drawString(string, (float)(d + (d3 - rectangle2D.getWidth()) / 2.0), (float)(d2 + d4 - rectangle2D.getHeight() + (double)this.lm.getAscent()));
        }
        return ((RectangularShape)double_).getHeight();
    }

    static class PrintTabExpander
    implements TabExpander {
        private double tabWidth;

        PrintTabExpander(double d) {
            this.tabWidth = d;
        }

        @Override
        public float nextTabStop(float f, int n) {
            int n2 = (int)((double)(f + 1.0f) / this.tabWidth);
            return (float)((double)(n2 + 1) * this.tabWidth);
        }
    }
}

