/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AdaptableAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.WMTSTileSource;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.AlignImageryPanel;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.preferences.imagery.WMSLayerTree;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.imagery.WMSImagery;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class AddImageryLayerAction
extends JosmAction
implements AdaptableAction {
    private final transient ImageryInfo info;

    public AddImageryLayerAction(ImageryInfo info) {
        super(info.getMenuName(), "imagery_menu", I18n.tr("Add imagery layer {0}", info.getName()), null, true, "imagery_" + info.getToolbarName(), false);
        this.putValue("help", HelpUtil.ht("/Preferences/Imagery"));
        this.setTooltip(info.getToolTipText().replaceAll("</?html>", ""));
        this.info = info;
        this.installAdapters();
        String icon = info.getIcon();
        if (icon != null) {
            new ImageProvider(icon).setOptional(true).getResourceAsync(result -> {
                if (result != null) {
                    GuiHelper.runInEDT(() -> result.attachImageIcon(this));
                }
            });
        }
    }

    private ImageryInfo convertImagery(ImageryInfo info) {
        try {
            switch (info.getImageryType()) {
                case WMS_ENDPOINT: {
                    return AddImageryLayerAction.getWMSLayerInfo(info);
                }
                case WMTS: {
                    DefaultLayer layerId = new WMTSTileSource(info).userSelectLayer();
                    if (layerId != null) {
                        ImageryInfo copy = new ImageryInfo(info);
                        ArrayList<DefaultLayer> defaultLayers = new ArrayList<DefaultLayer>(1);
                        defaultLayers.add(layerId);
                        copy.setDefaultLayers(defaultLayers);
                        return copy;
                    }
                    return null;
                }
            }
            return info;
        }
        catch (MalformedURLException ex) {
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Invalid service URL.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            }
            Logging.log(Logging.LEVEL_ERROR, ex);
        }
        catch (IOException ex) {
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not retrieve WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            }
            Logging.log(Logging.LEVEL_ERROR, ex);
        }
        catch (WMSImagery.WMSGetCapabilitiesException ex) {
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not parse WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            }
            Logging.log(Logging.LEVEL_ERROR, "Could not parse WMS layer list. Incoming data:\n" + ex.getIncomingData(), ex);
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            ImageryInfo infoToAdd = this.convertImagery(this.info);
            if (infoToAdd != null) {
                this.getLayerManager().addLayer(ImageryLayer.create(infoToAdd));
                AlignImageryPanel.addNagPanelIfNeeded(infoToAdd);
            }
        }
        catch (IllegalArgumentException ex) {
            if (ex.getMessage() == null || ex.getMessage().isEmpty() || GraphicsEnvironment.isHeadless()) {
                throw ex;
            }
            JOptionPane.showMessageDialog(Main.parent, ex.getMessage(), I18n.tr("Error", new Object[0]), 0);
        }
    }

    protected static ImageryInfo getWMSLayerInfo(ImageryInfo info) throws IOException, WMSImagery.WMSGetCapabilitiesException {
        CheckParameterUtil.ensureThat(ImageryInfo.ImageryType.WMS_ENDPOINT.equals((Object)info.getImageryType()), "wms_endpoint imagery type expected");
        WMSImagery wms = new WMSImagery();
        wms.attemptGetCapabilities(info.getUrl());
        WMSLayerTree tree = new WMSLayerTree();
        tree.updateTree(wms);
        List<String> wmsFormats = wms.getFormats();
        JComboBox<String> formats = new JComboBox<String>(wmsFormats.toArray(new String[0]));
        formats.setSelectedItem(wms.getPreferredFormats());
        formats.setToolTipText(I18n.tr("Select image format for WMS layer", new Object[0]));
        if (!GraphicsEnvironment.isHeadless() && 1 != new SelectWmsLayersDialog(tree, formats).showDialog().getValue()) {
            return null;
        }
        String url = wms.buildGetMapUrl(tree.getSelectedLayers(), (String)formats.getSelectedItem());
        HashSet<String> supportedCrs = new HashSet<String>();
        boolean first = true;
        StringBuilder layersString = new StringBuilder();
        for (WMSImagery.LayerDetails layer : tree.getSelectedLayers()) {
            if (first) {
                supportedCrs.addAll(layer.getProjections());
                first = false;
            }
            layersString.append(layer.name);
            layersString.append(", ");
            supportedCrs.retainAll(layer.getProjections());
        }
        ImageryInfo ret = new ImageryInfo(info);
        ret.setUrl(url);
        ret.setImageryType(ImageryInfo.ImageryType.WMS);
        if (layersString.length() > 2) {
            ret.setName(ret.getName() + ' ' + layersString.substring(0, layersString.length() - 2));
        }
        ret.setServerProjections(supportedCrs);
        return ret;
    }

    @Override
    protected void updateEnabledState() {
        if (this.info.isBlacklisted()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public String toString() {
        return "AddImageryLayerAction [info=" + this.info + ']';
    }

    static class SelectWmsLayersDialog
    extends ExtendedDialog {
        SelectWmsLayersDialog(WMSLayerTree tree, JComboBox<String> formats) {
            super(Main.parent, I18n.tr("Select WMS layers", new Object[0]), I18n.tr("Add layers", new Object[0]), I18n.tr("Cancel", new Object[0]));
            JScrollPane scrollPane = new JScrollPane(tree.getLayerTree());
            scrollPane.setPreferredSize(new Dimension(400, 400));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)scrollPane, GBC.eol().fill());
            panel.add(formats, GBC.eol().fill(2));
            this.setContent(panel);
        }
    }
}

