/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command.conflict;

import java.util.Objects;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public abstract class ConflictResolveCommand
extends Command {
    private final ConflictCollection resolvedConflicts = new ConflictCollection();

    public ConflictResolveCommand(DataSet ds) {
        super(ds);
    }

    protected void rememberConflict(Conflict<?> c) {
        if (!this.resolvedConflicts.hasConflictForMy((OsmPrimitive)c.getMy())) {
            this.resolvedConflicts.add(c);
        }
    }

    protected void reconstituteConflicts() {
        DataSet ds = this.getAffectedDataSet();
        for (Conflict<?> c : this.resolvedConflicts) {
            if (ds.getConflicts().hasConflictForMy((OsmPrimitive)c.getMy())) continue;
            ds.getConflicts().add(c);
        }
    }

    @Override
    public void undoCommand() {
        super.undoCommand();
        DataSet ds = this.getAffectedDataSet();
        if (Main.main != null) {
            if (!Main.main.containsDataSet(ds)) {
                Logging.warn(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), ds.getName()));
                return;
            }
            Main.main.setEditDataSet(ds);
        }
        this.reconstituteConflicts();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resolvedConflicts);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ConflictResolveCommand that = (ConflictResolveCommand)obj;
        return Objects.equals(this.resolvedConflicts, that.resolvedConflicts);
    }
}

