/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.data.preferences.LongProperty;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class TMSCachedTileLoaderJob
extends JCSCachedTileLoaderJob<String, BufferedImageCacheEntry>
implements TileJob,
ICachedLoaderListener {
    private static final LongProperty MAXIMUM_EXPIRES = new LongProperty("imagery.generic.maximum_expires", TimeUnit.DAYS.toMillis(30L));
    private static final LongProperty MINIMUM_EXPIRES = new LongProperty("imagery.generic.minimum_expires", TimeUnit.HOURS.toMillis(1L));
    protected final Tile tile;
    private volatile URL url;
    private static final ConcurrentMap<String, Set<TileLoaderListener>> inProgress = new ConcurrentHashMap<String, Set<TileLoaderListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMSCachedTileLoaderJob(TileLoaderListener listener, Tile tile, ICacheAccess<String, BufferedImageCacheEntry> cache, int connectTimeout, int readTimeout, Map<String, String> headers, ThreadPoolExecutor downloadExecutor) {
        super(cache, connectTimeout, readTimeout, headers, downloadExecutor);
        this.tile = tile;
        if (listener != null) {
            String deduplicationKey = this.getCacheKey();
            ConcurrentMap<String, Set<TileLoaderListener>> concurrentMap = inProgress;
            synchronized (concurrentMap) {
                inProgress.computeIfAbsent(deduplicationKey, k -> new HashSet()).add(listener);
            }
        }
    }

    @Override
    public String getCacheKey() {
        if (this.tile != null) {
            TileSource tileSource = this.tile.getTileSource();
            return Optional.ofNullable(tileSource.getName()).orElse("").replace(':', '_') + ':' + tileSource.getTileId(this.tile.getZoom(), this.tile.getXtile(), this.tile.getYtile());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getUrl() throws IOException {
        if (this.url == null) {
            TMSCachedTileLoaderJob tMSCachedTileLoaderJob = this;
            synchronized (tMSCachedTileLoaderJob) {
                String sUrl;
                if (this.url == null && !"".equals(sUrl = this.tile.getUrl())) {
                    this.url = new URL(sUrl);
                }
            }
        }
        return this.url;
    }

    @Override
    public boolean isObjectLoadable() {
        if (this.cacheData != null) {
            byte[] content = ((BufferedImageCacheEntry)this.cacheData).getContent();
            try {
                return content.length > 0 || ((BufferedImageCacheEntry)this.cacheData).getImage() != null || this.isNoTileAtZoom();
            }
            catch (IOException e) {
                Logging.logWithStackTrace(Logging.LEVEL_WARN, e, "JCS TMS - error loading from cache for tile {0}: {1}", this.tile.getKey(), e.getMessage());
            }
        }
        return false;
    }

    @Override
    protected boolean isResponseLoadable(Map<String, List<String>> headers, int statusCode, byte[] content) {
        this.attributes.setMetadata(this.tile.getTileSource().getMetadata(headers));
        if (this.tile.getTileSource().isNoTileAtZoom(headers, statusCode, content)) {
            this.attributes.setNoTileAtZoom(true);
            return false;
        }
        return super.isResponseLoadable(headers, statusCode, content);
    }

    @Override
    protected boolean cacheAsEmpty() {
        return this.isNoTileAtZoom() || super.cacheAsEmpty();
    }

    @Override
    public void submit(boolean force) {
        this.tile.initLoading();
        try {
            super.submit(this, force);
        }
        catch (IOException | IllegalArgumentException e) {
            Logging.log(Logging.LEVEL_WARN, e);
            this.tile.finishLoading();
            this.tile.setError(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadingFinished(CacheEntry object, CacheEntryAttributes attributes, ICachedLoaderListener.LoadResult result) {
        block17: {
            Set listeners;
            this.attributes = attributes;
            ConcurrentMap<String, Set<TileLoaderListener>> concurrentMap = inProgress;
            synchronized (concurrentMap) {
                listeners = (Set)inProgress.remove(this.getCacheKey());
            }
            boolean status = result.equals((Object)ICachedLoaderListener.LoadResult.SUCCESS);
            try {
                this.tile.finishLoading();
                if (this.attributes != null) {
                    for (Map.Entry<String, String> e : this.attributes.getMetadata().entrySet()) {
                        this.tile.putValue(e.getKey(), e.getValue());
                    }
                }
                switch (result) {
                    case SUCCESS: {
                        int httpStatusCode;
                        this.handleNoTileAtZoom();
                        if (attributes != null && (httpStatusCode = attributes.getResponseCode()) >= 400 && !this.isNoTileAtZoom()) {
                            if (attributes.getErrorMessage() == null) {
                                this.tile.setError(I18n.tr("HTTP error {0} when loading tiles", httpStatusCode));
                            } else {
                                this.tile.setError(I18n.tr("Error downloading tiles: {0}", attributes.getErrorMessage()));
                            }
                            status = false;
                        }
                        status &= this.tryLoadTileImage(object);
                        break;
                    }
                    case FAILURE: {
                        this.tile.setError("Problem loading tile");
                        this.tryLoadTileImage(object);
                        break;
                    }
                    case CANCELED: {
                        this.tile.loadingCanceled();
                    }
                }
                if (listeners == null) break block17;
                for (TileLoaderListener l : listeners) {
                    l.tileLoadingFinished(this.tile, status);
                }
            }
            catch (IOException e) {
                Logging.warn("JCS TMS - error loading object for tile {0}: {1}", this.tile.getKey(), e.getMessage());
                this.tile.setError(e);
                this.tile.setLoaded(false);
                if (listeners == null) break block17;
                for (TileLoaderListener l : listeners) {
                    l.tileLoadingFinished(this.tile, false);
                }
            }
        }
    }

    @Override
    protected String getServerKey() {
        TileSource ts = this.tile.getSource();
        if (ts instanceof AbstractTMSTileSource) {
            return ((AbstractTMSTileSource)ts).getBaseUrl();
        }
        return super.getServerKey();
    }

    @Override
    protected BufferedImageCacheEntry createCacheEntry(byte[] content) {
        return new BufferedImageCacheEntry(content);
    }

    @Override
    public void submit() {
        this.submit(false);
    }

    @Override
    protected CacheEntryAttributes parseHeaders(HttpClient.Response urlConn) {
        CacheEntryAttributes ret = super.parseHeaders(urlConn);
        if (ret.getExpirationTime() < this.now + MINIMUM_EXPIRES.get()) {
            ret.setExpirationTime(this.now + MINIMUM_EXPIRES.get());
        }
        if (ret.getExpirationTime() > this.now + MAXIMUM_EXPIRES.get()) {
            ret.setExpirationTime(this.now + MAXIMUM_EXPIRES.get());
        }
        return ret;
    }

    private boolean handleNoTileAtZoom() {
        if (this.isNoTileAtZoom()) {
            Logging.debug("JCS TMS - Tile valid, but no file, as no tiles at this level {0}", this.tile);
            this.tile.setError("No tile at this zoom level");
            this.tile.putValue("tile-info", "no-tile");
            return true;
        }
        return false;
    }

    private boolean isNoTileAtZoom() {
        if (this.attributes == null) {
            Logging.warn("Cache attributes are null");
        }
        return this.attributes != null && this.attributes.isNoTileAtZoom();
    }

    private boolean tryLoadTileImage(CacheEntry object) throws IOException {
        byte[] content;
        if (object != null && (content = object.getContent()).length > 0) {
            try {
                this.tile.loadImage(new ByteArrayInputStream(content));
            }
            catch (UnsatisfiedLinkError e) {
                throw new IOException(e);
            }
            if (this.tile.getImage() == null) {
                this.tile.setError(I18n.tr("Could not load image from tile server", new Object[0]));
                return false;
            }
        }
        return true;
    }
}

