/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;

public class ReferringRelationsBrowserModel
extends AbstractListModel<Relation> {
    private transient Relation relation;
    private final transient List<Relation> referrers = new ArrayList<Relation>();

    public ReferringRelationsBrowserModel(Relation relation) {
        this.relation = relation;
    }

    protected void fireModelUpdate() {
        int upper = Math.max(0, this.referrers.size() - 1);
        this.fireContentsChanged(this, 0, upper);
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
        this.referrers.clear();
        this.fireModelUpdate();
    }

    @Override
    public Relation getElementAt(int index) {
        return this.referrers.get(index);
    }

    @Override
    public int getSize() {
        return this.referrers.size();
    }

    protected boolean isReferringRelation(Relation parent) {
        if (parent == null) {
            return false;
        }
        for (RelationMember m : parent.getMembers()) {
            Relation child;
            if (!m.isRelation() || !(child = m.getRelation()).equals(this.relation)) continue;
            return true;
        }
        return false;
    }

    public void populate(List<Relation> parents) {
        this.referrers.clear();
        if (parents != null) {
            for (Relation relation : parents) {
                if (!this.isReferringRelation(relation)) continue;
                this.referrers.add(relation);
            }
        }
        this.fireModelUpdate();
    }

    public void populate(DataSet ds) {
        this.referrers.clear();
        if (ds == null) {
            this.fireModelUpdate();
            return;
        }
        for (Relation parent : ds.getRelations()) {
            if (!this.isReferringRelation(parent)) continue;
            this.referrers.add(parent);
        }
        this.fireModelUpdate();
    }

    public boolean canReload() {
        return this.relation != null && !this.relation.isNew();
    }

    public Relation getRelation() {
        return this.relation;
    }
}

