/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.AnalysisCanceledSoftException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowImpl;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowStack;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.EmptyInstruction;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.controlFlow.ControlFlowAnalyzer");
    private final PsiElement myCodeFragment;
    private final ControlFlowPolicy myPolicy;
    private ControlFlowImpl myCurrentFlow;
    private final ControlFlowStack myStack;
    private final Stack<PsiParameter> myCatchParameters;
    private final Stack<PsiElement> myCatchBlocks;
    private final Stack<FinallyBlockSubroutine> myFinallyBlocks;
    private final Stack<PsiElement> myUnhandledExceptionCatchBlocks;
    private final StatementStack myStartStatementStack;
    private final StatementStack myEndStatementStack;
    private final Stack<BranchingInstruction.Role> myStartJumpRoles;
    private final Stack<BranchingInstruction.Role> myEndJumpRoles;
    private final boolean myEnabledShortCircuit;
    private final boolean myEvaluateConstantIfCondition;
    private final boolean myAssignmentTargetsAreElements;
    private final Stack<TIntArrayList> intArrayPool;
    private final Map<PsiElement, TIntArrayList> offsetsAddElementStart;
    private final Map<PsiElement, TIntArrayList> offsetsAddElementEnd;
    private final ControlFlowFactory myControlFlowFactory;
    private final Map<PsiElement, ControlFlowSubRange> mySubRanges;
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final Map<PsiElement, List<PsiElement>> finallyBlockToUnhandledExceptions;

    ControlFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull ControlFlowPolicy policy, boolean enabledShortCircuit, boolean evaluateConstantIfCondition) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "<init>"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "<init>"));
        }
        this(codeFragment, policy, enabledShortCircuit, evaluateConstantIfCondition, false);
    }

    private ControlFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull ControlFlowPolicy policy, boolean enabledShortCircuit, boolean evaluateConstantIfCondition, boolean assignmentTargetsAreElements) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "<init>"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "<init>"));
        }
        this.myStack = new ControlFlowStack();
        this.myCatchParameters = new Stack();
        this.myCatchBlocks = new Stack();
        this.myFinallyBlocks = new Stack();
        this.myUnhandledExceptionCatchBlocks = new Stack();
        this.myStartStatementStack = new StatementStack();
        this.myEndStatementStack = new StatementStack();
        this.myStartJumpRoles = new Stack();
        this.myEndJumpRoles = new Stack();
        this.intArrayPool = new Stack();
        this.offsetsAddElementStart = new THashMap<PsiElement, TIntArrayList>();
        this.offsetsAddElementEnd = new THashMap<PsiElement, TIntArrayList>();
        this.mySubRanges = new THashMap<PsiElement, ControlFlowSubRange>();
        this.finallyBlockToUnhandledExceptions = new HashMap<PsiElement, List<PsiElement>>();
        this.myCodeFragment = codeFragment;
        this.myPolicy = policy;
        this.myEnabledShortCircuit = enabledShortCircuit;
        this.myEvaluateConstantIfCondition = evaluateConstantIfCondition;
        this.myAssignmentTargetsAreElements = assignmentTargetsAreElements;
        Project project = codeFragment.getProject();
        this.myControlFlowFactory = ControlFlowFactory.getInstance(project);
        this.myConstantEvaluationHelper = JavaPsiFacade.getInstance(project).getConstantEvaluationHelper();
    }

    @NotNull
    ControlFlow buildControlFlow() throws AnalysisCanceledException {
        this.myStartJumpRoles.push(BranchingInstruction.Role.END);
        this.myEndJumpRoles.push(BranchingInstruction.Role.END);
        this.myCurrentFlow = new ControlFlowImpl();
        this.myStartStatementStack.pushStatement(this.myCodeFragment, false);
        this.myEndStatementStack.pushStatement(this.myCodeFragment, false);
        try {
            this.myCodeFragment.accept(this);
            this.cleanup();
        }
        catch (AnalysisCanceledSoftException e) {
            throw new AnalysisCanceledException(e.getErrorElement());
        }
        ControlFlowImpl controlFlowImpl = this.myCurrentFlow;
        if (controlFlowImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "buildControlFlow"));
        }
        return controlFlowImpl;
    }

    @NotNull
    private TIntArrayList getEmptyIntArray() {
        if (this.intArrayPool.isEmpty()) {
            TIntArrayList tIntArrayList = new TIntArrayList(1);
            if (tIntArrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "getEmptyIntArray"));
            }
            return tIntArrayList;
        }
        TIntArrayList list2 = this.intArrayPool.pop();
        list2.clear();
        TIntArrayList tIntArrayList = list2;
        if (tIntArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "getEmptyIntArray"));
        }
        return tIntArrayList;
    }

    private void poolIntArray(@NotNull TIntArrayList list2) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "poolIntArray"));
        }
        this.intArrayPool.add(list2);
    }

    private void addElementOffsetLater(@NotNull PsiElement element, boolean atStart) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "addElementOffsetLater"));
        }
        Map<PsiElement, TIntArrayList> offsetsAddElement = atStart ? this.offsetsAddElementStart : this.offsetsAddElementEnd;
        TIntArrayList offsets = offsetsAddElement.get(element);
        if (offsets == null) {
            offsets = this.getEmptyIntArray();
            offsetsAddElement.put(element, offsets);
        }
        int offset2 = this.myCurrentFlow.getSize() - 1;
        offsets.add(offset2);
        if (this.myCurrentFlow.getEndOffset(element) != -1) {
            this.patchInstructionOffsets(element);
        }
    }

    private void patchInstructionOffsets(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchInstructionOffsets"));
        }
        this.patchInstructionOffsets(this.offsetsAddElementStart.get(element), this.myCurrentFlow.getStartOffset(element));
        this.offsetsAddElementStart.put(element, null);
        this.patchInstructionOffsets(this.offsetsAddElementEnd.get(element), this.myCurrentFlow.getEndOffset(element));
        this.offsetsAddElementEnd.put(element, null);
    }

    private void patchInstructionOffsets(@Nullable TIntArrayList offsets, int add) {
        if (offsets == null) {
            return;
        }
        for (int i = 0; i < offsets.size(); ++i) {
            int offset2 = offsets.get(i);
            BranchingInstruction instruction = (BranchingInstruction)this.myCurrentFlow.getInstructions().get(offset2);
            instruction.offset += add;
            LOG.assertTrue(instruction.offset >= 0);
        }
        this.poolIntArray(offsets);
    }

    private void cleanup() {
        for (TIntArrayList tIntArrayList : this.offsetsAddElementStart.values()) {
            this.patchInstructionOffsets(tIntArrayList, this.myCurrentFlow.getEndOffset(this.myCodeFragment));
        }
        for (TIntArrayList tIntArrayList : this.offsetsAddElementEnd.values()) {
            this.patchInstructionOffsets(tIntArrayList, this.myCurrentFlow.getEndOffset(this.myCodeFragment));
        }
        for (Map.Entry entry : this.mySubRanges.entrySet()) {
            ProgressManager.checkCanceled();
            ControlFlowSubRange subRange = (ControlFlowSubRange)entry.getValue();
            PsiElement element = (PsiElement)entry.getKey();
            this.myControlFlowFactory.registerSubRange(element, subRange, this.myEvaluateConstantIfCondition, this.myEnabledShortCircuit, this.myPolicy);
        }
    }

    private void startElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "startElement"));
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            ProgressManager.checkCanceled();
            if (!(child instanceof PsiErrorElement) || Comparing.strEqual(((PsiErrorElement)child).getErrorDescription(), JavaErrorMessages.message("expected.semicolon", new Object[0]))) continue;
            throw new AnalysisCanceledSoftException(element);
        }
        ProgressManager.checkCanceled();
        this.myCurrentFlow.startElement(element);
        this.generateUncheckedExceptionJumpsIfNeeded(element, true);
    }

    private void generateUncheckedExceptionJumpsIfNeeded(@NotNull PsiElement element, boolean atStart) {
        boolean isGeneratingCodeBlock;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateUncheckedExceptionJumpsIfNeeded"));
        }
        boolean isGeneratingStatement = element instanceof PsiStatement && !(element instanceof PsiSwitchLabelStatement);
        boolean bl = isGeneratingCodeBlock = element instanceof PsiCodeBlock && !(element.getParent() instanceof PsiSwitchStatement);
        if (isGeneratingStatement || isGeneratingCodeBlock) {
            this.generateUncheckedExceptionJumps(element, atStart);
        }
    }

    private void finishElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "finishElement"));
        }
        this.generateUncheckedExceptionJumpsIfNeeded(element, false);
        this.myCurrentFlow.finishElement(element);
        this.patchInstructionOffsets(element);
    }

    private void generateUncheckedExceptionJumps(@NotNull PsiElement element, boolean atStart) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateUncheckedExceptionJumps"));
        }
        if (atStart && element instanceof PsiStatement && element.getParent() instanceof PsiCodeBlock && element.getPrevSibling() != null) {
            return;
        }
        for (int i = this.myUnhandledExceptionCatchBlocks.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiElement block = (PsiElement)this.myUnhandledExceptionCatchBlocks.get(i);
            if (block == null) {
                if (this.myFinallyBlocks.isEmpty()) continue;
                break;
            }
            ConditionalThrowToInstruction throwToInstruction = new ConditionalThrowToInstruction(-1);
            this.myCurrentFlow.addInstruction(throwToInstruction);
            if (this.patchUncheckedThrowInstructionIfInsideFinally(throwToInstruction, element, block)) continue;
            this.addElementOffsetLater(block, true);
        }
        if (!this.myFinallyBlocks.isEmpty()) {
            PsiElement finallyBlock = this.myFinallyBlocks.peek().getElement();
            ConditionalThrowToInstruction throwToInstruction = new ConditionalThrowToInstruction(-2);
            this.myCurrentFlow.addInstruction(throwToInstruction);
            if (!this.patchUncheckedThrowInstructionIfInsideFinally(throwToInstruction, element, finallyBlock)) {
                this.addElementOffsetLater(finallyBlock, true);
            }
        }
    }

    private void generateCheckedExceptionJumps(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateCheckedExceptionJumps"));
        }
        Collection<PsiClassType> unhandledExceptions = ExceptionUtil.collectUnhandledExceptions(element, element.getParent());
        for (PsiClassType unhandledException : unhandledExceptions) {
            ProgressManager.checkCanceled();
            this.generateThrow(unhandledException, element);
        }
    }

    private void generateThrow(@NotNull PsiClassType unhandledException, @NotNull PsiElement throwingElement) {
        if (unhandledException == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unhandledException", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateThrow"));
        }
        if (throwingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwingElement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateThrow"));
        }
        List<PsiElement> catchBlocks = this.findThrowToBlocks(unhandledException);
        for (PsiElement block : catchBlocks) {
            ProgressManager.checkCanceled();
            ConditionalThrowToInstruction instruction = new ConditionalThrowToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.patchCheckedThrowInstructionIfInsideFinally(instruction, throwingElement, block)) continue;
            if (block == null) {
                this.addElementOffsetLater(this.myCodeFragment, false);
                continue;
            }
            --instruction.offset;
            this.addElementOffsetLater(block, true);
        }
    }

    private boolean patchCheckedThrowInstructionIfInsideFinally(@NotNull ConditionalThrowToInstruction instruction, @NotNull PsiElement throwingElement, PsiElement elementToJumpTo) {
        int index2;
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchCheckedThrowInstructionIfInsideFinally"));
        }
        if (throwingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwingElement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchCheckedThrowInstructionIfInsideFinally"));
        }
        PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(throwingElement, elementToJumpTo);
        if (finallyBlock == null) {
            return false;
        }
        List<PsiElement> unhandledExceptionCatchBlocks = this.finallyBlockToUnhandledExceptions.get(finallyBlock);
        if (unhandledExceptionCatchBlocks == null) {
            unhandledExceptionCatchBlocks = new ArrayList<PsiElement>();
            this.finallyBlockToUnhandledExceptions.put(finallyBlock, unhandledExceptionCatchBlocks);
        }
        if ((index2 = unhandledExceptionCatchBlocks.indexOf(elementToJumpTo)) == -1) {
            index2 = unhandledExceptionCatchBlocks.size();
            unhandledExceptionCatchBlocks.add(elementToJumpTo);
        }
        instruction.offset = 3 + index2;
        this.addElementOffsetLater(finallyBlock, false);
        return true;
    }

    private boolean patchUncheckedThrowInstructionIfInsideFinally(@NotNull ConditionalThrowToInstruction instruction, @NotNull PsiElement throwingElement, @NotNull PsiElement elementToJumpTo) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchUncheckedThrowInstructionIfInsideFinally"));
        }
        if (throwingElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwingElement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchUncheckedThrowInstructionIfInsideFinally"));
        }
        if (elementToJumpTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToJumpTo", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "patchUncheckedThrowInstructionIfInsideFinally"));
        }
        PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(throwingElement, elementToJumpTo);
        if (finallyBlock == null) {
            return false;
        }
        instruction.offset = 2;
        this.addElementOffsetLater(finallyBlock, false);
        return true;
    }

    @Override
    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        PsiElement[] children2;
        this.startElement(codeFragment);
        int prevOffset = this.myCurrentFlow.getSize();
        for (PsiElement child : children2 = codeFragment.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept(this);
        }
        this.finishElement(codeFragment);
        this.registerSubRange(codeFragment, prevOffset);
    }

    private void registerSubRange(@NotNull PsiElement codeFragment, int startOffset) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "registerSubRange"));
        }
        ControlFlowSubRange flow = new ControlFlowSubRange(this.myCurrentFlow, startOffset, this.myCurrentFlow.getSize());
        this.mySubRanges.put(codeFragment, flow);
    }

    @Override
    public void visitCodeBlock(PsiCodeBlock block) {
        PsiStatement[] statements;
        this.startElement(block);
        int prevOffset = this.myCurrentFlow.getSize();
        for (PsiStatement statement2 : statements = block.getStatements()) {
            ProgressManager.checkCanceled();
            statement2.accept(this);
        }
        int nextOffset = this.myCurrentFlow.getSize();
        if (!(block.getParent() instanceof PsiSwitchStatement) && prevOffset == nextOffset) {
            this.emitEmptyInstruction();
        }
        this.finishElement(block);
        if (prevOffset != 0) {
            this.registerSubRange(block, prevOffset);
        }
    }

    private void emitEmptyInstruction() {
        this.myCurrentFlow.addInstruction(EmptyInstruction.INSTANCE);
    }

    @Override
    public void visitFile(PsiFile file2) {
        this.visitChildren(file2);
    }

    @Override
    public void visitBlockStatement(PsiBlockStatement statement2) {
        this.startElement(statement2);
        PsiCodeBlock codeBlock = statement2.getCodeBlock();
        codeBlock.accept(this);
        this.finishElement(statement2);
    }

    @Override
    public void visitBreakStatement(PsiBreakStatement statement2) {
        this.startElement(statement2);
        PsiStatement exitedStatement = statement2.findExitedStatement();
        if (exitedStatement != null) {
            GoToInstruction instruction;
            int finallyStartOffset;
            this.callFinallyBlocksOnExit(exitedStatement);
            PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(statement2, exitedStatement);
            int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
            if (finallyBlock != null && finallyStartOffset != -1) {
                CallInstruction callInstruction = (CallInstruction)this.myCurrentFlow.getInstructions().get(finallyStartOffset - 2);
                instruction = new ReturnInstruction(0, this.myStack, callInstruction);
            } else {
                instruction = new GoToInstruction(0);
            }
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(exitedStatement, false);
        }
        this.finishElement(statement2);
    }

    private void callFinallyBlocksOnExit(PsiStatement exitedStatement) {
        FinallyBlockSubroutine finallyBlockSubroutine;
        PsiElement finallyBlock;
        PsiElement enclosingTryStatement;
        ListIterator it = this.myFinallyBlocks.listIterator(this.myFinallyBlocks.size());
        while (it.hasPrevious() && (enclosingTryStatement = (finallyBlock = (finallyBlockSubroutine = (FinallyBlockSubroutine)it.previous()).getElement()).getParent()) != null && PsiTreeUtil.isAncestor(exitedStatement, enclosingTryStatement, false)) {
            CallInstruction instruction = new CallInstruction(0, 0, this.myStack);
            finallyBlockSubroutine.addCall(instruction);
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(finallyBlock, true);
        }
    }

    private PsiElement findEnclosingFinallyBlockElement(@NotNull PsiElement sourceElement, @Nullable PsiElement jumpElement) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findEnclosingFinallyBlockElement"));
        }
        for (PsiElement element = sourceElement; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!(element instanceof PsiCodeBlock) || !(element.getParent() instanceof PsiTryStatement) || ((PsiTryStatement)element.getParent()).getFinallyBlock() != element) continue;
            if (this.myCurrentFlow.getStartOffset(element.getParent()) == -1) {
                return null;
            }
            if (jumpElement != null && PsiTreeUtil.isAncestor(element, jumpElement, false)) continue;
            return element;
        }
        return null;
    }

    @Override
    public void visitContinueStatement(PsiContinueStatement statement2) {
        this.startElement(statement2);
        PsiStatement continuedStatement = statement2.findContinuedStatement();
        if (continuedStatement != null) {
            GoToInstruction instruction;
            int finallyStartOffset;
            PsiElement body = null;
            if (continuedStatement instanceof PsiLoopStatement) {
                body = ((PsiLoopStatement)continuedStatement).getBody();
            }
            if (body == null) {
                body = this.myCodeFragment;
            }
            this.callFinallyBlocksOnExit(continuedStatement);
            PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(statement2, continuedStatement);
            int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
            if (finallyBlock != null && finallyStartOffset != -1) {
                CallInstruction callInstruction = (CallInstruction)this.myCurrentFlow.getInstructions().get(finallyStartOffset - 2);
                instruction = new ReturnInstruction(0, this.myStack, callInstruction);
            } else {
                instruction = new GoToInstruction(0);
            }
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(body, false);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
        PsiElement[] elements;
        this.startElement(statement2);
        int pc = this.myCurrentFlow.getSize();
        for (PsiElement element : elements = statement2.getDeclaredElements()) {
            ProgressManager.checkCanceled();
            if (element instanceof PsiClass) {
                element.accept(this);
                continue;
            }
            if (!(element instanceof PsiVariable)) continue;
            this.processVariable((PsiVariable)element);
        }
        if (pc == this.myCurrentFlow.getSize()) {
            this.emitEmptyInstruction();
        }
        this.finishElement(statement2);
    }

    private void processVariable(@NotNull PsiVariable element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "processVariable"));
        }
        PsiExpression initializer2 = element.getInitializer();
        if (initializer2 != null) {
            this.myStartStatementStack.pushStatement(initializer2, false);
            this.myEndStatementStack.pushStatement(initializer2, false);
            initializer2.accept(this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        if (element instanceof PsiLocalVariable && initializer2 != null || element instanceof PsiField) {
            if (element instanceof PsiLocalVariable && !this.myPolicy.isLocalVariableAccepted((PsiLocalVariable)element)) {
                return;
            }
            if (this.myAssignmentTargetsAreElements) {
                this.startElement(element);
            }
            this.generateWriteInstruction(element);
            if (this.myAssignmentTargetsAreElements) {
                this.finishElement(element);
            }
        }
    }

    @Override
    public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
        PsiExpression condition;
        this.startElement(statement2);
        PsiStatement body = statement2.getBody();
        this.myStartStatementStack.pushStatement(body == null ? statement2 : body, true);
        this.myEndStatementStack.pushStatement(statement2, false);
        if (body != null) {
            body.accept(this);
        }
        if ((condition = statement2.getCondition()) != null) {
            condition.accept(this);
        }
        int offset2 = this.myCurrentFlow.getStartOffset(statement2);
        Object loopCondition = this.myConstantEvaluationHelper.computeConstantExpression(statement2.getCondition());
        if (loopCondition instanceof Boolean) {
            if (((Boolean)loopCondition).booleanValue()) {
                this.myCurrentFlow.addInstruction(new GoToInstruction(offset2));
            } else {
                this.emitEmptyInstruction();
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(offset2, statement2.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement2);
    }

    @Override
    public void visitEmptyStatement(PsiEmptyStatement statement2) {
        this.startElement(statement2);
        this.emitEmptyInstruction();
        this.finishElement(statement2);
    }

    @Override
    public void visitExpressionStatement(PsiExpressionStatement statement2) {
        this.startElement(statement2);
        PsiExpression expression2 = statement2.getExpression();
        expression2.accept(this);
        for (PsiParameter catchParameter : this.myCatchParameters) {
            ProgressManager.checkCanceled();
            PsiType type2 = catchParameter.getType();
            if (!(type2 instanceof PsiClassType)) continue;
            this.generateThrow((PsiClassType)type2, statement2);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitExpressionListStatement(PsiExpressionListStatement statement2) {
        PsiExpression[] expressions;
        this.startElement(statement2);
        for (PsiExpression expr : expressions = statement2.getExpressionList().getExpressions()) {
            ProgressManager.checkCanceled();
            expr.accept(this);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitField(PsiField field) {
        PsiExpression initializer2 = field.getInitializer();
        if (initializer2 != null) {
            this.startElement(field);
            initializer2.accept(this);
            this.finishElement(field);
        }
    }

    @Override
    public void visitForStatement(PsiForStatement statement2) {
        PsiStatement update;
        Object loopCondition;
        PsiExpression condition;
        this.startElement(statement2);
        PsiStatement body = statement2.getBody();
        this.myStartStatementStack.pushStatement(body == null ? statement2 : body, false);
        this.myEndStatementStack.pushStatement(statement2, false);
        PsiStatement initialization = statement2.getInitialization();
        if (initialization != null) {
            initialization.accept(this);
        }
        if ((condition = statement2.getCondition()) != null) {
            condition.accept(this);
        }
        if ((loopCondition = this.myConstantEvaluationHelper.computeConstantExpression(condition)) instanceof Boolean || condition == null) {
            boolean value;
            boolean bl = value = condition == null || (Boolean)loopCondition != false;
            if (value) {
                this.emitEmptyInstruction();
            } else {
                this.myCurrentFlow.addInstruction(new GoToInstruction(0));
                this.addElementOffsetLater(statement2, false);
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(statement2, false);
        }
        if (body != null) {
            body.accept(this);
        }
        if ((update = statement2.getUpdate()) != null) {
            update.accept(this);
        }
        int offset2 = initialization != null ? this.myCurrentFlow.getEndOffset(initialization) : this.myCurrentFlow.getStartOffset(statement2);
        GoToInstruction instruction = new GoToInstruction(offset2);
        this.myCurrentFlow.addInstruction(instruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement2);
    }

    @Override
    public void visitForeachStatement(PsiForeachStatement statement2) {
        this.startElement(statement2);
        PsiStatement body = statement2.getBody();
        this.myStartStatementStack.pushStatement(body == null ? statement2 : body, false);
        this.myEndStatementStack.pushStatement(statement2, false);
        PsiExpression iteratedValue = statement2.getIteratedValue();
        if (iteratedValue != null) {
            iteratedValue.accept(this);
        }
        int gotoTarget = this.myCurrentFlow.getSize();
        ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getIteratedValue());
        this.myCurrentFlow.addInstruction(instruction);
        this.addElementOffsetLater(statement2, false);
        PsiParameter iterationParameter = statement2.getIterationParameter();
        if (this.myPolicy.isParameterAccepted(iterationParameter)) {
            this.generateWriteInstruction(iterationParameter);
        }
        if (body != null) {
            body.accept(this);
        }
        GoToInstruction gotoInstruction = new GoToInstruction(gotoTarget);
        this.myCurrentFlow.addInstruction(gotoInstruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement2);
    }

    @Override
    public void visitIfStatement(PsiIfStatement statement2) {
        this.startElement(statement2);
        PsiStatement elseBranch = statement2.getElseBranch();
        PsiStatement thenBranch = statement2.getThenBranch();
        PsiExpression conditionExpression = statement2.getCondition();
        this.generateConditionalStatementInstructions(statement2, conditionExpression, thenBranch, elseBranch);
        this.finishElement(statement2);
    }

    private void generateConditionalStatementInstructions(@NotNull PsiElement statement2, @Nullable PsiExpression conditionExpression, PsiElement thenBranch, PsiElement elseBranch) {
        Object value;
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateConditionalStatementInstructions"));
        }
        if (thenBranch == null) {
            this.myStartStatementStack.pushStatement(statement2, false);
        } else {
            this.myStartStatementStack.pushStatement(thenBranch, true);
        }
        if (elseBranch == null) {
            this.myEndStatementStack.pushStatement(statement2, false);
        } else {
            this.myEndStatementStack.pushStatement(elseBranch, true);
        }
        this.myEndJumpRoles.push(elseBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.ELSE);
        this.myStartJumpRoles.push(thenBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.THEN);
        if (conditionExpression != null) {
            conditionExpression.accept(this);
        }
        boolean generateElseFlow = true;
        boolean generateThenFlow = true;
        boolean generateConditionalJump = true;
        if (this.myEvaluateConstantIfCondition && (value = this.myConstantEvaluationHelper.computeConstantExpression(conditionExpression)) instanceof Boolean) {
            boolean condition;
            generateThenFlow = condition = ((Boolean)value).booleanValue();
            generateElseFlow = !condition;
            generateConditionalJump = false;
            this.myCurrentFlow.setConstantConditionOccurred(true);
        }
        if (generateConditionalJump) {
            BranchingInstruction.Role role = elseBranch == null ? BranchingInstruction.Role.END : BranchingInstruction.Role.ELSE;
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, role, conditionExpression);
            this.myCurrentFlow.addInstruction(instruction);
            if (elseBranch == null) {
                this.addElementOffsetLater(statement2, false);
            } else {
                this.addElementOffsetLater(elseBranch, true);
            }
        }
        if (thenBranch != null && generateThenFlow) {
            thenBranch.accept(this);
        }
        if (elseBranch != null && generateElseFlow) {
            if (generateThenFlow) {
                GoToInstruction instruction = new GoToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater(statement2, false);
            }
            elseBranch.accept(this);
        }
        this.myStartJumpRoles.pop();
        this.myEndJumpRoles.pop();
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
    }

    @Override
    public void visitLabeledStatement(PsiLabeledStatement statement2) {
        this.startElement(statement2);
        PsiStatement innerStatement = statement2.getStatement();
        if (innerStatement != null) {
            innerStatement.accept(this);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitReturnStatement(PsiReturnStatement statement2) {
        this.startElement(statement2);
        PsiExpression returnValue = statement2.getReturnValue();
        if (returnValue != null) {
            this.myStartStatementStack.pushStatement(returnValue, false);
            this.myEndStatementStack.pushStatement(returnValue, false);
            returnValue.accept(this);
        }
        this.addReturnInstruction(statement2);
        if (returnValue != null) {
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        this.finishElement(statement2);
    }

    private void addReturnInstruction(@NotNull PsiElement statement2) {
        int finallyStartOffset;
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "addReturnInstruction"));
        }
        PsiElement finallyBlock = this.findEnclosingFinallyBlockElement(statement2, null);
        int n = finallyStartOffset = finallyBlock == null ? -1 : this.myCurrentFlow.getStartOffset(finallyBlock);
        if (finallyBlock != null && finallyStartOffset != -1) {
            GoToInstruction instruction = new GoToInstruction(1, BranchingInstruction.Role.END, true);
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(finallyBlock, false);
        } else {
            GoToInstruction instruction = new GoToInstruction(0, BranchingInstruction.Role.END, true);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.myFinallyBlocks.isEmpty()) {
                this.addElementOffsetLater(this.myCodeFragment, false);
            } else {
                instruction.offset = -4;
                this.addElementOffsetLater(this.myFinallyBlocks.peek().getElement(), true);
            }
        }
    }

    @Override
    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement2) {
        this.startElement(statement2);
        PsiExpression caseValue = statement2.getCaseValue();
        if (caseValue != null) {
            this.myStartStatementStack.pushStatement(caseValue, false);
            this.myEndStatementStack.pushStatement(caseValue, false);
            caseValue.accept(this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitSwitchStatement(PsiSwitchStatement statement2) {
        PsiCodeBlock body;
        this.startElement(statement2);
        PsiExpression expr = statement2.getExpression();
        if (expr != null) {
            expr.accept(this);
        }
        if ((body = statement2.getBody()) != null) {
            PsiStatement[] statements = body.getStatements();
            PsiSwitchLabelStatement defaultLabel = null;
            for (PsiStatement aStatement : statements) {
                ProgressManager.checkCanceled();
                if (!(aStatement instanceof PsiSwitchLabelStatement)) continue;
                if (((PsiSwitchLabelStatement)aStatement).isDefaultCase()) {
                    defaultLabel = (PsiSwitchLabelStatement)aStatement;
                }
                ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getExpression());
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater(aStatement, true);
            }
            if (defaultLabel == null) {
                GoToInstruction instruction = new GoToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                this.addElementOffsetLater(body, false);
            }
            body.accept(this);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitSynchronizedStatement(PsiSynchronizedStatement statement2) {
        PsiCodeBlock body;
        this.startElement(statement2);
        PsiExpression lock = statement2.getLockExpression();
        if (lock != null) {
            lock.accept(this);
        }
        if ((body = statement2.getBody()) != null) {
            body.accept(this);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitThrowStatement(PsiThrowStatement statement2) {
        List<PsiElement> blocks;
        this.startElement(statement2);
        PsiExpression exception = statement2.getException();
        if (exception != null) {
            exception.accept(this);
        }
        if ((blocks = this.findThrowToBlocks(statement2)).isEmpty() || blocks.get(0) == null) {
            ThrowToInstruction instruction = new ThrowToInstruction(0);
            this.myCurrentFlow.addInstruction(instruction);
            if (this.myFinallyBlocks.isEmpty()) {
                PsiElement element = this.myCodeFragment;
                this.addElementOffsetLater(element, false);
            } else {
                instruction.offset = -2;
                PsiElement element = this.myFinallyBlocks.peek().getElement();
                this.addElementOffsetLater(element, true);
            }
        } else {
            for (int i = 0; i < blocks.size(); ++i) {
                ProgressManager.checkCanceled();
                PsiElement element = blocks.get(i);
                BranchingInstruction instruction = i == blocks.size() - 1 ? new ThrowToInstruction(0) : new ConditionalThrowToInstruction(0);
                this.myCurrentFlow.addInstruction(instruction);
                instruction.offset = -1;
                this.addElementOffsetLater(element, true);
            }
        }
        this.finishElement(statement2);
    }

    @NotNull
    private List<PsiElement> findThrowToBlocks(@NotNull PsiThrowStatement statement2) {
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findThrowToBlocks"));
        }
        PsiExpression exceptionExpr = statement2.getException();
        if (exceptionExpr == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findThrowToBlocks"));
            }
            return list2;
        }
        PsiType throwType = exceptionExpr.getType();
        if (!(throwType instanceof PsiClassType)) {
            List<PsiElement> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findThrowToBlocks"));
            }
            return list3;
        }
        List<PsiElement> list4 = this.findThrowToBlocks((PsiClassType)throwType);
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findThrowToBlocks"));
        }
        return list4;
    }

    @NotNull
    private List<PsiElement> findThrowToBlocks(@NotNull PsiClassType throwType) {
        if (throwType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwType", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findThrowToBlocks"));
        }
        ArrayList<PsiElement> blocks = new ArrayList<PsiElement>();
        for (int i = this.myCatchParameters.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiParameter parameter = (PsiParameter)this.myCatchParameters.get(i);
            PsiType catchType = parameter.getType();
            if (!ControlFlowUtil.isCaughtExceptionType(throwType, catchType)) continue;
            blocks.add((PsiElement)this.myCatchBlocks.get(i));
        }
        if (blocks.isEmpty()) {
            blocks.add(null);
        }
        ArrayList<PsiElement> arrayList = blocks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "findThrowToBlocks"));
        }
        return arrayList;
    }

    @Override
    public void visitAssertStatement(PsiAssertStatement statement2) {
        PsiExpression description2;
        this.startElement(statement2);
        this.myStartStatementStack.pushStatement(statement2, false);
        this.myEndStatementStack.pushStatement(statement2, false);
        ConditionalGoToInstruction passByWhenAssertionsDisabled = new ConditionalGoToInstruction(0, BranchingInstruction.Role.END, null);
        this.myCurrentFlow.addInstruction(passByWhenAssertionsDisabled);
        this.addElementOffsetLater(statement2, false);
        PsiExpression condition = statement2.getAssertCondition();
        if (condition != null) {
            this.myStartStatementStack.pushStatement(statement2, false);
            this.myEndStatementStack.pushStatement(statement2, false);
            this.myEndJumpRoles.push(BranchingInstruction.Role.END);
            this.myStartJumpRoles.push(BranchingInstruction.Role.END);
            condition.accept(this);
            this.myStartJumpRoles.pop();
            this.myEndJumpRoles.pop();
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
        if ((description2 = statement2.getAssertDescription()) != null) {
            description2.accept(this);
        }
        ConditionalThrowToInstruction instruction = new ConditionalThrowToInstruction(0, statement2.getAssertCondition());
        this.myCurrentFlow.addInstruction(instruction);
        this.addElementOffsetLater(this.myCodeFragment, false);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement2);
    }

    @Override
    public void visitTryStatement(PsiTryStatement statement2) {
        int i;
        PsiCodeBlock tryBlock;
        PsiResourceList resourceList;
        this.startElement(statement2);
        PsiCodeBlock[] catchBlocks = statement2.getCatchBlocks();
        PsiParameter[] catchBlockParameters = statement2.getCatchBlockParameters();
        int catchNum = Math.min(catchBlocks.length, catchBlockParameters.length);
        this.myUnhandledExceptionCatchBlocks.push(null);
        block0: for (int i2 = catchNum - 1; i2 >= 0; --i2) {
            ProgressManager.checkCanceled();
            this.myCatchParameters.push(catchBlockParameters[i2]);
            this.myCatchBlocks.push(catchBlocks[i2]);
            PsiType type2 = catchBlockParameters[i2].getType();
            if (type2 instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)type2)) {
                this.myUnhandledExceptionCatchBlocks.push(catchBlocks[i2]);
                continue;
            }
            if (!(type2 instanceof PsiDisjunctionType)) continue;
            PsiType lub = ((PsiDisjunctionType)type2).getLeastUpperBound();
            if (lub instanceof PsiClassType && ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)lub)) {
                this.myUnhandledExceptionCatchBlocks.push(catchBlocks[i2]);
                continue;
            }
            if (!(lub instanceof PsiIntersectionType)) continue;
            for (PsiType conjunct : ((PsiIntersectionType)lub).getConjuncts()) {
                if (!(conjunct instanceof PsiClassType) || !ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)conjunct)) continue;
                this.myUnhandledExceptionCatchBlocks.push(catchBlocks[i2]);
                continue block0;
            }
        }
        PsiCodeBlock finallyBlock = statement2.getFinallyBlock();
        FinallyBlockSubroutine finallyBlockSubroutine = null;
        if (finallyBlock != null) {
            finallyBlockSubroutine = new FinallyBlockSubroutine(finallyBlock);
            this.myFinallyBlocks.push(finallyBlockSubroutine);
        }
        if ((resourceList = statement2.getResourceList()) != null) {
            this.generateCheckedExceptionJumps(resourceList);
            resourceList.accept(this);
        }
        if ((tryBlock = statement2.getTryBlock()) != null) {
            this.generateCheckedExceptionJumps(tryBlock);
            tryBlock.accept(this);
        }
        while (this.myUnhandledExceptionCatchBlocks.pop() != null) {
        }
        this.myCurrentFlow.addInstruction(new GoToInstruction(finallyBlock == null ? 0 : -6));
        if (finallyBlock == null) {
            this.addElementOffsetLater(statement2, false);
        } else {
            this.addElementOffsetLater(finallyBlock, true);
        }
        for (i = 0; i < catchNum; ++i) {
            this.myCatchParameters.pop();
            this.myCatchBlocks.pop();
        }
        for (i = catchNum - 1; i >= 0; --i) {
            PsiCodeBlock catchBlock;
            ProgressManager.checkCanceled();
            if (this.myPolicy.isParameterAccepted(catchBlockParameters[i])) {
                this.generateWriteInstruction(catchBlockParameters[i]);
            }
            if ((catchBlock = catchBlocks[i]) != null) {
                catchBlock.accept(this);
            } else {
                LOG.error("Catch body is null (" + i + ") " + statement2.getText());
            }
            this.myCurrentFlow.addInstruction(new GoToInstruction(finallyBlock == null ? 0 : -6));
            if (finallyBlock == null) {
                this.addElementOffsetLater(statement2, false);
                continue;
            }
            this.addElementOffsetLater(finallyBlock, true);
        }
        if (finallyBlock != null) {
            this.myFinallyBlocks.pop();
        }
        if (finallyBlock != null) {
            CallInstruction normalCompletion = new CallInstruction(0, 0, this.myStack);
            finallyBlockSubroutine.addCall(normalCompletion);
            this.myCurrentFlow.addInstruction(normalCompletion);
            this.addElementOffsetLater(finallyBlock, true);
            this.myCurrentFlow.addInstruction(new GoToInstruction(0));
            this.addElementOffsetLater(statement2, false);
            CallInstruction returnCompletion = new CallInstruction(0, 0, this.myStack);
            finallyBlockSubroutine.addCall(returnCompletion);
            this.myCurrentFlow.addInstruction(returnCompletion);
            this.addElementOffsetLater(finallyBlock, true);
            this.addReturnInstruction(statement2);
            CallInstruction throwExceptionCompletion = new CallInstruction(0, 0, this.myStack);
            finallyBlockSubroutine.addCall(throwExceptionCompletion);
            this.myCurrentFlow.addInstruction(throwExceptionCompletion);
            this.addElementOffsetLater(finallyBlock, true);
            GoToInstruction gotoUncheckedRethrow = new GoToInstruction(0);
            this.myCurrentFlow.addInstruction(gotoUncheckedRethrow);
            this.addElementOffsetLater(finallyBlock, false);
            finallyBlock.accept(this);
            int procStart = this.myCurrentFlow.getStartOffset(finallyBlock);
            int procEnd = this.myCurrentFlow.getEndOffset(finallyBlock);
            for (CallInstruction callInstruction : finallyBlockSubroutine.getCalls()) {
                callInstruction.procBegin = procStart;
                callInstruction.procEnd = procEnd;
            }
            this.myCurrentFlow.addInstruction(new ReturnInstruction(0, this.myStack, normalCompletion));
            this.myCurrentFlow.addInstruction(new ReturnInstruction(procStart - 3, this.myStack, returnCompletion));
            this.myCurrentFlow.addInstruction(new ReturnInstruction(procStart - 1, this.myStack, throwExceptionCompletion));
            List<PsiElement> unhandledExceptionCatchBlocks = this.finallyBlockToUnhandledExceptions.remove(finallyBlock);
            for (int i3 = 0; unhandledExceptionCatchBlocks != null && i3 < unhandledExceptionCatchBlocks.size(); ++i3) {
                ProgressManager.checkCanceled();
                PsiElement catchBlock = unhandledExceptionCatchBlocks.get(i3);
                ReturnInstruction returnInstruction = new ReturnInstruction(0, this.myStack, throwExceptionCompletion);
                returnInstruction.setRethrowFromFinally();
                this.myCurrentFlow.addInstruction(returnInstruction);
                if (catchBlock == null) {
                    returnInstruction.offset = procStart - 1;
                    continue;
                }
                --returnInstruction.offset;
                this.addElementOffsetLater(catchBlock, true);
            }
            gotoUncheckedRethrow.offset = this.myCurrentFlow.getSize();
            this.generateUncheckedExceptionJumps(statement2, false);
            this.myCurrentFlow.addInstruction(new ThrowToInstruction(0));
            this.addElementOffsetLater(this.myCodeFragment, false);
        }
        this.finishElement(statement2);
    }

    @Override
    public void visitResourceList(PsiResourceList resourceList) {
        this.startElement(resourceList);
        for (PsiResourceListElement resource : resourceList) {
            ProgressManager.checkCanceled();
            if (resource instanceof PsiResourceVariable) {
                this.processVariable((PsiVariable)((Object)resource));
                continue;
            }
            if (!(resource instanceof PsiResourceExpression)) continue;
            ((PsiResourceExpression)resource).getExpression().accept(this);
        }
        this.finishElement(resourceList);
    }

    @Override
    public void visitWhileStatement(PsiWhileStatement statement2) {
        Object loopCondition;
        this.startElement(statement2);
        PsiStatement body = statement2.getBody();
        if (body == null) {
            this.myStartStatementStack.pushStatement(statement2, false);
        } else {
            this.myStartStatementStack.pushStatement(body, true);
        }
        this.myEndStatementStack.pushStatement(statement2, false);
        PsiExpression condition = statement2.getCondition();
        if (condition != null) {
            condition.accept(this);
        }
        if ((loopCondition = this.myConstantEvaluationHelper.computeConstantExpression(statement2.getCondition())) instanceof Boolean) {
            boolean value = (Boolean)loopCondition;
            if (value) {
                this.emitEmptyInstruction();
            } else {
                this.myCurrentFlow.addInstruction(new GoToInstruction(0));
                this.addElementOffsetLater(statement2, false);
            }
        } else {
            ConditionalGoToInstruction instruction = new ConditionalGoToInstruction(0, statement2.getCondition());
            this.myCurrentFlow.addInstruction(instruction);
            this.addElementOffsetLater(statement2, false);
        }
        if (body != null) {
            body.accept(this);
        }
        int offset2 = this.myCurrentFlow.getStartOffset(statement2);
        GoToInstruction instruction = new GoToInstruction(offset2);
        this.myCurrentFlow.addInstruction(instruction);
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(statement2);
    }

    @Override
    public void visitExpressionList(PsiExpressionList list2) {
        PsiExpression[] expressions;
        for (PsiExpression expression2 : expressions = list2.getExpressions()) {
            ProgressManager.checkCanceled();
            this.myStartStatementStack.pushStatement(expression2, false);
            this.myEndStatementStack.pushStatement(expression2, false);
            expression2.accept(this);
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
        }
    }

    @Override
    public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
        this.startElement(expression2);
        expression2.getArrayExpression().accept(this);
        PsiExpression indexExpression = expression2.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept(this);
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        PsiExpression[] initializers;
        this.startElement(expression2);
        for (PsiExpression initializer2 : initializers = expression2.getInitializers()) {
            ProgressManager.checkCanceled();
            initializer2.accept(this);
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
        this.startElement(expression2);
        PsiExpression rExpr = expression2.getRExpression();
        this.myStartStatementStack.pushStatement(rExpr == null ? expression2 : rExpr, false);
        this.myEndStatementStack.pushStatement(rExpr == null ? expression2 : rExpr, false);
        PsiExpression lExpr = PsiUtil.skipParenthesizedExprDown(expression2.getLExpression());
        if (lExpr instanceof PsiReferenceExpression) {
            PsiVariable variable2 = this.getUsedVariable((PsiReferenceExpression)lExpr);
            if (variable2 != null) {
                PsiExpression qualifier;
                if (this.myAssignmentTargetsAreElements) {
                    this.startElement(lExpr);
                }
                if ((qualifier = ((PsiReferenceExpression)lExpr).getQualifierExpression()) != null) {
                    qualifier.accept(this);
                }
                if (expression2.getOperationTokenType() != JavaTokenType.EQ) {
                    this.generateReadInstruction(variable2);
                }
                if (rExpr != null) {
                    rExpr.accept(this);
                }
                this.generateWriteInstruction(variable2);
                if (this.myAssignmentTargetsAreElements) {
                    this.finishElement(lExpr);
                }
            } else {
                if (rExpr != null) {
                    rExpr.accept(this);
                }
                lExpr.accept(this);
            }
        } else if (lExpr instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)lExpr).getArrayExpression() instanceof PsiReferenceExpression) {
            PsiVariable variable3 = this.getUsedVariable((PsiReferenceExpression)((PsiArrayAccessExpression)lExpr).getArrayExpression());
            if (variable3 != null) {
                this.generateReadInstruction(variable3);
                PsiExpression indexExpression = ((PsiArrayAccessExpression)lExpr).getIndexExpression();
                if (indexExpression != null) {
                    indexExpression.accept(this);
                }
            } else {
                lExpr.accept(this);
            }
            if (rExpr != null) {
                rExpr.accept(this);
            }
        } else if (lExpr != null) {
            lExpr.accept(this);
            if (rExpr != null) {
                rExpr.accept(this);
            }
        }
        this.myStartStatementStack.popStatement();
        this.myEndStatementStack.popStatement();
        this.finishElement(expression2);
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        this.startElement(expression2);
        IElementType signTokenType = expression2.getOperationTokenType();
        boolean isAndAnd = signTokenType == JavaTokenType.ANDAND;
        boolean isOrOr = signTokenType == JavaTokenType.OROR;
        PsiExpression[] operands = expression2.getOperands();
        Boolean lValue = isAndAnd;
        PsiExpression lOperand = null;
        Boolean rValue = null;
        for (int i = 0; i < operands.length; ++i) {
            PsiExpression rOperand = operands[i];
            if ((isAndAnd || isOrOr) && this.myEnabledShortCircuit) {
                boolean gotoIsAtStart;
                Object exprValue = this.myConstantEvaluationHelper.computeConstantExpression(rOperand);
                if (exprValue instanceof Boolean) {
                    this.myCurrentFlow.setConstantConditionOccurred(true);
                    rValue = this.shouldCalculateConstantExpression(expression2) ? (Boolean)exprValue : null;
                }
                BranchingInstruction.Role role = isAndAnd ? this.myEndJumpRoles.peek() : this.myStartJumpRoles.peek();
                PsiElement gotoElement = isAndAnd ? this.myEndStatementStack.peekElement() : this.myStartStatementStack.peekElement();
                boolean bl = gotoIsAtStart = isAndAnd ? this.myEndStatementStack.peekAtStart() : this.myStartStatementStack.peekAtStart();
                Shortcut shortcut = lValue != null ? (lValue == isOrOr ? Shortcut.STOP_EXPRESSION : Shortcut.SKIP_CURRENT_OPERAND) : (rValue != null && rValue == isOrOr ? Shortcut.STOP_EXPRESSION : Shortcut.NO_SHORTCUT);
                switch (shortcut) {
                    case NO_SHORTCUT: {
                        assert (lOperand != null);
                        this.myCurrentFlow.addInstruction(new ConditionalGoToInstruction(0, role, lOperand));
                        this.addElementOffsetLater(gotoElement, gotoIsAtStart);
                        break;
                    }
                    case STOP_EXPRESSION: {
                        if (lOperand == null) break;
                        this.myCurrentFlow.addInstruction(new GoToInstruction(0, role));
                        this.addElementOffsetLater(gotoElement, gotoIsAtStart);
                        break;
                    }
                }
                if (shortcut == Shortcut.STOP_EXPRESSION) break;
            }
            this.generateLOperand(rOperand, i == operands.length - 1 ? null : operands[i + 1], signTokenType);
            lOperand = rOperand;
            lValue = rValue;
        }
        this.finishElement(expression2);
    }

    private void generateLOperand(@NotNull PsiExpression lOperand, @Nullable PsiExpression rOperand, @NotNull IElementType signTokenType) {
        if (lOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOperand", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateLOperand"));
        }
        if (signTokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signTokenType", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateLOperand"));
        }
        if (rOperand != null) {
            this.myStartJumpRoles.push(BranchingInstruction.Role.END);
            this.myEndJumpRoles.push(BranchingInstruction.Role.END);
            PsiExpression then = signTokenType == JavaTokenType.OROR ? this.myStartStatementStack.peekElement() : rOperand;
            boolean thenAtStart = signTokenType != JavaTokenType.OROR || this.myStartStatementStack.peekAtStart();
            this.myStartStatementStack.pushStatement(then, thenAtStart);
            PsiExpression elseS = signTokenType == JavaTokenType.ANDAND ? this.myEndStatementStack.peekElement() : rOperand;
            boolean elseAtStart = signTokenType != JavaTokenType.ANDAND || this.myEndStatementStack.peekAtStart();
            this.myEndStatementStack.pushStatement(elseS, elseAtStart);
        }
        lOperand.accept(this);
        if (rOperand != null) {
            this.myStartStatementStack.popStatement();
            this.myEndStatementStack.popStatement();
            this.myStartJumpRoles.pop();
            this.myEndJumpRoles.pop();
        }
    }

    private static boolean isInsideIfCondition(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "isInsideIfCondition"));
        }
        PsiElement element = expression2;
        while (element instanceof PsiExpression) {
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof PsiIfStatement && element == ((PsiIfStatement)parent2).getCondition()) {
                return true;
            }
            element = parent2;
        }
        return false;
    }

    private boolean shouldCalculateConstantExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "shouldCalculateConstantExpression"));
        }
        return this.myEvaluateConstantIfCondition || !ControlFlowAnalyzer.isInsideIfCondition(expression2);
    }

    @Override
    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        this.visitChildren(expression2);
    }

    private void visitChildren(@NotNull PsiElement element) {
        PsiElement[] children2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "visitChildren"));
        }
        this.startElement(element);
        for (PsiElement child : children2 = element.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept(this);
        }
        this.finishElement(element);
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        this.startElement(expression2);
        PsiExpression condition = expression2.getCondition();
        PsiExpression thenExpression = expression2.getThenExpression();
        PsiExpression elseExpression = expression2.getElseExpression();
        this.generateConditionalStatementInstructions(expression2, condition, thenExpression, elseExpression);
        this.finishElement(expression2);
    }

    @Override
    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        this.startElement(expression2);
        PsiExpression operand = expression2.getOperand();
        operand.accept(this);
        this.finishElement(expression2);
    }

    @Override
    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        this.startElement(expression2);
        this.finishElement(expression2);
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        this.startElement(expression2);
        PsiElement body = expression2.getBody();
        if (body != null) {
            ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
            this.addUsedVariables(array, body);
            for (PsiVariable var : array) {
                ProgressManager.checkCanceled();
                this.generateReadInstruction(var);
            }
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        this.startElement(expression2);
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        methodExpression.accept(this);
        PsiExpressionList argumentList2 = expression2.getArgumentList();
        argumentList2.accept(this);
        this.emitEmptyInstruction();
        this.generateCheckedExceptionJumps(expression2);
        this.finishElement(expression2);
    }

    @Override
    public void visitNewExpression(PsiNewExpression expression2) {
        PsiElement[] children2;
        this.startElement(expression2);
        int pc = this.myCurrentFlow.getSize();
        for (PsiElement child : children2 = expression2.getChildren()) {
            ProgressManager.checkCanceled();
            child.accept(this);
        }
        this.generateCheckedExceptionJumps(expression2);
        if (pc == this.myCurrentFlow.getSize()) {
            this.emitEmptyInstruction();
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        this.visitChildren(expression2);
    }

    @Override
    public void visitPostfixExpression(PsiPostfixExpression expression2) {
        this.startElement(expression2);
        IElementType op = expression2.getOperationTokenType();
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown(expression2.getOperand());
        if (operand != null) {
            PsiVariable variable2;
            operand.accept(this);
            if ((op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) && operand instanceof PsiReferenceExpression && (variable2 = this.getUsedVariable((PsiReferenceExpression)operand)) != null) {
                this.generateWriteInstruction(variable2);
            }
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        this.startElement(expression2);
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown(expression2.getOperand());
        if (operand != null) {
            PsiVariable variable2;
            IElementType operationSign = expression2.getOperationTokenType();
            if (operationSign == JavaTokenType.EXCL) {
                PsiElement topStartStatement = this.myStartStatementStack.peekElement();
                boolean topAtStart = this.myStartStatementStack.peekAtStart();
                this.myStartStatementStack.pushStatement(this.myEndStatementStack.peekElement(), this.myEndStatementStack.peekAtStart());
                this.myEndStatementStack.pushStatement(topStartStatement, topAtStart);
            }
            operand.accept(this);
            if (operationSign == JavaTokenType.EXCL) {
                this.myStartStatementStack.popStatement();
                this.myEndStatementStack.popStatement();
            }
            if (operand instanceof PsiReferenceExpression && (operationSign == JavaTokenType.PLUSPLUS || operationSign == JavaTokenType.MINUSMINUS) && (variable2 = this.getUsedVariable((PsiReferenceExpression)operand)) != null) {
                this.generateWriteInstruction(variable2);
            }
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        PsiVariable variable2;
        this.startElement(expression2);
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept(this);
        }
        if ((variable2 = this.getUsedVariable(expression2)) != null) {
            this.generateReadInstruction(variable2);
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitSuperExpression(PsiSuperExpression expression2) {
        this.startElement(expression2);
        this.finishElement(expression2);
    }

    @Override
    public void visitThisExpression(PsiThisExpression expression2) {
        this.startElement(expression2);
        this.finishElement(expression2);
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        this.startElement(expression2);
        PsiExpression operand = expression2.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
        this.finishElement(expression2);
    }

    @Override
    public void visitClass(PsiClass aClass2) {
        PsiExpressionList arguments2;
        this.startElement(aClass2);
        if (aClass2 instanceof PsiAnonymousClass && (arguments2 = PsiTreeUtil.getChildOfType(aClass2, PsiExpressionList.class)) != null) {
            arguments2.accept(this);
        }
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        this.addUsedVariables(array, aClass2);
        for (PsiVariable var : array) {
            ProgressManager.checkCanceled();
            this.generateReadInstruction(var);
        }
        this.finishElement(aClass2);
    }

    private void addUsedVariables(@NotNull List<PsiVariable> array, @NotNull PsiElement scope) {
        PsiElement[] children2;
        PsiVariable variable2;
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "addUsedVariables"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "addUsedVariables"));
        }
        if (scope instanceof PsiReferenceExpression && (variable2 = this.getUsedVariable((PsiReferenceExpression)scope)) != null && !array.contains(variable2)) {
            array.add(variable2);
        }
        for (PsiElement child : children2 = scope.getChildren()) {
            ProgressManager.checkCanceled();
            this.addUsedVariables(array, child);
        }
    }

    private void generateReadInstruction(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateReadInstruction"));
        }
        ReadVariableInstruction instruction = new ReadVariableInstruction(variable2);
        this.myCurrentFlow.addInstruction(instruction);
    }

    private void generateWriteInstruction(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "generateWriteInstruction"));
        }
        WriteVariableInstruction instruction = new WriteVariableInstruction(variable2);
        this.myCurrentFlow.addInstruction(instruction);
    }

    @Nullable
    private PsiVariable getUsedVariable(@NotNull PsiReferenceExpression refExpr) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/psi/controlFlow/ControlFlowAnalyzer", "getUsedVariable"));
        }
        if (refExpr.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        return this.myPolicy.getUsedVariable(refExpr);
    }

    private static class FinallyBlockSubroutine {
        private final PsiElement myElement;
        private final List<CallInstruction> myCalls;

        public FinallyBlockSubroutine(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/controlFlow/ControlFlowAnalyzer$FinallyBlockSubroutine", "<init>"));
            }
            this.myElement = element;
            this.myCalls = new ArrayList<CallInstruction>();
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer$FinallyBlockSubroutine", "getElement"));
            }
            return psiElement;
        }

        @NotNull
        public List<CallInstruction> getCalls() {
            List<CallInstruction> list2 = this.myCalls;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer$FinallyBlockSubroutine", "getCalls"));
            }
            return list2;
        }

        private void addCall(@NotNull CallInstruction callInstruction) {
            if (callInstruction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInstruction", "com/intellij/psi/controlFlow/ControlFlowAnalyzer$FinallyBlockSubroutine", "addCall"));
            }
            this.myCalls.add(callInstruction);
        }
    }

    private static enum Shortcut {
        NO_SHORTCUT,
        SKIP_CURRENT_OPERAND,
        STOP_EXPRESSION;

    }

    private static class StatementStack {
        private final Stack<PsiElement> myStatements = new Stack();
        private final TIntArrayList myAtStart = new TIntArrayList();

        private StatementStack() {
        }

        private void popStatement() {
            this.myAtStart.remove(this.myAtStart.size() - 1);
            this.myStatements.pop();
        }

        @NotNull
        private PsiElement peekElement() {
            PsiElement psiElement = this.myStatements.peek();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowAnalyzer$StatementStack", "peekElement"));
            }
            return psiElement;
        }

        private boolean peekAtStart() {
            return this.myAtStart.get(this.myAtStart.size() - 1) == 1;
        }

        private void pushStatement(@NotNull PsiElement statement2, boolean atStart) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/psi/controlFlow/ControlFlowAnalyzer$StatementStack", "pushStatement"));
            }
            this.myStatements.push(statement2);
            this.myAtStart.add(atStart ? 1 : 0);
        }
    }
}

