/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.http.HttpConnection;

public class HttpSupport {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_POST = "POST";
    public static final String HDR_CACHE_CONTROL = "Cache-Control";
    public static final String HDR_PRAGMA = "Pragma";
    public static final String HDR_USER_AGENT = "User-Agent";
    public static final String HDR_SERVER = "Server";
    public static final String HDR_DATE = "Date";
    public static final String HDR_EXPIRES = "Expires";
    public static final String HDR_ETAG = "ETag";
    public static final String HDR_IF_NONE_MATCH = "If-None-Match";
    public static final String HDR_LAST_MODIFIED = "Last-Modified";
    public static final String HDR_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HDR_ACCEPT = "Accept";
    public static final String HDR_CONTENT_TYPE = "Content-Type";
    public static final String HDR_CONTENT_LENGTH = "Content-Length";
    public static final String HDR_CONTENT_ENCODING = "Content-Encoding";
    public static final String HDR_CONTENT_RANGE = "Content-Range";
    public static final String HDR_ACCEPT_RANGES = "Accept-Ranges";
    public static final String HDR_IF_RANGE = "If-Range";
    public static final String HDR_RANGE = "Range";
    public static final String HDR_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HDR_LOCATION = "Location";
    public static final String ENCODING_GZIP = "gzip";
    public static final String ENCODING_X_GZIP = "x-gzip";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String HDR_AUTHORIZATION = "Authorization";
    public static final String HDR_WWW_AUTHENTICATE = "WWW-Authenticate";

    public static void encode(StringBuilder urlstr, String key2) {
        if (key2 == null || key2.length() == 0) {
            return;
        }
        try {
            urlstr.append(URLEncoder.encode(key2, "UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(JGitText.get().couldNotURLEncodeToUTF8, e2);
        }
    }

    public static int response(HttpConnection c) throws IOException {
        try {
            return c.getResponseCode();
        }
        catch (ConnectException ce) {
            String host;
            URL url = c.getURL();
            String string2 = host = url == null ? "<null>" : url.getHost();
            if ("Connection timed out: connect".equals(ce.getMessage())) {
                throw new ConnectException(MessageFormat.format(JGitText.get().connectionTimeOut, host));
            }
            throw new ConnectException(ce.getMessage() + " " + host);
        }
    }

    public static int response(HttpURLConnection c) throws IOException {
        try {
            return c.getResponseCode();
        }
        catch (ConnectException ce) {
            String host;
            URL url = c.getURL();
            String string2 = host = url == null ? "<null>" : url.getHost();
            if ("Connection timed out: connect".equals(ce.getMessage())) {
                throw new ConnectException(MessageFormat.format(JGitText.get().connectionTimeOut, host));
            }
            throw new ConnectException(ce.getMessage() + " " + host);
        }
    }

    public static String responseHeader(HttpConnection c, String headerName) throws IOException {
        return c.getHeaderField(headerName);
    }

    public static Proxy proxyFor(ProxySelector proxySelector, URL u) throws ConnectException {
        try {
            return proxySelector.select(u.toURI()).get(0);
        }
        catch (URISyntaxException e2) {
            ConnectException err = new ConnectException(MessageFormat.format(JGitText.get().cannotDetermineProxyFor, u));
            err.initCause(e2);
            throw err;
        }
    }

    public static void disableSslVerify(HttpConnection conn) throws IOException {
        TrustManager[] trustAllCerts = new TrustManager[]{new DummyX509TrustManager()};
        try {
            conn.configure(null, trustAllCerts, null);
            conn.setHostnameVerifier(new DummyHostnameVerifier());
        }
        catch (KeyManagementException e2) {
            throw new IOException(e2.getMessage());
        }
        catch (NoSuchAlgorithmException e3) {
            throw new IOException(e3.getMessage());
        }
    }

    private HttpSupport() {
    }

    private static class DummyHostnameVerifier
    implements HostnameVerifier {
        private DummyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class DummyX509TrustManager
    implements X509TrustManager {
        private DummyX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

