/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class ClusterUpdateSettingsResponse
extends AcknowledgedResponse {
    Settings transientSettings;
    Settings persistentSettings;

    ClusterUpdateSettingsResponse() {
        this.persistentSettings = Settings.EMPTY;
        this.transientSettings = Settings.EMPTY;
    }

    ClusterUpdateSettingsResponse(boolean acknowledged, Settings transientSettings, Settings persistentSettings) {
        super(acknowledged);
        this.persistentSettings = persistentSettings;
        this.transientSettings = transientSettings;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.transientSettings = Settings.readSettingsFromStream(in);
        this.persistentSettings = Settings.readSettingsFromStream(in);
        this.readAcknowledged(in);
    }

    public Settings getTransientSettings() {
        return this.transientSettings;
    }

    public Settings getPersistentSettings() {
        return this.persistentSettings;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Settings.writeSettingsToStream(this.transientSettings, out);
        Settings.writeSettingsToStream(this.persistentSettings, out);
        this.writeAcknowledged(out);
    }
}

