/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.nio.ByteBuffer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;

public class ByteBufferReference
extends BytesReference {
    private final ByteBuffer buffer;
    private final int offset;
    private final int length;

    public ByteBufferReference(ByteBuffer buffer) {
        this.buffer = buffer;
        this.offset = buffer.position();
        this.length = buffer.remaining();
    }

    @Override
    public byte get(int index) {
        return this.buffer.get(index + this.offset);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public BytesReference slice(int from, int length) {
        if (from < 0 || from + length > this.length) {
            throw new IndexOutOfBoundsException("can't slice a buffer with length [" + this.length + "], with slice parameters from [" + from + "], length [" + length + "]");
        }
        ByteBuffer newByteBuffer = this.buffer.duplicate();
        newByteBuffer.position(this.offset + from);
        newByteBuffer.limit(this.offset + from + length);
        return new ByteBufferReference(newByteBuffer);
    }

    @Override
    public BytesRef toBytesRef() {
        if (this.buffer.hasArray()) {
            return new BytesRef(this.buffer.array(), this.buffer.arrayOffset() + this.offset, this.length);
        }
        byte[] copy = new byte[this.length];
        this.buffer.get(copy, this.offset, this.length);
        return new BytesRef(copy);
    }

    public long ramBytesUsed() {
        return this.buffer.capacity();
    }
}

