/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ScriptStats
implements Writeable,
ToXContentFragment {
    private final long compilations;
    private final long cacheEvictions;

    public ScriptStats(long compilations, long cacheEvictions) {
        this.compilations = compilations;
        this.cacheEvictions = cacheEvictions;
    }

    public ScriptStats(StreamInput in) throws IOException {
        this.compilations = in.readVLong();
        this.cacheEvictions = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.compilations);
        out.writeVLong(this.cacheEvictions);
    }

    public long getCompilations() {
        return this.compilations;
    }

    public long getCacheEvictions() {
        return this.cacheEvictions;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("script");
        builder.field("compilations", this.getCompilations());
        builder.field("cache_evictions", this.getCacheEvictions());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String SCRIPT_STATS = "script";
        static final String COMPILATIONS = "compilations";
        static final String CACHE_EVICTIONS = "cache_evictions";

        Fields() {
        }
    }
}

