/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.result;

import com.mysql.cj.api.mysqla.result.ColumnDefinition;
import com.mysql.cj.api.mysqla.result.Resultset;
import com.mysql.cj.api.mysqla.result.ResultsetRows;
import com.mysql.cj.api.result.Row;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.mysqla.result.MysqlaColumnDefinition;
import com.mysql.cj.mysqla.result.OkPacket;
import java.util.HashMap;

public class MysqlaResultset
implements Resultset {
    protected ColumnDefinition columnDefinition;
    protected ResultsetRows rowData;
    protected Resultset nextResultset = null;
    protected int resultId;
    protected long updateCount;
    protected long updateId = -1L;
    protected String serverInfo = null;
    protected Row thisRow = null;

    public MysqlaResultset() {
    }

    public MysqlaResultset(OkPacket ok) {
        this.updateCount = ok.getUpdateCount();
        this.updateId = ok.getUpdateID();
        this.serverInfo = ok.getInfo();
        this.columnDefinition = new MysqlaColumnDefinition(new Field[0]);
    }

    public MysqlaResultset(ResultsetRows rows) {
        this.columnDefinition = rows.getMetadata();
        this.rowData = rows;
        this.updateCount = this.rowData.size();
        if (this.rowData.size() > 0) {
            if (this.updateCount == 1L && this.thisRow == null) {
                this.rowData.close();
                this.updateCount = -1L;
            }
        } else {
            this.thisRow = null;
        }
    }

    @Override
    public void setColumnDefinition(ColumnDefinition metadata) {
        this.columnDefinition = metadata;
    }

    @Override
    public ColumnDefinition getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public boolean hasRows() {
        return this.rowData != null;
    }

    @Override
    public int getResultId() {
        return this.resultId;
    }

    @Override
    public void initRowsWithMetadata() {
        this.rowData.setMetadata(this.columnDefinition);
        this.columnDefinition.setColumnToIndexCache(new HashMap<String, Integer>());
    }

    @Override
    public synchronized void setNextResultset(Resultset nextResultset) {
        this.nextResultset = nextResultset;
    }

    @Override
    public synchronized Resultset getNextResultset() {
        return this.nextResultset;
    }

    @Override
    public synchronized void clearNextResultset() {
        this.nextResultset = null;
    }

    @Override
    public long getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public long getUpdateID() {
        return this.updateId;
    }

    @Override
    public String getServerInfo() {
        return this.serverInfo;
    }
}

