/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.reporting.components.internal.ComponentReportRenderer;
import org.gradle.api.reporting.components.internal.TypeAwareBinaryRenderer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;

@Incubating
public class ComponentReport
extends DefaultTask {
    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ModelRegistry getModelRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected TypeAwareBinaryRenderer getBinaryRenderer() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void report() {
        BinaryContainer binaries;
        ModelMap testSuites;
        Project project = this.getProject();
        StyledTextOutput textOutput = this.getTextOutputFactory().create(ComponentReport.class);
        ComponentReportRenderer renderer = new ComponentReportRenderer(this.getFileResolver(), this.getBinaryRenderer());
        renderer.setOutput(textOutput);
        renderer.startProject(project);
        ArrayList<ComponentSpec> components = new ArrayList<ComponentSpec>();
        ComponentSpecContainer componentSpecs = this.modelElement("components", ComponentSpecContainer.class);
        if (componentSpecs != null) {
            components.addAll(componentSpecs.values());
        }
        if ((testSuites = (ModelMap)this.modelElement("testSuites", ModelTypes.modelMap(ComponentSpec.class))) != null) {
            components.addAll(testSuites.values());
        }
        renderer.renderComponents(components);
        ProjectSourceSet sourceSets = this.modelElement("sources", ProjectSourceSet.class);
        if (sourceSets != null) {
            renderer.renderSourceSets((Collection<LanguageSourceSet>)sourceSets);
        }
        if ((binaries = this.modelElement("binaries", BinaryContainer.class)) != null) {
            renderer.renderBinaries(binaries.values());
        }
        renderer.completeProject(project);
        renderer.complete();
    }

    private <T> T modelElement(String path, Class<T> clazz) {
        return (T)this.getModelRegistry().find(path, clazz);
    }

    private <T> T modelElement(String path, ModelType<T> modelType) {
        return (T)this.getModelRegistry().find(path, modelType);
    }
}

