/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.BuildableComponentSpec;
import org.gradle.api.CheckableComponentSpec;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.platform.base.component.internal.AbstractComponentSpec;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;

public abstract class AbstractBuildableComponentSpec
extends AbstractComponentSpec
implements BuildableComponentSpec,
CheckableComponentSpec {
    private final DefaultTaskDependency buildTaskDependencies = new DefaultTaskDependency();
    private Task buildTask;
    private final DefaultTaskDependency checkTaskDependencies = new DefaultTaskDependency();
    private Task checkTask;

    public AbstractBuildableComponentSpec(ComponentSpecIdentifier identifier, Class<? extends BuildableComponentSpec> publicType) {
        super(identifier, publicType);
    }

    @Override
    public Task getBuildTask() {
        return this.buildTask;
    }

    @Override
    public void setBuildTask(Task buildTask) {
        this.buildTask = buildTask;
        buildTask.dependsOn(new Object[]{this.buildTaskDependencies});
    }

    public TaskDependency getBuildDependencies() {
        return new TaskDependency(){

            public Set<? extends Task> getDependencies(Task other) {
                if (AbstractBuildableComponentSpec.this.buildTask == null) {
                    return AbstractBuildableComponentSpec.this.buildTaskDependencies.getDependencies(other);
                }
                return Collections.singleton(AbstractBuildableComponentSpec.this.buildTask);
            }
        };
    }

    @Override
    public void builtBy(Object ... tasks) {
        this.buildTaskDependencies.add(tasks);
    }

    @Override
    public boolean hasBuildDependencies() {
        return this.buildTaskDependencies.getDependencies(this.buildTask).size() > 0;
    }

    @Override
    @Nullable
    public Task getCheckTask() {
        return this.checkTask;
    }

    @Override
    public void setCheckTask(Task checkTask) {
        this.checkTask = checkTask;
        checkTask.dependsOn(new Object[]{this.checkTaskDependencies});
    }

    @Override
    public void checkedBy(Object ... tasks) {
        this.checkTaskDependencies.add(tasks);
    }
}

