/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.builder.LightElementOrigin;
import org.jetbrains.kotlin.asJava.builder.LightElementOriginKt;
import org.jetbrains.kotlin.asJava.builder.MemberIndex;
import org.jetbrains.kotlin.codegen.AbstractClassBuilder;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.StubBuildingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.fileClasses.OldPackageFacadeClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class StubClassBuilder
extends AbstractClassBuilder {
    private static final InnerClassSourceStrategy<Object> EMPTY_STRATEGY = new InnerClassSourceStrategy<Object>(){

        @Override
        public Object findInnerClass(String s, Object o) {
            return null;
        }

        @Override
        public void accept(Object innerClass, StubBuildingVisitor<Object> visitor2) {
            throw new UnsupportedOperationException("Shall not be called!");
        }
    };
    private final StubElement parent;
    private final PsiJavaFileStub fileStub;
    private StubBuildingVisitor v;
    private final Stack<StubElement> parentStack;
    private boolean isPackageClass = false;
    private int memberIndex = 0;

    public StubClassBuilder(@NotNull Stack<StubElement> parentStack, @NotNull PsiJavaFileStub fileStub) {
        this.parentStack = parentStack;
        this.parent = parentStack.peek();
        this.fileStub = fileStub;
    }

    @Override
    @NotNull
    public ClassVisitor getVisitor() {
        assert (this.v != null) : "Called before class is defined";
        return this.v;
    }

    @Override
    public void defineClass(PsiElement origin, int version, int access, @NotNull String name, @Nullable String signature, @NotNull String superName, @NotNull String[] interfaces) {
        FqName packageName;
        String packageClassName;
        assert (this.v == null) : "defineClass() called twice?";
        this.v = new StubBuildingVisitor<Object>(null, EMPTY_STRATEGY, this.parent, access, this.calculateShortName(name));
        super.defineClass(origin, version, access, name, signature, superName, interfaces);
        if (origin instanceof KtFile && (name.equals(packageClassName = OldPackageFacadeClassUtils.getPackageClassName(packageName = ((KtFile)origin).getPackageFqName())) || name.endsWith("/" + packageClassName))) {
            this.isPackageClass = true;
        }
        if (!this.isPackageClass) {
            this.parentStack.push(this.v.getResult());
        }
        ((StubBase)((Object)this.v.getResult())).putUserData(ClsWrapperStubPsiFactory.ORIGIN, LightElementOriginKt.toLightClassOrigin(origin));
    }

    @Nullable
    private String calculateShortName(@NotNull String internalName) {
        if (this.parent instanceof PsiJavaFileStub) {
            assert (this.parent == this.fileStub);
            String packagePrefix = this.getPackageInternalNamePrefix();
            assert (internalName.startsWith(packagePrefix)) : internalName + " : " + packagePrefix;
            return internalName.substring(packagePrefix.length());
        }
        if (this.parent instanceof PsiClassStub) {
            String parentPrefix = this.getClassInternalNamePrefix((PsiClassStub)this.parent);
            if (parentPrefix == null) {
                return null;
            }
            assert (internalName.startsWith(parentPrefix)) : internalName + " : " + parentPrefix;
            return internalName.substring(parentPrefix.length());
        }
        return null;
    }

    @Nullable
    private String getClassInternalNamePrefix(@NotNull PsiClassStub classStub) {
        String packageName = this.fileStub.getPackageName();
        String classStubQualifiedName = classStub.getQualifiedName();
        if (classStubQualifiedName == null) {
            return null;
        }
        if (packageName.isEmpty()) {
            return classStubQualifiedName.replace('.', '$') + "$";
        }
        return packageName.replace('.', '/') + "/" + classStubQualifiedName.substring(packageName.length() + 1).replace('.', '$') + "$";
    }

    @NotNull
    private String getPackageInternalNamePrefix() {
        String packageName = this.fileStub.getPackageName();
        if (packageName.isEmpty()) {
            return "";
        }
        return packageName.replace('.', '/') + "/";
    }

    @Override
    @NotNull
    public MethodVisitor newMethod(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        MethodVisitor internalVisitor = super.newMethod(origin, access, name, desc, signature, exceptions);
        if (internalVisitor != EMPTY_METHOD_VISITOR) {
            this.markLastChild(origin);
        }
        return internalVisitor;
    }

    @Override
    @NotNull
    public FieldVisitor newField(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
        FieldVisitor internalVisitor = super.newField(origin, access, name, desc, signature, value);
        if (internalVisitor != EMPTY_FIELD_VISITOR) {
            this.markLastChild(origin);
        }
        return internalVisitor;
    }

    private void markLastChild(@NotNull JvmDeclarationOrigin origin) {
        List<StubElement> children = this.v.getResult().getChildrenStubs();
        StubBase last = (StubBase)children.get(children.size() - 1);
        LightElementOrigin oldOrigin = last.getUserData(ClsWrapperStubPsiFactory.ORIGIN);
        if (oldOrigin != null) {
            PsiElement originalElement = oldOrigin.getOriginalElement();
            throw new IllegalStateException("Rewriting origin element: " + (originalElement != null ? originalElement.getText() : null) + " for stub " + last.toString());
        }
        last.putUserData(ClsWrapperStubPsiFactory.ORIGIN, LightElementOriginKt.toLightMemberOrigin(origin));
        last.putUserData(MemberIndex.KEY, new MemberIndex(this.memberIndex++));
    }

    @Override
    public void done() {
        if (!this.isPackageClass) {
            StubElement pop2 = this.parentStack.pop();
            assert (pop2 == this.v.getResult()) : "parentStack: got " + pop2 + ", expected " + this.v.getResult();
        }
        super.done();
    }
}

