/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.depend.AbstractAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntAnalyzer
extends AbstractAnalyzer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void determineDependencies(Vector<File> files, Vector<String> classes) {
        Hashtable<String, String> dependencies = new Hashtable<String, String>();
        Hashtable<File, File> containers = new Hashtable<File, File>();
        Hashtable<String, String> toAnalyze = new Hashtable<String, String>();
        Enumeration<String> e = this.getRootClasses();
        while (e.hasMoreElements()) {
            String classname = e.nextElement();
            toAnalyze.put(classname, classname);
        }
        int count = 0;
        int maxCount = this.isClosureRequired() ? 1000 : 1;
        Hashtable<String, String> analyzedDeps = null;
        while (toAnalyze.size() != 0 && count++ < maxCount) {
            analyzedDeps = new Hashtable<String, String>();
            Enumeration e2 = toAnalyze.keys();
            while (e2.hasMoreElements()) {
                String classname = (String)e2.nextElement();
                dependencies.put(classname, classname);
                try {
                    File container = this.getClassContainer(classname);
                    if (container == null) continue;
                    containers.put(container, container);
                    ZipFile zipFile = null;
                    InputStream inStream = null;
                    try {
                        if (container.getName().endsWith(".class")) {
                            inStream = new FileInputStream(container.getPath());
                        } else {
                            zipFile = new ZipFile(container.getPath());
                            String entryName = classname.replace('.', '/') + ".class";
                            ZipEntry entry = new ZipEntry(entryName);
                            inStream = zipFile.getInputStream(entry);
                        }
                        ClassFile classFile = new ClassFile();
                        classFile.read(inStream);
                        for (String dependency : classFile.getClassRefs()) {
                            analyzedDeps.put(dependency, dependency);
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(inStream);
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        throw throwable;
                    }
                    FileUtils.close(inStream);
                    if (zipFile == null) continue;
                    zipFile.close();
                }
                catch (IOException iOException) {
                }
            }
            toAnalyze.clear();
            for (String className : analyzedDeps.values()) {
                if (dependencies.containsKey(className)) continue;
                toAnalyze.put(className, className);
            }
        }
        for (String className : analyzedDeps.values()) {
            dependencies.put(className, className);
        }
        files.removeAllElements();
        for (File f : containers.keySet()) {
            files.add(f);
        }
        classes.removeAllElements();
        for (String dependency : dependencies.keySet()) {
            classes.add(dependency);
        }
    }

    @Override
    protected boolean supportsFileDependencies() {
        return true;
    }
}

