/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;

public class Quat {
    public float q0 = 1.0f;
    public float q1;
    public float q2;
    public float q3;
    private M3 mat;
    private static final P4 qZero = new P4();
    private static final double RAD_PER_DEG = Math.PI / 180;

    public static Quat newQ(Quat quat) {
        Quat quat2 = new Quat();
        quat2.set(quat);
        return quat2;
    }

    public static Quat newVA(T3 t3, float f) {
        Quat quat = new Quat();
        quat.setTA(t3, f);
        return quat;
    }

    public static Quat newM(M3 m3) {
        Quat quat = new Quat();
        quat.setM(M3.newM3(m3));
        return quat;
    }

    public static Quat newAA(A4 a4) {
        Quat quat = new Quat();
        quat.setAA(a4);
        return quat;
    }

    public static Quat newP4(P4 p4) {
        Quat quat = new Quat();
        quat.setP4(p4);
        return quat;
    }

    public static Quat new4(float f, float f2, float f3, float f4) {
        Quat quat = new Quat();
        if (f4 < -1.0f) {
            quat.q0 = -1.0f;
            return quat;
        }
        if (f4 > 1.0f) {
            quat.q0 = 1.0f;
            return quat;
        }
        quat.q0 = f4;
        quat.q1 = f;
        quat.q2 = f2;
        quat.q3 = f3;
        return quat;
    }

    public void set(Quat quat) {
        this.q0 = quat.q0;
        this.q1 = quat.q1;
        this.q2 = quat.q2;
        this.q3 = quat.q3;
    }

    private void setP4(P4 p4) {
        float f;
        float f2 = f = p4 == null ? 0.0f : p4.distance4(qZero);
        if (f == 0.0f) {
            this.q0 = 1.0f;
            return;
        }
        this.q0 = p4.w / f;
        this.q1 = p4.x / f;
        this.q2 = p4.y / f;
        this.q3 = p4.z / f;
    }

    public void setTA(T3 t3, float f) {
        if (t3.x == 0.0f && t3.y == 0.0f && t3.z == 0.0f) {
            this.q0 = 1.0f;
            return;
        }
        double d = Math.sin((double)(f / 2.0f) * (Math.PI / 180)) / Math.sqrt(t3.x * t3.x + t3.y * t3.y + t3.z * t3.z);
        this.q0 = (float)Math.cos((double)(f / 2.0f) * (Math.PI / 180));
        this.q1 = (float)((double)t3.x * d);
        this.q2 = (float)((double)t3.y * d);
        this.q3 = (float)((double)t3.z * d);
    }

    public void setAA(A4 a4) {
        A4 a42 = A4.newAA(a4);
        if (a42.angle == 0.0f) {
            a42.y = 1.0f;
        }
        this.setM(new M3().setAA(a42));
    }

    private void setM(M3 m3) {
        double d;
        double d2;
        double d3;
        double d4;
        this.mat = m3;
        double d5 = m3.m00 + m3.m11 + m3.m22;
        if (d5 >= 0.5) {
            d4 = Math.sqrt(1.0 + d5);
            d3 = (double)(m3.m21 - m3.m12) / d4;
            d2 = (double)(m3.m02 - m3.m20) / d4;
            d = (double)(m3.m10 - m3.m01) / d4;
        } else {
            double d6;
            double d7 = (double)(m3.m00 + m3.m00) - d5;
            if (d6 >= 0.5) {
                d3 = Math.sqrt(1.0 + d7);
                d4 = (double)(m3.m21 - m3.m12) / d3;
                d2 = (double)(m3.m10 + m3.m01) / d3;
                d = (double)(m3.m20 + m3.m02) / d3;
            } else {
                d7 = (double)(m3.m11 + m3.m11) - d5;
                if (d7 >= 0.5 || m3.m11 > m3.m22) {
                    d2 = Math.sqrt(1.0 + d7);
                    d4 = (double)(m3.m02 - m3.m20) / d2;
                    d3 = (double)(m3.m10 + m3.m01) / d2;
                    d = (double)(m3.m21 + m3.m12) / d2;
                } else {
                    d = Math.sqrt(1.0 + (double)m3.m22 + (double)m3.m22 - d5);
                    d4 = (double)(m3.m10 - m3.m01) / d;
                    d3 = (double)(m3.m20 + m3.m02) / d;
                    d2 = (double)(m3.m21 + m3.m12) / d;
                }
            }
        }
        this.q0 = (float)(d4 * 0.5);
        this.q1 = (float)(d3 * 0.5);
        this.q2 = (float)(d2 * 0.5);
        this.q3 = (float)(d * 0.5);
    }

    public void setRef(Quat quat) {
        if (quat == null) {
            this.mul(this.getFixFactor());
            return;
        }
        if (this.dot(quat) >= 0.0f) {
            return;
        }
        this.q0 *= -1.0f;
        this.q1 *= -1.0f;
        this.q2 *= -1.0f;
        this.q3 *= -1.0f;
    }

    public static final Quat getQuaternionFrame(P3 p3, T3 t3, T3 t32) {
        V3 v3 = V3.newV(t3);
        V3 v32 = V3.newV(t32);
        if (p3 != null) {
            v3.sub(p3);
            v32.sub(p3);
        }
        return Quat.getQuaternionFrameV(v3, v32, null, false);
    }

    public static final Quat getQuaternionFrameV(V3 v3, V3 v32, V3 v33, boolean bl) {
        if (v33 == null) {
            v33 = new V3();
            v33.cross(v3, v32);
            if (bl) {
                v3.cross(v32, v33);
            }
        }
        V3 v34 = new V3();
        v34.cross(v33, v3);
        v3.normalize();
        v34.normalize();
        v33.normalize();
        M3 m3 = new M3();
        m3.setColumnV(0, v3);
        m3.setColumnV(1, v34);
        m3.setColumnV(2, v33);
        Quat quat = Quat.newM(m3);
        return quat;
    }

    public M3 getMatrix() {
        if (this.mat == null) {
            this.setMatrix();
        }
        return this.mat;
    }

    private void setMatrix() {
        this.mat = new M3();
        this.mat.m00 = this.q0 * this.q0 + this.q1 * this.q1 - this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m01 = 2.0f * this.q1 * this.q2 - 2.0f * this.q0 * this.q3;
        this.mat.m02 = 2.0f * this.q1 * this.q3 + 2.0f * this.q0 * this.q2;
        this.mat.m10 = 2.0f * this.q1 * this.q2 + 2.0f * this.q0 * this.q3;
        this.mat.m11 = this.q0 * this.q0 - this.q1 * this.q1 + this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m12 = 2.0f * this.q2 * this.q3 - 2.0f * this.q0 * this.q1;
        this.mat.m20 = 2.0f * this.q1 * this.q3 - 2.0f * this.q0 * this.q2;
        this.mat.m21 = 2.0f * this.q2 * this.q3 + 2.0f * this.q0 * this.q1;
        this.mat.m22 = this.q0 * this.q0 - this.q1 * this.q1 - this.q2 * this.q2 + this.q3 * this.q3;
    }

    public Quat add(float f) {
        return Quat.newVA(this.getNormal(), this.getTheta() + f);
    }

    public Quat mul(float f) {
        return f == 1.0f ? Quat.new4(this.q1, this.q2, this.q3, this.q0) : Quat.newVA(this.getNormal(), this.getTheta() * f);
    }

    public Quat mulQ(Quat quat) {
        return Quat.new4(this.q0 * quat.q1 + this.q1 * quat.q0 + this.q2 * quat.q3 - this.q3 * quat.q2, this.q0 * quat.q2 + this.q2 * quat.q0 + this.q3 * quat.q1 - this.q1 * quat.q3, this.q0 * quat.q3 + this.q3 * quat.q0 + this.q1 * quat.q2 - this.q2 * quat.q1, this.q0 * quat.q0 - this.q1 * quat.q1 - this.q2 * quat.q2 - this.q3 * quat.q3);
    }

    public Quat div(Quat quat) {
        return this.mulQ(quat.inv());
    }

    public Quat divLeft(Quat quat) {
        return this.inv().mulQ(quat);
    }

    public float dot(Quat quat) {
        return this.q0 * quat.q0 + this.q1 * quat.q1 + this.q2 * quat.q2 + this.q3 * quat.q3;
    }

    public Quat inv() {
        return Quat.new4(-this.q1, -this.q2, -this.q3, this.q0);
    }

    public Quat negate() {
        return Quat.new4(-this.q1, -this.q2, -this.q3, -this.q0);
    }

    private float getFixFactor() {
        return this.q0 < 0.0f || this.q0 == 0.0f && (this.q1 < 0.0f || this.q1 == 0.0f && (this.q2 < 0.0f || this.q2 == 0.0f && this.q3 < 0.0f)) ? -1 : 1;
    }

    public V3 getVector(int n) {
        return this.getVectorScaled(n, 1.0f);
    }

    public V3 getVectorScaled(int n, float f) {
        if (n == -1) {
            return V3.new3(this.q1 * (f *= this.getFixFactor()), this.q2 * f, this.q3 * f);
        }
        if (this.mat == null) {
            this.setMatrix();
        }
        V3 v3 = new V3();
        this.mat.getColumnV(n, v3);
        if (f != 1.0f) {
            v3.scale(f);
        }
        return v3;
    }

    public V3 getNormal() {
        V3 v3 = Quat.getRawNormal(this);
        v3.scale(this.getFixFactor());
        return v3;
    }

    private static V3 getRawNormal(Quat quat) {
        V3 v3 = V3.new3(quat.q1, quat.q2, quat.q3);
        if (v3.length() == 0.0f) {
            return V3.new3(0.0f, 0.0f, 1.0f);
        }
        v3.normalize();
        return v3;
    }

    public float getTheta() {
        return (float)(Math.acos(Math.abs(this.q0)) * 2.0 * 180.0 / Math.PI);
    }

    public float getThetaRadians() {
        return (float)(Math.acos(Math.abs(this.q0)) * 2.0);
    }

    public V3 getNormalDirected(V3 v3) {
        V3 v32 = this.getNormal();
        if (v32.x * v3.x + v32.y * v3.y + v32.z * v3.z < 0.0f) {
            v32.scale(-1.0f);
        }
        return v32;
    }

    public V3 get3dProjection(V3 v3) {
        v3.set(this.q1, this.q2, this.q3);
        return v3;
    }

    public P4 getThetaDirected(P4 p4) {
        float f = this.getTheta();
        V3 v3 = this.getNormal();
        if (p4.x * this.q1 + p4.y * this.q2 + p4.z * this.q3 < 0.0f) {
            v3.scale(-1.0f);
            f = -f;
        }
        p4.set4(v3.x, v3.y, v3.z, f);
        return p4;
    }

    public float getThetaDirectedV(V3 v3) {
        float f = this.getTheta();
        V3 v32 = this.getNormal();
        if (v3.x * this.q1 + v3.y * this.q2 + v3.z * this.q3 < 0.0f) {
            v32.scale(-1.0f);
            f = -f;
        }
        return f;
    }

    public P4 toPoint4f() {
        return P4.new4(this.q1, this.q2, this.q3, this.q0);
    }

    public A4 toAxisAngle4f() {
        double d = 2.0 * Math.acos(Math.abs(this.q0));
        double d2 = Math.sin(d / 2.0);
        V3 v3 = this.getNormal();
        if (d2 < 0.0) {
            v3.scale(-1.0f);
            d = Math.PI - d;
        }
        return A4.newVA(v3, (float)d);
    }

    public T3 transform2(T3 t3, T3 t32) {
        if (this.mat == null) {
            this.setMatrix();
        }
        this.mat.rotate2(t3, t32);
        return t32;
    }

    public Quat leftDifference(Quat quat) {
        Quat quat2 = this.dot(quat) < 0.0f ? quat.negate() : quat;
        return this.inv().mulQ(quat2);
    }

    public Quat rightDifference(Quat quat) {
        Quat quat2 = this.dot(quat) < 0.0f ? quat.negate() : quat;
        return this.mulQ(quat2.inv());
    }

    public String toString() {
        return "{" + this.q1 + " " + this.q2 + " " + this.q3 + " " + this.q0 + "}";
    }

    public static Quat[] div(Quat[] quatArray, Quat[] quatArray2, int n, boolean bl) {
        int n2;
        if (quatArray == null || quatArray2 == null || (n2 = Math.min(quatArray.length, quatArray2.length)) == 0) {
            return null;
        }
        if (n > 0 && n2 > n) {
            n2 = n;
        }
        Quat[] quatArray3 = new Quat[n2];
        for (int i = 0; i < n2; ++i) {
            if (quatArray[i] == null || quatArray2[i] == null) {
                return null;
            }
            quatArray3[i] = bl ? quatArray[i].divLeft(quatArray2[i]) : quatArray[i].div(quatArray2[i]);
        }
        return quatArray3;
    }

    public static Quat sphereMean(Quat[] quatArray, float[] fArray, float f) {
        if (quatArray == null || quatArray.length == 0) {
            return new Quat();
        }
        if (fArray == null) {
            fArray = new float[1];
        }
        if (quatArray.length == 1) {
            fArray[0] = 0.0f;
            return Quat.newQ(quatArray[0]);
        }
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        Quat quat = Quat.simpleAverage(quatArray);
        int n = 100;
        int n2 = 0;
        while (f2 > f && f3 != 0.0f && n2 < n) {
            quat = Quat.newMean(quatArray, quat);
            fArray[0] = Quat.stdDev(quatArray, quat);
            f2 = Math.abs(fArray[0] - f3);
            f3 = fArray[0];
        }
        return quat;
    }

    private static Quat simpleAverage(Quat[] quatArray) {
        V3 v3 = V3.new3(0.0f, 0.0f, 1.0f);
        V3 v32 = quatArray[0].getNormal();
        v3.add(v32);
        int n = quatArray.length;
        while (--n >= 0) {
            v3.add(quatArray[n].getNormalDirected(v3));
        }
        v3.sub(v32);
        v3.normalize();
        float f = 0.0f;
        int n2 = quatArray.length;
        while (--n2 >= 0) {
            f += Math.abs(quatArray[n2].get3dProjection(v32).dot(v3));
        }
        if (f != 0.0f) {
            v3.scale(f / (float)quatArray.length);
        }
        if (Float.isNaN(f = (float)Math.sqrt(1.0f - v3.lengthSquared()))) {
            f = 0.0f;
        }
        return Quat.newP4(P4.new4(v3.x, v3.y, v3.z, f));
    }

    private static Quat newMean(Quat[] quatArray, Quat quat) {
        V3 v3 = new V3();
        int n = quatArray.length;
        while (--n >= 0) {
            Quat quat2 = quatArray[n];
            Quat quat3 = quat2.div(quat);
            V3 v32 = quat3.getNormal();
            v32.scale(quat3.getTheta());
            v3.add(v32);
        }
        v3.scale(1.0f / (float)quatArray.length);
        Quat quat4 = Quat.newVA(v3, v3.length());
        return quat4.mulQ(quat);
    }

    private static float stdDev(Quat[] quatArray, Quat quat) {
        int n;
        double d = 0.0;
        int n2 = n = quatArray.length;
        while (--n2 >= 0) {
            float f = quatArray[n2].div(quat).getTheta();
            d += (double)(f * f);
        }
        return (float)Math.sqrt(d / (double)n);
    }

    public float[] getEulerZYZ() {
        if (this.q1 == 0.0f && this.q2 == 0.0f) {
            float f = this.getTheta();
            return new float[]{this.q3 < 0.0f ? -f : f, 0.0f, 0.0f};
        }
        double d = Math.atan2(2.0f * (this.q2 * this.q3 + this.q0 * this.q1), 2.0f * (-this.q1 * this.q3 + this.q0 * this.q2));
        double d2 = Math.acos(this.q3 * this.q3 - this.q2 * this.q2 - this.q1 * this.q1 + this.q0 * this.q0);
        double d3 = Math.atan2(2.0f * (this.q2 * this.q3 - this.q0 * this.q1), 2.0f * (this.q0 * this.q2 + this.q1 * this.q3));
        return new float[]{(float)(d / (Math.PI / 180)), (float)(d2 / (Math.PI / 180)), (float)(d3 / (Math.PI / 180))};
    }

    public float[] getEulerZXZ() {
        if (this.q1 == 0.0f && this.q2 == 0.0f) {
            float f = this.getTheta();
            return new float[]{this.q3 < 0.0f ? -f : f, 0.0f, 0.0f};
        }
        double d = Math.atan2(2.0f * (this.q1 * this.q3 - this.q0 * this.q2), 2.0f * (this.q0 * this.q1 + this.q2 * this.q3));
        double d2 = Math.acos(this.q3 * this.q3 - this.q2 * this.q2 - this.q1 * this.q1 + this.q0 * this.q0);
        double d3 = Math.atan2(2.0f * (this.q1 * this.q3 + this.q0 * this.q2), 2.0f * (-this.q2 * this.q3 + this.q0 * this.q1));
        return new float[]{(float)(d / (Math.PI / 180)), (float)(d2 / (Math.PI / 180)), (float)(d3 / (Math.PI / 180))};
    }
}

