/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.PAL;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.render.FontLineShapeRenderer;
import org.jmol.util.C;
import org.jmol.util.Edge;

public class SticksRenderer
extends FontLineShapeRenderer {
    private boolean showMultipleBonds;
    private float multipleBondSpacing;
    private float multipleBondRadiusFactor;
    private boolean bondsPerp;
    private boolean useBananas;
    private byte modeMultipleBond;
    private boolean isCartesian;
    private byte endcaps;
    private boolean ssbondsBackbone;
    private boolean hbondsBackbone;
    private boolean bondsBackbone;
    private boolean hbondsSolid;
    private Atom a;
    private Atom b;
    private Bond bond;
    private int xA;
    private int yA;
    private int zA;
    private int xB;
    private int yB;
    private int zB;
    private int dx;
    private int dy;
    private int mag2d;
    private int bondOrder;
    private boolean wireframeOnly;
    private boolean isAntialiased;
    private boolean slabbing;
    private boolean slabByAtom;
    private final V3 x = new V3();
    private final V3 y = new V3();
    private final V3 z = new V3();
    private final P3 p1 = new P3();
    private final P3 p2 = new P3();
    private final BS bsForPass2 = BS.newN(64);
    private boolean isPass2;
    private double rTheta;
    private int xAxis1;
    private int yAxis1;
    private int xAxis2;
    private int yAxis2;
    private int dxStep;
    private int dyStep;
    private M3 rot;
    private A4 a4;

    @Override
    protected boolean render() {
        boolean needTranslucent;
        block5: {
            Bond[] bonds;
            block4: {
                bonds = this.ms.bo;
                if (bonds == null) {
                    return false;
                }
                this.isPass2 = this.vwr.gdata.isPass2;
                if (!this.isPass2) {
                    this.bsForPass2.clearAll();
                }
                this.slabbing = this.tm.slabEnabled;
                this.slabByAtom = this.vwr.getBoolean(603979939);
                this.endcaps = (byte)3;
                this.dashDots = this.vwr.getBoolean(603979893) ? sixdots : dashes;
                this.isCartesian = this.exportType == 1;
                this.getMultipleBondSettings(false);
                this.wireframeOnly = !this.vwr.checkMotionRendering(1677721602);
                this.ssbondsBackbone = this.vwr.getBoolean(603979952);
                this.hbondsBackbone = this.vwr.getBoolean(603979852);
                this.bondsBackbone = this.hbondsBackbone | this.ssbondsBackbone;
                this.hbondsSolid = this.vwr.getBoolean(603979854);
                this.isAntialiased = this.g3d.isAntialiased();
                needTranslucent = false;
                if (!this.isPass2) break block4;
                if (this.isExport) break block5;
                int i = this.bsForPass2.nextSetBit(0);
                while (i >= 0) {
                    this.bond = bonds[i];
                    this.renderBond();
                    i = this.bsForPass2.nextSetBit(i + 1);
                }
                break block5;
            }
            int i = this.ms.bondCount;
            while (--i >= 0) {
                this.bond = bonds[i];
                if ((this.bond.shapeVisibilityFlags & this.myVisibilityFlag) == 0 || !this.renderBond()) continue;
                needTranslucent = true;
                this.bsForPass2.set(i);
            }
        }
        return needTranslucent;
    }

    private void getMultipleBondSettings(boolean isPymol) {
        this.useBananas = this.vwr.getBoolean(603979886) && !isPymol;
        this.multipleBondSpacing = isPymol ? 0.15f : this.vwr.getFloat(570425370);
        this.multipleBondRadiusFactor = isPymol ? 0.4f : this.vwr.getFloat(570425369);
        boolean bl = this.bondsPerp = this.useBananas || this.multipleBondSpacing > 0.0f && this.multipleBondRadiusFactor < 0.0f;
        if (this.useBananas) {
            this.multipleBondSpacing = this.multipleBondSpacing < 0.0f ? -this.multipleBondSpacing * 0.4f : this.multipleBondSpacing;
        }
        this.multipleBondRadiusFactor = Math.abs(this.multipleBondRadiusFactor);
        if (this.multipleBondSpacing == 0.0f && this.isCartesian) {
            this.multipleBondSpacing = 0.2f;
        }
        this.modeMultipleBond = this.vwr.g.modeMultipleBond;
        this.showMultipleBonds = this.multipleBondSpacing != 0.0f && this.modeMultipleBond != 0 && this.vwr.getBoolean(603979928);
    }

    private boolean renderBond() {
        boolean ba;
        Atom atomB0;
        Atom atomA0;
        this.a = atomA0 = this.bond.atom1;
        this.b = atomB0 = this.bond.atom2;
        int order = this.bond.order & 0xFFFDFFFF;
        if (this.bondsBackbone) {
            if (this.ssbondsBackbone && (order & 0x100) != 0) {
                this.a = this.a.group.getLeadAtomOr(this.a);
                this.b = this.b.group.getLeadAtomOr(this.b);
            } else if (this.hbondsBackbone && Edge.isOrderH(order)) {
                this.a = this.a.group.getLeadAtomOr(this.a);
                this.b = this.b.group.getLeadAtomOr(this.b);
            }
        }
        if (!(this.isPass2 || this.a.isVisible(9) && this.b.isVisible(9) && this.g3d.isInDisplayRange(this.a.sX, this.a.sY) && this.g3d.isInDisplayRange(this.b.sX, this.b.sY))) {
            return false;
        }
        if (this.slabbing && ((ba = this.vwr.gdata.isClippedZ(this.a.sZ)) && this.vwr.gdata.isClippedZ(this.b.sZ) || this.slabByAtom && (ba || this.vwr.gdata.isClippedZ(this.b.sZ)))) {
            return false;
        }
        this.zA = this.a.sZ;
        this.zB = this.b.sZ;
        if (this.zA == 1 || this.zB == 1) {
            return false;
        }
        this.colixA = atomA0.colixAtom;
        this.colixB = atomB0.colixAtom;
        this.colix = this.bond.colix;
        if ((this.colix & 0xFFFF87FF) == 2) {
            this.colix = (short)(this.colix & 0x7800);
            this.colixA = C.getColixInherited((short)(this.colix | this.vwr.cm.getColixAtomPalette(atomA0, PAL.CPK.id)), this.colixA);
            this.colixB = C.getColixInherited((short)(this.colix | this.vwr.cm.getColixAtomPalette(atomB0, PAL.CPK.id)), this.colixB);
        } else {
            this.colixA = C.getColixInherited(this.colix, this.colixA);
            this.colixB = C.getColixInherited(this.colix, this.colixB);
        }
        boolean needTranslucent = false;
        if (!this.isExport && !this.isPass2) {
            boolean doB;
            boolean doA = !C.renderPass2(this.colixA);
            boolean bl = doB = !C.renderPass2(this.colixB);
            if (!doA || !doB) {
                if (!(doA || doB || needTranslucent)) {
                    this.g3d.setC(!doA ? this.colixA : this.colixB);
                    return true;
                }
                needTranslucent = true;
            }
        }
        this.bondOrder = order & 0xFFFDFFFF;
        if ((this.bondOrder & 0xE0) == 0) {
            if ((this.bondOrder & 0x100) != 0) {
                this.bondOrder &= 0xFFFFFEFF;
            }
            if ((this.bondOrder & 0x3FF) != 0 && (!this.showMultipleBonds || this.modeMultipleBond == 2 && this.mad > 500 || (this.bondOrder & 0x18000) == 65536)) {
                this.bondOrder = 1;
            }
        }
        int mask = 0;
        switch (this.bondOrder) {
            case 1025: 
            case 1041: {
                this.bondOrder = 1;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 17: 
            case 513: {
                this.bondOrder = 1;
                mask = order == 513 ? 0 : 1;
                break;
            }
            case 514: 
            case 515: {
                this.bondOrder = 2;
                mask = order == 515 ? this.getAromaticDottedBondMask() : 0;
                break;
            }
            default: {
                if ((this.bondOrder & 0xE0) != 0) {
                    this.bondOrder = Edge.getPartialBondOrder(order);
                    mask = Edge.getPartialBondDotted(order);
                    break;
                }
                if (Edge.isOrderH(this.bondOrder)) {
                    this.bondOrder = 1;
                    if (this.hbondsSolid) break;
                    mask = -1;
                    break;
                }
                if (this.bondOrder == 32768) {
                    this.bondOrder = 1;
                    break;
                }
                if ((this.bondOrder & 0x18000) != 98304) break;
                this.getMultipleBondSettings(true);
                this.bondOrder &= 3;
                mask = -2;
            }
        }
        this.xA = this.a.sX;
        this.yA = this.a.sY;
        this.xB = this.b.sX;
        this.yB = this.b.sY;
        this.mad = this.bond.mad;
        if (this.multipleBondRadiusFactor > 0.0f && this.bondOrder > 1) {
            this.mad = (short)((float)this.mad * this.multipleBondRadiusFactor);
        }
        this.dx = this.xB - this.xA;
        this.dy = this.yB - this.yA;
        this.width = (int)this.vwr.tm.scaleToScreen((this.zA + this.zB) / 2, this.mad);
        if (this.wireframeOnly && this.width > 0) {
            this.width = 1;
        }
        if (!this.isCartesian) {
            boolean bl = this.asLineOnly = this.width <= 1;
            if (this.asLineOnly && this.isAntialiased) {
                this.width = 3;
                this.asLineOnly = false;
            }
        }
        block6 : switch (mask) {
            case -2: {
                this.drawBond(0);
                this.getMultipleBondSettings(false);
                break;
            }
            case -1: {
                this.drawDashed(this.xA, this.yA, this.zA, this.xB, this.yB, this.zB, hDashes);
                break;
            }
            default: {
                switch (this.bondOrder) {
                    case 4: {
                        float m;
                        this.bondOrder = 2;
                        float f = this.multipleBondRadiusFactor;
                        if (f == 0.0f && this.width > 1) {
                            this.width = (int)((double)this.width * 0.5);
                        }
                        if ((m = this.multipleBondSpacing) < 0.0f) {
                            this.multipleBondSpacing = 0.3f;
                        }
                        this.drawBond(mask);
                        this.bondsPerp = !this.bondsPerp;
                        this.bondOrder = 2;
                        this.drawBond(mask >> 2);
                        this.bondsPerp = !this.bondsPerp;
                        this.multipleBondSpacing = m;
                        break block6;
                    }
                    case 5: {
                        float m;
                        this.bondOrder = 3;
                        float f = this.multipleBondRadiusFactor;
                        if (f == 0.0f && this.width > 1) {
                            this.width = (int)((double)this.width * 0.5);
                        }
                        if ((m = this.multipleBondSpacing) < 0.0f) {
                            this.multipleBondSpacing = 0.2f;
                        }
                        this.drawBond(mask);
                        this.bondsPerp = !this.bondsPerp;
                        this.bondOrder = 2;
                        this.multipleBondSpacing *= 1.5f;
                        this.drawBond(mask >> 3);
                        this.bondsPerp = !this.bondsPerp;
                        this.multipleBondSpacing = m;
                        break block6;
                    }
                    case 6: {
                        float m;
                        this.bondOrder = 4;
                        float f = this.multipleBondRadiusFactor;
                        if (f == 0.0f && this.width > 1) {
                            this.width = (int)((double)this.width * 0.5);
                        }
                        if ((m = this.multipleBondSpacing) < 0.0f) {
                            this.multipleBondSpacing = 0.15f;
                        }
                        this.drawBond(mask);
                        this.bondsPerp = !this.bondsPerp;
                        this.bondOrder = 2;
                        this.multipleBondSpacing *= 1.5f;
                        this.drawBond(mask >> 4);
                        this.bondsPerp = !this.bondsPerp;
                        this.multipleBondSpacing = m;
                        break block6;
                    }
                }
                this.drawBond(mask);
            }
        }
        return needTranslucent;
    }

    private void drawBond(int dottedMask) {
        boolean isPiBonded;
        boolean isEndOn;
        boolean isDashed;
        boolean bl = isDashed = (dottedMask & 1) != 0;
        if (this.isCartesian && this.bondOrder == 1 && !isDashed) {
            this.g3d.drawBond(this.a, this.b, this.colixA, this.colixB, this.endcaps, this.mad, -1);
            return;
        }
        boolean bl2 = isEndOn = this.dx == 0 && this.dy == 0;
        if (isEndOn && this.asLineOnly && !this.isCartesian) {
            return;
        }
        boolean doFixedSpacing = this.bondOrder > 1 && this.multipleBondSpacing > 0.0f;
        boolean bl3 = isPiBonded = doFixedSpacing && (this.vwr.getHybridizationAndAxes(this.a.i, this.z, this.x, "pz") != null || this.vwr.getHybridizationAndAxes(this.b.i, this.z, this.x, "pz") != null) && !Float.isNaN(this.x.x);
        if (isEndOn && !doFixedSpacing) {
            int space = this.width / 8 + 3;
            int step = this.width + space;
            int y = this.yA - (this.bondOrder - 1) * step / 2;
            do {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xA, y, this.zA, this.xB, y, this.zB);
                y += step;
            } while (--this.bondOrder > 0);
            return;
        }
        if (this.bondOrder == 1) {
            if (isDashed) {
                this.drawDashed(this.xA, this.yA, this.zA, this.xB, this.yB, this.zB, this.dashDots);
            } else {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            }
            return;
        }
        if (doFixedSpacing) {
            if (!isPiBonded) {
                this.z.setT(P3.getUnlikely());
            }
            this.x.sub2(this.b, this.a);
            this.y.cross(this.x, this.z);
            this.y.normalize();
            if (Float.isNaN(this.y.x)) {
                this.z.setT(P3.getUnlikely());
                this.y.cross(this.x, this.z);
                this.y.cross(this.y, this.x);
                this.y.normalize();
            }
            if (this.bondsPerp) {
                this.y.cross(this.y, this.x);
            }
            this.y.scale(this.multipleBondSpacing);
            this.x.setT(this.y);
            this.x.scale((float)(this.bondOrder - 1) / 2.0f);
            if (this.useBananas) {
                this.drawBanana(this.a, this.b, this.x, 0);
                switch (this.bondOrder) {
                    case 4: {
                        this.drawBanana(this.a, this.b, this.x, 90);
                        this.drawBanana(this.a, this.b, this.x, -90);
                    }
                    default: {
                        this.drawBanana(this.a, this.b, this.x, 180);
                        break;
                    }
                    case 3: {
                        this.drawBanana(this.a, this.b, this.x, 120);
                        this.drawBanana(this.a, this.b, this.x, -120);
                    }
                }
                return;
            }
            this.p1.sub2(this.a, this.x);
            this.p2.sub2(this.b, this.x);
            while (true) {
                if (this.isCartesian) {
                    this.g3d.drawBond(this.p1, this.p2, this.colixA, this.colixB, this.endcaps, this.mad, -2);
                } else {
                    this.tm.transformPtScr(this.p1, this.s1);
                    this.tm.transformPtScr(this.p2, this.s2);
                    if (isDashed) {
                        this.drawDashed(this.s1.x, this.s1.y, this.s1.z, this.s2.x, this.s2.y, this.s2.z, this.dashDots);
                    } else {
                        this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.s1.x, this.s1.y, this.s1.z, this.s2.x, this.s2.y, this.s2.z);
                    }
                }
                boolean bl4 = isDashed = ((dottedMask >>= 1) & 1) != 0;
                if (--this.bondOrder <= 0) break;
                this.p1.add(this.y);
                this.p2.add(this.y);
                this.stepAxisCoordinates();
            }
            return;
        }
        int dxB = this.dx * this.dx;
        int dyB = this.dy * this.dy;
        this.mag2d = (int)Math.round(Math.sqrt(dxB + dyB));
        this.resetAxisCoordinates();
        if (this.isCartesian && this.bondOrder == 3) {
            this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            this.stepAxisCoordinates();
            this.x.sub2(this.b, this.a);
            this.x.scale(0.05f);
            this.p1.sub2(this.a, this.x);
            this.p2.add2(this.b, this.x);
            this.g3d.drawBond(this.p1, this.p2, this.colixA, this.colixB, this.endcaps, this.mad, -2);
            this.stepAxisCoordinates();
            this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            return;
        }
        while (true) {
            if ((dottedMask & 1) != 0) {
                this.drawDashed(this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB, this.dashDots);
            } else {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            }
            dottedMask >>= 1;
            if (--this.bondOrder <= 0) break;
            this.stepAxisCoordinates();
        }
    }

    private void resetAxisCoordinates() {
        int space = this.mag2d >> 3;
        if (this.multipleBondSpacing != -1.0f && this.multipleBondSpacing < 0.0f) {
            space = (int)((float)space * -this.multipleBondSpacing);
        }
        int step = this.width + space;
        this.dxStep = step * this.dy / this.mag2d;
        this.dyStep = step * -this.dx / this.mag2d;
        this.xAxis1 = this.xA;
        this.yAxis1 = this.yA;
        this.xAxis2 = this.xB;
        this.yAxis2 = this.yB;
        int f = this.bondOrder - 1;
        this.xAxis1 -= this.dxStep * f / 2;
        this.yAxis1 -= this.dyStep * f / 2;
        this.xAxis2 -= this.dxStep * f / 2;
        this.yAxis2 -= this.dyStep * f / 2;
    }

    private void stepAxisCoordinates() {
        this.xAxis1 += this.dxStep;
        this.yAxis1 += this.dyStep;
        this.xAxis2 += this.dxStep;
        this.yAxis2 += this.dyStep;
    }

    private int getAromaticDottedBondMask() {
        Atom atomC = this.b.findAromaticNeighbor(this.a.i);
        if (atomC == null) {
            return 1;
        }
        int dyAC = atomC.sY - this.yA;
        int dxAC = atomC.sX - this.xA;
        return this.dx * dyAC - this.dy * dxAC < 0 ? 2 : 1;
    }

    private void drawBanana(Atom a, Atom b, V3 x, int deg) {
        this.g3d.addRenderer(553648147);
        this.vectorT.sub2(b, a);
        if (this.rot == null) {
            this.rot = new M3();
            this.a4 = new A4();
        }
        this.a4.setVA(this.vectorT, (float)((double)deg * Math.PI / 180.0));
        this.rot.setAA(this.a4);
        this.pointT.setT(a);
        this.pointT3.setT(b);
        this.pointT2.ave(a, b);
        this.rot.rotate2(x, this.vectorT);
        this.pointT2.add(this.vectorT);
        this.tm.transformPtScrT3(a, this.pointT);
        this.tm.transformPtScrT3(this.pointT2, this.pointT2);
        this.tm.transformPtScrT3(b, this.pointT3);
        int w = Math.max(this.width, 1);
        this.g3d.setC(this.colixA);
        this.g3d.fillHermite(5, w, w, w, this.pointT, this.pointT, this.pointT2, this.pointT3);
        this.g3d.setC(this.colixB);
        this.g3d.fillHermite(5, w, w, w, this.pointT, this.pointT2, this.pointT3, this.pointT3);
    }
}

