/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.ProjectWebServiceView;
import org.netbeans.modules.websvc.core.ProjectWebServiceViewImpl;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class ProjectWebServiceNodeFactory
implements NodeFactory {
    public static ProjectWebServiceNodeFactory ejbproject() {
        return new ProjectWebServiceNodeFactory();
    }

    public static ProjectWebServiceNodeFactory j2seproject() {
        return new ProjectWebServiceNodeFactory();
    }

    public static ProjectWebServiceNodeFactory j2eeClientProject() {
        return new ProjectWebServiceNodeFactory();
    }

    public NodeList<ProjectWebServiceView.ViewType> createNodes(Project p) {
        assert (p != null);
        return new WsNodeList(p);
    }

    private static class WsClientPrivilegedTemplates
    implements PrivilegedTemplates {
        private WsClientPrivilegedTemplates() {
        }

        public String[] getPrivilegedTemplates() {
            return new String[]{"Templates/WebServices/WebServiceClient", "Templates/WebServices/MessageHandler.java", "Templates/WebServices/LogicalHandler.java"};
        }
    }

    private static class WsPrivilegedTemplates
    implements PrivilegedTemplates {
        private WsPrivilegedTemplates() {
        }

        public String[] getPrivilegedTemplates() {
            return new String[]{"Templates/WebServices/WebService.java", "Templates/WebServices/WebServiceFromWSDL.java", "Templates/WebServices/MessageHandler.java", "Templates/WebServices/LogicalHandler.java"};
        }
    }

    private static class WSRootNode
    extends AbstractNode {
        private static final String SERVICES_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/webservicegroup.png";
        private Icon folderIconCache;
        private Icon openedFolderIconCache;
        private Image cachedServicesBadge;
        private WSChildrenFactory factory;

        public WSRootNode(WSChildrenFactory factory, Lookup lookup) {
            super(Children.create((ChildFactory)factory, (boolean)true), lookup);
            this.factory = factory;
        }

        public Action[] getActions(boolean context) {
            return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(PropertiesAction.class)};
        }

        public Image getIcon(int type) {
            return this.computeIcon(false);
        }

        public Image getOpenedIcon(int type) {
            return this.computeIcon(true);
        }

        WSChildrenFactory getFactory() {
            return this.factory;
        }

        private Image getServicesImage() {
            if (this.cachedServicesBadge == null) {
                this.cachedServicesBadge = ImageUtilities.loadImage((String)SERVICES_BADGE);
            }
            return this.cachedServicesBadge;
        }

        private Icon getFolderIcon(boolean opened) {
            if (this.openedFolderIconCache == null) {
                Node n = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
                this.openedFolderIconCache = new ImageIcon(n.getOpenedIcon(1));
                this.folderIconCache = new ImageIcon(n.getIcon(1));
            }
            if (opened) {
                return this.openedFolderIconCache;
            }
            return this.folderIconCache;
        }

        private Image computeIcon(boolean opened) {
            Icon icon = this.getFolderIcon(opened);
            Image image = ((ImageIcon)icon).getImage();
            image = ImageUtilities.mergeImages((Image)image, (Image)this.getServicesImage(), (int)7, (int)7);
            return image;
        }
    }

    private static class Pair {
        private final ProjectWebServiceViewImpl impl;
        private final Node[] nodes;

        Pair(ProjectWebServiceViewImpl impl, Node[] nodes) {
            this.impl = impl;
            this.nodes = nodes;
        }

        ProjectWebServiceViewImpl getView() {
            return this.impl;
        }

        Node[] getNodes() {
            return this.nodes;
        }
    }

    private static class WSChildrenFactory
    extends ChildFactory<Pair> {
        private ProjectWebServiceView.ViewType viewType;
        private ProjectWebServiceView view;

        public WSChildrenFactory(ProjectWebServiceView view, ProjectWebServiceView.ViewType viewType) {
            this.view = view;
            this.viewType = viewType;
        }

        protected boolean createKeys(List<Pair> keys) {
            if (this.view != null && !this.view.isViewEmpty(this.viewType)) {
                List<ProjectWebServiceViewImpl> webServiceViews = this.view.getWebServiceViews();
                if (Thread.interrupted()) {
                    return false;
                }
                for (ProjectWebServiceViewImpl projectWebServiceViewImpl : webServiceViews) {
                    if (Thread.interrupted()) {
                        return false;
                    }
                    Node[] nodes = projectWebServiceViewImpl.createView(this.viewType);
                    keys.add(new Pair(projectWebServiceViewImpl, nodes));
                }
            }
            return true;
        }

        protected Node[] createNodesForKey(Pair key) {
            return key.getNodes();
        }

        void updateKeys() {
            this.refresh(true);
        }
    }

    private static class WsNodeList
    implements NodeList<ProjectWebServiceView.ViewType>,
    ChangeListener {
        private Project project;
        private ChangeSupport changeSupport;
        private ProjectWebServiceView view;
        private WSRootNode serviceNode;
        private WSRootNode clientNode;
        private ChangeListener weakL;

        public WsNodeList(Project proj) {
            this.project = proj;
            this.changeSupport = new ChangeSupport((Object)this);
        }

        public List<ProjectWebServiceView.ViewType> keys() {
            this.initView();
            ArrayList<ProjectWebServiceView.ViewType> result = new ArrayList<ProjectWebServiceView.ViewType>();
            if (!this.view.isViewEmpty(ProjectWebServiceView.ViewType.SERVICE)) {
                result.add(ProjectWebServiceView.ViewType.SERVICE);
            }
            if (!this.view.isViewEmpty(ProjectWebServiceView.ViewType.CLIENT)) {
                result.add(ProjectWebServiceView.ViewType.CLIENT);
            }
            return result;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        private void fireChange() {
            this.changeSupport.fireChange();
        }

        public Node node(ProjectWebServiceView.ViewType key) {
            switch (key) {
                case SERVICE: {
                    if (this.serviceNode == null) {
                        this.serviceNode = new WSRootNode(new WSChildrenFactory(this.view, key), this.createLookup(this.project, new WsPrivilegedTemplates()));
                        this.serviceNode.setDisplayName(NbBundle.getBundle(ProjectWebServiceNodeFactory.class).getString("LBL_WebServices"));
                    }
                    return this.serviceNode;
                }
                case CLIENT: {
                    if (this.clientNode == null) {
                        this.clientNode = new WSRootNode(new WSChildrenFactory(this.view, key), this.createLookup(this.project, new WsClientPrivilegedTemplates()));
                        this.clientNode.setDisplayName(NbBundle.getBundle(ProjectWebServiceNodeFactory.class).getString("LBL_ServiceReferences"));
                    }
                    return this.clientNode;
                }
            }
            return null;
        }

        public void addNotify() {
            this.initView();
            this.weakL = WeakListeners.change((ChangeListener)this, (Object)this.view);
            this.view.addChangeListener(this.weakL, ProjectWebServiceView.ViewType.SERVICE);
            this.view.addChangeListener(this.weakL, ProjectWebServiceView.ViewType.CLIENT);
            this.view.addNotify();
        }

        public void removeNotify() {
            if (this.view != null) {
                this.view.removeChangeListener(this.weakL, ProjectWebServiceView.ViewType.SERVICE);
                this.view.removeChangeListener(this.weakL, ProjectWebServiceView.ViewType.CLIENT);
                this.view.removeNotify();
                this.weakL = null;
            }
        }

        @Override
        public void stateChanged(final ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WsNodeList.this.fireChange();
                    Object source = e.getSource();
                    if (source instanceof ProjectWebServiceViewImpl) {
                        if (WsNodeList.this.serviceNode != null) {
                            WsNodeList.this.serviceNode.getFactory().updateKeys();
                        }
                        if (WsNodeList.this.clientNode != null) {
                            WsNodeList.this.clientNode.getFactory().updateKeys();
                        }
                    }
                }
            });
        }

        private void initView() {
            if (this.view == null) {
                this.view = ProjectWebServiceView.getProjectWebServiceView(this.project);
            }
        }

        private Lookup createLookup(Project project, PrivilegedTemplates privilegedTemplates) {
            return Lookups.fixed((Object[])new Object[]{project, privilegedTemplates});
        }
    }
}

