/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.prep.CssPreprocessorType;
import org.netbeans.modules.css.prep.preferences.CssPreprocessorPreferences;
import org.netbeans.modules.css.prep.util.Bundle;
import org.netbeans.modules.css.prep.util.StringUtils;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.spi.ProjectWebRootProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;
import org.openide.util.Utilities;

public final class CssPreprocessorUtils {
    private static final Logger LOGGER = Logger.getLogger(CssPreprocessorUtils.class.getName());
    static final String MAPPINGS_DELIMITER = ",";
    static final String MAPPING_DELIMITER = ":";
    private static final String WEB_ROOT_PARAM = "${web.root}";
    private static final String CSS_EXTENSION = "css";

    private CssPreprocessorUtils() {
    }

    public static void processSavedFile(Project project, CssPreprocessorType type) {
        assert (project != null);
        assert (type != null);
        CssPreprocessorPreferences projectPreferences = type.getPreferences();
        assert (projectPreferences != null);
        if (projectPreferences.isConfigured(project)) {
            return;
        }
        projectPreferences.setConfigured(project, true);
        String displayName = type.getDisplayName();
        if (!CssPreprocessorUtils.askUser(Bundle.CssPreprocessorUtils_fileSaved_title(displayName), Bundle.CssPreprocessorUtils_fileSaved_question(displayName))) {
            return;
        }
        projectPreferences.setEnabled(project, true);
        projectPreferences.setMappings(project, CssPreprocessorUtils.getDefaultMappings(type));
        CustomizerProvider2 customizerProvider = (CustomizerProvider2)project.getLookup().lookup(CustomizerProvider2.class);
        if (customizerProvider == null) {
            LOGGER.log(Level.WARNING, "CustomizerProvider2 not found in lookup of project {0}", project.getClass().getName());
        } else {
            customizerProvider.showCustomizer("CssPreprocessors", null);
        }
    }

    public static List<Pair<String, String>> getDefaultMappings(CssPreprocessorType type) {
        return Collections.singletonList(Pair.of((Object)("/" + type.getDefaultDirectoryName()), (Object)"/css"));
    }

    private static boolean askUser(String title, String question) {
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)question, title, 0));
        return result == NotifyDescriptor.YES_OPTION;
    }

    public static String encodeMappings(List<Pair<String, String>> mappings) {
        StringBuilder buffer = new StringBuilder(200);
        for (Pair<String, String> mapping : mappings) {
            if (buffer.length() > 0) {
                buffer.append(MAPPINGS_DELIMITER);
            }
            buffer.append((String)mapping.first());
            buffer.append(MAPPING_DELIMITER);
            buffer.append((String)mapping.second());
        }
        return buffer.toString();
    }

    public static List<Pair<String, String>> decodeMappings(String mappings) {
        List<String> pairs = StringUtils.explode(mappings, MAPPINGS_DELIMITER);
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>(pairs.size());
        for (String pair : pairs) {
            List<String> paths = StringUtils.explode(pair, MAPPING_DELIMITER);
            result.add((Pair<String, String>)Pair.of((Object)paths.get(0), (Object)paths.get(1)));
        }
        return result;
    }

    public static List<String> parseCompilerOptions(@NullAllowed String compilerOptions, @NullAllowed FileObject webRoot) {
        if (!StringUtils.hasText(compilerOptions)) {
            return Collections.emptyList();
        }
        String[] parsedCompilerParams = Utilities.parseParameters((String)CssPreprocessorUtils.processCompilerOptions(compilerOptions, webRoot));
        return Arrays.asList(parsedCompilerParams);
    }

    private static String processCompilerOptions(String compilerOptions, @NullAllowed FileObject webRoot) {
        if (webRoot == null || compilerOptions.indexOf(WEB_ROOT_PARAM) == -1) {
            return compilerOptions;
        }
        return compilerOptions.replace(WEB_ROOT_PARAM, FileUtil.toFile((FileObject)webRoot).getAbsolutePath());
    }

    @CheckForNull
    public static FileObject getWebRoot(Project project, FileObject fileObject) {
        ProjectWebRootProvider projectWebRootProvider = CssPreprocessorUtils.getProjectWebRootProvider(project);
        if (projectWebRootProvider == null) {
            return null;
        }
        return projectWebRootProvider.getWebRoot(fileObject);
    }

    @CheckForNull
    public static FileObject getWebRoot(Project project) {
        ProjectWebRootProvider projectWebRootProvider = CssPreprocessorUtils.getProjectWebRootProvider(project);
        if (projectWebRootProvider == null) {
            return null;
        }
        Collection webRoots = projectWebRootProvider.getWebRoots();
        if (webRoots.isEmpty()) {
            return null;
        }
        return (FileObject)webRoots.iterator().next();
    }

    @CheckForNull
    private static ProjectWebRootProvider getProjectWebRootProvider(Project project) {
        ProjectWebRootProvider projectWebRootProvider = (ProjectWebRootProvider)project.getLookup().lookup(ProjectWebRootProvider.class);
        if (projectWebRootProvider == null) {
            LOGGER.log(Level.INFO, "ProjectWebRootProvider should be found in project lookup of {0}", project.getClass().getName());
            return null;
        }
        return projectWebRootProvider;
    }

    @CheckForNull
    public static File resolveTarget(FileObject webRoot, List<Pair<String, String>> mappings, FileObject source) {
        return CssPreprocessorUtils.resolveTarget(FileUtil.toFile((FileObject)webRoot), mappings, FileUtil.toFile((FileObject)source));
    }

    @CheckForNull
    public static File resolveTarget(FileObject webRoot, List<Pair<String, String>> mappings, File source) {
        return CssPreprocessorUtils.resolveTarget(FileUtil.toFile((FileObject)webRoot), mappings, source);
    }

    public static File resolveInput(FileObject webRoot, Pair<String, String> mapping) {
        return CssPreprocessorUtils.resolveFile(FileUtil.toFile((FileObject)webRoot), (String)mapping.first());
    }

    @CheckForNull
    static File resolveTarget(File root, List<Pair<String, String>> mappings, File file) {
        String name = file.getName();
        String extension = FileUtil.getExtension((String)name);
        if (!extension.isEmpty()) {
            name = name.substring(0, name.length() - (extension.length() + 1));
        }
        for (Pair<String, String> mapping : mappings) {
            String relpath;
            File from = CssPreprocessorUtils.resolveFile(root, (String)mapping.first());
            if (from.equals(file)) {
                File to = CssPreprocessorUtils.resolveFile(root, (String)mapping.second());
                if (CssPreprocessorUtils.isFileMapping(to, CSS_EXTENSION)) {
                    return to;
                }
                return CssPreprocessorUtils.resolveFile(to, CssPreprocessorUtils.makeCssFilename(name));
            }
            if (CssPreprocessorUtils.isFileMapping(from, extension)) continue;
            try {
                relpath = PropertyUtils.relativizeFile((File)from, (File)file.getParentFile());
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.INFO, "Incorrect mapping [input is existing file but directory expected]", ex);
                continue;
            }
            if (relpath == null || relpath.startsWith("..")) continue;
            File to = PropertyUtils.resolveFile((File)CssPreprocessorUtils.resolveFile(root, (String)mapping.second()), (String)relpath);
            assert (!CssPreprocessorUtils.isFileMapping(to, CSS_EXTENSION)) : to;
            return CssPreprocessorUtils.resolveFile(to, CssPreprocessorUtils.makeCssFilename(name));
        }
        return null;
    }

    static boolean isFileMapping(File file, String extension) {
        if (file.isFile()) {
            return true;
        }
        if (file.isDirectory()) {
            return false;
        }
        return file.getName().toLowerCase().endsWith("." + extension);
    }

    static File resolveFile(File directory, String subpath) {
        if ((subpath = subpath.trim()).startsWith("/")) {
            subpath = subpath.substring(1);
        }
        return PropertyUtils.resolveFile((File)directory, (String)subpath);
    }

    private static String makeCssFilename(String name) {
        return name + "." + CSS_EXTENSION;
    }

    public static final class MappingsValidator {
        private static final Pattern MAPPING_PATTERN = Pattern.compile("[^:]+");
        private final String extension;
        private final ValidationResult result = new ValidationResult();

        public MappingsValidator(String extension) {
            assert (extension != null);
            this.extension = extension;
        }

        public ValidationResult getResult() {
            return this.result;
        }

        public MappingsValidator validate(@NullAllowed FileObject root, List<Pair<String, String>> mappings) {
            File f = null;
            if (root != null) {
                f = FileUtil.toFile((FileObject)root);
            }
            return this.validate(f, mappings);
        }

        public MappingsValidator validate(@NullAllowed File root, List<Pair<String, String>> mappings) {
            this.validateMappings(root, mappings);
            return this;
        }

        private MappingsValidator validateMappings(@NullAllowed File root, List<Pair<String, String>> mappings) {
            if (root == null) {
                this.result.addError(new ValidationResult.Message((Object)"root", Bundle.MappingsValidator_warning_root_invalid()));
            }
            if (mappings.isEmpty()) {
                this.result.addError(new ValidationResult.Message((Object)"mappings", Bundle.MappingsValidator_warning_none()));
            }
            for (Pair<String, String> mapping : mappings) {
                String input = (String)mapping.first();
                if (!StringUtils.hasText(input)) {
                    this.result.addError(new ValidationResult.Message((Object)("mapping." + input), Bundle.MappingsValidator_warning_input_empty()));
                } else if (!MAPPING_PATTERN.matcher(input).matches()) {
                    this.result.addError(new ValidationResult.Message((Object)("mapping." + input), Bundle.MappingsValidator_warning_input_format(input)));
                }
                String output = (String)mapping.second();
                if (!StringUtils.hasText(output)) {
                    this.result.addError(new ValidationResult.Message((Object)("mapping." + output), Bundle.MappingsValidator_warning_output_empty()));
                } else if (!MAPPING_PATTERN.matcher(output).matches()) {
                    this.result.addError(new ValidationResult.Message((Object)("mapping." + output), Bundle.MappingsValidator_warning_output_format(output)));
                }
                if (root == null) continue;
                File inputFile = CssPreprocessorUtils.resolveFile(root, input);
                File outputFile = CssPreprocessorUtils.resolveFile(root, output);
                if (CssPreprocessorUtils.isFileMapping(inputFile, this.extension) || !CssPreprocessorUtils.isFileMapping(outputFile, CssPreprocessorUtils.CSS_EXTENSION)) continue;
                this.result.addError(new ValidationResult.Message((Object)("mapping.io." + output), Bundle.MappingsValidator_warning_io_conflict(input, output)));
            }
            return this;
        }
    }
}

