/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.SystemUtils;

public class BrowserUtils {
    private static final boolean isBrowseSupported;
    private static final Method browseMethod;
    private static final Object desktop;

    public static boolean openBrowser(URI uri) {
        LogManager.log("... opening in the browser: " + uri);
        boolean result = false;
        try {
            if (isBrowseSupported) {
                LogManager.log("... browse (bs): " + uri);
                result = BrowserUtils.browse(uri);
            } else if (SystemUtils.getNativeUtils().isBrowseSupported()) {
                LogManager.log("... browse (fb): " + uri);
                result = SystemUtils.getNativeUtils().openBrowser(uri);
            } else {
                LogManager.log("... browser is not supported");
            }
        }
        catch (Exception ex) {
            LogManager.log("Cannot open browser", (Throwable)ex);
        }
        return result;
    }

    public static boolean isBrowseSupported() {
        return isBrowseSupported || SystemUtils.getNativeUtils().isBrowseSupported();
    }

    private static boolean browse(URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("null uri");
        }
        if (!isBrowseSupported) {
            throw new UnsupportedOperationException("Browse operation is not supported");
        }
        try {
            browseMethod.invoke(desktop, uri);
            return true;
        }
        catch (IllegalAccessException e) {
            InternalError x = new InternalError("Desktop.getDesktop() method not found");
            x.initCause(e);
            throw x;
        }
        catch (InvocationTargetException e) {
            Throwable x = e.getCause();
            if (x != null) {
                if (x instanceof UnsupportedOperationException) {
                    throw (UnsupportedOperationException)x;
                }
                if (x instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)x;
                }
                if (x instanceof IOException) {
                    throw (IOException)x;
                }
                if (x instanceof SecurityException) {
                    throw (SecurityException)x;
                }
            }
            return false;
        }
    }

    public static HyperlinkListener createHyperlinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hlevt) {
                URL url;
                if (HyperlinkEvent.EventType.ACTIVATED == hlevt.getEventType() && (url = hlevt.getURL()) != null) {
                    try {
                        BrowserUtils.openBrowser(url.toURI());
                    }
                    catch (URISyntaxException e) {
                        LogManager.log(e);
                    }
                }
            }
        };
    }

    static {
        LogManager.log("Checking if java.awt.Desktop.getDesktop().browse() functionality is supported");
        boolean supported = false;
        Method browseM = null;
        Object desktopObj = null;
        try {
            Class<?> desktopCls = Class.forName("java.awt.Desktop", true, null);
            Method getDesktopM = desktopCls.getMethod("getDesktop", new Class[0]);
            browseM = desktopCls.getMethod("browse", URI.class);
            Class<?> actionCls = Class.forName("java.awt.Desktop$Action", true, null);
            Method isDesktopSupportedMethod = desktopCls.getMethod("isDesktopSupported", new Class[0]);
            Method isSupportedMethod = desktopCls.getMethod("isSupported", actionCls);
            Field browseField = actionCls.getField("BROWSE");
            Boolean result = (Boolean)isDesktopSupportedMethod.invoke(null, new Object[0]);
            if (result.booleanValue()) {
                desktopObj = getDesktopM.invoke(null, new Object[0]);
                result = (Boolean)isSupportedMethod.invoke(desktopObj, browseField.get(null));
                supported = result;
            }
        }
        catch (ClassNotFoundException e) {
            LogManager.log("... browser not supported", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LogManager.log("... browser not supported", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LogManager.log("... browser not supported", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            InternalError x = new InternalError("Desktop.getDesktop() method not found");
            x.initCause(e);
            LogManager.log("... browser not supported", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LogManager.log("... browser not supported", (Throwable)e);
        }
        isBrowseSupported = supported;
        browseMethod = browseM;
        desktop = desktopObj;
    }
}

