/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.websvc.manager.ui.ReflectionHelper;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;
import org.netbeans.modules.websvc.manager.ui.WebServiceReflectionException;
import org.openide.ErrorManager;

public class TypeCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    Component lastComponent;
    String type;
    private ClassLoader classLoader;

    public TypeCellEditor(ClassLoader loader) {
        super(new JTextField());
        this.setClickCountToStart(1);
        this.classLoader = loader;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        if (null == this.type) {
            return ((JTextField)this.lastComponent).getText();
        }
        if (this.lastComponent instanceof JTextField) {
            String valueString = ((JTextField)this.lastComponent).getText();
            Object value = this.createValue(valueString);
            return value;
        }
        if (this.lastComponent instanceof JComboBox) {
            return ((JComboBox)this.lastComponent).getSelectedItem();
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)table.getModel().getValueAt(row, 0);
        if (null == node.getUserObject()) {
            JTextField txtField = new JTextField();
            txtField.setText((String)value);
            this.lastComponent = txtField;
        } else {
            TypeNodeData data = (TypeNodeData)node.getUserObject();
            this.type = data.getTypeClass();
            if (ReflectionHelper.isSimpleType(this.type, this.classLoader)) {
                if (this.type.equalsIgnoreCase(Boolean.TYPE.getName()) || this.type.equalsIgnoreCase(Boolean.class.getName())) {
                    JComboBox<Boolean> combo;
                    this.lastComponent = combo = new JComboBox<Boolean>();
                    combo.addItem(true);
                    combo.addItem(false);
                    Object parameterValue = data.getTypeValue();
                    combo.setSelectedItem(parameterValue);
                    combo.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            TypeCellEditor.this.comboActionPerformed(evt);
                        }
                    });
                } else {
                    JTextField txtField = new JTextField();
                    if (null != value) {
                        txtField.setText(value.toString());
                    }
                    this.lastComponent = txtField;
                }
            } else if (ReflectionHelper.isEnumeration(this.type, this.classLoader)) {
                try {
                    JComboBox<Object> combo = new JComboBox<Object>();
                    List<String> enumTypes = ReflectionHelper.getEnumerationValues(this.type, this.classLoader);
                    for (String enumType : enumTypes) {
                        Object nextEnum = ReflectionHelper.getEnumeration(this.type, enumType, this.classLoader);
                        combo.addItem(nextEnum);
                    }
                    this.lastComponent = combo;
                    combo.setSelectedItem(data.getTypeValue());
                    combo.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            TypeCellEditor.this.comboActionPerformed(evt);
                        }
                    });
                }
                catch (WebServiceReflectionException wsre) {
                    Throwable cause = wsre.getCause();
                    ErrorManager.getDefault().notify(cause);
                    ErrorManager.getDefault().log(this.getClass().getName() + ": Error retrieving Enum type on: " + "WebServiceReflectionException=" + cause);
                }
            }
        }
        return this.lastComponent;
    }

    private void comboActionPerformed(ActionEvent evt) {
        this.fireEditingStopped();
    }

    private Object createValue(String inValue) {
        Object returnValue = null;
        String currentType = this.type;
        if (currentType.equalsIgnoreCase("int") || currentType.equalsIgnoreCase("java.lang.Integer")) {
            try {
                returnValue = Integer.valueOf(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = 0;
            }
        } else if (currentType.equalsIgnoreCase("byte") || currentType.equalsIgnoreCase("java.lang.Byte")) {
            try {
                returnValue = Byte.valueOf(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = Byte.valueOf("0");
            }
        } else if (currentType.equalsIgnoreCase("boolean") || currentType.equalsIgnoreCase("java.lang.Boolean")) {
            try {
                returnValue = Boolean.valueOf(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = false;
            }
        } else if (currentType.equalsIgnoreCase("float") || currentType.equalsIgnoreCase("java.lang.Float")) {
            try {
                returnValue = Float.valueOf(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = Float.valueOf(0.0f);
            }
        } else if (currentType.equalsIgnoreCase("double") || currentType.equalsIgnoreCase("java.lang.Double")) {
            try {
                returnValue = Double.valueOf(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = 0.0;
            }
        } else if (currentType.equalsIgnoreCase("long") || currentType.equalsIgnoreCase("java.lang.Long")) {
            try {
                returnValue = Long.valueOf(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = 0L;
            }
        } else if (currentType.equalsIgnoreCase("short") || currentType.equalsIgnoreCase("java.lang.Short")) {
            try {
                returnValue = Short.valueOf(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = Short.valueOf(" ");
            }
        } else if (currentType.equalsIgnoreCase("java.lang.String")) {
            returnValue = inValue;
        } else if (currentType.equalsIgnoreCase("java.math.BigDecimal")) {
            try {
                returnValue = new BigDecimal(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = BigDecimal.valueOf(0L);
            }
        } else if (currentType.equalsIgnoreCase("java.math.BigInteger")) {
            try {
                returnValue = new BigInteger(inValue);
            }
            catch (NumberFormatException nfe) {
                returnValue = new BigInteger("0");
            }
        } else if (currentType.equalsIgnoreCase("java.net.URI")) {
            try {
                returnValue = new URI(inValue);
            }
            catch (URISyntaxException uri) {
                try {
                    returnValue = new URI("http://java.sun.com");
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        } else if (currentType.equalsIgnoreCase("java.util.Calendar")) {
            returnValue = Calendar.getInstance();
        } else if (currentType.equalsIgnoreCase("java.util.Date")) {
            try {
                returnValue = DateFormat.getInstance().parse(inValue);
            }
            catch (ParseException pe) {
                returnValue = new Date();
            }
        }
        return returnValue;
    }
}

