/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.DirectoryEntry;
import org.clang.basic.llvm.DenseMapInfoFileEntry;
import org.clang.basic.vfs.File;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.DenseMapInfoObject;
import org.llvm.adt.StringRef;
import org.llvm.support.sys.fs;

public class FileEntry
implements Destructors.ClassWithDestructor,
Native.NativePOD<FileEntry>,
Native.ComparableLower {
    public static final DenseMapInfo<FileEntry> DenseMapInfo;
    char.ptr Name;
    int NameLen;
    std.string RealPathName;
    long Size;
    long ModTime;
    DirectoryEntry Dir;
    public int UID = Integer.MIN_VALUE;
    fs.UniqueID UniqueID;
    boolean IsNamedPipe;
    boolean InPCH;
    boolean IsValid;
    std_ptr.unique_ptr<File> File;

    public FileEntry(fs.UniqueID UniqueID2) {
        this.UniqueID = UniqueID2;
        this.IsNamedPipe = false;
        this.InPCH = false;
        this.IsValid = false;
        this.File = new std_ptr.unique_ptr();
    }

    public FileEntry $assign(FileEntry $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public FileEntry() {
        this.RealPathName = new std.string();
        this.UniqueID = new fs.UniqueID(0L, 0L);
        this.IsNamedPipe = false;
        this.InPCH = false;
        this.IsValid = false;
        this.File = new std_ptr.unique_ptr();
    }

    public FileEntry(FileEntry FE) {
        this.RealPathName = new std.string();
        this.UniqueID = new fs.UniqueID(FE.UniqueID);
        this.IsNamedPipe = FE.IsNamedPipe;
        this.InPCH = FE.InPCH;
        this.IsValid = FE.IsValid;
        this.File = new std_ptr.unique_ptr();
        assert (!this.isValid()) : "Cannot copy an initialized FileEntry";
    }

    public char.ptr getName() {
        return this.Name;
    }

    public StringRef tryGetRealPathName() {
        return new StringRef(this.RealPathName);
    }

    public boolean isValid() {
        return this.IsValid;
    }

    public long getSize() {
        return this.Size;
    }

    public int getUID() {
        return this.UID;
    }

    public fs.UniqueID getUniqueID() {
        return this.UniqueID;
    }

    public boolean isInPCH() {
        return this.InPCH;
    }

    public long getModificationTime() {
        return this.ModTime;
    }

    public DirectoryEntry getDir() {
        return this.Dir;
    }

    public boolean $less(Object RHS) {
        return this.UniqueID.$less((Object)((FileEntry)RHS).UniqueID);
    }

    public boolean $lesseq(Object RHS) {
        return this.UniqueID.$less((Object)((FileEntry)RHS).UniqueID) || !((FileEntry)RHS).UniqueID.$less((Object)this.UniqueID);
    }

    public boolean isNamedPipe() {
        return this.IsNamedPipe;
    }

    public void closeFile() {
        this.File.reset();
    }

    public void $destroy() {
        this.File.$destroy();
        this.RealPathName.$destroy();
    }

    public FileEntry clone() {
        return new FileEntry(this);
    }

    public boolean $noteq(FileEntry other) {
        return !this.$eq(other);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + this.UniqueID.hashCode();
        hash = 67 * hash + (this.IsNamedPipe ? 1 : 0);
        hash = 67 * hash + (this.InPCH ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileEntry other = (FileEntry)obj;
        return this.$eq(other);
    }

    public boolean $eq(FileEntry other) {
        if (other == null) {
            return false;
        }
        if (!this.UniqueID.equals((Object)other.UniqueID)) {
            return false;
        }
        if (this.IsNamedPipe != other.IsNamedPipe) {
            return false;
        }
        return this.InPCH == other.InPCH;
    }

    public String toString() {
        if (this.UID == -1) {
            assert (this == DenseMapInfo.getEmptyKey());
            return "EMPTY_FILE_ENTRY";
        }
        if (this.UID == -2) {
            assert (this == DenseMapInfo.getTombstoneKey());
            return "TOMBSTONE_FILE_ENTRY";
        }
        return "FileEntry{\nName=" + Casts.toCharSequence((char.ptr)this.Name) + ", RealPathName=" + this.RealPathName + ", Size=" + this.Size + ", ModTime=" + this.ModTime + ",\nDir=" + this.Dir + ",\nUID=" + this.UID + ", UniqueID=" + this.UniqueID + ", IsNamedPipe=" + this.IsNamedPipe + ", InPCH=" + this.InPCH + ", IsValid=" + this.IsValid + ", File=" + this.File + "\n}";
    }

    static {
        FileEntry emptyKey = new FileEntry();
        assert (emptyKey.UID == Integer.MIN_VALUE) : "UID must be assigned only once " + emptyKey;
        emptyKey.UID = -1;
        FileEntry tombstoneKey = new FileEntry();
        assert (tombstoneKey.UID == Integer.MIN_VALUE) : "UID must be assigned only once " + tombstoneKey;
        tombstoneKey.UID = -2;
        DenseMapInfo = NativeTrace.OPTIMIZE_DENSE_MAP_INFO ? new DenseMapInfoFileEntry(emptyKey, tombstoneKey) : new DenseMapInfoObject((Object)emptyKey, (Object)tombstoneKey);
    }
}

