/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clang.basic.FileManager;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.impl.ModuleStatics;
import org.clang.basic.java.ClankAliases;
import org.clang.basic.target.TargetInfo;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.java.stdimpl.aliases.StdVectorString;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.DenseMapInfoObject;
import org.llvm.adt.PointerUnion;
import org.llvm.adt.SmallSetVector;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseSet;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMapConstIteratorUInt;
import org.llvm.adt.aliases.StringMapIteratorUInt;
import org.llvm.adt.aliases.StringMapUInt;
import org.llvm.adt.iterator_range;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class Module
implements Destructors.ClassWithDestructor {
    public static final DenseMapInfo<Module> DenseMapInfo = new DenseMapInfoObject((Object)new Module(), (Object)new Module());
    public std.string Name;
    public SourceLocation DefinitionLoc;
    public Module Parent;
    private static final DenseMapInfo<Module> DenseMapInfoModule = new DenseMapInfoObject((Object)new Module(), (Object)new Module());
    public DirectoryEntry Directory;
    public PointerUnion<DirectoryEntry, FileEntry> Umbrella;
    public long Signature;
    public std.string UmbrellaAsWritten;
    private std.vector<Module> SubModules;
    private StringMapUInt SubModuleIndex;
    private FileEntry ASTFile;
    private SmallSetVector<FileEntry> TopHeaders;
    private std.vectorString TopHeaderNames;
    private DenseSet<Module> VisibleModulesCache;
    private int VisibilityID;
    public static int NumHeaderKinds = HeaderKind.HK_Excluded.getValue() + 1;
    public SmallVector<Header>[] Headers = new SmallVector[5];
    public SmallVector<UnresolvedHeaderDirective> MissingHeaders;
    public SmallVector<Requirement> Requirements;
    public boolean IsMissingRequirement;
    public boolean HasIncompatibleModuleFile;
    public boolean IsAvailable;
    public boolean IsFromModuleFile;
    public boolean IsFramework;
    public boolean IsExplicit;
    public boolean IsSystem;
    public boolean IsExternC;
    public boolean IsInferred;
    public boolean InferSubmodules;
    public boolean InferExplicitSubmodules;
    public boolean InferExportWildcard;
    public boolean ConfigMacrosExhaustive;
    public NameVisibilityKind NameVisibility;
    public SourceLocation InferredSubmoduleLoc;
    public SmallSetVector<Module> Imports;
    public SmallVector<ADTAliases.PointerInt2Pair<Module>> Exports;
    public SmallVector<UnresolvedExportDecl> UnresolvedExports;
    public SmallVector<Module> DirectUses;
    public SmallVector<ClankAliases.ModuleId> UnresolvedDirectUses;
    public SmallVector<LinkLibrary> LinkLibraries;
    public std.vectorString ConfigMacros;
    public std.vector<UnresolvedConflict> UnresolvedConflicts;
    public std.vector<Conflict> Conflicts;

    public Module() {
    }

    public Module(StringRef Name, SourceLocation DefinitionLoc, Module Parent, boolean IsFramework, boolean IsExplicit, int VisibilityID) {
        this.Name = Name.$basic_string();
        this.DefinitionLoc = new SourceLocation(DefinitionLoc);
        this.Parent = Parent;
        this.Directory = null;
        this.Umbrella = new PointerUnion(DirectoryEntry.class, FileEntry.class);
        this.Signature = 0L;
        this.UmbrellaAsWritten = new std.string();
        this.SubModules = new std.vector((Object)null);
        this.SubModuleIndex = new StringMapUInt(0);
        this.ASTFile = null;
        this.TopHeaders = new SmallSetVector(2, (Object)null);
        this.TopHeaderNames = new std.vectorString(std.string.EMPTY);
        this.VisibleModulesCache = new DenseSet(DenseMapInfoModule);
        this.VisibilityID = VisibilityID;
        this.Headers = (SmallVector[])NativePointer.new$T((Object[])new SmallVector[5], () -> new SmallVector(2, (Object)Header.EMPTY));
        this.MissingHeaders = new SmallVector(1, (Object)new UnresolvedHeaderDirective());
        this.Requirements = new SmallVector(2, (Object)new Requirement());
        this.IsMissingRequirement = false;
        this.HasIncompatibleModuleFile = false;
        this.IsAvailable = true;
        this.IsFromModuleFile = false;
        this.IsFramework = IsFramework;
        this.IsExplicit = IsExplicit;
        this.IsSystem = false;
        this.IsExternC = false;
        this.IsInferred = false;
        this.InferSubmodules = false;
        this.InferExplicitSubmodules = false;
        this.InferExportWildcard = false;
        this.ConfigMacrosExhaustive = false;
        this.NameVisibility = NameVisibilityKind.Hidden;
        this.InferredSubmoduleLoc = new SourceLocation();
        this.Imports = new SmallSetVector(2, (Object)null);
        this.Exports = new SmallVector(2, (Object)new ADTAliases.PointerInt2Pair());
        this.UnresolvedExports = new SmallVector(2, (Object)new UnresolvedExportDecl());
        this.DirectUses = new SmallVector(2, (Object)null);
        this.UnresolvedDirectUses = new SmallVector(2, (Object)new ClankAliases.ModuleId());
        this.LinkLibraries = new SmallVector(2, (Object)new LinkLibrary());
        this.ConfigMacros = new std.vectorString(std.string.EMPTY);
        this.UnresolvedConflicts = new std.vector((Object)new UnresolvedConflict());
        this.Conflicts = new std.vector((Object)new Conflict());
        if (Parent != null) {
            if (!Parent.isAvailable()) {
                this.IsAvailable = false;
            }
            if (Parent.IsSystem) {
                this.IsSystem = true;
            }
            if (Parent.IsExternC) {
                this.IsExternC = true;
            }
            this.IsMissingRequirement = Parent.IsMissingRequirement;
            Parent.SubModuleIndex.$set(Name, Parent.SubModules.size());
            Parent.SubModules.push_back((Object)this);
        }
    }

    public void $destroy() {
        StdVector.iterator<Module> I = this.submodule_begin();
        StdVector.iterator<Module> IEnd = this.submodule_end();
        while (std.$noteq___normal_iterator$C(I, IEnd)) {
            if (I.$star() != null) {
                ((Module)I.$star()).$destroy();
            }
            I.$preInc();
        }
        this.Conflicts.$destroy();
        this.UnresolvedConflicts.$destroy();
        this.ConfigMacros.$destroy();
        this.LinkLibraries.$destroy();
        this.UnresolvedDirectUses.$destroy();
        this.DirectUses.$destroy();
        this.UnresolvedExports.$destroy();
        this.Exports.$destroy();
        this.Imports.$destroy();
        this.Requirements.$destroy();
        this.MissingHeaders.$destroy();
        Destructors.$destroyArray(this.Headers);
        this.VisibleModulesCache.$destroy();
        this.TopHeaderNames.$destroy();
        this.TopHeaders.$destroy();
        this.SubModuleIndex.$destroy();
        this.SubModules.$destroy();
        this.UmbrellaAsWritten.$destroy();
        this.Name.$destroy();
    }

    public boolean isAvailable() {
        return this.IsAvailable;
    }

    public boolean isAvailable(LangOptions LangOpts, TargetInfo Target, std_pair.pairTypeBool<std.string> Req, UnresolvedHeaderDirective MissingHeader) {
        if (this.IsAvailable) {
            return true;
        }
        Module Current = this;
        while (Current != null) {
            int N = Current.Requirements.size();
            for (int I = 0; I != N; ++I) {
                if (ModuleStatics.hasFeature(new StringRef((std.string)((Requirement)((Object)Current.Requirements.$at((int)I))).first), LangOpts, Target) == ((Requirement)((Object)Current.Requirements.$at((int)I))).second) continue;
                Req.$assign((std_pair.pairTypeBool)Current.Requirements.$at(I));
                return false;
            }
            if (!Current.MissingHeaders.empty()) {
                MissingHeader.$assign((UnresolvedHeaderDirective)Current.MissingHeaders.front());
                return false;
            }
            Current = Current.Parent;
        }
        throw new llvm_unreachable("could not find a reason why module is unavailable");
    }

    public boolean isSubModule() {
        return this.Parent != null;
    }

    public boolean isSubModuleOf(Module Other) {
        Module This = this;
        do {
            if (This != Other) continue;
            return true;
        } while ((This = This.Parent) != null);
        return false;
    }

    public boolean isPartOfFramework() {
        Module Mod = this;
        while (Mod != null) {
            if (Mod.IsFramework) {
                return true;
            }
            Mod = Mod.Parent;
        }
        return false;
    }

    public boolean isSubFramework() {
        return this.IsFramework && this.Parent != null && this.Parent.isPartOfFramework();
    }

    public std.string getFullModuleName() {
        SmallVector Names = new SmallVector(2, (Object)new StringRef());
        Module M = this;
        while (M != null) {
            Names.push_back((Object)new StringRef(M.Name));
            M = M.Parent;
        }
        std.string Result = new std.string();
        std.reverse_iterator I = Names.rbegin();
        std.reverse_iterator IEnd = Names.rend();
        while (ADTAliases.$noteq_reverse_iterator$C((abstract_iterator)I, (abstract_iterator)IEnd)) {
            if (!Result.empty()) {
                Result.$addassign((byte)46);
            }
            llvm.$addassign_str_StringRef((std.string)Result, (StringRef)((StringRef)I.$star()));
            I.$preInc();
        }
        return Result;
    }

    public boolean fullModuleNameIs(ArrayRef<StringRef> nameParts) {
        Module M = this;
        while (M != null) {
            if (nameParts.empty() || llvm.$noteq_StringRef((StringRef)new StringRef(M.Name), (StringRef)((StringRef)nameParts.back()))) {
                return false;
            }
            nameParts.$assignMove(nameParts.drop_back());
            M = M.Parent;
        }
        return nameParts.empty();
    }

    public Module getTopLevelModule() {
        Module Result = this;
        while (Result.Parent != null) {
            Result = Result.Parent;
        }
        return Result;
    }

    public StringRef getTopLevelModuleName() {
        return new StringRef(this.getTopLevelModule().Name);
    }

    public FileEntry getASTFile() {
        return this.getTopLevelModule().ASTFile;
    }

    public void setASTFile(FileEntry File2) {
        assert (File2 == null || this.getASTFile() == null || this.getASTFile() == File2) : "file path changed";
        this.getTopLevelModule().ASTFile = File2;
    }

    public DirectoryName getUmbrellaDir() {
        Header U = null;
        try {
            U = this.getUmbrellaHeader();
            if (U.$bool()) {
                DirectoryName directoryName = new DirectoryName(NativePointer.$EMPTY, U.Entry.getDir());
                return directoryName;
            }
        }
        finally {
            if (U != null) {
                U.$destroy();
            }
        }
        return new DirectoryName(this.UmbrellaAsWritten, (DirectoryEntry)this.Umbrella.dyn_cast(DirectoryEntry.class));
    }

    public Header getUmbrellaHeader() {
        FileEntry E = (FileEntry)this.Umbrella.dyn_cast(FileEntry.class);
        if (E != null) {
            return new Header(this.UmbrellaAsWritten, E);
        }
        return new Header();
    }

    public boolean hasUmbrellaDir() {
        return this.Umbrella.$bool() && this.Umbrella.is(DirectoryEntry.class) != 0;
    }

    public void addTopHeader(FileEntry File2) {
        assert (File2 != null);
        this.TopHeaders.insert((Object)File2);
    }

    public void addTopHeaderFilename(StringRef Filename) {
        this.TopHeaderNames.push_back(Filename.$basic_string());
    }

    public ArrayRef<FileEntry> getTopHeaders(FileManager FileMgr) {
        if (!this.TopHeaderNames.empty()) {
            StdVectorString.iterator I = this.TopHeaderNames.begin();
            StdVectorString.iterator E = this.TopHeaderNames.end();
            while (std.$noteq___normal_iterator$C((abstract_iterator)I, (abstract_iterator)E)) {
                FileEntry FE = FileMgr.getFile(new StringRef(I.$star()));
                if (FE != null) {
                    this.TopHeaders.insert((Object)FE);
                }
                I.$preInc();
            }
            this.TopHeaderNames.clear();
        }
        return llvm.makeArrayRef((type.iterator)this.TopHeaders.begin(), (type.iterator)this.TopHeaders.end());
    }

    public boolean directlyUses(Module Requested) {
        Module Top = this.getTopLevelModule();
        if (Requested.isSubModuleOf(Top)) {
            return true;
        }
        for (Module Use : Top.DirectUses) {
            if (!Requested.isSubModuleOf(Use)) continue;
            return true;
        }
        return false;
    }

    public void addRequirement(StringRef Feature2, boolean RequiredState, LangOptions LangOpts, TargetInfo Target) {
        this.Requirements.push_back((Object)new Requirement(Feature2.$basic_string(), RequiredState));
        if (ModuleStatics.hasFeature(new StringRef(Feature2), LangOpts, Target) == RequiredState) {
            return;
        }
        this.markUnavailable(true);
    }

    public void markUnavailable() {
        this.markUnavailable(false);
    }

    public void markUnavailable(boolean MissingRequirement) {
        markUnavailable_lambda needUpdate = M -> M.IsAvailable || !M.IsMissingRequirement && MissingRequirement;
        if (!needUpdate.$call(this)) {
            return;
        }
        SmallVector Stack = new SmallVector(2, (Object)null);
        Stack.push_back((Object)this);
        while (!Stack.empty()) {
            Module Current = (Module)Stack.back();
            Stack.pop_back();
            if (!needUpdate.$call(Current)) continue;
            Current.IsAvailable = false;
            Current.IsMissingRequirement |= MissingRequirement;
            StdVector.iterator<Module> Sub = Current.submodule_begin();
            StdVector.iterator<Module> SubEnd = Current.submodule_end();
            while (std.$noteq___normal_iterator$C(Sub, SubEnd)) {
                if (needUpdate.$call((Module)Sub.$star())) {
                    Stack.push_back(Sub.$star());
                }
                Sub.$preInc();
            }
        }
    }

    public Module findSubmodule(StringRef Name) {
        StringMapIteratorUInt Pos = this.SubModuleIndex.find(Name);
        if (Pos.$eq((StringMapConstIteratorUInt)this.SubModuleIndex.end())) {
            return null;
        }
        return (Module)this.SubModules.$at(Pos.$arrow().getValue());
    }

    public boolean isModuleVisible(Module M) {
        if (this.VisibleModulesCache.empty()) {
            this.buildVisibleModulesCache();
        }
        return this.VisibleModulesCache.count((Object)M) != 0;
    }

    public int getVisibilityID() {
        return this.VisibilityID;
    }

    public StdVector.iterator<Module> submodule_begin() {
        return this.SubModules.begin();
    }

    public StdVector.iterator<Module> submodule_end() {
        return this.SubModules.end();
    }

    public iterator_range<Module> submodules() {
        return llvm.make_range(this.submodule_begin(), this.submodule_end());
    }

    public void getExportedModules(SmallVectorImpl<Module> Exported) {
        Module Mod;
        int I;
        StdVector.iterator I2 = this.SubModules.begin();
        StdVector.iterator E = this.SubModules.end();
        while (std.$noteq___normal_iterator((StdVector.iterator)I2, (StdVector.iterator)E)) {
            Module Mod2 = (Module)I2.$star();
            if (!Mod2.IsExplicit) {
                Exported.push_back((Object)Mod2);
            }
            I2.$preInc();
        }
        boolean AnyWildcard = false;
        boolean UnrestrictedWildcard = false;
        SmallVector WildcardRestrictions = new SmallVector(4, (Object)null);
        int N = this.Exports.size();
        for (I = 0; I != N; ++I) {
            Mod = (Module)((ADTAliases.PointerInt2Pair)this.Exports.$at(I)).getPointer();
            if (((ADTAliases.PointerInt2Pair)this.Exports.$at(I)).getInt() == 0) {
                Exported.push_back((Object)Mod);
                continue;
            }
            AnyWildcard = true;
            if (UnrestrictedWildcard) continue;
            Module Restriction = (Module)((ADTAliases.PointerInt2Pair)this.Exports.$at(I)).getPointer();
            if (Restriction != null) {
                WildcardRestrictions.push_back((Object)Restriction);
                continue;
            }
            WildcardRestrictions.clear();
            UnrestrictedWildcard = true;
        }
        if (!AnyWildcard) {
            return;
        }
        N = this.Imports.size();
        for (I = 0; I != N; ++I) {
            Mod = (Module)this.Imports.$at(I);
            boolean Acceptable = UnrestrictedWildcard;
            if (!Acceptable) {
                int NR = WildcardRestrictions.size();
                for (int R = 0; R != NR; ++R) {
                    Module Restriction = (Module)WildcardRestrictions.$at(R);
                    if (Mod != Restriction && !Mod.isSubModuleOf(Restriction)) continue;
                    Acceptable = true;
                    break;
                }
            }
            if (!Acceptable) continue;
            Exported.push_back((Object)Mod);
        }
    }

    public static StringRef getModuleInputBufferName() {
        return new StringRef("<module-includes>");
    }

    public void print(raw_ostream OS) {
        this.print(OS, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(raw_ostream OS, int Indent) {
        int I;
        class Unnamed_struct {
            public StringRef Prefix;
            public HeaderKind Kind;

            public Unnamed_struct(StringRef Prefix, HeaderKind Kind2) {
                this.Prefix = Prefix;
                this.Kind = Kind2;
            }

            public String toString() {
                return "Prefix=" + this.Prefix + ", Kind=" + (Object)((Object)this.Kind);
            }
        }
        Unnamed_struct[] Kinds;
        block42: {
            OS.indent(Indent);
            if (this.IsFramework) {
                OS.$out("framework ");
            }
            if (this.IsExplicit) {
                OS.$out("explicit ");
            }
            OS.$out("module ").$out(this.Name);
            if (this.IsSystem || this.IsExternC) {
                OS.indent(Indent + 2);
                if (this.IsSystem) {
                    OS.$out(" [system]");
                }
                if (this.IsExternC) {
                    OS.$out(" [extern_c]");
                }
            }
            OS.$out(" {\n");
            if (!this.Requirements.empty()) {
                OS.indent(Indent + 2);
                OS.$out("requires ");
                int N = this.Requirements.size();
                for (int I2 = 0; I2 != N; ++I2) {
                    if (I2 != 0) {
                        OS.$out(NativePointer.$COMMA_SPACE);
                    }
                    if (!((Requirement)((Object)this.Requirements.$at((int)I2))).second) {
                        OS.$out(NativePointer.$EXCLAIM);
                    }
                    OS.$out((std.string)((Requirement)((Object)this.Requirements.$at((int)I2))).first);
                }
                OS.$out(NativePointer.$LF);
            }
            Header H = null;
            try {
                H = this.getUmbrellaHeader();
                if (H.$bool()) {
                    OS.indent(Indent + 2);
                    OS.$out("umbrella header \"");
                    OS.write_escaped(new StringRef(H.NameAsWritten));
                    OS.$out(NativePointer.$QUOTE_LF);
                    break block42;
                }
                DirectoryName D = null;
                try {
                    D = this.getUmbrellaDir();
                    if (D.$bool()) {
                        OS.indent(Indent + 2);
                        OS.$out("umbrella \"");
                        OS.write_escaped(new StringRef(D.NameAsWritten));
                        OS.$out(NativePointer.$QUOTE_LF);
                    }
                }
                finally {
                    if (D != null) {
                        D.$destroy();
                    }
                }
            }
            finally {
                if (H != null) {
                    H.$destroy();
                }
            }
        }
        if (!this.ConfigMacros.empty() || this.ConfigMacrosExhaustive) {
            OS.indent(Indent + 2);
            OS.$out("config_macros ");
            if (this.ConfigMacrosExhaustive) {
                OS.$out("[exhaustive]");
            }
            int N = this.ConfigMacros.size();
            for (int I3 = 0; I3 != N; ++I3) {
                if (I3 != 0) {
                    OS.$out(NativePointer.$COMMA_SPACE);
                }
                OS.$out(this.ConfigMacros.$at(I3));
            }
            OS.$out(NativePointer.$LF);
        }
        for (Unnamed_struct K : Kinds = new Unnamed_struct[]{new Unnamed_struct(new StringRef(""), HeaderKind.HK_Normal), new Unnamed_struct(new StringRef("textual "), HeaderKind.HK_Textual), new Unnamed_struct(new StringRef("private "), HeaderKind.HK_Private), new Unnamed_struct(new StringRef("private textual "), HeaderKind.HK_PrivateTextual), new Unnamed_struct(new StringRef("exclude "), HeaderKind.HK_Excluded)}) {
            for (Header H : this.Headers[K.Kind.getValue()]) {
                OS.indent(Indent + 2);
                OS.$out(K.Prefix).$out("header \"");
                OS.write_escaped(new StringRef(H.NameAsWritten));
                OS.$out(NativePointer.$QUOTE_LF);
            }
        }
        StdVector.iterator<Module> MI = this.submodule_begin();
        StdVector.iterator<Module> MIEnd = this.submodule_end();
        while (std.$noteq___normal_iterator$C(MI, MIEnd)) {
            if (!((Module)MI.$star()).IsInferred || ((Module)MI.$star()).IsFramework) {
                ((Module)MI.$star()).print(OS, Indent + 2);
            }
            MI.$preInc();
        }
        int N = this.Exports.size();
        for (I = 0; I != N; ++I) {
            OS.indent(Indent + 2);
            OS.$out("export ");
            Module Restriction = (Module)((ADTAliases.PointerInt2Pair)this.Exports.$at(I)).getPointer();
            if (Restriction != null) {
                OS.$out(Restriction.getFullModuleName());
                if (((ADTAliases.PointerInt2Pair)this.Exports.$at(I)).getInt() != 0) {
                    OS.$out(NativePointer.$DOT_STAR);
                }
            } else {
                OS.$out(NativePointer.$STAR);
            }
            OS.$out(NativePointer.$LF);
        }
        N = this.UnresolvedExports.size();
        for (I = 0; I != N; ++I) {
            OS.indent(Indent + 2);
            OS.$out("export ");
            ModuleStatics.printModuleId(OS, ((UnresolvedExportDecl)this.UnresolvedExports.$at((int)I)).Id);
            if (((UnresolvedExportDecl)this.UnresolvedExports.$at((int)I)).Wildcard) {
                OS.$out(((UnresolvedExportDecl)this.UnresolvedExports.$at((int)I)).Id.empty() ? NativePointer.$STAR : NativePointer.$DOT_STAR);
            }
            OS.$out(NativePointer.$LF);
        }
        N = this.DirectUses.size();
        for (I = 0; I != N; ++I) {
            OS.indent(Indent + 2);
            OS.$out("use ");
            OS.$out(((Module)this.DirectUses.$at(I)).getFullModuleName());
            OS.$out(NativePointer.$LF);
        }
        N = this.UnresolvedDirectUses.size();
        for (I = 0; I != N; ++I) {
            OS.indent(Indent + 2);
            OS.$out("use ");
            ModuleStatics.printModuleId(OS, (ClankAliases.ModuleId)((Object)this.UnresolvedDirectUses.$at(I)));
            OS.$out(NativePointer.$LF);
        }
        N = this.LinkLibraries.size();
        for (I = 0; I != N; ++I) {
            OS.indent(Indent + 2);
            OS.$out("link ");
            if (((LinkLibrary)this.LinkLibraries.$at((int)I)).IsFramework) {
                OS.$out("framework ");
            }
            OS.$out(NativePointer.$DBL_QUOTE);
            OS.write_escaped(new StringRef(((LinkLibrary)this.LinkLibraries.$at((int)I)).Library));
            OS.$out(NativePointer.$DBL_QUOTE);
        }
        N = this.UnresolvedConflicts.size();
        for (I = 0; I != N; ++I) {
            OS.indent(Indent + 2);
            OS.$out("conflict ");
            ModuleStatics.printModuleId(OS, ((UnresolvedConflict)this.UnresolvedConflicts.$at((int)I)).Id);
            OS.$out(", \"");
            OS.write_escaped(new StringRef(((UnresolvedConflict)this.UnresolvedConflicts.$at((int)I)).Message));
            OS.$out(NativePointer.$QUOTE_LF);
        }
        N = this.Conflicts.size();
        for (I = 0; I != N; ++I) {
            OS.indent(Indent + 2);
            OS.$out("conflict ");
            OS.$out(((Conflict)this.Conflicts.$at((int)I)).Other.getFullModuleName());
            OS.$out(", \"");
            OS.write_escaped(new StringRef(((Conflict)this.Conflicts.$at((int)I)).Message));
            OS.$out(NativePointer.$QUOTE_LF);
        }
        if (this.InferSubmodules) {
            OS.indent(Indent + 2);
            if (this.InferExplicitSubmodules) {
                OS.$out("explicit ");
            }
            OS.$out("module * {\n");
            if (this.InferExportWildcard) {
                OS.indent(Indent + 4);
                OS.$out("export *\n");
            }
            OS.indent(Indent + 2);
            OS.$out("}\n");
        }
        OS.indent(Indent);
        OS.$out("}\n");
    }

    public void dump() {
        this.print(llvm.errs());
    }

    private void buildVisibleModulesCache() {
        assert (this.VisibleModulesCache.empty()) : "cache does not need building";
        this.VisibleModulesCache.insert((Object)this);
        SmallVector Stack = new SmallVector(16, (type.iterator)this.Imports.begin(), (type.iterator)this.Imports.end(), (Object)null);
        while (!Stack.empty()) {
            Module CurrModule = (Module)Stack.pop_back_val();
            if (!this.VisibleModulesCache.insert((Object)CurrModule).second) continue;
            CurrModule.getExportedModules((SmallVectorImpl<Module>)Stack);
        }
    }

    public String toString() {
        return "Name=" + this.Name + ", DefinitionLoc=" + this.DefinitionLoc + ", Parent=" + this.Parent + ", Directory=" + this.Directory + ", Umbrella=" + this.Umbrella + ", Signature=" + this.Signature + ", UmbrellaAsWritten=" + this.UmbrellaAsWritten + ", SubModules=" + this.SubModules + ", SubModuleIndex=" + this.SubModuleIndex + ", ASTFile=" + this.ASTFile + ", TopHeaders=" + this.TopHeaders + ", TopHeaderNames=" + this.TopHeaderNames + ", VisibleModulesCache=" + this.VisibleModulesCache + ", VisibilityID=" + this.VisibilityID + ", Headers=" + this.Headers + ", MissingHeaders=" + this.MissingHeaders + ", Requirements=" + this.Requirements + ", IsMissingRequirement=" + this.IsMissingRequirement + ", HasIncompatibleModuleFile=" + this.HasIncompatibleModuleFile + ", IsAvailable=" + this.IsAvailable + ", IsFromModuleFile=" + this.IsFromModuleFile + ", IsFramework=" + this.IsFramework + ", IsExplicit=" + this.IsExplicit + ", IsSystem=" + this.IsSystem + ", IsExternC=" + this.IsExternC + ", IsInferred=" + this.IsInferred + ", InferSubmodules=" + this.InferSubmodules + ", InferExplicitSubmodules=" + this.InferExplicitSubmodules + ", InferExportWildcard=" + this.InferExportWildcard + ", ConfigMacrosExhaustive=" + this.ConfigMacrosExhaustive + ", NameVisibility=" + (Object)((Object)this.NameVisibility) + ", InferredSubmoduleLoc=" + this.InferredSubmoduleLoc + ", Imports=" + this.Imports + ", Exports=" + this.Exports + ", UnresolvedExports=" + this.UnresolvedExports + ", DirectUses=" + this.DirectUses + ", UnresolvedDirectUses=" + this.UnresolvedDirectUses + ", LinkLibraries=" + this.LinkLibraries + ", ConfigMacros=" + this.ConfigMacros + ", UnresolvedConflicts=" + this.UnresolvedConflicts + ", Conflicts=" + this.Conflicts;
    }

    @FunctionalInterface
    private static interface markUnavailable_lambda {
        public boolean $call(Module var1);
    }

    public static class Conflict
    implements Destructors.ClassWithDestructor {
        public Module Other;
        public std.string Message;

        public void $destroy() {
            this.Message.$destroy();
        }

        public Conflict(Conflict $Prm0) {
            this.Other = $Prm0.Other;
            this.Message = new std.string($Prm0.Message);
        }

        public Conflict(JavaDifferentiators.JD.Move _dparam, Conflict $Prm0) {
            this.Other = $Prm0.Other;
            this.Message = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Message);
        }

        public Conflict() {
            this.Message = new std.string();
        }

        public String toString() {
            return "Other=" + this.Other + ", Message=" + this.Message;
        }
    }

    public static class UnresolvedConflict
    implements Destructors.ClassWithDestructor {
        public ClankAliases.ModuleId Id;
        public std.string Message;

        public void $destroy() {
            this.Message.$destroy();
            this.Id.$destroy();
        }

        public UnresolvedConflict(UnresolvedConflict $Prm0) {
            this.Id = new ClankAliases.ModuleId($Prm0.Id);
            this.Message = new std.string($Prm0.Message);
        }

        public UnresolvedConflict() {
            this.Id = new ClankAliases.ModuleId();
            this.Message = new std.string();
        }

        public String toString() {
            return "Id=" + (Object)((Object)this.Id) + ", Message=" + this.Message;
        }
    }

    public static class LinkLibrary
    implements Destructors.ClassWithDestructor,
    Native.NativePOD<LinkLibrary> {
        public std.string Library;
        public boolean IsFramework;

        public LinkLibrary() {
            this.Library = new std.string();
            this.IsFramework = false;
        }

        public LinkLibrary(std.string Library, boolean IsFramework) {
            this.Library = new std.string(Library);
            this.IsFramework = IsFramework;
        }

        public void $destroy() {
            this.Library.$destroy();
        }

        public LinkLibrary(JavaDifferentiators.JD.Move _dparam, LinkLibrary $Prm0) {
            this.Library = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Library);
            this.IsFramework = $Prm0.IsFramework;
        }

        public String toString() {
            return "Library=" + this.Library + ", IsFramework=" + this.IsFramework;
        }

        public LinkLibrary $assign(LinkLibrary other) {
            this.Library.$assign(other.Library);
            this.IsFramework = other.IsFramework;
            return this;
        }

        public LinkLibrary clone() {
            return new LinkLibrary(this.Library, this.IsFramework);
        }

        public boolean $noteq(LinkLibrary other) {
            return !this.$eq(other);
        }

        public boolean $eq(LinkLibrary other) {
            return this.IsFramework == other.IsFramework && this.Library.$eq((Object)other.Library);
        }
    }

    public static class UnresolvedExportDecl
    implements Native.NativePOD<UnresolvedExportDecl> {
        public SourceLocation ExportLoc;
        public ClankAliases.ModuleId Id;
        public boolean Wildcard;

        public void $destroy() {
            this.Id.$destroy();
        }

        public UnresolvedExportDecl(JavaDifferentiators.JD.Move _dparam, UnresolvedExportDecl $Prm0) {
            this.ExportLoc = $Prm0.ExportLoc;
            this.Id = $Prm0.Id;
            this.Wildcard = $Prm0.Wildcard;
        }

        public UnresolvedExportDecl $assignMove(UnresolvedExportDecl $Prm0) {
            this.ExportLoc.$assignMove($Prm0.ExportLoc);
            this.Id.$assignMove((SmallVectorImpl)$Prm0.Id);
            this.Wildcard = $Prm0.Wildcard;
            return this;
        }

        public UnresolvedExportDecl(UnresolvedExportDecl $Prm0) {
            this.ExportLoc = new SourceLocation($Prm0.ExportLoc);
            this.Id = new ClankAliases.ModuleId($Prm0.Id);
            this.Wildcard = $Prm0.Wildcard;
        }

        public UnresolvedExportDecl(SourceLocation ExportLoc, ClankAliases.ModuleId Id, boolean Wildcard) {
            this.ExportLoc = new SourceLocation(ExportLoc);
            this.Id = Id;
            this.Wildcard = Wildcard;
        }

        public UnresolvedExportDecl() {
            this.ExportLoc = new SourceLocation();
            this.Id = new ClankAliases.ModuleId();
            this.Wildcard = false;
        }

        public String toString() {
            return "ExportLoc=" + this.ExportLoc + ", Id=" + (Object)((Object)this.Id) + ", Wildcard=" + this.Wildcard;
        }

        public UnresolvedExportDecl $assign(UnresolvedExportDecl other) {
            this.ExportLoc.$assign(other.ExportLoc);
            this.Id.$assign((SmallVectorImpl)other.Id);
            this.Wildcard = other.Wildcard;
            return this;
        }

        public UnresolvedExportDecl clone() {
            return new UnresolvedExportDecl().$assign(this);
        }

        public boolean $noteq(UnresolvedExportDecl other) {
            return !this.$eq(other);
        }

        public boolean $eq(UnresolvedExportDecl other) {
            return this.Wildcard == other.Wildcard && this.ExportLoc.$eq(other.ExportLoc) && this.Id.$eq((SmallVectorImpl)other.Id);
        }
    }

    public static final class NameVisibilityKind
    extends Enum<NameVisibilityKind>
    implements Native.ComparableLower {
        public static final /* enum */ NameVisibilityKind Hidden = new NameVisibilityKind(0);
        public static final /* enum */ NameVisibilityKind AllVisible = new NameVisibilityKind(Hidden.getValue() + 1);
        private final int value;
        private static final /* synthetic */ NameVisibilityKind[] $VALUES;

        public static NameVisibilityKind[] values() {
            return (NameVisibilityKind[])$VALUES.clone();
        }

        public static NameVisibilityKind valueOf(String name) {
            return Enum.valueOf(NameVisibilityKind.class, name);
        }

        public static NameVisibilityKind valueOf(int val) {
            NameVisibilityKind out;
            NameVisibilityKind nameVisibilityKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private NameVisibilityKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((NameVisibilityKind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((NameVisibilityKind)((Object)obj)).value);
        }

        static {
            $VALUES = new NameVisibilityKind[]{Hidden, AllVisible};
        }

        private static final class Values {
            private static final NameVisibilityKind[] VALUES;
            private static final NameVisibilityKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (NameVisibilityKind kind : NameVisibilityKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new NameVisibilityKind[min < 0 ? 1 - min : 0];
                VALUES = new NameVisibilityKind[max >= 0 ? 1 + max : 0];
                for (NameVisibilityKind kind : NameVisibilityKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((NameVisibilityKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((NameVisibilityKind)kind).value] = kind;
                }
            }
        }
    }

    public final class Requirement
    extends std_pair.pairTypeBool<std.string> {
        private Requirement() {
            super((Object)new std.string(), false);
        }

        public Requirement(std.string first, boolean second) {
            super((Object)first, second);
        }

        public std_pair.pairTypeBool<std.string> clone() {
            return new Requirement((std.string)this.first, this.second);
        }
    }

    public static class UnresolvedHeaderDirective
    implements Destructors.ClassWithDestructor,
    Native.NativePOD<UnresolvedHeaderDirective> {
        public SourceLocation FileNameLoc;
        public std.string FileName;
        public boolean IsUmbrella;

        public UnresolvedHeaderDirective $assign(UnresolvedHeaderDirective $Prm0) {
            this.FileNameLoc.$assign($Prm0.FileNameLoc);
            this.FileName.$assign($Prm0.FileName);
            this.IsUmbrella = $Prm0.IsUmbrella;
            return this;
        }

        public void $destroy() {
            this.FileName.$destroy();
        }

        public UnresolvedHeaderDirective(UnresolvedHeaderDirective $Prm0) {
            this.FileNameLoc = new SourceLocation($Prm0.FileNameLoc);
            this.FileName = new std.string($Prm0.FileName);
            this.IsUmbrella = $Prm0.IsUmbrella;
        }

        public UnresolvedHeaderDirective(JavaDifferentiators.JD.Move _dparam, UnresolvedHeaderDirective $Prm0) {
            this.FileNameLoc = new SourceLocation(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.FileNameLoc);
            this.FileName = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.FileName);
            this.IsUmbrella = $Prm0.IsUmbrella;
        }

        public UnresolvedHeaderDirective() {
            this.FileNameLoc = new SourceLocation();
            this.FileName = new std.string();
            this.IsUmbrella = false;
        }

        public String toString() {
            return "FileNameLoc=" + this.FileNameLoc + ", FileName=" + this.FileName + ", IsUmbrella=" + this.IsUmbrella;
        }

        public UnresolvedHeaderDirective clone() {
            return new UnresolvedHeaderDirective().$assign(this);
        }

        public boolean $noteq(UnresolvedHeaderDirective other) {
            return !this.$eq(other);
        }

        public boolean $eq(UnresolvedHeaderDirective other) {
            return this.IsUmbrella == other.IsUmbrella && this.FileNameLoc.$eq(other.FileNameLoc) && this.FileName.$eq((Object)other.FileName);
        }
    }

    public static class DirectoryName
    implements Destructors.ClassWithDestructor {
        public std.string NameAsWritten;
        public DirectoryEntry Entry;

        public boolean $bool() {
            return this.Entry != null;
        }

        public DirectoryName(char.ptr NameAsWritten, DirectoryEntry Entry2) {
            this.NameAsWritten = new std.string(NameAsWritten);
            this.Entry = Entry2;
        }

        public DirectoryName(std.string NameAsWritten, DirectoryEntry Entry2) {
            this.NameAsWritten = NameAsWritten;
            this.Entry = Entry2;
        }

        public DirectoryName(JavaDifferentiators.JD.Move _dparam, DirectoryName $Prm0) {
            this.NameAsWritten = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.NameAsWritten);
            this.Entry = $Prm0.Entry;
        }

        public void $destroy() {
            this.NameAsWritten.$destroy();
        }

        public String toString() {
            return "NameAsWritten=" + this.NameAsWritten + ", Entry=" + this.Entry;
        }
    }

    public static class Header
    implements Destructors.ClassWithDestructor,
    Native.NativePOD<Header> {
        public std.string NameAsWritten;
        public FileEntry Entry;
        public static final Header EMPTY = new Header();

        public boolean $bool() {
            return this.Entry != null;
        }

        public Header(JavaDifferentiators.JD.Move _dparam, Header $Prm0) {
            this.NameAsWritten = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.NameAsWritten);
            this.Entry = $Prm0.Entry;
        }

        public void $destroy() {
            this.NameAsWritten.$destroy();
        }

        public Header(Header $Prm0) {
            this.NameAsWritten = new std.string($Prm0.NameAsWritten);
            this.Entry = $Prm0.Entry;
        }

        public String toString() {
            return "NameAsWritten=" + this.NameAsWritten + ", Entry=" + this.Entry;
        }

        private Header() {
            this.NameAsWritten = new std.string();
            this.Entry = null;
        }

        public Header(std.string NameAsWritten, FileEntry Entry2) {
            this.NameAsWritten = NameAsWritten;
            this.Entry = Entry2;
        }

        public Header(StringRef NameAsWritten, FileEntry Entry2) {
            this.NameAsWritten = NameAsWritten.$basic_string();
            this.Entry = Entry2;
        }

        public Header(char.ptr NameAsWritten, FileEntry Entry2) {
            this.NameAsWritten = new std.string(NameAsWritten);
            this.Entry = Entry2;
        }

        public Header $assign(Header other) {
            this.NameAsWritten.$assign(other.NameAsWritten);
            this.Entry = other.Entry;
            return this;
        }

        public Header clone() {
            return new Header(this);
        }

        public boolean $noteq(Header other) {
            return !this.$eq(other);
        }

        public boolean $eq(Header other) {
            return this.Entry == other.Entry && this.NameAsWritten.$eq((Object)other.NameAsWritten);
        }
    }

    public static final class HeaderKind
    extends Enum<HeaderKind>
    implements Native.ComparableLower {
        public static final /* enum */ HeaderKind HK_Normal = new HeaderKind(0);
        public static final /* enum */ HeaderKind HK_Textual = new HeaderKind(HK_Normal.getValue() + 1);
        public static final /* enum */ HeaderKind HK_Private = new HeaderKind(HK_Textual.getValue() + 1);
        public static final /* enum */ HeaderKind HK_PrivateTextual = new HeaderKind(HK_Private.getValue() + 1);
        public static final /* enum */ HeaderKind HK_Excluded = new HeaderKind(HK_PrivateTextual.getValue() + 1);
        private final int value;
        private static final /* synthetic */ HeaderKind[] $VALUES;

        public static HeaderKind[] values() {
            return (HeaderKind[])$VALUES.clone();
        }

        public static HeaderKind valueOf(String name) {
            return Enum.valueOf(HeaderKind.class, name);
        }

        public static HeaderKind valueOf(int val) {
            HeaderKind out;
            HeaderKind headerKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private HeaderKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((HeaderKind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((HeaderKind)((Object)obj)).value);
        }

        static {
            $VALUES = new HeaderKind[]{HK_Normal, HK_Textual, HK_Private, HK_PrivateTextual, HK_Excluded};
        }

        private static final class Values {
            private static final HeaderKind[] VALUES;
            private static final HeaderKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (HeaderKind kind : HeaderKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new HeaderKind[min < 0 ? 1 - min : 0];
                VALUES = new HeaderKind[max >= 0 ? 1 + max : 0];
                for (HeaderKind kind : HeaderKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((HeaderKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((HeaderKind)kind).value] = kind;
                }
            }
        }
    }
}

