/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.vfs;

import org.clang.basic.impl.JSONWriter;
import org.clang.basic.impl.VirtualFileSystemStatics;
import org.clang.basic.vfs.YAMLVFSEntry;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.path;

public class YAMLVFSWriter
implements Destructors.ClassWithDestructor {
    private std.vector<YAMLVFSEntry> Mappings = new std.vector((Object)YAMLVFSEntry.EMPTY);
    private ADTAliases.OptionalBool IsCaseSensitive = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool IsOverlayRelative = new ADTAliases.OptionalBool();
    private ADTAliases.OptionalBool UseExternalNames = new ADTAliases.OptionalBool();
    private std.string OverlayDir = new std.string();

    public void addFileMapping(StringRef VirtualPath, StringRef RealPath) {
        assert (path.is_absolute((Twine)new Twine(VirtualPath))) : "virtual path not absolute";
        assert (path.is_absolute((Twine)new Twine(RealPath))) : "real path not absolute";
        assert (!VirtualFileSystemStatics.pathHasTraversal(VirtualPath)) : "path traversal is not supported";
        this.Mappings.emplace_back((Object)new YAMLVFSEntry(VirtualPath, RealPath));
    }

    public void setCaseSensitivity(boolean CaseSensitive) {
        this.IsCaseSensitive.$assign(CaseSensitive);
    }

    public void setUseExternalNames(boolean UseExtNames) {
        this.UseExternalNames.$assign(UseExtNames);
    }

    public void setOverlayDir(StringRef OverlayDirectory) {
        this.IsOverlayRelative.$assign(true);
        this.OverlayDir.assign(OverlayDirectory.str());
    }

    public void write(raw_ostream OS) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            std.sort((type.iterator)this.Mappings.begin(), (type.iterator)this.Mappings.end(), (LHS, RHS) -> std.$less_string$C((std.string)LHS.VPath, (std.string)RHS.VPath));
            ((JSONWriter)$c$.track((Object)new JSONWriter(OS))).write((ArrayRef<YAMLVFSEntry>)new ArrayRef(this.Mappings), new ADTAliases.OptionalBool(this.UseExternalNames), new ADTAliases.OptionalBool(this.IsCaseSensitive), new ADTAliases.OptionalBool(this.IsOverlayRelative), new StringRef(this.OverlayDir));
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }

    public void $destroy() {
        this.OverlayDir.$destroy();
        this.UseExternalNames.$destroy();
        this.IsOverlayRelative.$destroy();
        this.IsCaseSensitive.$destroy();
        this.Mappings.$destroy();
    }

    public String toString() {
        return "Mappings=" + this.Mappings + ", IsCaseSensitive=" + this.IsCaseSensitive + ", IsOverlayRelative=" + this.IsOverlayRelative + ", UseExternalNames=" + this.UseExternalNames + ", OverlayDir=" + this.OverlayDir;
    }
}

