/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.cnd.api.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.cnd.lexer.CppStringLexer;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum CppStringTokenId implements TokenId
{
    TEXT(null, "string"),
    PREFIX_L("L", "string-escape"),
    PREFIX_R("R", "string-escape"),
    PREFIX_U("U", "string-escape"),
    PREFIX_u("u", "string-escape"),
    PREFIX_u8("u8", "string-escape"),
    PREFIX_LR("LR", "string-escape"),
    PREFIX_UR("UR", "string-escape"),
    PREFIX_uR("uR", "string-escape"),
    PREFIX_u8R("u8R", "string-escape"),
    SINGLE_QUOTE("'", "string"),
    FIRST_QUOTE("\"", "string-escape"),
    START_DELIMETER(null, "string-escape"),
    START_DELIMETER_PAREN("(", "string-escape"),
    DOUBLE_QUOTE("\"", "string"),
    END_DELIMETER_PAREN(")", "string-escape"),
    END_DELIMETER(null, "string-escape"),
    LAST_QUOTE("\"", "string-escape"),
    BELL("\\a", "string-escape"),
    BACKSPACE("\\b", "string-escape"),
    ANSI_COLOR(null, "string-escape"),
    FORM_FEED("\\f", "string-escape"),
    NEWLINE("\\n", "string-escape"),
    CR("\\r", "string-escape"),
    TAB("\\t", "string-escape"),
    SINGLE_QUOTE_ESCAPE("\\\"", "string-escape"),
    DOUBLE_QUOTE_ESCAPE("\\'", "string-escape"),
    BACKSLASH_ESCAPE("\\\\", "string-escape"),
    OCTAL_ESCAPE(null, "string-escape"),
    OCTAL_ESCAPE_INVALID(null, "error"),
    HEX_ESCAPE(null, "string-escape"),
    HEX_ESCAPE_INVALID(null, "error"),
    UNICODE_ESCAPE(null, "string-escape"),
    UNICODE_ESCAPE_INVALID(null, "error"),
    ESCAPE_SEQUENCE_INVALID(null, "error");

    private final String primaryCategory;
    private final String fixedText;
    private static final Language<CppStringTokenId> languageDouble;
    private static final Language<CppStringTokenId> languageRawString;
    private static final Language<CppStringTokenId> languageSingle;

    private CppStringTokenId(String fixedText, String primaryCategory) {
        this.primaryCategory = primaryCategory;
        this.fixedText = fixedText;
    }

    public String fixedText() {
        return this.fixedText;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<CppStringTokenId> languageDouble() {
        return languageDouble;
    }

    public static Language<CppStringTokenId> languageRawString() {
        return languageRawString;
    }

    public static Language<CppStringTokenId> languageSingle() {
        return languageSingle;
    }

    static {
        languageDouble = new StringHierarchy(true, false).language();
        languageRawString = new StringHierarchy(true, true).language();
        languageSingle = new StringHierarchy(false, false).language();
    }

    private static final class StringHierarchy
    extends LanguageHierarchy<CppStringTokenId> {
        private final boolean dblQuoted;
        private final boolean raw;

        public StringHierarchy(boolean doubleQuotedString, boolean raw) {
            this.dblQuoted = doubleQuotedString;
            this.raw = raw;
        }

        protected Collection<CppStringTokenId> createTokenIds() {
            return EnumSet.allOf(CppStringTokenId.class);
        }

        protected Map<String, Collection<CppStringTokenId>> createTokenCategories() {
            return null;
        }

        protected Lexer<CppStringTokenId> createLexer(LexerRestartInfo<CppStringTokenId> info) {
            return new CppStringLexer(info, this.dblQuoted, this.raw);
        }

        protected String mimeType() {
            return this.dblQuoted ? "text/x-cpp-string-double" : "text/x-cpp-string-single";
        }
    }
}

