/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.wizard;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.wizard.AddServerInstanceWizard;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ServerChooserVisual
extends JPanel {
    private final List listeners = new ArrayList();
    private AddServerInstanceWizard wizard;
    private HashMap displayNames = new HashMap();
    private boolean updatingDisplayName = false;
    private JTextField displayNameEditField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JList serverListBox;

    public ServerChooserVisual() {
        this.initComponents();
        ServerAdapter selected = (ServerAdapter)((ComboBoxModel)this.serverListBox.getModel()).getSelectedItem();
        this.serverListBox.setSelectedValue(selected, true);
        if (selected != null) {
            this.fillDisplayName(selected.getServer());
        }
        this.displayNameEditField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ServerChooserVisual.this.displayNameEditFieldUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ServerChooserVisual.this.displayNameEditFieldUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ServerChooserVisual.this.displayNameEditFieldUpdate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public void read(AddServerInstanceWizard wizard) {
        Object prop;
        if (this.wizard == null) {
            this.wizard = wizard;
        }
        if ((prop = wizard.getProperty("ServInstWizard_displayName")) != null) {
            this.displayNameEditField.setText((String)prop);
        }
    }

    public void store(AddServerInstanceWizard wizard) {
        wizard.putProperty("ServInstWizard_displayName", this.displayNameEditField.getText());
        Object selectedItem = this.serverListBox.getSelectedValue();
        if (selectedItem != null) {
            wizard.putProperty("ServInstWizard_server", ((ServerAdapter)selectedItem).getServer());
        }
    }

    public boolean hasValidData() {
        boolean result;
        boolean bl = result = this.isServerValid() && this.isDisplayNameValid();
        if (result) {
            this.wizard.setErrorMessage(null);
        }
        return result;
    }

    private boolean isServerValid() {
        boolean result;
        boolean bl = result = this.serverListBox.getSelectedValue() != null;
        if (!result) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerChooserVisual.class, (String)"MSG_SCV_ChooseServer"));
        }
        return result;
    }

    private boolean isDisplayNameValid() {
        String trimmed = this.displayNameEditField.getText().trim();
        if (trimmed.length() <= 0) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerChooserVisual.class, (String)"MSG_SCV_DisplayName"));
            return false;
        }
        if (this.getServerInstance(trimmed) != null) {
            this.wizard.setErrorMessage(NbBundle.getMessage(ServerChooserVisual.class, (String)"MSG_SCV_DisplayNameExists"));
            return false;
        }
        return true;
    }

    private ServerInstance getServerInstance(String displayName) {
        for (ServerInstance instance : ServerRegistry.getInstance().getInstances()) {
            if (instance.getDisplayName() == null || !instance.getDisplayName().equalsIgnoreCase(displayName)) continue;
            return instance;
        }
        return null;
    }

    private void displayNameEditFieldUpdate() {
        if (!this.updatingDisplayName) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList tempList;
        ChangeEvent event = new ChangeEvent(this);
        List list = this.listeners;
        synchronized (list) {
            tempList = new ArrayList(this.listeners);
        }
        Iterator iter = tempList.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(event);
        }
    }

    private String generateDisplayName(Server server) {
        String name;
        int count = 0;
        do {
            name = server.getDisplayName();
            if (count != 0) {
                name = name + " (" + String.valueOf(count) + ")";
            }
            ++count;
        } while (this.getServerInstance(name) != null);
        return name;
    }

    private void fillDisplayName(Server server) {
        String name = (String)this.displayNames.get(server);
        if (name == null) {
            name = this.generateDisplayName(server);
        }
        this.updatingDisplayName = true;
        this.displayNameEditField.setText(name);
        this.updatingDisplayName = false;
        this.fireChange();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.displayNameEditField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.serverListBox = new JList();
        this.setName(NbBundle.getBundle(ServerChooserVisual.class).getString("LBL_SCV_Name"));
        this.jLabel1.setLabelFor(this.serverListBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(ServerChooserVisual.class).getString("LBL_SCV_Server"));
        this.jLabel2.setLabelFor(this.displayNameEditField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getBundle(ServerChooserVisual.class).getString("LBL_SCV_DisplayName"));
        this.displayNameEditField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ServerChooserVisual.this.displayNameEditFieldKeyReleased(evt);
            }
        });
        this.serverListBox.setModel(new ServerModel());
        this.serverListBox.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ServerChooserVisual.this.serverListBoxValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.serverListBox);
        this.serverListBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_NAME_Server"));
        this.serverListBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_DESC_Server"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayNameEditField, -1, 375, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 375, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jScrollPane1, -1, 202, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.displayNameEditField, -2, -1, -2)).addContainerGap()));
        this.displayNameEditField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_NAME_DisplayName"));
        this.displayNameEditField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_DESC_DisplayName"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_NAME"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerChooserVisual.class, (String)"A11Y_SCV_DESC"));
    }

    private void serverListBoxValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            ServerAdapter adapter = (ServerAdapter)this.serverListBox.getSelectedValue();
            if (adapter != null) {
                Server server = adapter.getServer();
                if (server != null) {
                    this.fillDisplayName(server);
                }
            } else {
                this.fireChange();
            }
        }
    }

    private void displayNameEditFieldKeyReleased(KeyEvent evt) {
        ServerAdapter serverAdapter = (ServerAdapter)this.serverListBox.getSelectedValue();
        if (serverAdapter != null) {
            this.displayNames.put(serverAdapter.getServer(), this.displayNameEditField.getText());
        }
    }

    private static class ServerAdapter
    implements Comparable {
        private Server server;

        public ServerAdapter(Server server) {
            this.server = server;
        }

        public Server getServer() {
            return this.server;
        }

        public String toString() {
            return this.server.getDisplayName();
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }
    }

    private static class ServerModel
    implements ComboBoxModel {
        private List servers = new ArrayList();
        private ServerAdapter selected;

        public ServerModel() {
            Collection<Server> allServers = ServerRegistry.getInstance().getServers();
            for (Server server : allServers) {
                OptionalDeploymentManagerFactory factory = server.getOptionalFactory();
                if (factory == null || factory.getAddInstanceIterator() == null) continue;
                ServerAdapter serverAdapter = new ServerAdapter(server);
                this.servers.add(serverAdapter);
                String n = server.getShortName();
                if (null != n && n.startsWith("gfv3")) {
                    this.selected = serverAdapter;
                }
                if (null != this.selected || !"J2EE".equals(n)) continue;
                this.selected = serverAdapter;
            }
            Collections.sort(this.servers);
            if (this.selected == null) {
                this.selected = this.servers.size() > 0 ? (ServerAdapter)this.servers.get(0) : null;
            }
        }

        @Override
        public Object getElementAt(int index) {
            return this.servers.get(index);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public int getSize() {
            return this.servers.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selected = (ServerAdapter)anItem;
        }
    }
}

