/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectWithCache;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;

public class RemoteLockSupport {
    private final Object mainLock = new Object();
    private final Map<File, WeakReference<ReadWriteLock>> cacheLocks = new HashMap<File, WeakReference<ReadWriteLock>>();
    private final IdentityHashMap<RemoteFileObjectBase, RemoteFileLock> fileLocks = new IdentityHashMap();
    private final Object plainFileMainLock = new Object();
    private final Map<RemotePlainFile, SimpleRWLock> plainFileRWLocks = new IdentityHashMap<RemotePlainFile, SimpleRWLock>();
    private static final int RW_LOCK_TIMEOUT = Integer.getInteger("remote.rwlock.timeout", 4);
    private static final boolean TRACE_LOCKERS;
    private AtomicInteger readLocksCount = new AtomicInteger();
    private AtomicInteger writeLocksCount = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadWriteLock getCacheLock(RemoteFileObjectWithCache fo) {
        File file = fo.getCache();
        Object object = this.mainLock;
        synchronized (object) {
            ReadWriteLock result;
            WeakReference<ReadWriteLock> ref = this.cacheLocks.get(file);
            ReadWriteLock readWriteLock = result = ref == null ? null : (ReadWriteLock)ref.get();
            if (result == null) {
                result = new ReentrantReadWriteLock();
                this.cacheLocks.put(file, new WeakReference<ReadWriteLock>(result));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock lock(RemoteFileObjectBase fo) throws FileAlreadyLockedException {
        RemoteFileLock lock;
        Object object = this.mainLock;
        synchronized (object) {
            lock = this.fileLocks.get(fo);
            if (lock != null && lock.isValid()) {
                throw new FileAlreadyLockedException(fo.getPath());
            }
            lock = new RemoteFileLock(fo);
            this.fileLocks.put(fo, lock);
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(RemoteFileObjectBase fo) {
        Object object = this.mainLock;
        synchronized (object) {
            RemoteFileLock lock = this.fileLocks.get(fo);
            return lock != null && lock.isValid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkLock(RemoteFileObjectBase fo, FileLock aLock) {
        if (aLock != null) {
            Object object = this.mainLock;
            synchronized (object) {
                RemoteFileLock lock = this.fileLocks.get(fo);
                return lock == aLock;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleRWLock getPlainFileRWLock(RemotePlainFile fo, boolean create) {
        SimpleRWLock lock;
        Object object = this.plainFileMainLock;
        synchronized (object) {
            lock = this.plainFileRWLocks.get(fo);
            if (lock == null && create) {
                lock = TRACE_LOCKERS ? new SimpleRWLockWithTrace(fo) : new SimpleRWLock(fo);
                this.plainFileRWLocks.put(fo, lock);
            }
        }
        return lock;
    }

    public void tryReadLock(RemotePlainFile fo) throws InterruptedException, FileAlreadyLockedException {
        this.getPlainFileRWLock(fo, true).tryReadLock();
    }

    public void readUnlock(RemotePlainFile fo) {
        SimpleRWLock lock = this.getPlainFileRWLock(fo, false);
        if (lock != null) {
            lock.readUnlock();
        }
    }

    public void tryWriteLock(RemotePlainFile fo) throws InterruptedException, FileAlreadyLockedException {
        this.getPlainFileRWLock(fo, true).tryWriteLock();
    }

    public void writeUnlock(RemotePlainFile fo) {
        SimpleRWLock lock = this.getPlainFileRWLock(fo, false);
        if (lock != null) {
            lock.writeUnlock();
        }
    }

    void printStatistics(RemoteFileSystem fs) {
        System.err.println("RemoteLockSupport statistics for " + (Object)((Object)fs));
        System.err.println("Read locks count:  " + this.readLocksCount.get());
        System.err.println("Write locks count: " + this.writeLocksCount.get());
    }

    static {
        boolean trace = RemoteLogger.isDebugMode();
        String setting = System.getProperty("remote.rwlock.trace.lockers");
        if (setting != null) {
            trace = Boolean.parseBoolean(setting);
        }
        TRACE_LOCKERS = trace;
    }

    private class RemoteFileLock
    extends FileLock {
        private final RemoteFileObjectBase fo;

        public RemoteFileLock(RemoteFileObjectBase fo) {
            this.fo = fo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseLock() {
            Object object = RemoteLockSupport.this.mainLock;
            synchronized (object) {
                super.releaseLock();
                RemoteLockSupport.this.fileLocks.remove(this.fo);
            }
        }
    }

    private class SimpleRWLockWithTrace
    extends SimpleRWLock {
        private ReaderInfo lastReader;

        public SimpleRWLockWithTrace(RemotePlainFile owner) {
            super(owner);
        }

        private void addReader() {
            this.lastReader = new ReaderInfo(this.lastReader);
        }

        private void removeReader(ReaderInfo reader) {
            if (reader == this.lastReader) {
                this.lastReader = this.lastReader.next;
            } else {
                ReaderInfo prev = this.lastReader;
                while (prev != null) {
                    ReaderInfo next = prev.next;
                    if (next == reader) {
                        prev.next = next.next;
                    }
                    prev = next;
                }
            }
        }

        private ReaderInfo findReader() {
            ReaderInfo curr = this.lastReader;
            while (curr != null) {
                if (curr.thread.getId() == Thread.currentThread().getId()) {
                    return curr;
                }
                curr = curr.next;
            }
            return this.lastReader;
        }

        @Override
        protected void onReadLock(boolean success) {
            if (success) {
                this.addReader();
            }
        }

        @Override
        protected void onReadUnlock() {
            ReaderInfo reader = this.findReader();
            if (reader != null) {
                this.removeReader(reader);
            }
        }

        @Override
        protected FileAlreadyLockedException createWriteLockException() {
            FileAlreadyLockedException result = super.createWriteLockException();
            Object ex = result;
            ReaderInfo reader = this.lastReader;
            while (reader != null) {
                Exception cause = new Exception("Locked at " + new Date(reader.timestamp) + " by thread " + reader.thread.getName());
                cause.setStackTrace(reader.lockedStack);
                ((Throwable)ex).initCause(cause);
                ex = cause;
                StackTraceElement[] stack = reader.thread.getStackTrace();
                if (stack.length > 0) {
                    cause = new Exception("Now the stack of the reader thead " + reader.thread.getName());
                    cause.setStackTrace(stack);
                    ((Throwable)ex).initCause(cause);
                    ex = cause;
                }
                reader = reader.next;
            }
            return result;
        }
    }

    private static class ReaderInfo {
        public final Thread thread;
        public final StackTraceElement[] lockedStack;
        public final long timestamp;
        public ReaderInfo next;

        public ReaderInfo(ReaderInfo next) {
            this.next = next;
            this.thread = Thread.currentThread();
            this.timestamp = System.currentTimeMillis();
            StackTraceElement[] stack = this.thread.getStackTrace();
            this.lockedStack = new StackTraceElement[stack.length - 4];
            System.arraycopy(stack, 4, this.lockedStack, 0, stack.length - 4);
        }
    }

    private class SimpleRWLock {
        private int activeReaders = 0;
        private int waiters = 0;
        private Thread writer = null;
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition readable = this.lock.newCondition();
        private final Condition writtable = this.lock.newCondition();
        private final RemotePlainFile owner;

        public SimpleRWLock(RemotePlainFile owner) {
            this.owner = owner;
        }

        private boolean writeCondition() {
            assert (this.lock.isLocked());
            return this.activeReaders == 0 && this.writer == null;
        }

        private boolean readCondition() {
            assert (this.lock.isLocked());
            return this.writer == null || this.writer == Thread.currentThread();
        }

        private void removeIfPossible() {
            assert (this.lock.isLocked());
            if (this.activeReaders == 0 && this.writer == null && this.waiters == 0) {
                RemoteLockSupport.this.plainFileRWLocks.remove(this.owner);
            }
        }

        protected void onReadLock(boolean success) {
        }

        protected void onReadUnlock() {
        }

        protected void onWriteLock(boolean success) {
        }

        protected void onWriteUnlock() {
        }

        public Thread getWriter() {
            return this.writer;
        }

        public RemotePlainFile getOwner() {
            return this.owner;
        }

        public void tryReadLock() throws InterruptedException, FileAlreadyLockedException {
            this.lock.lock();
            try {
                ++this.waiters;
                while (!this.readCondition()) {
                    if (this.readable.await(RW_LOCK_TIMEOUT, TimeUnit.SECONDS)) continue;
                    this.onReadLock(false);
                    throw this.createReadLockException();
                }
                ++this.activeReaders;
                if (this.writer == Thread.currentThread()) {
                    this.writer = null;
                }
                RemoteLockSupport.this.readLocksCount.incrementAndGet();
                this.onReadLock(true);
            }
            finally {
                --this.waiters;
                this.lock.unlock();
            }
        }

        public void readUnlock() {
            this.lock.lock();
            try {
                ++this.waiters;
                if (this.activeReaders > 0) {
                    --this.activeReaders;
                    if (this.activeReaders == 0) {
                        this.writtable.signalAll();
                    }
                }
                this.onReadUnlock();
            }
            finally {
                --this.waiters;
                this.removeIfPossible();
                this.lock.unlock();
            }
        }

        public void tryWriteLock() throws InterruptedException, FileAlreadyLockedException {
            this.lock.lock();
            try {
                while (!this.writeCondition()) {
                    if (this.writtable.await(RW_LOCK_TIMEOUT, TimeUnit.SECONDS)) continue;
                    this.onWriteLock(false);
                    throw this.createWriteLockException();
                }
                this.writer = Thread.currentThread();
                RemoteLockSupport.this.writeLocksCount.incrementAndGet();
                this.onWriteLock(true);
            }
            finally {
                this.lock.unlock();
            }
        }

        public void writeUnlock() {
            this.lock.lock();
            try {
                if (this.writer != null) {
                    this.writer = null;
                    this.writtable.signal();
                    this.readable.signalAll();
                }
            }
            finally {
                this.removeIfPossible();
                this.lock.unlock();
            }
        }

        protected FileAlreadyLockedException createReadLockException() {
            return new FileAlreadyLockedException("Cannot read from locked file: " + this.owner);
        }

        protected FileAlreadyLockedException createWriteLockException() {
            return new FileAlreadyLockedException("Cannot write to locked file: " + this.owner);
        }
    }
}

