/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.ProcessStatusEx;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RefreshManager;
import org.netbeans.modules.remote.impl.fs.RemoteExceptions;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.server.Buffer;
import org.netbeans.modules.remote.impl.fs.server.Disposer;
import org.netbeans.modules.remote.impl.fs.server.FSSRequest;
import org.netbeans.modules.remote.impl.fs.server.FSSRequestKind;
import org.netbeans.modules.remote.impl.fs.server.FSSResponse;
import org.netbeans.modules.remote.impl.fs.server.FSSResponseKind;
import org.netbeans.modules.remote.impl.fs.server.FSSUtil;
import org.netbeans.modules.remote.impl.fs.ui.RemoteNotifier;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

final class FSSDispatcher
implements Disposer<FSSResponse> {
    private static final boolean SUPPRESS_STDERR = Boolean.parseBoolean(System.getProperty("remote.fs_server.suppress.stderr", "true"));
    private static final Map<ExecutionEnvironment, FSSDispatcher> instances = new HashMap<ExecutionEnvironment, FSSDispatcher>();
    private static final Object instanceLock = new Object();
    private final ExecutionEnvironment env;
    private final Map<Integer, FSSResponse> responses = new LinkedHashMap<Integer, FSSResponse>();
    private final Object responseLock = new Object();
    private static final String USER_DEFINED_SERVER_PATH = System.getProperty("remote.fs_server.path");
    private static final int REFRESH_INTERVAL = Integer.getInteger("remote.fs_server.refresh", 0);
    private static final int VERBOSE = Integer.getInteger("remote.fs_server.verbose", 0);
    private static final boolean LOG = Boolean.getBoolean("remote.fs_server.log");
    private static final String SERVER_CACHE = System.getProperty("remote.fs_server.remote.cache");
    private static final int SERVER_THREADS = Integer.getInteger("remote.fs_server.threads", 0);
    private final RequestProcessor RP = new RequestProcessor(this.getClass().getSimpleName(), 20);
    private FsServer server;
    private final Object serverLock = new Object();
    private final String traceName;
    private volatile boolean valid = true;
    private final AtomicInteger attempts = new AtomicInteger();
    private static final int MAX_ATTEMPTS = Integer.getInteger("remote.fs_server.attempts", 3);
    private final AtomicReference<String> lastErrorMessage = new AtomicReference();
    private volatile boolean cleanupUponStart = false;
    private volatile FileSystemProvider.AccessCheckType accessCheckType;

    private String getMinServerVersion() {
        if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)this.env)) {
            try {
                if (HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env).getCpuFamily() == HostInfo.CpuFamily.ARM) {
                    return "1.7.0";
                }
            }
            catch (IOException | ConnectionManager.CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return "1.10.2";
    }

    private FSSDispatcher(ExecutionEnvironment env) {
        this.env = env;
        this.traceName = "fs_server[" + env + ']';
        this.accessCheckType = FSSDispatcher.restoreAccessCheckType();
    }

    public void setCleanupUponStart(boolean cleanup) {
        this.cleanupUponStart = cleanup;
    }

    private void addToRefresh(String path) {
        RefreshManager refreshManager = this.getFileSystem().getRefreshManager();
        refreshManager.scheduleRefreshExistent(Arrays.asList(path), false);
    }

    private RemoteFileSystem getFileSystem() {
        return RemoteFileSystemManager.getInstance().getFileSystem(this.env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSSDispatcher getInstance(ExecutionEnvironment env) {
        Object object = instanceLock;
        synchronized (object) {
            FSSDispatcher instance = instances.get(env);
            if (instance == null) {
                instance = new FSSDispatcher(env);
                instances.put(env, instance);
            }
            return instance;
        }
    }

    public boolean isRefreshing() {
        return REFRESH_INTERVAL > 0;
    }

    public void connected() {
        boolean wasValid = this.valid;
        this.valid = true;
        if (wasValid && this.getFileSystem().getRoot().getImplementor().hasCache()) {
            this.RP.post((Runnable)new ConnectTask());
        }
    }

    void requestRefreshCycle(String path) {
        this.RP.post((Runnable)new RefreshTask(path));
    }

    private void sendRefreshRequest(String path) {
        FSSRequest req = new FSSRequest(FSSRequestKind.FS_REQ_REFRESH, path, true);
        try {
            this.dispatch(req);
        }
        catch (ConnectException connectException) {
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (CancellationException ex) {
        }
        catch (InterruptedException ex) {
        }
        catch (ExecutionException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void sendAccessTypeChangeRequest(FileSystemProvider.AccessCheckType accessCheckType) {
        String option;
        switch (accessCheckType) {
            case FAST: {
                option = "access=fast";
                break;
            }
            case FULL: {
                option = "access=full";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected access check type" + accessCheckType.name());
            }
        }
        FSSRequest req = new FSSRequest(FSSRequestKind.FS_REQ_OPTION, option, true);
        FsServer server = this.getServer();
        if (server != null) {
            FSSDispatcher.sendRequest(server.getWriter(), req);
        }
    }

    private static FileSystemProvider.AccessCheckType restoreAccessCheckType() {
        FileSystemProvider.AccessCheckType result = FileSystemProvider.AccessCheckType.FAST;
        String name = NbPreferences.forModule(FSSDispatcher.class).get("accessCheckType", result.name());
        if (name != null) {
            try {
                result = FileSystemProvider.AccessCheckType.valueOf((String)name);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result;
    }

    private static void storeAccessCheckType(FileSystemProvider.AccessCheckType accessCheckType) {
        NbPreferences.forModule(FSSDispatcher.class).put("accessCheckType", accessCheckType.name());
    }

    public void setAccessCheckType(FileSystemProvider.AccessCheckType accessCheckType) {
        FSSDispatcher.storeAccessCheckType(accessCheckType);
        this.accessCheckType = accessCheckType;
        if (this.getServer() != null) {
            this.sendAccessTypeChangeRequest(accessCheckType);
        }
    }

    FileSystemProvider.AccessCheckType getAccessCheckType() {
        return this.accessCheckType;
    }

    public boolean isValidFast() {
        return this.valid;
    }

    private void setInvalid(boolean force) {
        if (force) {
            this.valid = false;
        } else if (this.attempts.incrementAndGet() > MAX_ATTEMPTS) {
            this.valid = false;
        }
        RemoteLogger.log(Level.WARNING, "fs_server at {0} failed: {1} ", this.env, this.lastErrorMessage.get());
    }

    public boolean isValidSlow() throws ConnectException, ConnectionManager.CancellationException, InterruptedException {
        FsServer srv = null;
        try {
            srv = this.getOrCreateServer();
        }
        catch (ConnectException ex) {
            throw ex;
        }
        catch (IOException | ExecutionException | InitializationException ex) {
            ex.printStackTrace(System.err);
        }
        if (srv == null) {
            this.setInvalid(true);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkValid() throws ExecutionException, InterruptedException {
        NativeProcess process;
        FsServer srv;
        if (ConnectionManager.getInstance().isConnectedTo(this.env) && (srv = this.getServer()) != null && !ProcessUtils.isAlive((Process)(process = srv.getProcess()))) {
            try {
                int rc = process.waitFor();
                if (rc != 0 && rc != -1) {
                    this.setInvalid(false);
                }
                ExecutionException exception = new ExecutionException(this.lastErrorMessage.get(), null);
                Object object = this.responseLock;
                synchronized (object) {
                    for (FSSResponse rsp : this.responses.values()) {
                        rsp.failed(exception);
                    }
                }
                throw exception;
            }
            catch (IllegalThreadStateException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(FSSResponse response) {
        Object object = this.responseLock;
        synchronized (object) {
            this.responses.remove(response.getId());
        }
    }

    public FSSResponse dispatch(FSSRequest request) throws IOException, ConnectException, CancellationException, InterruptedException, ExecutionException {
        return this.dispatch(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSSResponse dispatch(FSSRequest request, FSSResponse.Listener listener) throws IOException, ConnectException, CancellationException, InterruptedException, ExecutionException {
        FsServer srv;
        FSSResponse response = null;
        if (request.needsResponse()) {
            response = new FSSResponse(request, this, listener, this.env);
            Object object = this.responseLock;
            synchronized (object) {
                RemoteLogger.assertNull(this.responses.get(request.getId()), "response should be null for id {0}", request.getId());
                this.responses.put(request.getId(), response);
            }
        }
        try {
            srv = this.getOrCreateServer();
        }
        catch (ConnectionManager.CancellationException ex) {
            throw new CancellationException(ex.getMessage());
        }
        catch (ConnectException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.setInvalid(false);
            throw ex;
        }
        catch (ExecutionException ex) {
            this.setInvalid(false);
            throw ex;
        }
        catch (InitializationException ex) {
            throw new ExecutionException(ex);
        }
        PrintWriter writer = srv.getWriter();
        FSSDispatcher.sendRequest(writer, request);
        if (writer.checkError()) {
            this.checkValid();
        }
        return response;
    }

    static void sendRequest(PrintWriter writer, FSSRequest request) {
        String buffer;
        String escapedPath = FSSUtil.escape(request.getPath());
        String path2 = request.getPath2();
        if (path2 == null) {
            buffer = String.format("%c %d %d %s\n", Character.valueOf(request.getKind().getChar()), request.getId(), escapedPath.length(), escapedPath);
        } else {
            String escapedPath2 = FSSUtil.escape(path2);
            buffer = String.format("%c %d %d %s %d %s\n", Character.valueOf(request.getKind().getChar()), request.getId(), escapedPath.length(), escapedPath, escapedPath2.length(), escapedPath2);
        }
        RemoteLogger.finest("### sending request {0}", buffer);
        writer.print(buffer);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FsServer getServer() {
        Object object = this.serverLock;
        synchronized (object) {
            return this.server;
        }
    }

    static File testGetOriginalFSServerFile(ExecutionEnvironment execEnv) throws IOException, ConnectionManager.CancellationException {
        String path = FSSDispatcher.getOriginalFSServerPath(execEnv);
        return InstalledFileLocator.getDefault().locate(path, "org.netbeans.modules.remote.impl", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testDump(PrintStream ps) {
        FsServer srv;
        ps.printf("Dumping %s [%s]\n", this.traceName, this.valid ? "valid" : "invalid");
        ps.printf("\tlastErrorMessage=%s \n", this.lastErrorMessage);
        Object object = this.serverLock;
        synchronized (object) {
            srv = this.server;
        }
        if (srv != null) {
            srv.testDump(ps);
        }
    }

    private static String getOriginalFSServerPath(ExecutionEnvironment execEnv) throws IOException, ConnectionManager.CancellationException {
        String toolPath = "";
        MacroExpanderFactory.MacroExpander macroExpander = MacroExpanderFactory.getExpander((ExecutionEnvironment)execEnv);
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            HostInfo.OSFamily osFamily = hostInfo.getOSFamily();
            if (osFamily == HostInfo.OSFamily.UNKNOWN) {
                throw new IOException("Unsupported platform on " + execEnv.getDisplayName());
            }
            String toExpand = "$osname-$platform" + (osFamily == HostInfo.OSFamily.LINUX && hostInfo.getCpuFamily() != HostInfo.CpuFamily.SPARC ? "${_isa}" : "");
            String platformPath = macroExpander.expandPredefinedMacros(toExpand);
            toolPath = toolPath + "bin/" + platformPath + "/fs_server";
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return toolPath;
    }

    private String checkServerSetup() throws ConnectException, IOException, ConnectionManager.CancellationException, InterruptedException, ExecutionException {
        String toolPath;
        if (!ConnectionManager.getInstance().isConnectedTo(this.env)) {
            throw RemoteExceptions.createConnectException(RemoteFileSystemUtils.getConnectExceptionMessage(this.env));
        }
        try {
            toolPath = FSSDispatcher.getOriginalFSServerPath(this.env);
        }
        catch (IOException ioe) {
            this.setInvalid(true);
            throw ioe;
        }
        HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env);
        String remotePath = USER_DEFINED_SERVER_PATH;
        if (remotePath == null) {
            remotePath = hostInfo.getTempDir() + "/" + toolPath;
        }
        String remoteBase = PathUtilities.getDirName((String)remotePath);
        File localFile = InstalledFileLocator.getDefault().locate(toolPath, "org.netbeans.modules.remote.impl", false);
        if (localFile != null && localFile.exists()) {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.env);
            npb.setExecutable("/bin/mkdir").setArguments(new String[]{"-p", remoteBase});
            ProcessUtils.execute((NativeProcessBuilder)npb);
            Future copyTask = CommonTasksSupport.uploadFile((File)localFile, (ExecutionEnvironment)this.env, (String)remotePath, (int)493, (boolean)true);
            CommonTasksSupport.UploadStatus uploadStatus = (CommonTasksSupport.UploadStatus)copyTask.get();
            if (!uploadStatus.isOK()) {
                this.setInvalid(true);
                throw new IOException(uploadStatus.getError());
            }
        } else if (!HostInfoUtils.fileExists((ExecutionEnvironment)this.env, (String)remotePath)) {
            this.setInvalid(true);
            throw new FileNotFoundException(this.env.getDisplayName() + ':' + remotePath);
        }
        return remotePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FsServer getOrCreateServer() throws IOException, ConnectException, ConnectionManager.CancellationException, InterruptedException, ExecutionException, InitializationException {
        Object object = this.serverLock;
        synchronized (object) {
            if (this.server != null && !ProcessUtils.isAlive((Process)this.server.getProcess())) {
                this.server = null;
            }
            if (this.server == null) {
                if (!ConnectionManager.getInstance().isConnectedTo(this.env)) {
                    throw RemoteExceptions.createConnectException(RemoteFileSystemUtils.getConnectExceptionMessage(this.env));
                }
                String path = this.checkServerSetup();
                this.server = new FsServer(path);
                this.RP.post((Runnable)new ErrorReader(this.server.getProcess().getErrorStream()));
                try {
                    this.handShake();
                    this.setupProhibitedToLstat();
                }
                catch (InitializationException ex) {
                    this.server = null;
                    this.setInvalid(true);
                    throw ex;
                }
                this.RP.post((Runnable)new MainLoop());
            }
            return this.server;
        }
    }

    private void setupProhibitedToLstat() {
        List<String> forbiddenPaths = this.getFileSystem().getDirsProhibitedToStat(this.traceName);
        if (forbiddenPaths == null || forbiddenPaths.isEmpty()) {
            return;
        }
        FsServer srv = this.server;
        if (srv == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("dirs-forbidden-to-stat=");
        boolean first = true;
        for (String path : forbiddenPaths) {
            sb.append(path).append(first ? "" : ":");
            first = false;
        }
        FSSRequest req = new FSSRequest(FSSRequestKind.FS_REQ_OPTION, sb.toString());
        FSSDispatcher.sendRequest(this.server.getWriter(), req);
    }

    private void handShake() throws IOException, InitializationException, InterruptedException {
        FSSRequest infoReq = new FSSRequest(FSSRequestKind.FS_REQ_SERVER_INFO, "");
        FSSDispatcher.sendRequest(this.server.getWriter(), infoReq);
        String line = this.server.getReader().readLine();
        if (line == null) {
            NativeProcess.State state = this.server.getProcess().getState();
            if (state == NativeProcess.State.FINISHED) {
                throw new InitializationException(this.createInitializerExceptionMessage());
            }
        } else {
            RemoteLogger.fine("Reading handshake response from {0}:{1} -> {2}", this.env, this.server.path, line);
            Buffer buf = new Buffer(line);
            char respKind = buf.getChar();
            RemoteLogger.assertTrue(respKind == FSSResponseKind.FS_RSP_SERVER_INFO.getChar());
            int respId = buf.getInt();
            RemoteLogger.assertTrue(respId == infoReq.getId());
            String version = buf.getRest().trim();
            this.checkVersions(this.getMinServerVersion(), version);
            if (this.accessCheckType != FileSystemProvider.AccessCheckType.FULL) {
                this.sendAccessTypeChangeRequest(this.accessCheckType);
            }
            RemoteLogger.info("Remote agent version " + version + " [" + this.env + "] ", new Object[0]);
        }
    }

    private String createInitializerExceptionMessage() {
        NativeProcess process;
        StringBuilder sb = new StringBuilder();
        sb.append("fs_server failed at ").append(this.env.toString()).append(' ');
        if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)this.env)) {
            try {
                HostInfo hi = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env);
                sb.append('(').append(hi.getOS().getName()).append(' ').append(hi.getCpuFamily()).append(' ');
                sb.append(" - ").append(hi.getOS().getVersion()).append(')');
            }
            catch (IOException | ConnectionManager.CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if ((process = this.server.getProcess()) != null) {
            sb.append(" rc=").append(process.exitValue()).append(' ');
        }
        sb.append(' ').append(this.lastErrorMessage.get());
        return sb.toString();
    }

    private void checkVersions(String ref, String fact) throws InitializationException {
        String[] refArr = ref.split("\\.");
        String[] factArr = fact.split("\\.");
        if (refArr.length != 3) {
            Exceptions.printStackTrace((Throwable)new IllegalArgumentException("wrong version format: " + ref));
        }
        if (factArr.length != 3) {
            throw new InitializationException("Wrong version format: " + fact);
        }
        for (int i = 0; i < 3; ++i) {
            int factValue;
            int refValue;
            try {
                refValue = Integer.parseInt(refArr[i]);
            }
            catch (NumberFormatException nfe) {
                throw new InitializationException("Wrong version format: " + ref);
            }
            try {
                factValue = Integer.parseInt(factArr[i]);
            }
            catch (NumberFormatException nfe) {
                throw new InitializationException("Wrong version format: " + fact);
            }
            if (factValue < refValue) {
                throw new InitializationException("Wrong server version: " + fact + " should be more or equal to " + ref);
            }
            if (factValue > refValue) break;
        }
    }

    private String lastPIDKey() {
        return "last_fs_server_pid:" + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.env);
    }

    private void setLastPID(int pid) {
        NbPreferences.forModule(FSSDispatcher.class).putInt(this.lastPIDKey(), pid);
    }

    private int getLastPID() {
        return NbPreferences.forModule(FSSDispatcher.class).getInt(this.lastPIDKey(), 0);
    }

    public static class InitializationException
    extends Exception {
        public InitializationException(String message) {
            super(message);
        }
    }

    private class FsServer {
        private final PrintWriter writer;
        private final BufferedReader reader;
        private final NativeProcess process;
        private final String path;
        private final String[] args;

        public FsServer(String path) throws IOException, ConnectionManager.CancellationException {
            StringBuilder sb;
            this.path = path;
            NativeProcessBuilder processBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)FSSDispatcher.this.env);
            processBuilder.setExecutable(this.path);
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add("-t");
            argsList.add("4");
            argsList.add("-p");
            argsList.add("-d");
            argsList.add(this.getCacheDirectory());
            if (REFRESH_INTERVAL > 0) {
                argsList.add("-r");
                argsList.add("" + REFRESH_INTERVAL);
            }
            if (VERBOSE > 0) {
                argsList.add("-v");
                argsList.add("" + VERBOSE);
            }
            if (LOG) {
                argsList.add("-l");
            }
            if (FSSDispatcher.this.cleanupUponStart) {
                argsList.add("-c");
            } else if (!FSSDispatcher.this.getFileSystem().getRoot().getImplementor().hasCache()) {
                argsList.add("-c");
            }
            if (SERVER_THREADS > 0) {
                argsList.add("-t");
                argsList.add(Integer.toString(SERVER_THREADS));
            }
            boolean killAllLockers = Boolean.getBoolean("remote.fs_server.kill.all");
            int killTimeout = Integer.getInteger("remote.fs_server.kill.timeout", 3000);
            if (killAllLockers) {
                argsList.add("-K");
                argsList.add(Integer.toString(killTimeout));
            } else {
                int lastPID = FSSDispatcher.this.getLastPID();
                if (lastPID != 0) {
                    argsList.add("-K");
                    argsList.add(Integer.toString(lastPID) + ':' + Integer.toString(killTimeout));
                }
            }
            this.args = argsList.toArray(new String[argsList.size()]);
            processBuilder.setArguments(this.args);
            this.process = processBuilder.call();
            FSSDispatcher.this.setLastPID(this.process.getPID());
            Charset charset = Charset.isSupported("UTF-8") ? Charset.forName("UTF-8") : Charset.defaultCharset();
            this.writer = new PrintWriter(new OutputStreamWriter(this.process.getOutputStream(), charset));
            InputStream inputStream = this.process.getInputStream();
            int available = inputStream.available();
            if (available > 0) {
                sb = new StringBuilder();
                while ((available = inputStream.available()) > 0) {
                    byte[] byArray = new byte[available];
                    int cnt = inputStream.read(byArray);
                    String line = new String(byArray, charset);
                    sb.append(line).append('\n');
                }
                RemoteLogger.finest("Warning: got the following without any request on {0} startup: \n{1}\n", FSSDispatcher.this.env, sb);
                RemoteNotifier.notifyError(NbBundle.getMessage(FSSDispatcher.class, (String)"EchoInProfile_Title", (Object)FSSDispatcher.this.env.getDisplayName()), NbBundle.getMessage(FSSDispatcher.class, (String)"EchoInProfile_Details", (Object)FSSDispatcher.this.env.getDisplayName()));
            }
            this.reader = new BufferedReader(new InputStreamReader(inputStream, charset));
            sb = new StringBuilder("Started remote agent ").append(path).append(' ');
            for (String p : this.args) {
                sb.append(p).append(' ');
            }
            try {
                int n = this.process.getPID();
                sb.append(" [pid=").append(n).append(" at ").append(FSSDispatcher.this.env).append("] ");
            }
            catch (IllegalStateException illegalStateException) {
                sb.append(" [no pid] ");
            }
            RemoteLogger.info(sb.toString(), new Object[0]);
        }

        private String getCacheDirectory() throws IOException, ConnectionManager.CancellationException {
            if (SERVER_CACHE != null) {
                return SERVER_CACHE;
            }
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)FSSDispatcher.this.env);
            String path = hostInfo.getTempDir().trim();
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            return path + "fs_server_cache";
        }

        public PrintWriter getWriter() {
            return this.writer;
        }

        public BufferedReader getReader() {
            return this.reader;
        }

        public NativeProcess getProcess() {
            return this.process;
        }

        private void testDump(PrintStream ps) {
            int pid = -2;
            try {
                pid = this.process.getPID();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ps.printf("\t[pid=%d] %s", pid, this.path);
            for (String p : this.args) {
                ps.print(p);
                ps.print(' ');
            }
            ps.print('\n');
            ps.printf("\t[pid=%d] state=%s ", pid, this.process.getState());
            try {
                ProcessStatusEx exitStatusEx = this.process.getExitStatusEx();
                ps.printf("\trc=%d signalled=%b termSignal=%s ", exitStatusEx.getExitCode(), exitStatusEx.ifSignalled(), exitStatusEx.termSignal());
            }
            catch (Throwable exitStatusEx) {
                // empty catch block
            }
            ps.print('\n');
            if (ProcessUtils.isAlive((Process)this.process)) {
                ProcessUtils.ExitStatus res;
                HostInfo hostInfo = null;
                try {
                    hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)FSSDispatcher.this.env);
                }
                catch (IOException iOException) {
                }
                catch (ConnectionManager.CancellationException cancellationException) {
                    // empty catch block
                }
                if (hostInfo != null && hostInfo.getOSFamily() == HostInfo.OSFamily.SUNOS && (res = ProcessUtils.execute((ExecutionEnvironment)FSSDispatcher.this.env, (String)"pstack", (String[])new String[]{"" + pid})).isOK()) {
                    System.err.println(res.getOutputString());
                }
            }
        }
    }

    private class ErrorReader
    implements Runnable {
        private final InputStream inputStream;

        public ErrorReader(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String oldThreadName = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName("fs_server error reader for " + FSSDispatcher.this.env);
                BufferedReader reader = ProcessUtils.getReader((InputStream)this.inputStream, (boolean)true);
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!SUPPRESS_STDERR) {
                            System.err.printf("%s %s\n", FSSDispatcher.this.env, line);
                        }
                        FSSDispatcher.this.lastErrorMessage.set(line);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                Thread.currentThread().setName(oldThreadName);
            }
        }
    }

    private class MainLoop
    implements Runnable {
        private MainLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int exceptionsCount = 0;
            String oldThreadName = Thread.currentThread().getName();
            try {
                ArrayList respCopy;
                String line;
                Thread.currentThread().setName("fs_server dispatcher for " + FSSDispatcher.this.env);
                FsServer server = FSSDispatcher.this.getServer();
                if (server == null) {
                    RemoteLogger.warning("Can not launch file system server on {0}", FSSDispatcher.this.env);
                    return;
                }
                BufferedReader reader = server.getReader();
                String prevLine = null;
                while ((line = reader.readLine()) != null) {
                    Object path;
                    if (line.isEmpty()) {
                        RemoteLogger.fine("error: empty line for {0} prev.line was {1}", FSSDispatcher.this.traceName, prevLine);
                        continue;
                    }
                    prevLine = line;
                    Buffer buf = new Buffer(line);
                    char respKind = buf.getChar();
                    int respId = buf.getInt();
                    if (respId == 0) {
                        RemoteLogger.finest("got fs_server notification: {0}", line);
                        if (respKind == FSSResponseKind.FS_RSP_CHANGE.getChar()) {
                            path = buf.getString();
                            FSSDispatcher.this.addToRefresh((String)path);
                            continue;
                        }
                        RemoteLogger.info("wrong response #0: {1}", line);
                        continue;
                    }
                    path = FSSDispatcher.this.responseLock;
                    synchronized (path) {
                        FSSResponse response = (FSSResponse)FSSDispatcher.this.responses.get(respId);
                        if (response == null) {
                            RemoteLogger.fine("skipping {0} response #{1}: {2}", FSSDispatcher.this.traceName, respId, line);
                        } else {
                            response.addPackage(FSSResponseKind.fromChar(respKind), line);
                        }
                    }
                }
                Object respKind = FSSDispatcher.this.responseLock;
                synchronized (respKind) {
                    respCopy = new ArrayList(FSSDispatcher.this.responses.values());
                    FSSDispatcher.this.responses.clear();
                }
                ExecutionException ex = new ExecutionException(RemoteExceptions.createConnectException(RemoteFileSystemUtils.getConnectExceptionMessage(FSSDispatcher.this.env)));
                for (FSSResponse resp : respCopy) {
                    resp.failed(ex);
                }
                NativeProcess process = server.getProcess();
                if (!ProcessUtils.isAlive((Process)process)) {
                    int rc = process.waitFor();
                    RemoteLogger.finest("fs_server (pid {0} at {1}) exited with rc = {2}", process.getPID(), FSSDispatcher.this.env, rc);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
            catch (Throwable thr) {
                thr.printStackTrace(System.err);
                if (exceptionsCount++ > 1000) {
                    FSSDispatcher.this.setInvalid(true);
                }
            }
            finally {
                try {
                    FSSDispatcher.this.checkValid();
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace(System.err);
                }
                catch (InterruptedException ex) {}
                Thread.currentThread().setName(oldThreadName);
            }
        }
    }

    private class ConnectTask
    implements Runnable {
        private ConnectTask() {
        }

        @Override
        public void run() {
            String oldThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("fs_server on-connect initialization for " + FSSDispatcher.this.env);
            try {
                FSSDispatcher.this.sendRefreshRequest("/");
            }
            finally {
                Thread.currentThread().setName(oldThreadName);
            }
        }
    }

    private class RefreshTask
    implements Runnable {
        private final String path;

        public RefreshTask(String path) {
            this.path = path;
        }

        @Override
        public void run() {
            FSSDispatcher.this.sendRefreshRequest(this.path);
        }
    }
}

