/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.lexer;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.php.smarty.editor.lexer.TplTokenId;
import org.netbeans.modules.php.smarty.editor.utlis.LexerUtils;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class TplLexer
implements Lexer<TplTokenId> {
    private static final int EOF = -1;
    private final LexerInput input;
    private String keyword;
    private boolean argValue;
    private boolean endingTag;
    private final TokenFactory<TplTokenId> tokenFactory;
    private final InputAttributes inputAttributes;
    private int lexerState = 0;
    private static final int INIT = 0;
    private static final int ISI_TEXT = 1;
    private static final int ISI_ERROR = 2;
    private static final int ISA_DOLLAR = 3;
    private static final int ISI_VAR_PHP = 4;
    private static final int ISA_WS = 9;
    private static final int ISA_HASH = 10;
    private static final int ISI_QUOT = 12;
    private static final int ISI_DQUOT = 13;
    static final Set<String> VARIABLE_MODIFIERS = new HashSet<String>();
    static final Set<String> OPERATORS;
    static final Set<String> FUNCTIONS;

    public TplLexer(LexerRestartInfo<TplTokenId> info) {
        this.input = info.input();
        this.inputAttributes = info.inputAttributes();
        this.tokenFactory = info.tokenFactory();
        if (info.state() == null) {
            this.keyword = "";
            this.argValue = false;
            this.endingTag = false;
            this.lexerState = 0;
        } else {
            CompoundState cs = (CompoundState)info.state();
            this.lexerState = cs.lexerState;
            this.argValue = cs.isArgumentValue;
            this.endingTag = cs.isEndingTag;
            this.keyword = cs.keyword;
        }
    }

    public Object state() {
        return new CompoundState(this.lexerState, this.argValue, this.endingTag, this.keyword);
    }

    public Token<TplTokenId> nextToken() {
        block22: while (true) {
            int actChar;
            if ((actChar = this.input.read()) == -1) {
                if (this.input.readLengthEOF() == 1) {
                    return null;
                }
                if (this.lexerState == 0) {
                    return this.token(TplTokenId.OTHER);
                }
            }
            block0 : switch (this.lexerState) {
                case 0: {
                    switch (actChar) {
                        case 36: {
                            this.lexerState = 3;
                            break block0;
                        }
                        case 35: {
                            this.lexerState = 10;
                            break block0;
                        }
                        case 39: {
                            this.lexerState = 12;
                            break block0;
                        }
                        case 47: {
                            this.endingTag = true;
                            break block0;
                        }
                        case 34: {
                            this.lexerState = 13;
                            break block0;
                        }
                        case 61: {
                            this.argValue = true;
                            return this.token(TplTokenId.OTHER);
                        }
                        case 124: {
                            if (this.input.read() == 124) {
                                return this.token(TplTokenId.OTHER);
                            }
                            this.input.backup(1);
                            return this.token(TplTokenId.PIPE);
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            this.argValue = false;
                            this.lexerState = 9;
                            return this.token(TplTokenId.WHITESPACE);
                        }
                        case -1: {
                            return null;
                        }
                    }
                    this.input.backup(1);
                    this.lexerState = 1;
                    break;
                }
                case 3: {
                    this.argValue = false;
                    if (Character.isJavaIdentifierStart(actChar)) {
                        this.lexerState = 4;
                        break;
                    }
                    this.input.backup(1);
                    this.lexerState = 2;
                    break;
                }
                case 10: {
                    this.argValue = false;
                    if (Character.isJavaIdentifierPart(actChar)) continue block22;
                    if (actChar == 35 && this.input.readLength() > 2) {
                        this.lexerState = 0;
                        return this.token(TplTokenId.CONFIG_VARIABLE);
                    }
                    return this.token(TplTokenId.ERROR);
                }
                case 12: {
                    this.argValue = false;
                    if (actChar == 39 || actChar == -1) {
                        this.lexerState = 0;
                        return this.token(TplTokenId.STRING);
                    }
                    if (actChar == 92) {
                        if (this.input.read() == 39) {
                            return this.token(TplTokenId.STRING);
                        }
                        this.input.backup(1);
                        break;
                    }
                    return this.token(TplTokenId.STRING);
                }
                case 13: {
                    this.argValue = false;
                    if (actChar == 34 || actChar == -1) {
                        this.lexerState = 0;
                        return this.token(TplTokenId.STRING);
                    }
                    if (actChar == 92) {
                        if (this.input.read() == 34) {
                            return this.token(TplTokenId.STRING);
                        }
                        this.input.backup(1);
                        break;
                    }
                    return this.token(TplTokenId.STRING);
                }
                case 4: {
                    if (LexerUtils.isVariablePart(actChar)) continue block22;
                    this.lexerState = 0;
                    if (this.input.readLength() <= 1) continue block22;
                    this.input.backup(1);
                    return this.token(TplTokenId.PHP_VARIABLE);
                }
                case 9: {
                    if (LexerUtils.isWS(actChar)) {
                        return this.token(TplTokenId.WHITESPACE);
                    }
                    this.input.backup(1);
                    this.lexerState = 0;
                    break;
                }
                case 2: {
                    this.lexerState = 0;
                    return this.token(TplTokenId.ERROR);
                }
                case 1: {
                    if (LexerUtils.isVariablePart(actChar)) {
                        this.keyword = this.keyword + Character.toString((char)actChar);
                        break;
                    }
                    if (this.input.readLengthEOF() == 1) {
                        this.lexerState = 0;
                        if (LexerUtils.isWS(actChar)) {
                            return this.token(TplTokenId.WHITESPACE);
                        }
                        return this.token(TplTokenId.OTHER);
                    }
                    this.input.backup(1);
                    TplTokenId tokenId = this.resolveStringToken(this.keyword);
                    this.keyword = "";
                    this.lexerState = 0;
                    return this.token(tokenId);
                }
                default: {
                    return this.token(TplTokenId.OTHER);
                }
            }
        }
    }

    public void release() {
    }

    private Token<TplTokenId> token(TplTokenId tplTokenId) {
        return this.tokenFactory.createToken((TokenId)tplTokenId);
    }

    private TplTokenId resolveStringToken(String keyword) {
        if (this.isVariableModifier(keyword)) {
            return TplTokenId.VARIABLE_MODIFIER;
        }
        if (this.isVariableOperator(keyword)) {
            return TplTokenId.OPERATOR;
        }
        if (this.isSmartyFunction(keyword)) {
            if (this.input.read() != 46) {
                this.input.backup(1);
                this.endingTag = false;
                return TplTokenId.FUNCTION;
            }
            this.input.backup(1);
            return TplTokenId.OTHER;
        }
        if (this.argValue) {
            return TplTokenId.ARGUMENT_VALUE;
        }
        int readChars = 1;
        int c = this.input.read();
        while (LexerUtils.isWS(c)) {
            ++readChars;
            c = this.input.read();
        }
        if (c == 61) {
            c = this.input.read();
            this.input.backup(++readChars);
            if (c == 61) {
                return TplTokenId.OTHER;
            }
            return TplTokenId.ARGUMENT;
        }
        this.input.backup(readChars);
        return TplTokenId.OTHER;
    }

    private boolean isVariableModifier(String keyword) {
        return VARIABLE_MODIFIERS.contains(keyword.toString().toLowerCase(Locale.ENGLISH));
    }

    private boolean isVariableOperator(String keyword) {
        return OPERATORS.contains(keyword.toString().toLowerCase(Locale.ENGLISH));
    }

    private boolean isSmartyFunction(String keyword) {
        return FUNCTIONS.contains(keyword.toString().toLowerCase(Locale.ENGLISH));
    }

    static {
        VARIABLE_MODIFIERS.add("capitalize");
        VARIABLE_MODIFIERS.add("cat");
        VARIABLE_MODIFIERS.add("count_characters");
        VARIABLE_MODIFIERS.add("count_paragraphs");
        VARIABLE_MODIFIERS.add("count_sentences");
        VARIABLE_MODIFIERS.add("count_words");
        VARIABLE_MODIFIERS.add("date_format");
        VARIABLE_MODIFIERS.add("default");
        VARIABLE_MODIFIERS.add("escape");
        VARIABLE_MODIFIERS.add("from_charset");
        VARIABLE_MODIFIERS.add("indent");
        VARIABLE_MODIFIERS.add("lower");
        VARIABLE_MODIFIERS.add("nl2br");
        VARIABLE_MODIFIERS.add("regex_replace");
        VARIABLE_MODIFIERS.add("replace");
        VARIABLE_MODIFIERS.add("spacify");
        VARIABLE_MODIFIERS.add("string_format");
        VARIABLE_MODIFIERS.add("strip");
        VARIABLE_MODIFIERS.add("strip_tags");
        VARIABLE_MODIFIERS.add("to_charset");
        VARIABLE_MODIFIERS.add("truncate");
        VARIABLE_MODIFIERS.add("unescape");
        VARIABLE_MODIFIERS.add("upper");
        VARIABLE_MODIFIERS.add("wordwrap");
        OPERATORS = new HashSet<String>();
        OPERATORS.add("as");
        OPERATORS.add("div");
        OPERATORS.add("by");
        OPERATORS.add("even");
        OPERATORS.add("is");
        OPERATORS.add("not");
        OPERATORS.add("odd");
        OPERATORS.add("eq");
        OPERATORS.add("ge");
        OPERATORS.add("gt");
        OPERATORS.add("gte");
        OPERATORS.add("le");
        OPERATORS.add("lt");
        OPERATORS.add("lte");
        OPERATORS.add("mod");
        OPERATORS.add("ne");
        OPERATORS.add("neq");
        OPERATORS.add("not");
        OPERATORS.add("or");
        OPERATORS.add("and");
        FUNCTIONS = new HashSet<String>();
        FUNCTIONS.add("append");
        FUNCTIONS.add("assign");
        FUNCTIONS.add("block");
        FUNCTIONS.add("call");
        FUNCTIONS.add("capture");
        FUNCTIONS.add("config_load");
        FUNCTIONS.add("counter");
        FUNCTIONS.add("cycle");
        FUNCTIONS.add("debug");
        FUNCTIONS.add("else");
        FUNCTIONS.add("elseif");
        FUNCTIONS.add("eval");
        FUNCTIONS.add("extends");
        FUNCTIONS.add("fetch");
        FUNCTIONS.add("for");
        FUNCTIONS.add("foreach");
        FUNCTIONS.add("foreachelse");
        FUNCTIONS.add("function");
        FUNCTIONS.add("html_checkboxes");
        FUNCTIONS.add("html_image");
        FUNCTIONS.add("html_options");
        FUNCTIONS.add("html_radios");
        FUNCTIONS.add("html_select_date");
        FUNCTIONS.add("html_select_time");
        FUNCTIONS.add("html_table");
        FUNCTIONS.add("if");
        FUNCTIONS.add("include");
        FUNCTIONS.add("include_php");
        FUNCTIONS.add("insert");
        FUNCTIONS.add("ldelim");
        FUNCTIONS.add("literal");
        FUNCTIONS.add("mailto");
        FUNCTIONS.add("math");
        FUNCTIONS.add("nocache");
        FUNCTIONS.add("php");
        FUNCTIONS.add("popup");
        FUNCTIONS.add("popup_init");
        FUNCTIONS.add("rdelim");
        FUNCTIONS.add("section");
        FUNCTIONS.add("sectionelse");
        FUNCTIONS.add("setfilter");
        FUNCTIONS.add("strip");
        FUNCTIONS.add("textformat");
        FUNCTIONS.add("while");
    }

    private static class CompoundState {
        private int lexerState;
        private boolean isArgumentValue;
        private boolean isEndingTag;
        private String keyword;

        public CompoundState(int lexerState, boolean isArgumentValue, boolean isEndingTag, String keyword) {
            this.lexerState = lexerState;
            this.isArgumentValue = isArgumentValue;
            this.isEndingTag = isEndingTag;
            this.keyword = keyword;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompoundState other = (CompoundState)obj;
            if (this.lexerState != other.lexerState) {
                return false;
            }
            if (this.isArgumentValue != other.isArgumentValue) {
                return false;
            }
            if (this.isEndingTag != other.isEndingTag) {
                return false;
            }
            return this.keyword == other.keyword || this.keyword != null && this.keyword.equals(other.keyword);
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + this.lexerState;
            hash = 17 * hash + (this.isArgumentValue ? 1 : 0);
            hash = 17 * hash + (this.isEndingTag ? 1 : 0);
            hash = 17 * hash + (this.keyword != null ? this.keyword.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return "State(hash=" + this.hashCode() + ",s=" + this.lexerState + ",iAV=" + this.isArgumentValue + ",iET=" + this.isEndingTag + ",keyword=" + this.keyword + ")";
        }
    }
}

