/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ThreadInfo;

public class ProfilerRuntimeCPUFullInstr
extends ProfilerRuntimeCPU {
    public static void enableProfiling(boolean v) {
        if (v) {
            ProfilerRuntimeCPUFullInstr.createNewDataStructures();
            ProfilerRuntimeCPU.enableProfiling(v);
        } else {
            ProfilerRuntimeCPU.enableProfiling(v);
            ProfilerRuntimeCPUFullInstr.clearDataStructures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void markerMethodEntry(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        if (!ti.isInitialized()) {
            if (nProfiledThreadsAllowed <= 0 || ThreadInfo.isCurrentThreadProfilerServerThread()) return;
            ti.initialize();
            ti.useEventBuffer();
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                --nProfiledThreadsAllowed;
                ++ti.inProfilingRuntimeMethod;
                ti.inCallGraph = true;
                ProfilerRuntimeCPUFullInstr.writeThreadCreationEvent(ti);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            ++ti.inProfilingRuntimeMethod;
            ti.inCallGraph = true;
        }
        {
            if (ti.stackDepth <= stackDepthLimit) {
                int methodIdInt = methodId & 0xFF;
                if (!instrMethodInvoked[methodIdInt |= methodId & 0xFF00]) {
                    ProfilerRuntimeCPUFullInstr.instrMethodInvoked[methodIdInt] = true;
                    if (ti.rootMethodStackDepth > 0) {
                        ProfilerRuntimeCPUFullInstr.firstTimeMethodInvoke(ti, methodId);
                    }
                }
                ProfilerServer.notifyClientOnResultsAvailability();
                ProfilerRuntimeCPUFullInstr.writeParametersEvent(ti);
                ProfilerRuntimeCPUFullInstr.writeTimeStampedEvent((byte)3, ti, methodId);
            }
            ++ti.stackDepth;
            --ti.inProfilingRuntimeMethod;
            return;
        }
    }

    public static void markerMethodExit(char methodId) {
        ProfilerRuntimeCPUFullInstr.markerMethodExit(NO_RET_VALUE, methodId);
    }

    public static void markerMethodExit(Object ret, char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            --ti.stackDepth;
            if (ti.stackDepth < 1) {
                ti.inCallGraph = false;
            }
            if (ti.stackDepth <= stackDepthLimit) {
                ProfilerRuntimeCPUFullInstr.writeRetValue(ret, ti);
                ProfilerRuntimeCPUFullInstr.writeTimeStampedEvent((byte)4, ti, methodId);
            }
            --ti.inProfilingRuntimeMethod;
        }
    }

    public static void methodEntry(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph && ti.rootMethodStackDepth > 0) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            if (ti.stackDepth <= stackDepthLimit) {
                int methodIdInt = methodId & 0xFF;
                if (!instrMethodInvoked[methodIdInt |= methodId & 0xFF00]) {
                    ProfilerRuntimeCPUFullInstr.instrMethodInvoked[methodIdInt] = true;
                    ProfilerRuntimeCPUFullInstr.firstTimeMethodInvoke(ti, methodId);
                }
                ProfilerRuntimeCPUFullInstr.writeTimeStampedEvent((byte)6, ti, methodId);
            }
            ++ti.stackDepth;
            --ti.inProfilingRuntimeMethod;
        }
    }

    public static void methodExit(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.isInitialized() && ti.inCallGraph && ti.rootMethodStackDepth > 0) {
            if (ti.inProfilingRuntimeMethod > 0) {
                return;
            }
            ++ti.inProfilingRuntimeMethod;
            if (ti.rootMethodStackDepth == ti.stackDepth) {
                ti.rootMethodStackDepth = 0;
            }
            --ti.stackDepth;
            if (ti.stackDepth < 1) {
                ti.inCallGraph = false;
                ProfilerRuntimeCPUFullInstr.writeTimeStampedEvent((byte)2, ti, methodId);
            } else if (ti.rootMethodStackDepth == 0) {
                ProfilerRuntimeCPUFullInstr.writeTimeStampedEvent((byte)2, ti, methodId);
            } else if (ti.stackDepth <= stackDepthLimit) {
                ProfilerRuntimeCPUFullInstr.writeTimeStampedEvent((byte)7, ti, methodId);
            }
            --ti.inProfilingRuntimeMethod;
        }
    }

    public static void resumeActiveTimers() {
        ProfilerRuntimeCPUFullInstr.writeTimeStampedEvent((byte)9, null, '\u0000');
        ProfilerRuntimeCPUFullInstr.changeAllThreadsInProfRuntimeMethodStatus(-1);
        recursiveInstrumentationDisabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void rootMethodEntry(char methodId) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo ti = ThreadInfo.getThreadInfo();
        if (ti.inProfilingRuntimeMethod > 0) {
            return;
        }
        ProfilerServer.notifyClientOnResultsAvailability();
        if (ti.isInitialized() && !ti.inCallGraph && ti.stackDepth > 0) {
            ti.inCallGraph = true;
            ProfilerRuntimeCPUFullInstr.methodEntry(methodId);
            ti.inCallGraph = false;
            return;
        }
        if (ti.isInitialized() && ti.inCallGraph && ti.rootMethodStackDepth > 0) {
            ProfilerRuntimeCPUFullInstr.methodEntry(methodId);
            return;
        }
        if (!ti.isInitialized()) {
            if (nProfiledThreadsAllowed <= 0) return;
            if (ThreadInfo.isCurrentThreadProfilerServerThread()) return;
            ti.initialize();
            ti.useEventBuffer();
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                --nProfiledThreadsAllowed;
                ++ti.inProfilingRuntimeMethod;
                if (!ProfilerServer.startProfilingPointsActive()) {
                    ti.inCallGraph = true;
                }
                ProfilerRuntimeCPUFullInstr.writeThreadCreationEvent(ti);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else {
            ++ti.inProfilingRuntimeMethod;
            if (ti.stackDepth == 0 && !ProfilerServer.startProfilingPointsActive()) {
                ti.inCallGraph = true;
            }
        }
        {
            int methodIdInt = methodId & 0xFF;
            if (!instrMethodInvoked[methodIdInt |= methodId & 0xFF00]) {
                ProfilerRuntimeCPUFullInstr.instrMethodInvoked[methodIdInt] = true;
                if (enableFirstTimeMethodInvoke) {
                    externalActionsHandler.handleFirstTimeMethodInvoke(methodId);
                }
            }
            ++ti.stackDepth;
            ProfilerRuntimeCPUFullInstr.writeTimeStampedEvent((byte)1, ti, methodId);
            ti.rootMethodStackDepth = ti.stackDepth;
            --ti.inProfilingRuntimeMethod;
            return;
        }
    }

    public static void suspendActiveTimers() {
        ProfilerRuntimeCPUFullInstr.changeAllThreadsInProfRuntimeMethodStatus(1);
        recursiveInstrumentationDisabled = true;
        ProfilerRuntimeCPUFullInstr.writeTimeStampedEvent((byte)8, null, '\u0000');
    }

    protected static void clearDataStructures() {
        ProfilerRuntimeCPU.clearDataStructures();
    }
}

