/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.picklist.DefaultPicklistModel;
import org.netbeans.modules.cnd.api.project.CodeAssistance;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.utils.ImportUtils;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.DefaultProjectOperationsImplementationExecutorImpl;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProjectImpl;
import org.netbeans.modules.cnd.makeproject.api.MakeActionProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeCommandFlagsProviderFactory;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.StepControllerProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.AssemblerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ComboStringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Platform;
import org.netbeans.modules.cnd.makeproject.api.configurations.Platforms;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.api.wizards.PreBuildSupport;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.CompileOptionsProvider;
import org.netbeans.modules.cnd.makeproject.uiapi.ConfirmSupport;
import org.netbeans.modules.cnd.makeproject.uiapi.DefaultProjectOperationsImplementationUI;
import org.netbeans.modules.cnd.makeproject.uiapi.LongOperation;
import org.netbeans.modules.cnd.makeproject.uiapi.RunActionSupport;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.toolchain.CompilerSetFactory;
import org.netbeans.modules.cnd.spi.utils.CndNotifier;
import org.netbeans.modules.cnd.toolchain.support.ToolchainUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.OSSComponentUsages;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.ShellValidationSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.project.ActionProgress;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class MakeActionProviderImpl
implements MakeActionProvider {
    private static final String[] supportedActions = new String[]{"pre_build", "build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.stepinto", "debug.single", "batch_build", "build_packages", "delete", "copy", "move", "rename", "custom.action", "test", "test.single", "debug.test", "debug.stepinto.test"};
    private final MakeProject project;
    private final Map<String, Commands> commands;
    private boolean lastValidation = false;
    private static final String SAVE_STEP = "save";
    private static final String PRE_BUILD_STEP = "pre-build";
    private static final String BUILD_STEP = "build";
    private static final String BUILD_PACKAGE_STEP = "build-package";
    private static final String CLEAN_STEP = "clean";
    private static final String RUN_STEP = "run";
    private static final String DEBUG_STEP = "debug";
    private static final String DEBUG_STEPINTO_STEP = "debug-stepinto";
    private static final String RUN_SINGLE_STEP = "run-single";
    private static final String DEBUG_SINGLE_STEP = "debug-single";
    private static final String COMPILE_SINGLE_STEP = "compile-single";
    private static final String CUSTOM_ACTION_STEP = "custom-action";
    private static final String VALIDATE_TOOLCHAIN = "validate-toolchain";
    private static final String BUILD_TESTS_STEP = "build-tests";
    private static final String TEST_STEP = "test";
    private static final String TEST_SINGLE_STEP = "test-single";
    private static final String DEBUG_TEST_STEP = "debug-test";
    private static final String DEBUG_STEPINTO_TEST_STEP = "debug-stepinto-test";
    private static final RequestProcessor RP = new RequestProcessor("Make Action RP", 1);
    private static final boolean PARALLEL_POST = "true".equals(System.getProperty("org.netbeans.modules.cnd.makeproject.parallel-build", "false"));
    private static final Map<String, Boolean> fileExistenceCache = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> validExecutablesCache = new HashMap<String, Boolean>();

    public MakeActionProviderImpl(MakeProject project) {
        this.project = project;
        this.commands = this.loadAcrionSteps("CND/BuildAction");
    }

    private Map<String, Commands> loadAcrionSteps(String root) {
        HashMap<String, Commands> res = new HashMap<String, Commands>();
        FileObject folder = FileUtil.getConfigFile((String)root);
        if (folder != null && folder.isFolder()) {
            for (FileObject subFolder : folder.getChildren()) {
                if (!subFolder.isFolder()) continue;
                TreeMap<Integer, Command> map = new TreeMap<Integer, Command>();
                for (FileObject file : subFolder.getChildren()) {
                    Integer position = (Integer)file.getAttribute("position");
                    String flag = (String)file.getAttribute("flag");
                    map.put(position, new Command(file.getNameExt(), flag));
                }
                res.put(subFolder.getNameExt(), new Commands(subFolder.getNameExt(), map.values()));
            }
        }
        return res;
    }

    private boolean isProjectDescriptorLoaded() {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        return pdp.gotDescriptor();
    }

    private MakeConfigurationDescriptor getProjectDescriptor() {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        return pdp.getConfigurationDescriptor();
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    private void saveIfModified() {
        if (this.getProjectDescriptor() != null && this.getProjectDescriptor().isModified()) {
            this.getProjectDescriptor().save();
        }
    }

    public void invokeAction(String command, final Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            try {
                ((MakeProjectImpl)this.project).setDeleting(true);
                DefaultProjectOperationsImplementationUI.getDefaultProjectOperationsImplementationUI().deleteProject(this.project, new DefaultProjectOperationsImplementationExecutorImpl());
            }
            finally {
                ((MakeProjectImpl)this.project).setDeleting(false);
            }
            return;
        }
        if ("copy".equals(command)) {
            this.saveIfModified();
            DefaultProjectOperationsImplementationUI.getDefaultProjectOperationsImplementationUI().copyProject(this.project, new DefaultProjectOperationsImplementationExecutorImpl());
            return;
        }
        if ("move".equals(command)) {
            this.saveIfModified();
            DefaultProjectOperationsImplementationUI.getDefaultProjectOperationsImplementationUI().moveProject(this.project, new DefaultProjectOperationsImplementationExecutorImpl());
            return;
        }
        if ("rename".equals(command)) {
            this.saveIfModified();
            DefaultProjectOperationsImplementationUI.getDefaultProjectOperationsImplementationUI().renameProject(this.project, new DefaultProjectOperationsImplementationExecutorImpl());
            return;
        }
        if ("run.single".equals(command)) {
            RunActionSupport.geRunActionSupport().run(context);
            return;
        }
        final MakeConfigurationDescriptor pd = this.getProjectDescriptor();
        MakeConfiguration activeConf = pd.getActiveConfiguration();
        if (activeConf == null) {
            return;
        }
        final ArrayList<MakeConfiguration> confs = new ArrayList<MakeConfiguration>();
        if (command.equals("batch_build")) {
            Configuration[] confsArray;
            ConfirmSupport.BatchConfigurationSelector selector = ConfirmSupport.getBatchConfigurationSelectorFactory().create(this.project, pd.getConfs().toArray());
            if (selector == null) {
                return;
            }
            command = selector.getCommand();
            for (Configuration conf : confsArray = selector.getSelectedConfs()) {
                confs.add((MakeConfiguration)conf);
            }
        } else {
            confs.add(activeConf);
        }
        final String finalCommand = command;
        ActionProgress progress = PARALLEL_POST ? null : ActionProgress.start((Lookup)context);
        LongOperation.CancellableTask actionWorker = new LongOperation.CancellableTask(progress){

            @Override
            protected void runImpl() {
                final ArrayList actionEvents = new ArrayList();
                for (MakeConfiguration conf : confs) {
                    if (MakeActionProviderImpl.this.addAction(actionEvents, pd, conf, finalCommand, context, this.getCancelled())) continue;
                    if (!this.getCancelled().isCanceled()) {
                        this.getCancelled().getActionProgress().finished(false);
                    }
                    return;
                }
                if (!this.getCancelled().isCanceled()) {
                    if (actionEvents.size() > 0) {
                        RP.post((Runnable)new NamedRunnable("Make Project Action Worker"){

                            protected void runImpl() {
                                ProjectActionSupport.getInstance().fireActionPerformed(actionEvents.toArray(new ProjectActionEvent[actionEvents.size()]), null, this.getCancelled().getActionProgress());
                            }
                        });
                    } else {
                        this.getCancelled().getActionProgress().finished(false);
                    }
                }
            }
        };
        ConfigurationDescriptorProvider.recordActionMetrics(command, pd);
        MakeActionProviderImpl.runActionWorker(activeConf.getDevelopmentHost().getExecutionEnvironment(), actionWorker);
    }

    private static void runActionWorker(ExecutionEnvironment exeEnv, LongOperation.CancellableTask actionWorker) {
        ServerRecord record = ServerList.get((ExecutionEnvironment)exeEnv);
        assert (record != null);
        MakeActionProviderImpl.invokeLongAction(record, actionWorker);
    }

    public void invokeCustomAction(final MakeConfigurationDescriptor pd, final MakeConfiguration conf, final ProjectActionHandler customProjectActionHandler) {
        LongOperation.CancellableTask actionWorker = new LongOperation.CancellableTask(null){

            @Override
            protected void runImpl() {
                ArrayList actionEvents = new ArrayList();
                MakeActionProviderImpl.this.addAction(actionEvents, pd, conf, "custom.action", null, this.getCancelled());
                ProjectActionSupport.getInstance().fireActionPerformed(actionEvents.toArray(new ProjectActionEvent[actionEvents.size()]), customProjectActionHandler);
            }
        };
        MakeActionProviderImpl.runActionWorker(conf.getDevelopmentHost().getExecutionEnvironment(), actionWorker);
    }

    private static void invokeLongAction(final ServerRecord record, final LongOperation.CancellableTask actionWorker) {
        LongOperation.CancellableTask wrapper;
        if (!record.isDeleted() && record.isOnline()) {
            wrapper = actionWorker;
        } else {
            if (record.isDeleted()) {
                String message = MessageFormat.format(MakeActionProviderImpl.getString("ERR_RequestingDeletedConnection"), record.getDisplayName());
                String autoConfirm = message + "\n Confirm Yes";
                if (CndUtils.isUnitTestMode() || CndUtils.isStandalone()) {
                    new Exception(autoConfirm).printStackTrace(System.err);
                    ServerList.addServer((ExecutionEnvironment)record.getExecutionEnvironment(), (String)record.getDisplayName(), (RemoteSyncFactory)record.getSyncFactory(), (boolean)false, (boolean)true);
                } else {
                    ConfirmSupport.AutoConfirm confirm = ConfirmSupport.getConfirmCreateConnectionFactory().createConnection(MakeActionProviderImpl.getString("DLG_TITLE_DeletedConnection"), message, autoConfirm);
                    if (confirm == null) {
                        return;
                    }
                    ServerList.addServer((ExecutionEnvironment)record.getExecutionEnvironment(), (String)record.getDisplayName(), (RemoteSyncFactory)record.getSyncFactory(), (boolean)false, (boolean)true);
                }
            }
            wrapper = new LongOperation.CancellableTask(actionWorker.getCancelled().getActionProgress()){

                @Override
                public boolean cancel() {
                    return actionWorker.cancel();
                }

                @Override
                public void runImpl() {
                    try {
                        if (!ConnectionManager.getInstance().isConnectedTo(record.getExecutionEnvironment())) {
                            ConnectionManager.getInstance().connectTo(record.getExecutionEnvironment());
                        }
                        record.validate(true);
                        CompilerSetManager csm = CompilerSetManager.get((ExecutionEnvironment)record.getExecutionEnvironment());
                        csm.initialize(true, true, null);
                    }
                    catch (ConnectionManager.CancellationException ex) {
                        this.cancel();
                    }
                    catch (Exception e) {
                        String message = MessageFormat.format(MakeActionProviderImpl.getString("ERR_Cant_Connect"), record.getDisplayName());
                        if (CndUtils.isUnitTestMode() || CndUtils.isStandalone()) {
                            new Exception(message).printStackTrace(System.err);
                        }
                        String title = MakeActionProviderImpl.getString("DLG_TITLE_Cant_Connect");
                        ConfirmSupport.getNotifyCantConnectFactory().showErrorLater(title, message);
                    }
                    if (record.isOnline()) {
                        actionWorker.run();
                    }
                }
            };
        }
        LongOperation.getLongOperation().executeLongOperation(wrapper, NbBundle.getMessage(MakeActionProviderImpl.class, (String)"DLG_TITLE_Validate_Host"), NbBundle.getMessage(MakeActionProviderImpl.class, (String)"MSG_Validate_Host", (Object)record.getDisplayName()));
    }

    private boolean addAction(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, String command, Lookup context, LongOperation.CanceledState cancelled) throws IllegalArgumentException {
        if (cancelled.isCanceled()) {
            return false;
        }
        AtomicBoolean validated = new AtomicBoolean(false);
        this.lastValidation = false;
        String[] targetNames = this.getTargetNames(command, conf, context);
        if (targetNames == null || targetNames.length == 0) {
            return false;
        }
        for (int i = 0; i < targetNames.length; ++i) {
            String targetName = targetNames[i];
            ArrayList<String> tail = new ArrayList<String>();
            for (int j = i + 1; j < targetNames.length; ++j) {
                tail.add(targetNames[j]);
            }
            List<String> delegate = this.validateStep(targetName, tail);
            if (delegate != null) {
                for (String target : delegate) {
                    if (!this.addTarget(target, actionEvents, pd, conf, context, cancelled, validated)) break;
                }
                continue;
            }
            if (!this.addTarget(targetName, actionEvents, pd, conf, context, cancelled, validated)) break;
        }
        return true;
    }

    private boolean addTarget(String targetName, ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, Lookup context, LongOperation.CanceledState cancelled, AtomicBoolean validated) throws IllegalArgumentException {
        if (cancelled.isCanceled()) {
            return false;
        }
        if (targetName.equals(SAVE_STEP)) {
            return this.onSaveStep();
        }
        if (targetName.equals(VALIDATE_TOOLCHAIN)) {
            return this.onValidateToolchainStep(pd, conf, cancelled, validated, context);
        }
        if (targetName.equals(PRE_BUILD_STEP)) {
            return this.onPreBuildStep(actionEvents, pd, conf, context, ProjectActionEvent.PredefinedType.PRE_BUILD);
        }
        if (targetName.equals(BUILD_STEP)) {
            return this.onBuildStep(actionEvents, pd, conf, context, ProjectActionEvent.PredefinedType.BUILD);
        }
        if (targetName.equals(BUILD_TESTS_STEP)) {
            return this.onBuildStep(actionEvents, pd, conf, context, ProjectActionEvent.PredefinedType.BUILD_TESTS);
        }
        if (targetName.equals(BUILD_PACKAGE_STEP)) {
            return this.onBuildPackageStep(actionEvents, conf, context, ProjectActionEvent.PredefinedType.BUILD);
        }
        if (targetName.equals(CLEAN_STEP)) {
            return this.onCleanStep(actionEvents, pd, conf, context, ProjectActionEvent.PredefinedType.CLEAN);
        }
        if (targetName.equals(COMPILE_SINGLE_STEP)) {
            return this.onCompileSingleStep(actionEvents, pd, conf, context, ProjectActionEvent.PredefinedType.COMPILE_SINGLE);
        }
        if (targetName.equals(RUN_STEP)) {
            return this.onRunStep(actionEvents, pd, conf, cancelled, validated, context, ProjectActionEvent.PredefinedType.RUN);
        }
        if (targetName.equals(TEST_STEP)) {
            return this.onRunStep(actionEvents, pd, conf, cancelled, validated, context, ProjectActionEvent.PredefinedType.TEST);
        }
        if (targetName.equals(TEST_SINGLE_STEP)) {
            return this.onTestSingleStep(actionEvents, pd, conf, context, ProjectActionEvent.PredefinedType.TEST);
        }
        if (targetName.equals(RUN_SINGLE_STEP) || targetName.equals(DEBUG_SINGLE_STEP)) {
            return this.onRunSingleStep(conf, actionEvents, context, ProjectActionEvent.PredefinedType.RUN);
        }
        if (targetName.equals(DEBUG_STEP)) {
            return this.onRunStep(actionEvents, pd, conf, cancelled, validated, context, ProjectActionEvent.PredefinedType.DEBUG);
        }
        if (targetName.equals(DEBUG_TEST_STEP)) {
            return this.onRunStep(actionEvents, pd, conf, cancelled, validated, context, ProjectActionEvent.PredefinedType.DEBUG_TEST);
        }
        if (targetName.equals(DEBUG_STEPINTO_STEP)) {
            return this.onRunStep(actionEvents, pd, conf, cancelled, validated, context, ProjectActionEvent.PredefinedType.DEBUG_STEPINTO);
        }
        if (targetName.equals(DEBUG_STEPINTO_TEST_STEP)) {
            return this.onRunStep(actionEvents, pd, conf, cancelled, validated, context, ProjectActionEvent.PredefinedType.DEBUG_STEPINTO_TEST);
        }
        if (targetName.equals(CUSTOM_ACTION_STEP)) {
            return this.onCustomActionStep(actionEvents, conf, context, ProjectActionEvent.PredefinedType.CUSTOM_ACTION);
        }
        return this.onExtendedStep(actionEvents, conf, context, targetName);
    }

    private boolean onSaveStep() {
        if (MakeOptions.getInstance().getSave()) {
            LifecycleManager.getDefault().saveAll();
        }
        return ProjectSupport.saveAllProjects(MakeActionProviderImpl.getString("NeedToSaveAllText"));
    }

    private boolean onRunStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, LongOperation.CanceledState cancelled, AtomicBoolean validated, Lookup context, ProjectActionEvent.Type actionEvent) {
        PlatformInfo pi = conf.getPlatformInfo();
        validated.set(true);
        Folder targetFolder = (Folder)context.lookup(Folder.class);
        if (targetFolder != null) {
            RunProfile runProfile;
            CompilerSet compilerSet;
            String path = "";
            if (targetFolder.isTest() && (compilerSet = conf.getCompilerSet().getCompilerSet()) != null) {
                path = targetFolder.getFolderConfiguration(conf).getLinkerConfiguration().getOutputValue();
                path = conf.expandMacros(path);
                path = CndPathUtilities.toAbsolutePath((FSPath)conf.getBaseFSPath(), (String)path);
                conf = conf.clone();
                StringConfiguration sc = new StringConfiguration(null, "OutputPath");
                sc.setValue(path);
                if (conf.isLinkerConfiguration()) {
                    conf.getLinkerConfiguration().setOutput(sc);
                } else if (conf.isArchiverConfiguration()) {
                    conf.getArchiverConfiguration().setOutput(sc);
                } else if (conf.isMakefileConfiguration()) {
                    conf.getMakefileConfiguration().setOutput(sc);
                } else if (!conf.isQmakeConfiguration()) assert (false);
            }
            if ((runProfile = MakeActionProviderImpl.createRunProfile(conf, cancelled)) == null && cancelled.isCanceled()) {
                return false;
            }
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, path, conf, runProfile, false);
            actionEvents.add(projectActionEvent);
        } else if (actionEvent == ProjectActionEvent.PredefinedType.TEST) {
            if (conf.isCompileConfiguration() && !this.validateProject(conf)) {
                return true;
            }
            MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
            String buildCommand = makeArtifact.getBuildCommand(MakeActionProviderImpl.getMakeCommand(pd, conf), TEST_STEP);
            String args = "";
            int index = this.getArgsIndex(buildCommand);
            if (index > 0) {
                args = buildCommand.substring(index + 1);
                buildCommand = this.removeQuotes(buildCommand.substring(0, index));
            }
            RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform(), conf);
            profile.setArgs(args);
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, buildCommand, conf, profile, true);
            actionEvents.add(projectActionEvent);
        } else if (conf.isMakefileConfiguration()) {
            String path;
            if (actionEvent == ProjectActionEvent.PredefinedType.RUN) {
                path = conf.getMakefileConfiguration().getOutput().getValue();
                if (path.length() > 0 && !CndPathUtilities.isPathAbsolute((CharSequence)path)) {
                    path = conf.getMakefileConfiguration().getAbsOutput();
                    path = CndPathUtilities.toRelativePath((String)conf.getProfile().getRunDirectory(), (String)path);
                }
            } else {
                path = conf.getMakefileConfiguration().getAbsOutput();
                path = CndPathUtilities.normalizeSlashes((String)path);
            }
            RunProfile runProfile = conf.getProfile().clone(conf);
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, path, conf, runProfile, false);
            actionEvents.add(projectActionEvent);
        } else if (conf.isLibraryConfiguration()) {
            String path;
            if (actionEvent == ProjectActionEvent.PredefinedType.RUN) {
                path = conf.getProfile().getRunCommand().getValue();
                if (path.length() > 0 && !CndPathUtilities.isPathAbsolute((CharSequence)path)) {
                    path = conf.getMakefileConfiguration().getAbsOutput();
                    path = CndPathUtilities.toRelativePath((String)conf.getProfile().getRunDirectory(), (String)path);
                }
            } else {
                path = conf.getMakefileConfiguration().getAbsOutput();
                path = CndPathUtilities.normalizeSlashes((String)path);
            }
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, path, conf, null, false);
            actionEvents.add(projectActionEvent);
        } else if (conf.isApplicationConfiguration()) {
            String path;
            RunProfile runProfile = MakeActionProviderImpl.createRunProfile(conf, cancelled);
            if (runProfile == null && cancelled.isCanceled()) {
                return false;
            }
            MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
            if (actionEvent == ProjectActionEvent.PredefinedType.RUN) {
                path = makeArtifact.getOutput();
                if (!CndPathUtilities.isPathAbsolute((CharSequence)path)) {
                    path = makeArtifact.getWorkingDirectory() + "/" + path;
                    path = CndPathUtilities.naturalizeSlashes((String)path);
                    path = CndPathUtilities.toRelativePath((String)conf.getProfile().getRunDirectory(), (String)path);
                    path = CndPathUtilities.naturalizeSlashes((String)path);
                }
            } else {
                path = CndPathUtilities.toAbsolutePath((FSPath)conf.getBaseFSPath(), (String)makeArtifact.getOutput());
            }
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, path, conf, runProfile, false, context);
            actionEvents.add(projectActionEvent);
        } else assert (false);
        return true;
    }

    private static RunProfile createRunProfile(MakeConfiguration conf, LongOperation.CanceledState cancelled) {
        RunProfile runProfile = null;
        PlatformInfo pi = conf.getPlatformInfo();
        int platform = conf.getDevelopmentHost().getBuildPlatform();
        if (platform == 3) {
            runProfile = conf.getProfile().clone(conf);
            Set<String> subProjectOutputLocations = conf.getSubProjectOutputLocations();
            StringBuilder path = new StringBuilder();
            Iterator<String> iter = subProjectOutputLocations.iterator();
            while (iter.hasNext()) {
                String location = CndPathUtilities.naturalizeSlashes((String)iter.next());
                if (path.length() > 0) {
                    path.append(';');
                }
                path.append(location);
            }
            List<String> list = conf.getLinkerConfiguration().getAdditionalLibs().getValue();
            iter = list.iterator();
            while (iter.hasNext()) {
                String location = CndPathUtilities.naturalizeSlashes((String)iter.next());
                if (path.length() > 0) {
                    path.append(';');
                }
                path.append(location);
            }
            String userPath = runProfile.getEnvironment().getenv(pi.getPathName());
            if (userPath == null) {
                if (cancelled.isCanceled()) {
                    return null;
                }
                userPath = (String)HostInfoProvider.getEnv((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).get(pi.getPathName());
            }
            if (userPath != null && !userPath.isEmpty()) {
                if (path.length() > 0) {
                    path.append(';');
                }
                path.append(userPath);
            }
            runProfile.getEnvironment().putenv(pi.getPathName(), path.toString());
        } else if (platform == 4) {
            StringBuilder path = new StringBuilder();
            Set<String> subProjectOutputLocations = conf.getSubProjectOutputLocations();
            Iterator<String> iter = subProjectOutputLocations.iterator();
            while (iter.hasNext()) {
                String location = CndPathUtilities.naturalizeSlashes((String)iter.next());
                if (path.length() > 0) {
                    path.append(":");
                }
                path.append(location);
            }
            List<String> list = conf.getLinkerConfiguration().getAdditionalLibs().getValue();
            iter = list.iterator();
            while (iter.hasNext()) {
                String location = CndPathUtilities.naturalizeSlashes((String)iter.next());
                if (path.length() > 0) {
                    path.append(":");
                }
                path.append(location);
            }
            if (path.length() > 0) {
                runProfile = conf.getProfile().clone(conf);
                String extPath = runProfile.getEnvironment().getenv("DYLD_LIBRARY_PATH");
                if (extPath == null) {
                    if (cancelled.isCanceled()) {
                        return null;
                    }
                    extPath = (String)HostInfoProvider.getEnv((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).get("DYLD_LIBRARY_PATH");
                }
                if (extPath != null) {
                    path.append(":").append(extPath);
                }
                runProfile.getEnvironment().putenv("DYLD_LIBRARY_PATH", path.toString());
            }
        } else if (platform == 1 || platform == 0 || platform == 2) {
            String ont;
            StringBuilder path = new StringBuilder();
            List<String> list = conf.getLinkerConfiguration().getAdditionalLibs().getValue();
            Iterator<String> iter = list.iterator();
            while (iter.hasNext()) {
                String location = CndPathUtilities.naturalizeSlashes((String)iter.next());
                if (path.length() > 0) {
                    path.append(":");
                }
                path.append(location);
            }
            if (path.length() > 0) {
                runProfile = conf.getProfile().clone(conf);
                String extPath = runProfile.getEnvironment().getenv("LD_LIBRARY_PATH");
                if (extPath == null) {
                    if (cancelled.isCanceled()) {
                        return null;
                    }
                    extPath = (String)HostInfoProvider.getEnv((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).get("LD_LIBRARY_PATH");
                }
                if (extPath != null) {
                    path.append(":").append(extPath);
                }
                runProfile.getEnvironment().putenv("LD_LIBRARY_PATH", path.toString());
            }
            if ((ont = (String)HostInfoProvider.getEnv((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).get("OMP_NUM_THREADS")) == null) {
                ont = conf.getProfile().getEnvironment().getenv("OMP_NUM_THREADS");
            }
            if (ont == null) {
                if (runProfile == null) {
                    runProfile = conf.getProfile().clone(conf);
                }
                runProfile.getEnvironment().putenv("OMP_NUM_THREADS", "2");
            }
        }
        if (platform == 4 || platform == 1 || platform == 0 || platform == 2) {
            if (cancelled.isCanceled()) {
                return null;
            }
            if (conf.getDevelopmentHost().getExecutionEnvironment().isLocal() && HostInfoProvider.getEnv((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).get("DISPLAY") == null && conf.getProfile().getEnvironment().getenv("DISPLAY") == null) {
                if (runProfile == null) {
                    runProfile = conf.getProfile().clone(conf);
                }
                runProfile.getEnvironment().putenv("DISPLAY", ":0.0");
            }
        }
        return runProfile;
    }

    private boolean onRunSingleStep(MakeConfiguration conf, ArrayList<ProjectActionEvent> actionEvents, Lookup context, ProjectActionEvent.Type actionEvent) {
        if (conf.isMakefileConfiguration()) {
            FileObject f = (FileObject)context.lookup(FileObject.class);
            String path = CndFileUtils.toFile((FileObject)f).getPath();
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, path, conf, null, false);
            actionEvents.add(projectActionEvent);
        } else assert (false);
        return true;
    }

    private boolean onPreBuildStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, Lookup context, ProjectActionEvent.Type actionEvent) {
        String workingDir = conf.getPreBuildConfiguration().getAbsPreBuildCommandWorkingDir();
        String buildCommand = conf.getPreBuildConfiguration().getPreBuildCommand().getValue();
        String args = "";
        int index = this.getArgsIndex(buildCommand);
        if (index > 0) {
            args = buildCommand.substring(index + 1);
            buildCommand = this.removeQuotes(buildCommand.substring(0, index));
        }
        if (buildCommand.equals("${CMAKE}")) {
            buildCommand = this.removeQuotes(MakeActionProviderImpl.getCMakeCommand(pd, conf));
        }
        try {
            FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)conf.getFileSystemHost());
            FileObject root = fs.getRoot();
            String toRelativePath = CndPathUtilities.toRelativePath((FileObject)root, (String)workingDir);
            FileUtil.createFolder((FileObject)fs.getRoot(), (String)toRelativePath);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        RunProfile profile = new RunProfile(workingDir, conf.getDevelopmentHost().getBuildPlatform(), conf);
        profile.setArgs(args);
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, buildCommand, conf, profile, true, context);
        actionEvents.add(projectActionEvent);
        return true;
    }

    private boolean onBuildStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, Lookup context, ProjectActionEvent.Type actionEvent) {
        if (conf.isCompileConfiguration() && !this.validateProject(conf)) {
            return true;
        }
        Lookup ownLookup = null;
        if (conf.getConfigurationType().getValue() == 4 || conf.getConfigurationType().getValue() == 5 || conf.getConfigurationType().getValue() == 6) {
            for (ProjectActionEvent event : actionEvents) {
                ConfigurationDescriptorProvider.SnapShot snapShot = (ConfigurationDescriptorProvider.SnapShot)event.getContext().lookup(ConfigurationDescriptorProvider.SnapShot.class);
                if (snapShot == null) continue;
                ownLookup = event.getContext();
                break;
            }
            if (ownLookup == null) {
                ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)pd.getProject().getLookup().lookup(ConfigurationDescriptorProvider.class);
                ownLookup = Lookups.fixed((Object[])new Object[]{cdp.startModifications()});
            }
        }
        if (ownLookup == null) {
            ownLookup = Lookup.EMPTY;
        }
        ProxyLookup proxyLookup = new ProxyLookup(new Lookup[]{context, ownLookup});
        MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
        String makeCommand = MakeActionProviderImpl.getMakeCommand(pd, conf);
        String buildCommand = actionEvent == ProjectActionEvent.PredefinedType.BUILD_TESTS ? makeArtifact.getBuildCommand(makeCommand, BUILD_TESTS_STEP) : makeArtifact.getBuildCommand(makeCommand, "");
        String args = "";
        int index = this.getArgsIndex(buildCommand);
        if (index > 0) {
            args = buildCommand.substring(index + 1);
            buildCommand = this.removeQuotes(buildCommand.substring(0, index));
        }
        RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform(), conf);
        profile.setArgs(args);
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, buildCommand, conf, profile, true, (Lookup)proxyLookup);
        actionEvents.add(projectActionEvent);
        return true;
    }

    private boolean onBuildPackageStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfiguration conf, Lookup context, ProjectActionEvent.Type actionEvent) {
        if (!this.validatePackaging(conf)) {
            actionEvents.clear();
            return true;
        }
        String script = "nbproject/Package-" + conf.getName() + ".bash";
        RunProfile profile = new RunProfile(conf.getBaseDir(), conf.getDevelopmentHost().getBuildPlatform(), conf);
        String buildCommand = null;
        if (conf.getDevelopmentHost().getBuildPlatform() == 3) {
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment());
                buildCommand = hostInfo.getShell();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ConnectionManager.CancellationException cancellationException) {
                // empty catch block
            }
            if (buildCommand == null) {
                buildCommand = "sh.exe";
            }
        } else {
            buildCommand = "bash";
        }
        if (conf.getPackagingConfiguration().getVerbose().getValue()) {
            profile.setArgs(new String[]{"-x", script});
        } else {
            profile.setArgs(new String[]{script});
        }
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, buildCommand, conf, profile, true, context);
        actionEvents.add(projectActionEvent);
        return true;
    }

    private boolean onCleanStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, Lookup context, ProjectActionEvent.Type actionEvent) {
        Lookup ownLookup = null;
        if (conf.getConfigurationType().getValue() == 4 || conf.getConfigurationType().getValue() == 5 || conf.getConfigurationType().getValue() == 6) {
            for (ProjectActionEvent event : actionEvents) {
                ConfigurationDescriptorProvider.SnapShot snapShot = (ConfigurationDescriptorProvider.SnapShot)event.getContext().lookup(ConfigurationDescriptorProvider.SnapShot.class);
                if (snapShot == null) continue;
                ownLookup = event.getContext();
                break;
            }
            if (ownLookup == null) {
                ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)pd.getProject().getLookup().lookup(ConfigurationDescriptorProvider.class);
                ownLookup = Lookups.fixed((Object[])new Object[]{cdp.startModifications()});
            }
        }
        if (ownLookup == null) {
            ownLookup = Lookup.EMPTY;
        }
        ProxyLookup proxyLookup = new ProxyLookup(new Lookup[]{context, ownLookup});
        MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
        String buildCommand = makeArtifact.getCleanCommand(MakeActionProviderImpl.getMakeCommand(pd, conf), "");
        String args = "";
        int index = this.getArgsIndex(buildCommand);
        if (index > 0) {
            args = buildCommand.substring(index + 1);
            buildCommand = this.removeQuotes(buildCommand.substring(0, index));
        }
        RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform(), conf);
        profile.setArgs(args);
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, buildCommand, conf, profile, true, (Lookup)proxyLookup);
        actionEvents.add(projectActionEvent);
        return true;
    }

    private boolean onExtendedStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfiguration conf, Lookup context, String extendedStep) {
        MyType actionEvent = new MyType(extendedStep);
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, null, conf, null, true, context);
        actionEvents.add(projectActionEvent);
        return true;
    }

    private boolean onCompileSingleStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, Lookup context, ProjectActionEvent.Type actionEvent) {
        Item item = this.getNoteItem(context);
        if (item == null) {
            return false;
        }
        ItemConfiguration itemConfiguration = item.getItemConfiguration(conf);
        if (itemConfiguration == null) {
            return false;
        }
        if (itemConfiguration.getExcluded().getValue()) {
            Item bestComileUnit = this.getBestComileUnit(item, conf);
            if (bestComileUnit != null) {
                return this.onCompileSingleStepImpl(pd, conf, bestComileUnit, bestComileUnit.getItemConfiguration(conf), actionEvents, context, actionEvent);
            }
            return false;
        }
        if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool && !itemConfiguration.getCustomToolConfiguration().getModified()) {
            Item bestComileUnit = this.getBestComileUnit(item, conf);
            if (bestComileUnit != null) {
                return this.onCompileSingleStepImpl(pd, conf, bestComileUnit, bestComileUnit.getItemConfiguration(conf), actionEvents, context, actionEvent);
            }
            return false;
        }
        return this.onCompileSingleStepImpl(pd, conf, item, itemConfiguration, actionEvents, context, actionEvent);
    }

    private boolean onCompileSingleStepImpl(MakeConfigurationDescriptor pd, MakeConfiguration conf, Item item, ItemConfiguration itemConfiguration, ArrayList<ProjectActionEvent> actionEvents, Lookup context, ProjectActionEvent.Type actionEvent) {
        MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
        String outputFile = this.getOutputFile(conf, item, itemConfiguration);
        if (conf.isMakefileConfiguration()) {
            return this.compileSingleUnmanage(actionEvents, conf, makeArtifact, context, actionEvent, item, itemConfiguration);
        }
        this.compileSingleManage(actionEvents, conf, makeArtifact, context, actionEvent, pd, outputFile);
        return true;
    }

    private Item getBestComileUnit(Item item, MakeConfiguration conf) {
        CodeAssistance ca = (CodeAssistance)Lookup.getDefault().lookup(CodeAssistance.class);
        Item bestCandidate = null;
        if (ca.hasCodeAssistance((NativeFileItem)item)) {
            String name = item.getName();
            if (name.indexOf(46) > 0) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            List listCU = ca.findHeaderCompilationUnit((NativeFileItem)item);
            for (NativeFileItem i : listCU) {
                if (!Objects.equals(item.getNativeProject(), i.getNativeProject()) || !(i instanceof Item) || !this.checkItemCompileConfuguration((Item)i, conf)) continue;
                String aName = i.getName();
                if (aName.indexOf(46) > 0) {
                    aName = aName.substring(0, aName.lastIndexOf(46));
                }
                bestCandidate = (Item)i;
                if (!aName.equals(name)) continue;
                break;
            }
        }
        return bestCandidate;
    }

    private String getOutputFile(MakeConfiguration conf, Item item, ItemConfiguration itemConfiguration) {
        String outputFile = null;
        if (itemConfiguration.getTool() == PredefinedToolKind.CCompiler) {
            CCompilerConfiguration cCompilerConfiguration = itemConfiguration.getCCompilerConfiguration();
            outputFile = cCompilerConfiguration.getOutputFile(item, conf, false);
            if (item.getFolder().isTest()) {
                outputFile = outputFile.replace("${OBJECTDIR}", "${TESTDIR}");
            }
        } else if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) {
            CCCompilerConfiguration ccCompilerConfiguration = itemConfiguration.getCCCompilerConfiguration();
            outputFile = ccCompilerConfiguration.getOutputFile(item, conf, false);
            if (item.getFolder().isTest()) {
                outputFile = outputFile.replace("${OBJECTDIR}", "${TESTDIR}");
            }
        } else if (itemConfiguration.getTool() == PredefinedToolKind.FortranCompiler) {
            FortranCompilerConfiguration fortranCompilerConfiguration = itemConfiguration.getFortranCompilerConfiguration();
            outputFile = fortranCompilerConfiguration.getOutputFile(item, conf, false);
            if (item.getFolder().isTest()) {
                outputFile = outputFile.replace("${OBJECTDIR}", "${TESTDIR}");
            }
        } else if (itemConfiguration.getTool() == PredefinedToolKind.Assembler) {
            AssemblerConfiguration assemblerConfiguration = itemConfiguration.getAssemblerConfiguration();
            outputFile = assemblerConfiguration.getOutputFile(item, conf, false);
            if (item.getFolder().isTest()) {
                outputFile = outputFile.replace("${OBJECTDIR}", "${TESTDIR}");
            }
        } else if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool) {
            CustomToolConfiguration customToolConfiguration = itemConfiguration.getCustomToolConfiguration();
            outputFile = customToolConfiguration.getOutputs().getValue();
        }
        return conf.expandMacros(outputFile);
    }

    private boolean compileSingleUnmanage(ArrayList<ProjectActionEvent> actionEvents, MakeConfiguration conf, MakeArtifact makeArtifact, Lookup context, ProjectActionEvent.Type actionEvent, Item item, ItemConfiguration itemConfiguration) {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        AbstractCompiler ccCompiler = null;
        CCCCompilerConfiguration optionProvider = null;
        if (itemConfiguration.getTool() == PredefinedToolKind.CCompiler) {
            ccCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
            optionProvider = itemConfiguration.getCCompilerConfiguration();
        } else if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) {
            ccCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            optionProvider = itemConfiguration.getCCCompilerConfiguration();
        }
        if (ccCompiler == null) {
            return false;
        }
        CompileConfiguration compileConfiguration = conf.getCompileConfiguration();
        if ("${AUTO_COMPILE}".equals(compileConfiguration.getCompileCommand().getValue())) {
            String compileLine;
            AllOptionsProvider options = CompileOptionsProvider.getDefault().getOptions(item);
            if (options != null) {
                int hasPath;
                String compileLine2 = options.getAllOptions((Tool)ccCompiler);
                if (compileLine2 != null && (hasPath = compileLine2.indexOf(35)) >= 0) {
                    int i;
                    RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform(), conf);
                    profile.setRunDirectory(compileLine2.substring(0, hasPath));
                    String command = compileLine2.substring(hasPath + 1).trim();
                    if (command.length() > 0 && command.charAt(0) != '-' && (i = command.indexOf(32)) > 0) {
                        command = command.substring(i + 1).trim();
                    }
                    profile.setArgs(command);
                    String compilerPath = this.convertPath(ccCompiler.getPath(), conf.getDevelopmentHost().getExecutionEnvironment());
                    ExecutionEnvironment ee = conf.getDevelopmentHost().getExecutionEnvironment();
                    if (ee.isLocal() && Utilities.isWindows()) {
                        try {
                            compilerPath = compilerPath.replace('\\', '/');
                            command = this.escapeQuotes(command);
                            profile.setArgs(new String[]{"-c", "\"'" + compilerPath + "' " + command + "\""});
                            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ee);
                            compilerPath = hostInfo.getShell();
                        }
                        catch (IOException ex) {
                            return false;
                        }
                        catch (ConnectionManager.CancellationException ex) {
                            return false;
                        }
                    }
                    ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, compilerPath, conf, profile, true, context);
                    actionEvents.add(projectActionEvent);
                    return true;
                }
            } else if (optionProvider != null && (compileLine = optionProvider.getAllOptions((Tool)ccCompiler)) != null) {
                boolean isWindows;
                RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform(), conf);
                profile.setRunDirectory(makeArtifact.getWorkingDirectory());
                String command = compileLine.trim();
                List parseArgs = ImportUtils.parseArgs((String)command);
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < parseArgs.size(); ++i) {
                    String s2;
                    String s = (String)parseArgs.get(i);
                    if (s.equals(s2 = CndPathUtilities.quoteIfNecessary((String)s))) {
                        int j;
                        if (s.indexOf(34) > 0 && (j = s.indexOf("\\\"")) < 0) {
                            s = s.replace("\"", "\\\"");
                        }
                    } else {
                        s = s2;
                    }
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(s);
                }
                command = buf.toString();
                command = command + " -o " + this.getDevNull(conf.getDevelopmentHost().getExecutionEnvironment(), compilerSet);
                String source = item.getAbsolutePath();
                ExecutionEnvironment ee = conf.getDevelopmentHost().getExecutionEnvironment();
                boolean bl = isWindows = ee.isLocal() && Utilities.isWindows();
                if (isWindows) {
                    source = source.replace('\\', '/');
                    source = CppUtils.normalizeDriveLetter(compilerSet, source);
                    source = "'" + source + "'";
                }
                command = command + " -c " + source;
                profile.setArgs(command);
                String compilerPath = this.convertPath(ccCompiler.getPath(), conf.getDevelopmentHost().getExecutionEnvironment());
                if (isWindows) {
                    try {
                        String path;
                        String dir;
                        Tool make;
                        HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ee);
                        compilerPath = compilerPath.replace('\\', '/');
                        command = this.escapeQuotes(command);
                        profile.setArgs(new String[]{"-c", "\"'" + compilerPath + "' " + command + "\""});
                        Shell shell = WindowsSupport.getInstance().getActiveShell();
                        String shellPath = hostInfo.getShell();
                        if (compilerSet.getCompilerFlavor().isMinGWCompiler() && shell != null && shell.type == Shell.ShellType.CYGWIN && (make = compilerSet.findTool((ToolKind)PredefinedToolKind.MakeTool)) != null && (dir = CndPathUtilities.getDirName((String)(path = make.getPath()))) != null && !dir.isEmpty()) {
                            shellPath = dir + "/sh.exe";
                        }
                        if (shellPath != null) {
                            compilerPath = shellPath = shellPath.replace('\\', '/');
                        }
                    }
                    catch (IOException ex) {
                        return false;
                    }
                    catch (ConnectionManager.CancellationException ex) {
                        return false;
                    }
                }
                ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, compilerPath, conf, profile, true, context);
                actionEvents.add(projectActionEvent);
                return true;
            }
        } else {
            String workingDir;
            String command = compileConfiguration.getCompileCommand().getValue();
            if (command.contains("${ITEM_PATH}")) {
                command = command.replace("${ITEM_PATH}", item.getAbsolutePath());
            }
            if (command.contains("${ITEM_NAME}")) {
                String name = item.getName();
                if (name.indexOf(46) > 0) {
                    name = name.substring(0, name.lastIndexOf(46));
                }
                command = command.replace("${ITEM_NAME}", name);
            }
            if (command.contains("${MAKE}")) {
                String make = "make";
                Tool makeTool = compilerSet.findTool((ToolKind)PredefinedToolKind.MakeTool);
                if (makeTool != null && makeTool.getPath().length() > 0) {
                    make = makeTool.getPath();
                }
                command = command.replace("${MAKE}", make);
            }
            if ("${AUTO_FOLDER}".equals(workingDir = compileConfiguration.getCompileCommandWorkingDir().getValue())) {
                workingDir = CndPathUtilities.getDirName((String)item.getAbsolutePath());
            } else {
                if (!CndPathUtilities.isPathAbsolute((CharSequence)workingDir)) {
                    workingDir = conf.getBaseDir() + "/" + workingDir;
                }
                workingDir = FileSystemProvider.normalizeAbsolutePath((String)workingDir, (FileSystem)conf.getSourceFileSystem());
            }
            RunProfile profile = new RunProfile(workingDir, conf.getDevelopmentHost().getBuildPlatform(), conf);
            profile.setRunDirectory(workingDir);
            profile.setRunCommand(new ComboStringConfiguration(null, command, new DefaultPicklistModel()));
            ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, workingDir, conf, profile, true, context);
            actionEvents.add(projectActionEvent);
            return true;
        }
        return false;
    }

    private String escapeQuotes(String command) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            if (c == '\"') {
                buf.append("\\\"");
                continue;
            }
            if (c == '\\') {
                buf.append("\\\\");
                continue;
            }
            buf.append(c);
        }
        command = buf.toString();
        return command;
    }

    private String getDevNull(ExecutionEnvironment execEnv, CompilerSet compilerSet) {
        if (execEnv.isLocal() && Utilities.isWindows() && !compilerSet.getCompilerFlavor().isCygwinCompiler()) {
            return "NUL";
        }
        return "/dev/null";
    }

    private String convertPath(String path, ExecutionEnvironment execEnv) {
        if (execEnv.isLocal()) {
            return LinkSupport.resolveWindowsLink((String)path);
        }
        return path;
    }

    private void compileSingleManage(ArrayList<ProjectActionEvent> actionEvents, MakeConfiguration conf, MakeArtifact makeArtifact, Lookup context, ProjectActionEvent.Type actionEvent, MakeConfigurationDescriptor pd, String outputFile) {
        String args;
        String commandLine;
        if (conf.getDevelopmentHost().getBuildPlatform() == 3) {
            commandLine = "cmd.exe";
            args = "/c rm -rf " + outputFile;
        } else {
            commandLine = "rm";
            args = "-rf " + outputFile;
        }
        RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform(), conf);
        profile.setArgs(args);
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, ProjectActionEvent.PredefinedType.CLEAN, commandLine, conf, profile, true);
        actionEvents.add(projectActionEvent);
        commandLine = MakeActionProviderImpl.getMakeCommand(pd, conf) + " -f nbproject" + '/' + "Makefile-" + conf.getName() + ".mk " + outputFile;
        args = "";
        int index = commandLine.indexOf(32);
        if (index > 0) {
            args = commandLine.substring(index + 1);
            commandLine = commandLine.substring(0, index);
        }
        profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform(), conf);
        profile.setArgs(args);
        projectActionEvent = new ProjectActionEvent(this.project, actionEvent, commandLine, conf, profile, true, context);
        actionEvents.add(projectActionEvent);
    }

    private boolean onTestSingleStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfigurationDescriptor pd, MakeConfiguration conf, Lookup context, ProjectActionEvent.Type actionEvent) {
        if (actionEvent == ProjectActionEvent.PredefinedType.TEST) {
            if (conf.isCompileConfiguration() && !this.validateProject(conf)) {
                return true;
            }
            Folder targetFolder = (Folder)context.lookup(Folder.class);
            if (targetFolder == null) {
                return true;
            }
            List<Folder> list = targetFolder.getAllTests();
            if (targetFolder.isTest()) {
                list.add(targetFolder);
            }
            for (Folder folder : list) {
                CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
                if (compilerSet == null) continue;
                String target = folder.getFolderConfiguration(conf).getLinkerConfiguration().getOutputValue();
                target = conf.expandMacros(target);
                MakeArtifact makeArtifact = new MakeArtifact(pd, conf);
                String buildCommand = makeArtifact.getBuildCommand(MakeActionProviderImpl.getMakeCommand(pd, conf), "test TEST=" + target);
                String args = "";
                int index = this.getArgsIndex(buildCommand);
                if (index > 0) {
                    args = buildCommand.substring(index + 1);
                    buildCommand = this.removeQuotes(buildCommand.substring(0, index));
                }
                RunProfile profile = new RunProfile(makeArtifact.getWorkingDirectory(), conf.getDevelopmentHost().getBuildPlatform(), conf);
                profile.setArgs(args);
                ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, buildCommand, conf, profile, true);
                actionEvents.add(projectActionEvent);
                break;
            }
        }
        return true;
    }

    private boolean onCustomActionStep(ArrayList<ProjectActionEvent> actionEvents, MakeConfiguration conf, Lookup context, ProjectActionEvent.Type actionEvent) {
        String exe = conf.getAbsoluteOutputValue();
        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, actionEvent, exe, conf, null, true, context);
        actionEvents.add(projectActionEvent);
        return true;
    }

    private boolean onValidateToolchainStep(MakeConfigurationDescriptor pd, MakeConfiguration conf, LongOperation.CanceledState cancelled, AtomicBoolean validated, Lookup context) {
        if (!this.validateBuildSystem(pd, conf, validated.get(), cancelled)) {
            return false;
        }
        validated.set(true);
        return true;
    }

    private boolean validateProject(MakeConfiguration conf) {
        boolean ret = false;
        if (this.getProjectDescriptor().getProjectItems().length == 0) {
            ret = false;
        } else {
            for (int i = 0; i < this.getProjectDescriptor().getProjectItems().length; ++i) {
                Item item = this.getProjectDescriptor().getProjectItems()[i];
                ItemConfiguration itemConfiguration = item.getItemConfiguration(conf);
                if (itemConfiguration == null || itemConfiguration.getExcluded().getValue() || itemConfiguration.getTool() == PredefinedToolKind.CustomTool && itemConfiguration.getCustomToolConfiguration().getCommandLine().getValue().length() <= 0) continue;
                ret = true;
                break;
            }
        }
        if (!ret) {
            CndNotifier.getDefault().notifyErrorLater(MakeActionProviderImpl.getString("ERR_EMPTY_PROJECT"));
        }
        return ret;
    }

    private String[] getTargetNames(String command, MakeConfiguration conf, Lookup context) throws IllegalArgumentException {
        if (conf == null) {
            return null;
        }
        Commands cmds = this.commands.get(command);
        if (cmds == null) {
            throw new IllegalArgumentException(command);
        }
        return cmds.getCommands(this.project, conf, context);
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if (!this.isProjectDescriptorLoaded()) {
            return false;
        }
        MakeConfiguration conf = this.getProjectDescriptor().getActiveConfiguration();
        if (conf == null) {
            return false;
        }
        if (command.equals(CLEAN_STEP)) {
            return true;
        }
        if (command.equals("pre_build")) {
            return conf.isMakefileConfiguration() && !conf.getPreBuildConfiguration().getPreBuildCommand().getValue().isEmpty();
        }
        if (command.equals(BUILD_STEP)) {
            return true;
        }
        if (command.equals("build_packages")) {
            return true;
        }
        if (command.equals("batch_build")) {
            return true;
        }
        if (command.equals("rebuild")) {
            return true;
        }
        if (command.equals(RUN_STEP)) {
            return true;
        }
        if (command.equals(DEBUG_STEP)) {
            return conf.hasDebugger();
        }
        if (command.equals("debug.stepinto")) {
            return conf.hasDebugger();
        }
        if (command.equals("compile.single")) {
            return this.isCompileEnable(context, conf);
        }
        if (command.equals("delete") || command.equals("rename")) {
            return true;
        }
        if (command.equals("copy") || command.equals("move")) {
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            return file != null;
        }
        if (command.equals("run.single")) {
            return RunActionSupport.geRunActionSupport().canRun(context);
        }
        if (command.equals(TEST_STEP)) {
            Folder root = this.getProjectDescriptor().getLogicalFolders();
            Folder testRootFolder = null;
            for (Folder folder : root.getFolders()) {
                if (!folder.isTestRootFolder()) continue;
                testRootFolder = folder;
                break;
            }
            return testRootFolder != null;
        }
        return false;
    }

    private boolean isCompileEnable(Lookup context, MakeConfiguration conf) {
        Item item = this.getNoteItem(context);
        if (item == null) {
            return false;
        }
        ItemConfiguration itemConfiguration = item.getItemConfiguration(conf);
        if (itemConfiguration == null) {
            return false;
        }
        if (itemConfiguration.getExcluded().getValue()) {
            CodeAssistance ca = (CodeAssistance)Lookup.getDefault().lookup(CodeAssistance.class);
            if (ca.hasCodeAssistance((NativeFileItem)item)) {
                List listCU = ca.findHeaderCompilationUnit((NativeFileItem)item);
                for (NativeFileItem i : listCU) {
                    if (!Objects.equals(item.getNativeProject(), i.getNativeProject()) || !(i instanceof Item) || !this.checkItemCompileConfuguration((Item)i, conf)) continue;
                    return true;
                }
            }
            return false;
        }
        if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool && !itemConfiguration.getCustomToolConfiguration().getModified()) {
            CodeAssistance ca = (CodeAssistance)Lookup.getDefault().lookup(CodeAssistance.class);
            if (ca.hasCodeAssistance((NativeFileItem)item)) {
                List listCU = ca.findHeaderCompilationUnit((NativeFileItem)item);
                for (NativeFileItem i : listCU) {
                    if (!Objects.equals(item.getNativeProject(), i.getNativeProject()) || !(i instanceof Item) || !this.checkItemCompileConfuguration((Item)i, conf)) continue;
                    return true;
                }
            }
            return false;
        }
        if (conf.isMakefileConfiguration()) {
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            AbstractCompiler ccCompiler = null;
            if (itemConfiguration.getTool() == PredefinedToolKind.CCompiler) {
                ccCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
            } else if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) {
                AbstractCompiler abstractCompiler = ccCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            }
            return ccCompiler != null;
        }
        return true;
    }

    private boolean checkItemCompileConfuguration(Item item, MakeConfiguration conf) {
        ItemConfiguration itemConfiguration = item.getItemConfiguration(conf);
        if (itemConfiguration == null) {
            return false;
        }
        if (itemConfiguration.getExcluded().getValue()) {
            return false;
        }
        if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool && !itemConfiguration.getCustomToolConfiguration().getModified()) {
            return false;
        }
        if (conf.isMakefileConfiguration()) {
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            AbstractCompiler ccCompiler = null;
            if (itemConfiguration.getTool() == PredefinedToolKind.CCompiler) {
                ccCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
            } else if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler) {
                AbstractCompiler abstractCompiler = ccCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            }
            return ccCompiler != null;
        }
        return true;
    }

    private Item getNoteItem(Lookup context) {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        if (fo != null) {
            return this.getProjectDescriptor().findItemByFileObject(fo);
        }
        return null;
    }

    private static String getMakeCommand(MakeConfigurationDescriptor pd, MakeConfiguration conf) {
        String cmd;
        CompilerSet cs = conf.getCompilerSet().getCompilerSet();
        if (cs != null) {
            cmd = cs.getTool((ToolKind)PredefinedToolKind.MakeTool).getPath();
        } else {
            CndUtils.assertFalse((boolean)true, (String)"Null compiler collection");
            cmd = "make";
        }
        return cmd;
    }

    private static String getCMakeCommand(MakeConfigurationDescriptor pd, MakeConfiguration conf) {
        String cmd;
        CompilerSet cs = conf.getCompilerSet().getCompilerSet();
        if (cs != null) {
            cmd = PreBuildSupport.getCmakePath(cs);
        } else {
            CndUtils.assertFalse((boolean)true, (String)"Null compiler collection");
            cmd = "cmake";
        }
        return cmd;
    }

    private List<String> validateStep(String id, List<String> tailSteps) {
        StepControllerProvider.StepController validator = StepControllerProvider.getController(id);
        if (validator == null) {
            return null;
        }
        return validator.validate(this.project, id, tailSteps);
    }

    private boolean validateBuildSystem(MakeConfigurationDescriptor pd, MakeConfiguration conf, boolean validated, LongOperation.CanceledState cancelled) {
        ExecutionEnvironment execEnv;
        int hostPlatformId;
        int buildPlatformId;
        CompilerSet2Configuration csconf = conf.getCompilerSet();
        ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)conf.getDevelopmentHost().getHostKey());
        ArrayList<String> errs = new ArrayList<String>();
        boolean cRequired = conf.hasCFiles(pd);
        boolean cppRequired = conf.hasCPPFiles(pd);
        boolean fRequired = conf.hasFortranFiles(pd);
        boolean asRequired = conf.hasAssemblerFiles(pd);
        boolean runBTA = false;
        if (validated) {
            return this.lastValidation;
        }
        if (!conf.getDevelopmentHost().isLocalhost()) {
            ServerRecord record = ServerList.get((ExecutionEnvironment)env);
            assert (record != null);
            record.validate(false);
            if (cancelled.isCanceled()) {
                return false;
            }
            if (!record.isOnline()) {
                this.lastValidation = false;
                runBTA = true;
            }
        }
        if ((buildPlatformId = conf.getDevelopmentHost().getBuildPlatform()) != (hostPlatformId = CompilerSetManager.get((ExecutionEnvironment)(execEnv = conf.getDevelopmentHost().getExecutionEnvironment())).getPlatform())) {
            if (!conf.isMakefileConfiguration()) {
                Platform buildPlatform = Platforms.getPlatform(buildPlatformId);
                Platform hostPlatform = Platforms.getPlatform(hostPlatformId);
                String errormsg = MakeActionProviderImpl.getString("WRONG_PLATFORM", hostPlatform.getDisplayName(), buildPlatform.getDisplayName());
                String autoConfirm = errormsg + "\n (build platform id =" + buildPlatformId + " host platform id = " + hostPlatformId + ")";
                if (CndUtils.isUnitTestMode() || CndUtils.isStandalone()) {
                    new Exception(autoConfirm).printStackTrace(System.err);
                } else {
                    ConfirmSupport.ConfirmPlatformMismatch confirm = ConfirmSupport.getConfirmPlatformMismatchFactory().createAndWait(errormsg, autoConfirm);
                    if (confirm == null) {
                        return false;
                    }
                }
            }
            conf.getDevelopmentHost().setBuildPlatform(hostPlatformId);
        }
        CompilerSet cs = csconf.getCompilerSet();
        String csname = csconf.getOption();
        if (cs == null) {
            if (csconf.getFlavor() != null && csconf.getFlavor().equals("Unknown")) {
                cs = CompilerSetManager.get((ExecutionEnvironment)env).getDefaultCompilerSet();
                String errMsg = NbBundle.getMessage(MakeActionProviderImpl.class, (String)"ERR_UnknownCompiler", (Object)csname);
                errs.add(errMsg);
                runBTA = true;
            } else {
                CompilerFlavor flavor = null;
                if (csconf.getFlavor() != null) {
                    flavor = CompilerFlavor.toFlavor((String)csconf.getFlavor(), (int)conf.getPlatformInfo().getPlatform());
                }
                if (flavor == null) {
                    flavor = CompilerFlavor.getUnknown((int)conf.getPlatformInfo().getPlatform());
                }
                cs = CompilerSetFactory.getCompilerSet((ExecutionEnvironment)env, flavor, (String)csname);
                String errMsg = NbBundle.getMessage(MakeActionProviderImpl.class, (String)"ERR_INVALID_LOCAL_COMPILER_SET", (Object)csname);
                errs.add(errMsg);
                runBTA = true;
            }
        }
        if (cancelled.isCanceled()) {
            return false;
        }
        if (!runBTA) {
            Tool cTool = cs.getTool((ToolKind)PredefinedToolKind.CCompiler);
            Tool cppTool = cs.getTool((ToolKind)PredefinedToolKind.CCCompiler);
            Tool fTool = cs.getTool((ToolKind)PredefinedToolKind.FortranCompiler);
            Tool asTool = cs.getTool((ToolKind)PredefinedToolKind.Assembler);
            Tool makeTool = cs.getTool((ToolKind)PredefinedToolKind.MakeTool);
            Tool qmakeTool = cs.getTool((ToolKind)PredefinedToolKind.QMakeTool);
            PlatformInfo pi = conf.getPlatformInfo();
            if (conf.getDevelopmentHost().isLocalhost()) {
                File file = new File(makeTool.getPath());
                if (!MakeActionProviderImpl.exists(makeTool.getPath(), pi) && Path.findCommand((String)makeTool.getPath()) == null || ToolchainUtilities.isUnsupportedMake((String)file.getPath())) {
                    runBTA = true;
                }
            } else if (!MakeActionProviderImpl.isValidExecutable(makeTool.getPath(), pi)) {
                runBTA = true;
            }
            ArrayList<Tool> tools2check = new ArrayList<Tool>();
            if (cRequired) {
                tools2check.add(cTool);
            }
            if (cppRequired) {
                tools2check.add(cppTool);
            }
            if (fRequired) {
                tools2check.add(fTool);
            }
            if (asRequired) {
                tools2check.add(asTool);
            }
            if (conf.isQmakeConfiguration()) {
                tools2check.add(qmakeTool);
            }
            for (Tool tool : tools2check) {
                if (cancelled.isCanceled()) {
                    return false;
                }
                if (MakeActionProviderImpl.exists(tool.getPath(), pi)) continue;
                runBTA = true;
            }
        }
        if (cancelled.isCanceled()) {
            return false;
        }
        if (!CndUtils.isUnitTestMode()) {
            OSSComponentUsages.countIDEUsage();
        }
        if (runBTA) {
            if (CndUtils.isUnitTestMode() || CndUtils.isStandalone()) {
                this.lastValidation = false;
            } else {
                String title = NbBundle.getMessage(MakeActionProviderImpl.class, (String)"LBL_ResolveMissingTools_Title");
                ConfirmSupport.ResolveBuildToolsFactory resolver = (ConfirmSupport.ResolveBuildToolsFactory)Lookup.getDefault().lookup(ConfirmSupport.ResolveBuildToolsFactory.class);
                this.lastValidation = resolver.resolveTools(title, pd, conf, env, csname, cs, cRequired, cppRequired, fRequired, asRequired, errs);
                if (this.lastValidation) {
                    cs = conf.getCompilerSet().getCompilerSet();
                }
            }
        } else {
            this.lastValidation = true;
        }
        if (this.lastValidation) {
            Shell activeShell;
            if (cs.getCompilerFlavor().isCygwinCompiler()) {
                boolean isOK;
                activeShell = WindowsSupport.getInstance().getActiveShell();
                ShellValidationSupport.ShellValidationStatus shellValidationStatus = ShellValidationSupport.getValidationStatus((Shell)activeShell);
                boolean bl = isOK = shellValidationStatus.isValid() && !shellValidationStatus.hasWarnings();
                if (!isOK) {
                    String binDir = cs.getDirectory();
                    if (activeShell == null || !binDir.equals(activeShell.bindir.getAbsolutePath())) {
                        WindowsSupport.getInstance().init(binDir);
                        activeShell = WindowsSupport.getInstance().getActiveShell();
                        shellValidationStatus = ShellValidationSupport.getValidationStatus((Shell)activeShell);
                        boolean bl2 = isOK = shellValidationStatus.isValid() && !shellValidationStatus.hasWarnings();
                        if (isOK) {
                            try {
                                HostInfoUtils.updateHostInfo((ExecutionEnvironment)execEnv);
                            }
                            catch (IOException iOException) {
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (!isOK) {
                    this.lastValidation = ShellValidationSupport.confirm((ShellValidationSupport.ShellValidationStatus)shellValidationStatus);
                }
            } else if (cs.getCompilerFlavor().isMinGWCompiler() && (activeShell = WindowsSupport.getInstance().getActiveShell()) == null) {
                String binDir = cs.getCommandFolder();
                WindowsSupport.getInstance().init(binDir);
                activeShell = WindowsSupport.getInstance().getActiveShell();
                if (activeShell == null) {
                    this.lastValidation = ShellValidationSupport.confirm(null);
                } else {
                    try {
                        HostInfoUtils.updateHostInfo((ExecutionEnvironment)execEnv);
                    }
                    catch (IOException iOException) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.lastValidation;
    }

    private boolean validatePackaging(MakeConfiguration conf) {
        String errormsg = null;
        if (conf.getPackagingConfiguration().getFiles().getValue().isEmpty()) {
            errormsg = MakeActionProviderImpl.getString("ERR_EMPTY_PACKAGE");
        }
        if (PackagerManager.getDefault().getPackager(conf.getPackagingConfiguration().getType().getValue()) == null) {
            errormsg = NbBundle.getMessage(MakeActionProviderImpl.class, (String)"ERR_MISSING_TOOL4", (Object)conf.getPackagingConfiguration().getType().getValue());
        }
        if (errormsg != null) {
            MakeCustomizerProvider makeCustomizerProvider;
            CndNotifier.getDefault().notifyError(errormsg);
            if (conf.getPackagingConfiguration().getFiles().getValue().isEmpty() && (makeCustomizerProvider = (MakeCustomizerProvider)this.project.getLookup().lookup(MakeCustomizerProvider.class)) != null) {
                makeCustomizerProvider.showCustomizer("Packaging");
            }
            return false;
        }
        return true;
    }

    private static boolean isValidExecutable(String path, PlatformInfo pi) {
        return MakeActionProviderImpl.existsImpl(path, pi, true);
    }

    private static boolean exists(String path, PlatformInfo pi) {
        return MakeActionProviderImpl.existsImpl(path, pi, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean existsImpl(String path, PlatformInfo pi, boolean checkExecutable) {
        boolean result;
        Map<String, Boolean> map;
        ExecutionEnvironment execEnv = pi.getExecutionEnvironment();
        String key = path + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)execEnv);
        Map<String, Boolean> map2 = map = checkExecutable ? validExecutablesCache : fileExistenceCache;
        synchronized (map2) {
            Boolean cached = map.get(key);
            if (cached != null && cached.booleanValue()) {
                return true;
            }
        }
        if (checkExecutable) {
            result = ServerList.isValidExecutable((ExecutionEnvironment)execEnv, (String)path);
        } else {
            boolean bl = result = pi.fileExists(path) || pi.isWindows() && pi.fileExists(path + ".lnk") || pi.findCommand(path) != null;
        }
        if (result) {
            Map<String, Boolean> map3 = map;
            synchronized (map3) {
                map.put(key, Boolean.TRUE);
            }
        }
        return result;
    }

    private String removeQuotes(String command) {
        if (command.startsWith("\"") && command.endsWith("\"")) {
            return command.substring(1, command.length() - 1);
        }
        if (command.startsWith("'") && command.endsWith("'")) {
            return command.substring(1, command.length() - 1);
        }
        return command;
    }

    private int getArgsIndex(String command) {
        boolean inQuote = false;
        char quote = '\u0000';
        block4: for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            switch (c) {
                case ' ': {
                    if (inQuote) continue block4;
                    return i;
                }
                case '\"': 
                case '\'': {
                    if (inQuote) {
                        if (quote != c) continue block4;
                        quote = '\u0000';
                        inQuote = false;
                        continue block4;
                    }
                    quote = c;
                    inQuote = true;
                }
            }
        }
        return -1;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(MakeActionProviderImpl.class, (String)s);
    }

    private static String getString(String s, String arg1, String arg2) {
        return NbBundle.getMessage(MakeActionProviderImpl.class, (String)s, (Object)arg1, (Object)arg2);
    }

    private static final class Commands {
        private final List<Command> commands;
        private final String id;

        private Commands(String id, Collection<Command> commands) {
            this.id = id;
            this.commands = new ArrayList<Command>(commands);
        }

        private String[] getCommands(Project project, MakeConfiguration conf, Lookup context) {
            ArrayList<String> res = new ArrayList<String>();
            block0: for (Command command : this.commands) {
                String conditions = command.conditions;
                if (conditions != null) {
                    HashMap<String, Boolean> flagValues = new HashMap<String, Boolean>();
                    for (String condition : conditions.split(",")) {
                        boolean can = false;
                        if (MakeCommandFlagsProviderFactory.DEFAULT.canHandle(condition, context, conf)) {
                            can = MakeCommandFlagsProviderFactory.DEFAULT.createProvider().flagValue(this.id, context, project, conf, condition, can);
                        }
                        for (MakeCommandFlagsProviderFactory factory : Lookup.getDefault().lookupAll(MakeCommandFlagsProviderFactory.class)) {
                            if (!factory.canHandle(this.id, context, conf)) continue;
                            can = factory.createProvider().flagValue(this.id, context, project, conf, condition, can);
                        }
                        flagValues.put(condition, can);
                    }
                    Iterator iterator = flagValues.values().iterator();
                    while (iterator.hasNext()) {
                        boolean can = (Boolean)iterator.next();
                        if (can) continue;
                        continue block0;
                    }
                }
                res.add(command.command);
            }
            return res.toArray(new String[res.size()]);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (Command command : this.commands) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append(command.command);
                if (command.conditions == null) continue;
                buf.append('[').append(command.conditions).append(']');
            }
            return buf.toString();
        }
    }

    private static final class Command {
        private final String command;
        private final String conditions;

        private Command(String command, String conditions) {
            this.command = command;
            this.conditions = conditions;
        }

        public String toString() {
            return this.conditions == null ? this.command : this.command + "[" + this.conditions + "]";
        }
    }

    private static final class MyType
    implements ProjectActionEvent.Type {
        private final String extendedStep;
        private String locName;

        private MyType(String extendedStep) {
            this.extendedStep = extendedStep;
            this.locName = extendedStep;
        }

        @Override
        public int ordinal() {
            return this.extendedStep.hashCode();
        }

        @Override
        public String name() {
            return this.extendedStep;
        }

        @Override
        public String getLocalizedName() {
            return this.locName;
        }

        @Override
        public void setLocalizedName(String name) {
            this.locName = name;
        }
    }
}

